/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage.file;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.io.LineReader;
import net.zerotoaster.io.LineWriter;
import net.zerotoaster.io.POP3OutputWriter;
import net.zerotoaster.mailfilters.MailFilterChain;
import net.zerotoaster.mta.MPA_ServerInstance;
import net.zerotoaster.storage.AccountingRecord;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.FilterRecord;
import net.zerotoaster.storage.LocalStorageManager;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.MailQueueRecord;
import net.zerotoaster.storage.MailingListRecord;
import net.zerotoaster.storage.StorageException;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.storage.UserRecord;
import net.zerotoaster.util.Helper;

public class FileStorage
extends LocalStorageManager {
    private static final String MAIL_EXT = ".ML";
    private static final String TEMP_EXT = ".TMP";
    private static final String QUEUE_EXT = ".QUE";
    private static final String QUEUE_LOCK_EXT = ".QUL";
    private static final String TRUENAME = "$truename";
    private static final int HEADER_SIZE = 512;
    private static final String CONFIG = "filestorage.ini";
    private static Properties prpConfig = null;
    private static Object lckAccounting = new Object();
    private static Object lckUser = new Object();
    private static Object lckDomain = new Object();
    private static Object lckMail = new Object();
    private static Object lckFilter = new Object();
    private static Object lckKeyData = new Object();
    private static Object lckMailingList = new Object();
    private static Object lckProcessQueue = new Object();
    private static boolean blnIsInitialized = false;
    private Vector vecFilesWritten = null;
    private static String strDomainDir = null;
    private static String strUserDir = null;
    private static String strUserMailDir = null;
    private static String strAccDir = null;
    private static String strFilterDir = null;
    private static String strKeyDataDir = null;
    private static String strMailingListDir = null;
    private static String strTempMailDir = null;
    private static String strOutMailDir = null;
    private static int intMailPathPreLen = -1;
    private static int intMailPathCntLen = -1;
    private static String strBackupMailDir = null;
    private static int intBackupMailKeep = 0;
    private SimpleDateFormat sdf = null;
    private Date datBuffer = null;

    public FileStorage(LogContext logContext, Configuration configuration) {
        super(logContext, configuration);
        this.setThreadName("File Storage Manager");
        try {
            try {
                this.init();
            }
            catch (InitializationException initializationException) {
                this.dispose();
                throw initializationException;
            }
            catch (Throwable throwable) {
                logContext.write("? Unhandled Exception", throwable);
                this.dispose();
                throw new InitializationException();
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.resetThreadName();
            throw throwable;
        }
        Object var3_7 = null;
        this.resetThreadName();
    }

    protected Vector accountingReadAll_Impl() {
        String[] stringArray = new File(strAccDir).list();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].toUpperCase();
            if (string.endsWith(".CSV") && (string.startsWith("D") || string.startsWith("M")) && string.charAt(2) == '_') {
                string = String.valueOf(string.substring(0, 2)) + string.substring(3);
                string = string.substring(0, string.length() - 4);
                vector.addElement(string);
            }
            ++n;
        }
        return vector;
    }

    protected Vector accountingRead_Impl(String string) throws Throwable {
        File file = new File(strAccDir, String.valueOf(string.substring(0, 2)) + "_" + string.substring(2) + ".CSV");
        if (!file.exists()) {
            return new Vector(0);
        }
        Vector<AccountingRecord> vector = new Vector<AccountingRecord>();
        BufferedReader bufferedReader = null;
        AccountingRecord accountingRecord = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedReader.readLine();
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                accountingRecord = new AccountingRecord();
                accountingRecord.parse(string2);
                vector.addElement(accountingRecord);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Helper.close(bufferedReader);
            throw throwable;
        }
        Object var6_10 = null;
        Helper.close(bufferedReader);
        return vector;
    }

    protected void accountingStore_Impl(String string, String string2, long l, long l2) {
        this.logContext.write("D Updating accounts");
        this.logContext.write("A User " + string2 + ",ID=" + string + ",RCV=" + l + ",SND=" + l2);
        this.datBuffer.setTime(TimeFactory.getTime());
        String string3 = this.sdf.format(this.datBuffer);
        String string4 = string3.substring(0, 6);
        File file = null;
        String string5 = null;
        file = new File(strAccDir, "DU_" + string3 + ".CSV");
        string5 = string2;
        this.accUpdate(file, string, string5, l, l2);
        file = new File(strAccDir, "DD_" + string3 + ".CSV");
        string5 = HelperExtract.splitUserName_getDomain((String)string2);
        this.accUpdate(file, string, string5, l, l2);
        file = new File(strAccDir, "MU_" + string4 + ".CSV");
        string5 = string2;
        this.accUpdate(file, string, string5, l, l2);
        file = new File(strAccDir, "MD_" + string4 + ".CSV");
        string5 = HelperExtract.splitUserName_getDomain((String)string2);
        this.accUpdate(file, string, string5, l, l2);
        this.logContext.write("D Accounts updated");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void accUpdate(File file, String string, String string2, long l, long l2) {
        RandomAccessFile randomAccessFile;
        block11: {
            randomAccessFile = null;
            try {
                try {
                    Object object = lckAccounting;
                    synchronized (object) {
                        CharSequence charSequence;
                        randomAccessFile = new RandomAccessFile(file, "rw");
                        int n = (int)(randomAccessFile.length() / 157L);
                        if (n == 0) {
                            charSequence = new StringBuffer();
                            ((StringBuffer)charSequence).append("*");
                            ((StringBuffer)charSequence).append(",");
                            ((StringBuffer)charSequence).append(Helper.lset("Username/Domain", 129, ' '));
                            ((StringBuffer)charSequence).append(",");
                            ((StringBuffer)charSequence).append(Helper.rset("Bytes rcv", 11, ' '));
                            ((StringBuffer)charSequence).append(",");
                            ((StringBuffer)charSequence).append(Helper.rset("Bytes snd", 11, ' '));
                            ((StringBuffer)charSequence).append("\r\n");
                            randomAccessFile.writeBytes(((StringBuffer)charSequence).toString());
                            ++n;
                        }
                        charSequence = null;
                        AccountingRecord accountingRecord = new AccountingRecord();
                        int n2 = 1;
                        while (true) {
                            if (n2 >= n) {
                                randomAccessFile.seek(n * 157);
                                accountingRecord = new AccountingRecord(string, string2, l, l2);
                                randomAccessFile.writeBytes(accountingRecord.toString());
                                break block11;
                            }
                            randomAccessFile.seek(n2 * 157);
                            charSequence = randomAccessFile.readLine();
                            accountingRecord.parse((String)charSequence);
                            if (accountingRecord.strKey.equals(string2)) {
                                accountingRecord.lngBytesReceived += l;
                                accountingRecord.lngBytesSent += l2;
                                randomAccessFile.seek(n2 * 157);
                                randomAccessFile.writeBytes(accountingRecord.toString());
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 7, 9] lbl47 : MonitorExitStatement: MONITOREXIT : var10_7
                                Object var9_14 = null;
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.logContext.write("? Cannot update accounting", throwable);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                Helper.close(randomAccessFile);
                throw throwable;
            }
            Helper.close(randomAccessFile);
            return;
        }
        Object var9_16 = null;
        Helper.close(randomAccessFile);
    }

    private String ascii2hex(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(Integer.toHexString(string.charAt(n)));
            stringBuffer.append("-");
            ++n;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private String buildShortname(String string, String string2) {
        String string3 = string2;
        if (string3.length() > intMailPathPreLen) {
            string3 = string3.substring(0, intMailPathPreLen);
        }
        String string4 = "";
        boolean bl = false;
        int n = (int)Math.pow(10.0, intMailPathCntLen) - 1;
        int n2 = 0;
        while (n2 < n) {
            Object var10_10;
            Closeable closeable;
            string4 = String.valueOf(string) + string3 + HelperFormat.rset((long)n2, (int)intMailPathCntLen, (char)'0');
            File file = new File(string4, TRUENAME);
            if (file.exists()) {
                closeable = null;
                try {
                    try {
                        closeable = new BufferedReader(new FileReader(file));
                        bl = ((BufferedReader)closeable).readLine().equals(string2);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.logContext.write((Throwable)fileNotFoundException);
                        var10_10 = null;
                        Helper.close(closeable);
                        return null;
                    }
                    catch (IOException iOException) {
                        this.logContext.write((Throwable)iOException);
                        var10_10 = null;
                        Helper.close(closeable);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    Helper.close(closeable);
                    throw throwable;
                }
                var10_10 = null;
                Helper.close(closeable);
                if (bl) {
                    break;
                }
            } else {
                new File(string4).mkdirs();
                closeable = null;
                try {
                    try {
                        closeable = new PrintWriter(new FileWriter(file));
                        ((PrintWriter)closeable).println(string2);
                        ((PrintWriter)closeable).flush();
                    }
                    catch (IOException iOException) {
                        this.logContext.write((Throwable)iOException);
                        var10_10 = null;
                        ((PrintWriter)closeable).close();
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    ((PrintWriter)closeable).close();
                    throw throwable;
                }
                var10_10 = null;
                ((PrintWriter)closeable).close();
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            string4 = null;
        }
        return string4;
    }

    private void check() {
        String string;
        boolean bl = false;
        this.logContext.write("# Integrity check");
        Vector vector = this.domainReadAll_Impl();
        int n = 0;
        while (n < vector.size()) {
            string = (String)vector.elementAt(n);
            try {
                this.domainRead_Impl(string);
            }
            catch (Throwable throwable) {
                this.logContext.write("? Corrupted domain: " + string + " [" + throwable.toString() + "]");
                bl = true;
            }
            ++n;
        }
        n = 0;
        while (n < vector.size()) {
            string = (String)vector.elementAt(n);
            Vector vector2 = this.userReadAllByDomain_Impl(string);
            int n2 = 0;
            while (n2 < vector2.size()) {
                String string2 = (String)vector2.elementAt(n2);
                try {
                    this.userRead_Impl(string2);
                }
                catch (Throwable throwable) {
                    this.logContext.write("? Corrupted user: " + string2 + " [" + throwable.toString() + "]");
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            throw new InitializationException();
        }
        this.logContext.write("# Integrity check end");
    }

    protected void cleanup_Impl(boolean bl) throws Throwable {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        String string;
        this.logContext.write("# Starting Cleanup");
        long l = TimeFactory.getTime();
        if (intBackupMailKeep > 0) {
            this.logContext.write("D Removing mail backup");
            string = null;
            object = this.sdf;
            synchronized (object) {
                this.datBuffer.setTime(TimeFactory.getTime() - (long)intBackupMailKeep * 1000L * 60L * 60L * 24L);
                string = this.sdf.format(this.datBuffer);
            }
            object = Helper.platformPath(strBackupMailDir);
            stringArray2 = new File(strBackupMailDir).list();
            int n = 0;
            while (n < stringArray2.length) {
                File file = new File((String)object, stringArray2[n]);
                if (file.isDirectory() && HelperValidate.isNumeric((String)stringArray2[n]) && stringArray2[n].compareTo(string) <= 0) {
                    stringArray = new File(file, File.separator).list();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        new File(file, stringArray[n2]).delete();
                        ++n2;
                    }
                    file.delete();
                    this.logContext.write("D Removed outdated backup mail directory " + file + " with " + stringArray.length / 2 + " mails");
                }
                ++n;
            }
        }
        string = "";
        object = "";
        this.logContext.write("D Checking usermaildir");
        stringArray2 = new File(strUserMailDir);
        String[] stringArray3 = new File((File)stringArray2, "").list();
        int n = 0;
        while (n < stringArray3.length) {
            stringArray = new File((File)stringArray2, stringArray3[n]);
            if (stringArray.isDirectory() && (string = this.readTruename(stringArray.getPath())) != null) {
                if (this.domainRead_Impl(string) == null) {
                    this.logContext.write("! Deleting maildirectory for non-existing domain " + string);
                    this.domainDelete_Impl(string);
                } else {
                    String[] stringArray4 = new File((File)stringArray, "").list();
                    int n3 = 0;
                    while (n3 < stringArray4.length) {
                        File file = new File((File)stringArray, stringArray4[n3]);
                        if (file.isDirectory() && (object = String.valueOf(this.readTruename(file.getPath())) + "@" + string) != null) {
                            if (this.userRead_Impl((String)object) == null) {
                                this.logContext.write("! Deleting maildirectory for non-existing user " + (String)object);
                                this.userDelete_Impl((String)object);
                            } else {
                                String[] stringArray5 = new File(file, "").list();
                                int n4 = 0;
                                while (n4 < stringArray5.length) {
                                    File file2;
                                    MailHeaderRecord mailHeaderRecord;
                                    if (stringArray5[n4].endsWith(MAIL_EXT) && (mailHeaderRecord = this.mailReadHeader_Internal((file2 = new File(file, stringArray5[n4])).getPath())) != null && (l - mailHeaderRecord.getMailLockedTimestamp() >= 1800000L || bl)) {
                                        if (mailHeaderRecord.getMailDeleted()) {
                                            this.logContext.write("D Delete mail " + mailHeaderRecord.toString());
                                            file2.delete();
                                        } else if (mailHeaderRecord.getMailLocked()) {
                                            this.logContext.write("! Unlocked mail " + mailHeaderRecord.toString());
                                            mailHeaderRecord.setMailLocked(false);
                                            this.mailWriteHeader_Impl(mailHeaderRecord);
                                        }
                                    }
                                    ++n4;
                                }
                            }
                        }
                        ++n3;
                    }
                }
            }
            ++n;
        }
        this.logContext.write("D Checking outbound");
        String[] stringArray6 = new File(strOutMailDir, "").list();
        int n5 = 0;
        while (n5 < stringArray6.length) {
            File file;
            MailHeaderRecord mailHeaderRecord;
            if (stringArray6[n5].endsWith(MAIL_EXT) && (mailHeaderRecord = this.mailReadHeader_Internal((file = new File(strOutMailDir, stringArray6[n5])).getPath())) != null && (l - mailHeaderRecord.getMailLockedTimestamp() >= 1800000L || bl)) {
                if (mailHeaderRecord.getMailDeleted()) {
                    this.logContext.write("D Delete mail " + mailHeaderRecord.toString());
                    file.delete();
                } else if (mailHeaderRecord.getMailLocked()) {
                    this.logContext.write("! Unlocked mail " + mailHeaderRecord.toString());
                    mailHeaderRecord.setMailLocked(false);
                    this.mailWriteHeader_Impl(mailHeaderRecord);
                }
            }
            ++n5;
        }
        this.logContext.write("# Cleanup finished");
    }

    protected void commit_Impl() throws Throwable {
        this.logContext.write("D Commit " + this.vecFilesWritten.size() + " files");
        this.vecFilesWritten.removeAllElements();
    }

    private void convert() {
        String[] stringArray = new File(strUserMailDir).list();
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].endsWith(MAIL_EXT)) {
                    MailHeaderRecord mailHeaderRecord = this.mailReadHeader_Internal(String.valueOf(strUserMailDir) + stringArray[n]);
                    this.logContext.write("D Converting mail " + mailHeaderRecord.toString());
                    String string = mailHeaderRecord.getEnvelopeTo_Redirected();
                    String string2 = null;
                    string2 = mailHeaderRecord.getExternalMail() ? strOutMailDir : this.getStorageDir(string);
                    File file = new File(strUserMailDir, stringArray[n]);
                    File file2 = new File(string2, String.valueOf(mailHeaderRecord.getUID()) + MAIL_EXT);
                    LineReader lineReader = new LineReader(new FileInputStream(file));
                    LineWriter lineWriter = new LineWriter(new FileOutputStream(file2));
                    String string3 = null;
                    while ((string3 = lineReader.readln()) != null) {
                        lineWriter.println(string3);
                    }
                    lineWriter.flush();
                    Helper.close(lineReader);
                    Helper.close(lineWriter);
                    file.delete();
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            this.logContext.write("! Cannot convert mail directory (2.30c12->c13), abort", (Throwable)iOException);
            throw new StorageException();
        }
    }

    private void deldir(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        new File(string).delete();
    }

    public void dispose() {
        this.setThreadName();
        this.blnDisposed = true;
        this.rollback();
        super.dispose();
        this.vecFilesWritten = null;
        this.resetThreadName();
    }

    protected final void domainDelete_Impl(String string) throws Throwable {
        Object object;
        String string2 = "@" + string;
        File file = new File(strUserDir);
        String[] stringArray = file.list();
        new Vector(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(string2)) {
                new File(strUserDir, stringArray[n]).delete();
            }
            ++n;
        }
        new File(strDomainDir, string).delete();
        String string3 = this.getStorageDir(string);
        String[] stringArray2 = new File(string3).list();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            File file2 = new File(string3, stringArray2[n2]);
            if (file2.isDirectory()) {
                object = file2.list();
                int n3 = 0;
                while (n3 < ((String[])object).length) {
                    new File(file2.getPath(), (String)object[n3]).delete();
                    ++n3;
                }
            }
            file2.delete();
            ++n2;
        }
        this.deldir(string3);
        String[] stringArray3 = new File(strDomainDir).list();
        int n4 = 0;
        while (n4 < stringArray3.length) {
            object = this.domainRead_Impl(stringArray3[n4]);
            if (((DomainRecord)object).getDomainAlias().equalsIgnoreCase(string)) {
                ((DomainRecord)object).setDomainAlias("");
                this.domainWrite_Impl((DomainRecord)object);
            }
            ++n4;
        }
    }

    protected final Vector domainReadAll_Impl() {
        Vector<String> vector = new Vector<String>();
        Object object = lckDomain;
        synchronized (object) {
            File file = new File(strDomainDir);
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        Helper.sortVector(vector);
        return vector;
    }

    protected final DomainRecord domainRead_Impl(String string) throws IOException {
        if (string.length() == 0) {
            return null;
        }
        File file = new File(strDomainDir, string);
        if (!file.exists()) {
            return null;
        }
        Object object = lckDomain;
        synchronized (object) {
            DomainRecord domainRecord = new DomainRecord();
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            domainRecord.recordImport(new String(cArray));
            fileReader.close();
            return domainRecord;
        }
    }

    protected void domainRename_Impl(String string, String string2) throws Throwable {
        StorageRecord storageRecord;
        Object object;
        DomainRecord domainRecord = this.domainRead_Impl(string);
        if (domainRecord == null) {
            throw new IOException("Source domain doesn't exist");
        }
        DomainRecord domainRecord2 = this.domainRead_Impl(string2);
        if (domainRecord2 != null) {
            throw new IOException("Target domain already exists");
        }
        domainRecord2 = new DomainRecord();
        domainRecord2.recordImport(domainRecord.recordExport());
        domainRecord2.setDomainName(string2);
        this.domainWrite_Impl(domainRecord2);
        domainRecord.setDomainAlias(string2);
        this.domainWrite_Impl(domainRecord);
        String string3 = this.getStorageDir(string);
        String[] stringArray = new File(string3).list();
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(string3, stringArray[n]);
            if (file.isDirectory()) {
                object = file.list();
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    if (object[n2].endsWith(MAIL_EXT) && (storageRecord = this.mailReadHeader_Internal(String.valueOf(file.getPath()) + File.separator + object[n2])) != null) {
                        MailHeaderRecord mailHeaderRecord = new MailHeaderRecord();
                        mailHeaderRecord.recordImport(((MailHeaderRecord)storageRecord).recordExport());
                        String string4 = mailHeaderRecord.getEnvelopeTo_Redirected();
                        mailHeaderRecord.setEnvelopeTo_Redirected(String.valueOf(HelperExtract.splitUserName_getUser((String)string4)) + "@" + string2);
                        this.mailMove_Impl((MailHeaderRecord)storageRecord, mailHeaderRecord);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Vector vector = this.userReadAllByDomain_Impl(string);
        int n3 = 0;
        while (n3 < vector.size()) {
            object = (String)vector.elementAt(n3);
            UserRecord userRecord = this.userRead_Impl((String)object);
            storageRecord = new UserRecord();
            ((UserRecord)storageRecord).recordImport(userRecord.recordExport());
            ((UserRecord)storageRecord).setUserName(String.valueOf(HelperExtract.splitUserName_getUser((String)object)) + "@" + string2);
            this.userWrite_Impl((UserRecord)storageRecord);
            this.userDelete_Impl((String)object);
            ++n3;
        }
    }

    protected final void domainWrite_Impl(DomainRecord domainRecord) throws IOException {
        Object object = lckDomain;
        synchronized (object) {
            File file = new File(strDomainDir, "$$" + domainRecord.getDomainName());
            File file2 = new File(strDomainDir, domainRecord.getDomainName());
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(domainRecord.recordExport());
            fileWriter.flush();
            fileWriter.close();
            file2.delete();
            file.renameTo(file2);
        }
    }

    private String fillHeader(String string) {
        int n = 32;
        int n2 = string.length();
        if (n2 > 512) {
            this.logContext.write("? Header too long");
            throw new StorageException();
        }
        byte[] byArray = new byte[514];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)string.charAt(n3);
            ++n3;
        }
        n3 = n2++;
        while (n3 < 512) {
            byArray[n3] = n;
            ++n3;
        }
        byArray[512] = 13;
        byArray[513] = 10;
        return new String(byArray);
    }

    protected final void filterDelete_Impl(String string) {
        Object object = lckFilter;
        synchronized (object) {
            new File(strFilterDir, string).delete();
        }
    }

    protected final Vector filterReadAll_Impl() throws Throwable {
        Vector<String> vector = new Vector<String>();
        Object object = lckFilter;
        synchronized (object) {
            File file = new File(strFilterDir);
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        Helper.sortVector(vector);
        return vector;
    }

    protected final FilterRecord filterRead_Impl(String string) throws Throwable {
        if (string.length() == 0) {
            return null;
        }
        File file = new File(strFilterDir, string);
        if (!file.exists()) {
            return null;
        }
        Object object = lckFilter;
        synchronized (object) {
            FilterRecord filterRecord = new FilterRecord();
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            filterRecord.recordImport(new String(cArray));
            fileReader.close();
            return filterRecord;
        }
    }

    protected final void filterWrite_Impl(FilterRecord filterRecord) throws Throwable {
        Object object = lckFilter;
        synchronized (object) {
            File file = new File(strFilterDir, "$$" + filterRecord.getName());
            File file2 = new File(strFilterDir, filterRecord.getName());
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(filterRecord.recordExport());
            fileWriter.flush();
            fileWriter.close();
            file2.delete();
            file.renameTo(file2);
        }
    }

    private String getMailBackupDir() {
        if (strBackupMailDir.length() == 0) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = this.sdf;
        synchronized (simpleDateFormat) {
            String string = null;
            this.datBuffer.setTime(TimeFactory.getTime());
            string = this.sdf.format(this.datBuffer);
            String string2 = Helper.platformPath(String.valueOf(strBackupMailDir) + string + File.separator);
            new File(string2).mkdirs();
            return string2;
        }
    }

    private String getPath(String string) {
        String string2 = Helper.platformPath(prpConfig.getProperty(string));
        if (string2.length() == 0) {
            return "";
        }
        if (!string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        new File(string2).mkdirs();
        return string2;
    }

    private String getStorageDir(String string) {
        String string2 = null;
        String string3 = null;
        if (string.indexOf("@") == -1) {
            string2 = string;
            string3 = null;
        } else {
            string2 = HelperExtract.splitUserName_getDomain((String)string);
            string3 = HelperExtract.splitUserName_getUser((String)string);
        }
        String string4 = strUserMailDir;
        string4 = this.buildShortname(string4, string2);
        if (string4 == null) {
            this.logContext.write("? Cannot create domain shortname path for " + string);
            return null;
        }
        string4 = String.valueOf(string4) + File.separator;
        if (string3 == null) {
            return string4;
        }
        if ((string4 = this.buildShortname(string4, string3)) == null) {
            this.logContext.write("? Cannot create user shortname path for " + string);
            return null;
        }
        string4 = String.valueOf(string4) + File.separator;
        return string4;
    }

    private String hex2ascii(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append((char)Integer.valueOf(stringTokenizer.nextToken(), 16).intValue());
        }
        return stringBuffer.toString();
    }

    private void init() {
        if (!blnIsInitialized) {
            blnIsInitialized = true;
            this.initConfig();
            this.convert();
            this.check();
        }
        this.vecFilesWritten = new Vector();
        this.sdf = new SimpleDateFormat();
        this.sdf.applyPattern("yyyyMMdd");
        this.datBuffer = new Date();
    }

    private void initConfig() {
        prpConfig = new Properties();
        ((Hashtable)prpConfig).put("domaindir", "./domains/");
        ((Hashtable)prpConfig).put("userdir", "./users/");
        ((Hashtable)prpConfig).put("maildir", "./mails/");
        ((Hashtable)prpConfig).put("outmaildir", "./mails/outbound/");
        ((Hashtable)prpConfig).put("tempmaildir", "./mails/temp/");
        ((Hashtable)prpConfig).put("accdir", "./accounting/");
        ((Hashtable)prpConfig).put("filterdir", "./filters/");
        ((Hashtable)prpConfig).put("keydatadir", "./misc/");
        ((Hashtable)prpConfig).put("mailinglistdir", "./mailinglists/");
        ((Hashtable)prpConfig).put("mailpath_pre_len", "38");
        ((Hashtable)prpConfig).put("mailpath_cnt_len", "2");
        ((Hashtable)prpConfig).put("backupmaildir", "");
        ((Hashtable)prpConfig).put("backupmailkeep", "0");
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(CONFIG);
                prpConfig.load(fileInputStream);
            }
            catch (Throwable throwable) {
                this.logContext.write("? filestorage.ini not found, abort");
                this.dispose();
                throw new InitializationException();
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            Helper.close(fileInputStream);
            throw throwable;
        }
        File file = null;
        Helper.close(fileInputStream);
        strDomainDir = this.getPath("domaindir");
        strUserDir = this.getPath("userdir");
        strUserMailDir = this.getPath("maildir");
        strOutMailDir = this.getPath("outmaildir");
        strTempMailDir = this.getPath("tempmaildir");
        strAccDir = this.getPath("accdir");
        strFilterDir = this.getPath("filterdir");
        strKeyDataDir = this.getPath("keydatadir");
        strMailingListDir = this.getPath("mailinglistdir");
        intMailPathPreLen = Integer.parseInt(prpConfig.getProperty("mailpath_pre_len"));
        intMailPathCntLen = Integer.parseInt(prpConfig.getProperty("mailpath_cnt_len"));
        strBackupMailDir = this.getPath("backupmaildir");
        intBackupMailKeep = Integer.parseInt(prpConfig.getProperty("backupmailkeep"));
        this.logContext.write("D Domain directory: " + strDomainDir);
        this.logContext.write("D User directory  : " + strUserDir);
        this.logContext.write("D Mail directory  : " + strUserMailDir);
        this.logContext.write("D Outbound dir.   : " + strOutMailDir);
        this.logContext.write("D TempMail dir.   : " + strTempMailDir);
        this.logContext.write("D Accounting      : " + strAccDir);
        this.logContext.write("D Filters         : " + strFilterDir);
        this.logContext.write("D KeyData         : " + strKeyDataDir);
        this.logContext.write("D Mailinglists    : " + strMailingListDir);
        this.logContext.write("D Pathlen         : " + intMailPathPreLen);
        this.logContext.write("D Pathsuffix      : " + intMailPathCntLen);
        this.logContext.write("D Backupmaildir   : " + strBackupMailDir);
        this.logContext.write("D Backupmailkeep  : " + intBackupMailKeep);
        file = new File(strUserMailDir);
        File file2 = new File(strOutMailDir);
        File file3 = new File(strTempMailDir);
        if (file.equals(file2)) {
            this.logContext.write("? maildir = outmaildir. Must be different directories");
            throw new InitializationException();
        }
        if (file.equals(file3)) {
            this.logContext.write("? maildir = tempmaildir. Must be different directories");
            throw new InitializationException();
        }
        if (file2.equals(file3)) {
            this.logContext.write("? outmaildir = tempmaildir. Must be different directories");
            throw new InitializationException();
        }
    }

    protected final void keyDataDelete_Impl(String string, String string2, String string3) throws Throwable {
        Object object = lckKeyData;
        synchronized (object) {
            new File(strKeyDataDir, String.valueOf(string) + "#" + string2 + "#" + this.ascii2hex(string3)).delete();
        }
    }

    protected final Vector keyDataReadAll_Impl(String string, String string2) throws Throwable {
        Vector<String> vector = new Vector<String>();
        Object object = lckKeyData;
        synchronized (object) {
            File file = new File(strKeyDataDir);
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                int n2 = string3.indexOf("#") + 1;
                int n3 = string3.indexOf("#", n2);
                if (string.length() == 0) {
                    vector.addElement(string3.substring(0, n2));
                } else if (string3.startsWith(String.valueOf(string) + "#")) {
                    if (string2.length() == 0) {
                        vector.addElement(string3.substring(n2, n3));
                    } else if (string3.startsWith(String.valueOf(string) + "#" + string2 + "#")) {
                        vector.addElement(this.hex2ascii(string3.substring(n3 + 1)));
                    }
                }
                ++n;
            }
        }
        Helper.sortVector(vector);
        return vector;
    }

    protected final String keyDataRead_Impl(String string, String string2, String string3) throws Throwable {
        File file = new File(strKeyDataDir, String.valueOf(string) + "#" + string2 + "#" + this.ascii2hex(string3));
        if (!file.exists()) {
            return null;
        }
        Object object = lckKeyData;
        synchronized (object) {
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            fileReader.close();
            return new String(cArray);
        }
    }

    protected final void keyDataWrite_Impl(String string, String string2, String string3, String string4) throws Throwable {
        Object object = lckKeyData;
        synchronized (object) {
            File file = new File(strKeyDataDir, "$$" + string + "#" + string2 + "#" + this.ascii2hex(string3));
            File file2 = new File(strKeyDataDir, String.valueOf(string) + "#" + string2 + "#" + this.ascii2hex(string3));
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string4);
            fileWriter.close();
            file2.delete();
            file.renameTo(file2);
        }
    }

    protected final Vector mailGetAllHeaders_Impl() throws Throwable {
        Object object;
        Vector<MailHeaderRecord> vector = new Vector<MailHeaderRecord>();
        File file = new File(strUserMailDir);
        String[] stringArray = new File(file, "").list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                object = new File(file2, "").list();
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    File file3 = new File(file2, (String)object[n2]);
                    if (file3.isDirectory()) {
                        String[] stringArray2 = new File(file3, "").list();
                        int n3 = 0;
                        while (n3 < stringArray2.length) {
                            File file4;
                            MailHeaderRecord mailHeaderRecord;
                            if (stringArray2[n3].endsWith(MAIL_EXT) && (mailHeaderRecord = this.mailReadHeader_Internal((file4 = new File(file3, stringArray2[n3])).getPath())) != null) {
                                vector.addElement(mailHeaderRecord);
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        String[] stringArray3 = new File(strOutMailDir).list();
        int n4 = 0;
        while (n4 < stringArray3.length) {
            MailHeaderRecord mailHeaderRecord;
            if (stringArray3[n4].endsWith(MAIL_EXT) && (mailHeaderRecord = this.mailReadHeader_Internal(((File)(object = new File(strOutMailDir, stringArray3[n4]))).getPath())) != null) {
                vector.addElement(mailHeaderRecord);
            }
            ++n4;
        }
        return vector;
    }

    protected final Vector mailGetHeadersForDomain_Impl(String string) throws Throwable {
        Vector<MailHeaderRecord> vector = new Vector<MailHeaderRecord>();
        String string2 = this.getStorageDir(string);
        String[] stringArray = new File(string2).list();
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(string2, stringArray[n]);
            if (file.isDirectory()) {
                String[] stringArray2 = file.list();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    MailHeaderRecord mailHeaderRecord;
                    if (stringArray2[n2].endsWith(MAIL_EXT) && (mailHeaderRecord = this.mailReadHeader_Internal(String.valueOf(file.getPath()) + File.separator + stringArray2[n2])) != null && !mailHeaderRecord.getExternalMail() && !mailHeaderRecord.getMailDeleted() && !mailHeaderRecord.getMailLocked() && mailHeaderRecord.getIsHubMail()) {
                        vector.addElement(mailHeaderRecord);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return vector;
    }

    protected final Vector mailGetHeadersForUser_Impl(String string) throws Throwable {
        Vector<MailHeaderRecord> vector = new Vector<MailHeaderRecord>();
        String string2 = this.getStorageDir(string);
        String[] stringArray = new File(string2).list();
        int n = 0;
        while (n < stringArray.length) {
            MailHeaderRecord mailHeaderRecord;
            if (stringArray[n].endsWith(MAIL_EXT) && (mailHeaderRecord = this.mailReadHeader_Internal(String.valueOf(string2) + stringArray[n])) != null && !mailHeaderRecord.getExternalMail() && !mailHeaderRecord.getMailDeleted() && !mailHeaderRecord.getMailLocked() && mailHeaderRecord.getEnvelopeTo_Redirected().equals(string)) {
                vector.addElement(mailHeaderRecord);
            }
            ++n;
        }
        return vector;
    }

    protected final Vector mailGetHeadersToSend_Impl(int n, long l) throws Throwable {
        Vector<MailHeaderRecord> vector = new Vector<MailHeaderRecord>(n);
        long l2 = TimeFactory.getTime();
        String[] stringArray = new File(strOutMailDir).list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            MailHeaderRecord mailHeaderRecord;
            if (stringArray[n2].endsWith(MAIL_EXT) && (mailHeaderRecord = this.mailReadHeader_Internal(String.valueOf(strOutMailDir) + stringArray[n2])) != null && mailHeaderRecord.getExternalMail() && !mailHeaderRecord.getMailDeleted() && !mailHeaderRecord.getMailLocked() && (l2 - mailHeaderRecord.getTimeNextRetry() >= 0L || mailHeaderRecord.getRetryCount() <= 0)) {
                vector.addElement(mailHeaderRecord);
                if (vector.size() > n) break;
            }
            ++n2;
        }
        return vector;
    }

    protected final void mailinglistDelete_Impl(String string) {
        Object object = lckMailingList;
        synchronized (object) {
            new File(strMailingListDir, string).delete();
        }
    }

    protected final Vector mailinglistReadAll_Impl() {
        Vector<String> vector = new Vector<String>();
        Object object = lckMailingList;
        synchronized (object) {
            File file = new File(strMailingListDir);
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        Helper.sortVector(vector);
        return vector;
    }

    protected final MailingListRecord mailinglistRead_Impl(String string) throws IOException {
        if (string.length() == 0) {
            return null;
        }
        File file = new File(strMailingListDir, string);
        if (!file.exists()) {
            return null;
        }
        Object object = lckMailingList;
        synchronized (object) {
            MailingListRecord mailingListRecord = new MailingListRecord();
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            mailingListRecord.recordImport(new String(cArray));
            fileReader.close();
            return mailingListRecord;
        }
    }

    protected final void mailinglistWrite_Impl(MailingListRecord mailingListRecord) throws IOException {
        Object object = lckMailingList;
        synchronized (object) {
            new File(strMailingListDir);
            File file = new File(strMailingListDir, "$$" + mailingListRecord.getName());
            File file2 = new File(strMailingListDir, mailingListRecord.getName());
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(mailingListRecord.recordExport());
            fileWriter.flush();
            fileWriter.close();
            file2.delete();
            file.renameTo(file2);
        }
    }

    protected final void mailMove_Impl(MailHeaderRecord mailHeaderRecord, MailHeaderRecord mailHeaderRecord2) throws Throwable {
        String string = null;
        string = mailHeaderRecord.getExternalMail() ? strOutMailDir : this.getStorageDir(mailHeaderRecord.getEnvelopeTo_Redirected());
        String string2 = null;
        string2 = mailHeaderRecord2.getExternalMail() ? strOutMailDir : this.getStorageDir(mailHeaderRecord2.getEnvelopeTo_Redirected());
        if (string.equals(string2) && mailHeaderRecord.getUID().equals(mailHeaderRecord2.getUID())) {
            this.mailWriteHeader_Impl(mailHeaderRecord2);
            return;
        }
        Object object = lckMail;
        synchronized (object) {
            File file = new File(String.valueOf(string) + mailHeaderRecord.getUID() + MAIL_EXT);
            File file2 = new File(String.valueOf(string2) + mailHeaderRecord2.getUID() + MAIL_EXT);
            LineReader lineReader = new LineReader(new FileInputStream(file));
            LineWriter lineWriter = new LineWriter(new FileOutputStream(file2));
            String string3 = null;
            while ((string3 = lineReader.readln()) != null) {
                lineWriter.println(string3);
            }
            Helper.close(lineReader);
            Helper.close(lineWriter);
            this.mailWriteHeader_Impl(mailHeaderRecord2);
            file.delete();
        }
    }

    protected final void mailProcessQueueAdd_Impl(MailQueueRecord mailQueueRecord) throws Throwable {
        this.logContext.write("D Adding " + mailQueueRecord.toString() + " to Queue");
        File file = new File(strTempMailDir, String.valueOf(mailQueueRecord.strUID_Queue) + QUEUE_EXT);
        LineWriter lineWriter = null;
        try {
            Object object = lckProcessQueue;
            synchronized (object) {
                lineWriter = new LineWriter(new FileOutputStream(file));
                lineWriter.println(mailQueueRecord.strUID_Queue);
                lineWriter.println(String.valueOf(mailQueueRecord.blnAVScan));
                lineWriter.println(mailQueueRecord.strUID_Temp);
                lineWriter.println(String.valueOf(TimeFactory.getTime()));
                lineWriter.println(String.valueOf(mailQueueRecord.arrMHR.length));
                int n = 0;
                while (n < mailQueueRecord.arrMHR.length) {
                    lineWriter.println(mailQueueRecord.arrMHR[n].recordExport());
                    ++n;
                }
                lineWriter.flush();
                Helper.close(lineWriter);
            }
            this.logContext.write("D " + mailQueueRecord.toString() + " added");
        }
        catch (Throwable throwable) {
            Helper.close(lineWriter);
            file.delete();
            throw throwable;
        }
    }

    protected final Vector mailProcessQueueNext_Impl(int n) throws Throwable {
        File file = new File(strTempMailDir);
        String[] stringArray = file.list();
        Vector<MailQueueRecord> vector = new Vector<MailQueueRecord>(n);
        this.logContext.write("D Retrieving next mail from queue");
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2].toUpperCase();
            if (string.endsWith(QUEUE_EXT)) {
                LineReader lineReader = null;
                try {
                    Serializable serializable;
                    File file2 = new File(strTempMailDir, string);
                    Object object = lckProcessQueue;
                    synchronized (object) {
                        lineReader = new LineReader(new FileInputStream(file2));
                        serializable = new MailQueueRecord();
                        ((MailQueueRecord)serializable).strUID_Queue = lineReader.readln();
                        ((MailQueueRecord)serializable).blnAVScan = Boolean.valueOf(lineReader.readln());
                        ((MailQueueRecord)serializable).strUID_Temp = lineReader.readln();
                        lineReader.readln();
                        int n3 = Integer.parseInt(lineReader.readln());
                        ((MailQueueRecord)serializable).arrMHR = new MailHeaderRecord[n3];
                        int n4 = 0;
                        while (n4 < n3) {
                            ((MailQueueRecord)serializable).arrMHR[n4] = new MailHeaderRecord();
                            ((MailQueueRecord)serializable).arrMHR[n4].recordImport(lineReader.readln());
                            ++n4;
                        }
                        Helper.close(lineReader);
                        vector.addElement((MailQueueRecord)serializable);
                        this.logContext.write("D Retrieved " + ((MailQueueRecord)serializable).toString());
                    }
                    object = String.valueOf(string.substring(0, string.length() - QUEUE_EXT.length())) + QUEUE_LOCK_EXT;
                    serializable = new File(strTempMailDir, (String)object);
                    file2.renameTo((File)serializable);
                    if (((File)serializable).exists() && !file2.exists()) {
                        this.logContext.write("D Queuefile successfully locked");
                    } else {
                        this.logContext.write("? Queuefile not locked");
                    }
                    if (vector.size() > n) {
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Helper.close(lineReader);
                    throw throwable;
                }
            }
            ++n2;
        }
        if (vector.size() == 0) {
            this.logContext.write("D Nothing to do, queue empty");
        }
        return vector;
    }

    protected final void mailProcessQueueRemove_Impl(MailQueueRecord mailQueueRecord) throws Throwable {
        this.logContext.write("D Removing " + mailQueueRecord.toString() + " from queue");
        File file = new File(strTempMailDir, String.valueOf(mailQueueRecord.strUID_Queue) + QUEUE_LOCK_EXT);
        String string = this.getMailBackupDir();
        if (string != null) {
            File file2 = new File(string, String.valueOf(mailQueueRecord.strUID_Queue) + QUEUE_EXT);
            file.renameTo(file2);
            this.logContext.write("D " + file.getName() + " moved to " + file2.getPath());
        } else {
            file.delete();
            this.logContext.write("D " + file.getName() + " removed from queue");
        }
        this.tempDelete_Impl(mailQueueRecord.strUID_Temp);
    }

    protected final LineReader mailReadBody_Impl(MailHeaderRecord mailHeaderRecord) throws Throwable {
        String string = null;
        string = mailHeaderRecord.getExternalMail() ? strOutMailDir : this.getStorageDir(mailHeaderRecord.getEnvelopeTo_Redirected());
        File file = new File(String.valueOf(string) + mailHeaderRecord.getUID() + MAIL_EXT);
        if (!file.exists()) {
            this.logContext.write("? Mail " + mailHeaderRecord.getUID() + MAIL_EXT + " / " + mailHeaderRecord.toString() + " not found !");
            throw new StorageException();
        }
        LineReader lineReader = new LineReader(new FileInputStream(file));
        lineReader.readln();
        return lineReader;
    }

    protected final void mailReadBody_Impl(MailHeaderRecord mailHeaderRecord, POP3OutputWriter pOP3OutputWriter) throws Throwable {
        LineReader lineReader = this.mailReadBody_Impl(mailHeaderRecord);
        try {
            String string = null;
            while ((string = lineReader.readln()) != null) {
                pOP3OutputWriter.println(string);
                if (!pOP3OutputWriter.isFinished()) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            lineReader.close();
            throw throwable;
        }
        Object var4_7 = null;
        lineReader.close();
    }

    protected final MailHeaderRecord mailReadHeader_Impl(String string) throws Throwable {
        if (string.length() == 0) {
            return null;
        }
        File file = new File(strUserMailDir, String.valueOf(string) + MAIL_EXT);
        if (!file.exists()) {
            return null;
        }
        Object object = lckMail;
        synchronized (object) {
            return this.mailReadHeader_Internal(file.getPath());
        }
    }

    private final MailHeaderRecord mailReadHeader_Internal(String string) throws IOException {
        if (string.length() == 0) {
            return null;
        }
        File file = new File(string);
        if (file.length() == 0L) {
            return null;
        }
        LineReader lineReader = new LineReader(new FileInputStream(file));
        MailHeaderRecord mailHeaderRecord = new MailHeaderRecord();
        try {
            mailHeaderRecord.recordImport(lineReader.readln());
            lineReader.close();
            mailHeaderRecord.setMailSize(file.length() - 512L - 2L);
            return mailHeaderRecord;
        }
        catch (Throwable throwable) {
            lineReader.close();
            this.logContext.write("? Renamed corrupted mail " + string + " (" + throwable.getMessage() + ")");
            File file2 = new File(string);
            File file3 = new File(String.valueOf(string) + ".damaged");
            file2.renameTo(file3);
            return null;
        }
    }

    protected final void mailWriteFromString_Impl(MailHeaderRecord mailHeaderRecord, String string) throws Throwable {
        if (mailHeaderRecord.getUID().length() == 0) {
            this.logContext.write("? Empty UID");
            throw new StorageException();
        }
        this.mailWriteHeader_Impl(mailHeaderRecord);
        String string2 = null;
        string2 = mailHeaderRecord.getExternalMail() ? strOutMailDir : this.getStorageDir(mailHeaderRecord.getEnvelopeTo_Redirected());
        File file = new File(string2, String.valueOf(mailHeaderRecord.getUID()) + MAIL_EXT);
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(514L);
            randomAccessFile.writeBytes(string);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Helper.close(randomAccessFile);
            throw throwable;
        }
        Object var6_8 = null;
        Helper.close(randomAccessFile);
        mailHeaderRecord.setMailSize(string.length());
        this.mailWriteHeader_Impl(mailHeaderRecord);
    }

    protected final void mailWriteFromTemp_Impl(MailFilterChain mailFilterChain, MailHeaderRecord mailHeaderRecord, String string) throws Throwable {
        String string2;
        String string3;
        if (mailHeaderRecord.getUID().length() == 0) {
            this.logContext.write("? Empty UID");
            throw new StorageException();
        }
        File file = new File(String.valueOf(strTempMailDir) + string + TEMP_EXT);
        if (!file.exists()) {
            this.logContext.write("? Cannot find temporary file " + string + TEMP_EXT);
            throw new StorageException();
        }
        LineReader lineReader = null;
        if (mailFilterChain != null) {
            try {
                lineReader = new LineReader(new FileInputStream(file));
                string3 = null;
                while ((string3 = lineReader.readln()) != null) {
                    mailFilterChain.analyze(string3);
                    if (!mailFilterChain.canAbort()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                Helper.close(lineReader);
                throw throwable;
            }
            string2 = null;
            Helper.close(lineReader);
            if (mailFilterChain.canDelete()) {
                return;
            }
        }
        string2 = null;
        string2 = mailHeaderRecord.getExternalMail() ? strOutMailDir : this.getStorageDir(mailHeaderRecord.getEnvelopeTo_Redirected());
        string3 = this.fillHeader(mailHeaderRecord.recordExport());
        LineWriter lineWriter = null;
        File file2 = new File(string2, String.valueOf(mailHeaderRecord.getUID()) + MAIL_EXT);
        if (!this.vecFilesWritten.contains(file2.getPath())) {
            this.vecFilesWritten.addElement(file2.getPath());
        }
        try {
            lineReader = new LineReader(new FileInputStream(file));
            lineWriter = new LineWriter(new FileOutputStream(file2));
            lineWriter.write(string3);
            String string4 = null;
            while ((string4 = lineReader.readln()) != null) {
                if (mailFilterChain != null) {
                    string4 = mailFilterChain.process(string4);
                }
                if (string4 == null) continue;
                lineWriter.println(string4);
            }
            lineWriter.flush();
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            Helper.close(lineReader);
            Helper.close(lineWriter);
            throw throwable;
        }
        Object var10_15 = null;
        Helper.close(lineReader);
        Helper.close(lineWriter);
        mailHeaderRecord.setMailSize(file2.length() - 512L - 2L);
        this.mailWriteHeader_Impl(mailHeaderRecord);
    }

    protected final void mailWriteHeader_Impl(MailHeaderRecord mailHeaderRecord) throws Throwable {
        String string = null;
        string = mailHeaderRecord.getExternalMail() ? strOutMailDir : this.getStorageDir(mailHeaderRecord.getEnvelopeTo_Redirected());
        Object object = lckMail;
        synchronized (object) {
            File file = new File(String.valueOf(string) + mailHeaderRecord.getUID() + MAIL_EXT);
            if (!this.vecFilesWritten.contains(file.getPath())) {
                this.vecFilesWritten.addElement(file.getPath());
            }
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.seek(0L);
                randomAccessFile.writeBytes(this.fillHeader(mailHeaderRecord.recordExport()));
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Helper.close(randomAccessFile);
                throw throwable;
            }
            Object var6_8 = null;
            Helper.close(randomAccessFile);
        }
    }

    protected final void quotaCleanup_Impl() throws Throwable {
        this.logContext.write("# Quota cleanup starts");
        long l = TimeFactory.getTime();
        int n = 0;
        Vector vector = this.domainReadAll_Impl();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            DomainRecord domainRecord = this.domainRead(string);
            if (domainRecord.getQuota_Days() != 0) {
                long l2 = (long)domainRecord.getQuota_Days() * 24L * 60L * 60L * 1000L;
                Vector vector2 = this.userReadAllByDomain_Impl(string);
                int n3 = 0;
                while (n3 < vector2.size()) {
                    String string2 = (String)vector2.elementAt(n3);
                    UserRecord userRecord = this.userRead(string2);
                    if (userRecord != null && userRecord.getQuota_Usage() != 0) {
                        long l3 = l2;
                        if (userRecord.getQuota_Usage() == 2) {
                            l3 = (long)userRecord.getQuota_Days() * 24L * 60L * 60L * 1000L;
                        }
                        if (l3 != 0L) {
                            Vector vector3 = this.mailGetHeadersForUser(string2);
                            long l4 = l - l3;
                            int n4 = 0;
                            while (n4 < vector3.size()) {
                                MailHeaderRecord mailHeaderRecord = (MailHeaderRecord)vector3.elementAt(n4);
                                if (!mailHeaderRecord.getMailDeleted() && mailHeaderRecord.getTimeReceived() < l4) {
                                    mailHeaderRecord.setMailDeleted(true);
                                    this.mailWriteHeader_Impl(mailHeaderRecord);
                                    this.logContext.write("D Quota (time) deleted message " + mailHeaderRecord.toString());
                                    ++n;
                                }
                                ++n4;
                            }
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        this.logContext.write("# Quota cleanup finished (" + n + " deleted)");
    }

    protected final boolean quotaExceeded_Impl(String string) throws Throwable {
        String string2 = HelperExtract.splitUserName_getDomain((String)string);
        DomainRecord domainRecord = this.domainRead(string2);
        if (domainRecord == null) {
            return false;
        }
        UserRecord userRecord = this.userRead(string);
        if (userRecord == null) {
            return false;
        }
        if (userRecord.getQuota_Usage() == 0) {
            return false;
        }
        int n = domainRecord.getQuota_Mails();
        int n2 = domainRecord.getQuota_MB();
        if (userRecord.getQuota_Usage() == 2) {
            n = userRecord.getQuota_Mails();
            n2 = userRecord.getQuota_MB();
        }
        if (n == 0 && n2 == 0) {
            return false;
        }
        Vector vector = this.mailGetHeadersForUser(string);
        long l = MPA_ServerInstance.getMailSizeForUser(string);
        int n3 = MPA_ServerInstance.getMailCountForUser(string);
        int n4 = 0;
        while (n4 < vector.size()) {
            MailHeaderRecord mailHeaderRecord = (MailHeaderRecord)vector.elementAt(n4);
            if (!mailHeaderRecord.getMailDeleted()) {
                l += mailHeaderRecord.getMailSize();
                ++n3;
            }
            ++n4;
        }
        if (n > 0 && n3 > n) {
            this.logContext.write("! Quota (amount) exceeded for " + string);
            return true;
        }
        if (n2 > 0 && l > (long)n2 * 1024L * 1024L) {
            this.logContext.write("! Quota (size) exceeded for " + string);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readTruename(String string) {
        String string2;
        File file = new File(string, TRUENAME);
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                string2 = bufferedReader.readLine();
                Object var4_5 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Object var4_6 = null;
                Helper.close(bufferedReader);
                return null;
            }
            catch (IOException iOException) {
                Object var4_7 = null;
                Helper.close(bufferedReader);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            Helper.close(bufferedReader);
            throw throwable;
        }
        Helper.close(bufferedReader);
        return string2;
    }

    protected final void rollback_Impl() throws Throwable {
        if (this.vecFilesWritten == null) {
            return;
        }
        Vector vector = this.vecFilesWritten;
        synchronized (vector) {
            int n = 0;
            while (n < this.vecFilesWritten.size()) {
                File file = new File((String)this.vecFilesWritten.elementAt(n));
                this.logContext.write("D Rollback file " + file.toString());
                file.delete();
                ++n;
            }
            this.vecFilesWritten.removeAllElements();
        }
    }

    protected final void tempDelete_Impl(String string) throws Throwable {
        File file = new File(strTempMailDir, String.valueOf(string) + TEMP_EXT);
        String string2 = this.getMailBackupDir();
        if (string2 == null) {
            file.delete();
            this.logContext.write("D " + file.getName() + " removed from queue");
            return;
        }
        File file2 = new File(string2, String.valueOf(string) + TEMP_EXT);
        file.renameTo(file2);
        this.logContext.write("D " + file.getName() + " moved to " + file2.getPath());
    }

    protected final LineReader tempRead_Impl(String string) throws Throwable {
        File file = new File(strTempMailDir, String.valueOf(string) + TEMP_EXT);
        if (!file.exists()) {
            this.logContext.write("? Cannot find temporary file " + string + TEMP_EXT);
            throw new StorageException();
        }
        return new LineReader(new FileInputStream(file));
    }

    protected final LineWriter tempWrite_Impl(String string) throws Throwable {
        File file = new File(strTempMailDir, String.valueOf(string) + TEMP_EXT);
        if (!this.vecFilesWritten.contains(file.getPath())) {
            this.vecFilesWritten.addElement(file.getPath());
        }
        return new LineWriter(new FileOutputStream(file));
    }

    protected final void tempWrite_Impl(String string, LineReader lineReader) throws Throwable {
        LineWriter lineWriter = null;
        try {
            lineWriter = this.tempWrite_Impl(string);
            String string2 = null;
            while ((string2 = lineReader.readln()) != null) {
                lineWriter.println(string2);
            }
            lineWriter.flush();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Helper.close(lineWriter);
            throw throwable;
        }
        Object var4_7 = null;
        Helper.close(lineWriter);
    }

    public final String toString() {
        return "Local file storage";
    }

    protected final void userDelete_Impl(String string) throws Throwable {
        new File(strUserDir, string).delete();
        String string2 = this.getStorageDir(string);
        String[] stringArray = new File(string2).list();
        int n = 0;
        while (n < stringArray.length) {
            new File(string2, stringArray[n]).delete();
            ++n;
        }
        new File(string2.substring(0, string2.length() - 1)).delete();
        stringArray = new File(strUserDir).list();
        n = 0;
        while (n < stringArray.length) {
            UserRecord userRecord = this.userRead_Impl(stringArray[n]);
            String[] stringArray2 = userRecord.getCopy();
            int n2 = 0;
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (stringArray2[n3].equalsIgnoreCase(string)) {
                    stringArray2[n3] = null;
                    ++n2;
                }
                ++n3;
            }
            if (n2 != 0) {
                String[] stringArray3 = new String[stringArray2.length - n2];
                int n4 = 0;
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    if (stringArray2[n5] != null) {
                        stringArray3[n4++] = stringArray2[n5];
                    }
                    ++n5;
                }
                userRecord.setCopy(stringArray3);
                this.userWrite_Impl(userRecord);
            }
            ++n;
        }
    }

    protected final Vector userReadAllByDomain_Impl(String string) {
        Vector<String> vector = new Vector<String>();
        Object object = lckUser;
        synchronized (object) {
            String string2 = "@" + string;
            File file = new File(strUserDir);
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].endsWith(string2)) {
                    vector.addElement(stringArray[n]);
                }
                ++n;
            }
        }
        Helper.sortVector(vector);
        return vector;
    }

    protected final UserRecord userRead_Impl(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return null;
        }
        File file = new File(strUserDir, string);
        if (!file.exists()) {
            return null;
        }
        Object object = lckUser;
        synchronized (object) {
            UserRecord userRecord = new UserRecord();
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            userRecord.recordImport(new String(cArray));
            fileReader.close();
            return userRecord;
        }
    }

    protected final void userWrite_Impl(UserRecord userRecord) throws IOException {
        Object object = lckUser;
        synchronized (object) {
            File file = new File(strUserDir, "$$" + userRecord.getUserName());
            File file2 = new File(strUserDir, userRecord.getUserName());
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(userRecord.recordExport());
            fileWriter.flush();
            fileWriter.close();
            file2.delete();
            file.renameTo(file2);
        }
    }
}

