/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import java.io.Serializable;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.Helper;

public class UserRecord
extends StorageRecord
implements Serializable {
    public static final int RESTRICT_IP_NONE = 0;
    public static final int RESTRICT_IP_TO_DOMAIN_SETUP = 1;
    public static final int RESTRICT_IP_TO_USER_SETUP = 2;
    public static final int RESTRICT_IP_TO_DOMAIN_AND_USER_SETUP = 3;
    public static final int SMTP_AFTER_POP3_NO = 0;
    public static final int SMTP_AFTER_POP3_USE_DOMAIN_SETUP = 1;
    public static final int SMTP_AFTER_POP3_YES = 2;
    public static final int PRIVILEGE_NONE = -1;
    public static final int PRIVILEGE_USER = 0;
    public static final int PRIVILEGE_POWERUSER = 1;
    public static final int PRIVILEGE_DOMAINADMIN = 3;
    public static final int PRIVILEGE_SYSTEMADMIN = 4;
    public static final int PRIVILEGE_SUPERUSER = 5;
    public static final int QUOTA_NONE = 0;
    public static final int QUOTA_DOMAIN = 1;
    public static final int QUOTA_INDIVIDUAL = 2;
    private String strUserName = null;
    private String strPassWord = null;
    private String strRedirect = null;
    private String[] strCopy = null;
    private long lngPOP3_Time = -1L;
    private String strPOP3_IP = null;
    private int intSMTP_after_POP3 = -1;
    private int intSessionTimeout = -1;
    private int intRestrictIP_SMTP = -1;
    private int intRestrictIP_POP3 = -1;
    private IP_Network[] ipNetwork = null;
    private boolean blnEnabled = false;
    private int intPrivilege = -1;
    private String strMemo = null;
    private int intQuota_Usage = 1;
    private int intQuota_Days = 0;
    private int intQuota_Mails = 0;
    private int intQuota_MB = 0;
    private long lngLastMailReceived = -1L;
    private boolean blnAllowXREN = false;
    private boolean blnDUMMY1 = true;

    public UserRecord() {
        this.init();
    }

    public boolean getAllowXREN() {
        return this.blnAllowXREN;
    }

    public String[] getCopy() {
        return this.strCopy;
    }

    public boolean getEnabled() {
        return this.blnEnabled;
    }

    public IP_Network[] getIP_Networks() {
        return this.ipNetwork;
    }

    public long getLastMailReceived() {
        return this.lngLastMailReceived;
    }

    public String getMemo() {
        return this.strMemo;
    }

    public String getPassWord() {
        return this.strPassWord;
    }

    public String getPOP3_IP() {
        return this.strPOP3_IP;
    }

    public long getPOP3_Time() {
        return this.lngPOP3_Time;
    }

    public int getPrivilege() {
        return this.intPrivilege;
    }

    public static final String getPrivilegeString(int n) {
        switch (n) {
            case 0: {
                return "User";
            }
            case 1: {
                return "Power user";
            }
            case 3: {
                return "Domain administrator";
            }
            case 4: {
                return "System administrator";
            }
            case 5: {
                return "Superuser";
            }
        }
        return "Unknown user level";
    }

    public int getQuota_Days() {
        return this.intQuota_Days;
    }

    public int getQuota_Mails() {
        return this.intQuota_Mails;
    }

    public int getQuota_MB() {
        return this.intQuota_MB;
    }

    public int getQuota_Usage() {
        return this.intQuota_Usage;
    }

    public String getRedirect() {
        return this.strRedirect;
    }

    public int getRestrictIP_POP3() {
        return this.intRestrictIP_POP3;
    }

    public int getRestrictIP_SMTP() {
        return this.intRestrictIP_SMTP;
    }

    public int getSessionTimeout() {
        return this.intSessionTimeout;
    }

    public int getSMTP_after_POP3() {
        return this.intSMTP_after_POP3;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public void init() {
        this.strUserName = "";
        this.strPassWord = "";
        this.strRedirect = "";
        this.strCopy = new String[0];
        this.lngPOP3_Time = 0L;
        this.strPOP3_IP = "";
        this.intSMTP_after_POP3 = 1;
        this.intSessionTimeout = 30;
        this.intRestrictIP_SMTP = 1;
        this.intRestrictIP_POP3 = 1;
        this.ipNetwork = new IP_Network[0];
        this.blnEnabled = true;
        this.intPrivilege = 0;
        this.strMemo = "";
        this.intQuota_Usage = 1;
        this.intQuota_Days = 0;
        this.intQuota_Mails = 0;
        this.intQuota_MB = 0;
        this.lngLastMailReceived = 0L;
        this.blnAllowXREN = false;
        this.blnDUMMY1 = true;
    }

    public String recordExport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.strUserName);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strPassWord);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strRedirect);
        stringBuffer.append('\u0014');
        stringBuffer.append(StorageRecord.conv_array2string(this.strCopy));
        stringBuffer.append('\u0014');
        stringBuffer.append(this.lngPOP3_Time);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strPOP3_IP);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intSMTP_after_POP3);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intSessionTimeout);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intRestrictIP_SMTP);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intRestrictIP_POP3);
        stringBuffer.append('\u0014');
        stringBuffer.append(StorageRecord.conv_networks2string(this.ipNetwork));
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnEnabled);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intPrivilege);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strMemo);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intQuota_Usage);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intQuota_Days);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intQuota_Mails);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intQuota_MB);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.lngLastMailReceived);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnAllowXREN);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnDUMMY1);
        stringBuffer.append('\u0014');
        return stringBuffer.toString();
    }

    public void recordImport(String string) {
        this.initTokenizer(string);
        this.strUserName = this.nextToken();
        this.strPassWord = this.nextToken();
        this.strRedirect = this.nextToken();
        this.strCopy = StorageRecord.conv_string2array(this.nextToken());
        this.lngPOP3_Time = this.nextTokenLong();
        this.strPOP3_IP = this.nextToken();
        this.intSMTP_after_POP3 = this.nextTokenInteger();
        this.intSessionTimeout = this.nextTokenInteger();
        this.intRestrictIP_SMTP = this.nextTokenInteger();
        this.intRestrictIP_POP3 = this.nextTokenInteger();
        this.ipNetwork = StorageRecord.conv_string2networks(this.nextToken());
        this.blnEnabled = this.nextTokenBoolean();
        this.intPrivilege = this.nextTokenInteger();
        this.strMemo = this.nextToken();
        if (this.hasMoreTokens()) {
            this.intQuota_Usage = this.nextTokenInteger();
            this.intQuota_Days = this.nextTokenInteger();
            this.intQuota_Mails = this.nextTokenInteger();
            this.intQuota_MB = this.nextTokenInteger();
        }
        if (this.hasMoreTokens()) {
            this.lngLastMailReceived = this.nextTokenLong();
        }
        if (this.hasMoreTokens()) {
            this.blnAllowXREN = this.nextTokenBoolean();
        }
        if (this.hasMoreTokens()) {
            this.blnDUMMY1 = this.nextTokenBoolean();
        }
    }

    public void setAllowXREN(boolean bl) {
        this.blnAllowXREN = bl;
    }

    public void setCopy(String[] stringArray) {
        this.strCopy = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.strCopy[n] = Helper.limit(stringArray[n].toLowerCase(), 129);
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        this.blnEnabled = bl;
    }

    public void setIP_Networks(IP_Network[] iP_NetworkArray) {
        this.ipNetwork = iP_NetworkArray;
    }

    public void setLastMailReceived(long l) {
        this.lngLastMailReceived = l;
    }

    public void setMemo(String string) {
        this.strMemo = Helper.limit(string, 512);
    }

    public void setPassWord(String string) {
        this.strPassWord = Helper.limit(string.toLowerCase(), 32);
    }

    public void setPOP3_IP(String string) {
        this.strPOP3_IP = string;
    }

    public void setPOP3_Time(long l) {
        this.lngPOP3_Time = l;
    }

    public void setPrivilege(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Value " + n + " is out of range");
        }
        this.intPrivilege = n;
    }

    public void setQuota_Days(int n) {
        this.intQuota_Days = n;
    }

    public void setQuota_Mails(int n) {
        this.intQuota_Mails = n;
    }

    public void setQuota_MB(int n) {
        this.intQuota_MB = n;
    }

    public void setQuota_Usage(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.intQuota_Usage = n;
                break;
            }
            default: {
                throw new IllegalAccessError("Illegal value for QuotaUsage");
            }
        }
    }

    public void setRedirect(String string) {
        this.strRedirect = Helper.limit(string.toLowerCase(), 129);
    }

    public void setRestrictIP_POP3(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Value " + n + " is out of range");
        }
        this.intRestrictIP_POP3 = n;
    }

    public void setRestrictIP_SMTP(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Value " + n + " is out of range");
        }
        this.intRestrictIP_SMTP = n;
    }

    public void setSessionTimeout(int n) {
        this.intSessionTimeout = n;
    }

    public void setSMTP_after_POP3(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Value " + n + " is out of range");
        }
        this.intSMTP_after_POP3 = n;
    }

    public void setUserName(String string) {
        String string2 = HelperValidate.validateRFC822_User((String)string);
        if (string2 == null) {
            throw new IllegalArgumentException(String.valueOf(string) + " isn't a valid domain name");
        }
        this.strUserName = Helper.limit(string2.toLowerCase(), 129);
    }

    public String toString() {
        return this.getUserName();
    }

    public boolean validatePassword(String string) {
        return this.strPassWord.equals(string.toLowerCase());
    }
}

