/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.LogContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.event.PostmasterAlert;
import net.zerotoaster.io.LineReader;
import net.zerotoaster.io.LineWriter;
import net.zerotoaster.io.POP3OutputWriter;
import net.zerotoaster.io.RemoteFile;
import net.zerotoaster.mailfilters.MailFilterChain;
import net.zerotoaster.mta.MPA_ServerContainer;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.FilterRecord;
import net.zerotoaster.storage.LicenceRecord;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.MailQueueRecord;
import net.zerotoaster.storage.MailingListRecord;
import net.zerotoaster.storage.StatisticsRecord;
import net.zerotoaster.storage.StorageException;
import net.zerotoaster.storage.UserRecord;

public abstract class StorageManager
extends Application {
    protected LogContext logContext = null;
    protected Configuration cnfConfig = null;

    public StorageManager(LogContext logContext, Configuration configuration) {
        this.logContext = logContext;
        this.cnfConfig = configuration;
    }

    public Vector accountingRead(String string) {
        try {
            return this.accountingRead_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    public Vector accountingReadAll() {
        try {
            return this.accountingReadAll_Impl();
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector accountingReadAll_Impl() throws Throwable;

    protected abstract Vector accountingRead_Impl(String var1) throws Throwable;

    public void accountingStore(String string, String string2, long l, long l2) {
        try {
            this.accountingStore_Impl(string, string2, l, l2);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void accountingStore_Impl(String var1, String var2, long var3, long var5);

    public final void adminForceFetchmail() {
        try {
            this.adminForceFetchmail_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write("? Error during force fetchmail", throwable);
            throw new StorageException();
        }
    }

    protected abstract void adminForceFetchmail_Impl() throws Throwable;

    public final void adminFullRestart() {
        try {
            this.adminFullRestart_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write("? Error during fullrestart", throwable);
            throw new StorageException();
        }
    }

    protected abstract void adminFullRestart_Impl() throws Throwable;

    public final void adminRestart() {
        try {
            this.adminRestart_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write("? Error during restart", throwable);
            throw new StorageException();
        }
    }

    protected abstract void adminRestart_Impl() throws Throwable;

    public final void adminShutdown() {
        try {
            this.adminShutdown_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write("? Error during shutdown", throwable);
            throw new StorageException();
        }
    }

    protected abstract void adminShutdown_Impl() throws Throwable;

    public final void cleanup(boolean bl) {
        try {
            this.cleanup_Impl(bl);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void cleanup_Impl(boolean var1) throws Throwable;

    public final void commit() {
        try {
            this.commit_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void commit_Impl() throws Throwable;

    public void dispose() {
        this.blnDisposed = true;
    }

    public final void domainDelete(String string) {
        try {
            this.domainDelete_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void domainDelete_Impl(String var1) throws Throwable;

    public final DomainRecord domainRead(String string) {
        try {
            return this.domainRead_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    public final Vector domainReadAll() {
        try {
            return this.domainReadAll_Impl();
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector domainReadAll_Impl() throws Throwable;

    protected abstract DomainRecord domainRead_Impl(String var1) throws Throwable;

    public final void domainRename(String string, String string2) {
        try {
            this.domainRename_Impl(string, string2);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void domainRename_Impl(String var1, String var2) throws Throwable;

    public final void domainWrite(DomainRecord domainRecord) {
        try {
            this.domainWrite_Impl(domainRecord);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void domainWrite_Impl(DomainRecord var1) throws Throwable;

    public final void fileDelete(String string) {
        try {
            this.fileDelete_Impl(string);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void fileDelete_Impl(String var1) throws Throwable;

    public final RemoteFile fileGet(String string) {
        try {
            return this.fileGet_Impl(string);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract RemoteFile fileGet_Impl(String var1) throws Throwable;

    public final RemoteFile[] fileList(String string) {
        try {
            return this.fileList_Impl(string);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract RemoteFile[] fileList_Impl(String var1) throws Throwable;

    public final void fileLoad(String string, OutputStream outputStream) {
        try {
            this.fileLoad_Impl(string, outputStream);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void fileLoad_Impl(String var1, OutputStream var2) throws Throwable;

    public final void fileSave(String string, InputStream inputStream) {
        try {
            this.fileSave_Impl(string, inputStream);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void fileSave_Impl(String var1, InputStream var2) throws Throwable;

    public final void filterDelete(String string) {
        try {
            this.filterDelete_Impl(string);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void filterDelete_Impl(String var1) throws Throwable;

    public final FilterRecord filterRead(String string) {
        try {
            return this.filterRead_Impl(string);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    public final Vector filterReadAll() {
        try {
            return this.filterReadAll_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector filterReadAll_Impl() throws Throwable;

    protected abstract FilterRecord filterRead_Impl(String var1) throws Throwable;

    public final void filterWrite(FilterRecord filterRecord) {
        try {
            this.filterWrite_Impl(filterRecord);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void filterWrite_Impl(FilterRecord var1) throws Throwable;

    public final void keyDataDelete(String string, String string2, String string3) {
        try {
            this.keyDataDelete_Impl(string, string2, string3);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void keyDataDelete_Impl(String var1, String var2, String var3) throws Throwable;

    public final String keyDataRead(String string, String string2, String string3) {
        try {
            return this.keyDataRead_Impl(string, string2, string3);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    public final Vector keyDataReadAll(String string, String string2) {
        try {
            return this.keyDataReadAll_Impl(string, string2);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector keyDataReadAll_Impl(String var1, String var2) throws Throwable;

    protected abstract String keyDataRead_Impl(String var1, String var2, String var3) throws Throwable;

    public final void keyDataWrite(String string, String string2, String string3, String string4) {
        try {
            this.keyDataWrite_Impl(string, string2, string3, string4);
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void keyDataWrite_Impl(String var1, String var2, String var3, String var4) throws Throwable;

    public final String licenceCheck() {
        try {
            return this.licenceCheck_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected String licenceCheck_Impl() throws Throwable {
        Object object;
        Vector vector = this.domainReadAll_Impl();
        int n = vector.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            object = (String)vector.elementAt(n3);
            n2 += this.userReadAllByDomain_Impl((String)object).size();
            ++n3;
        }
        n3 = this.mailinglistReadAll_Impl().size();
        object = this.cnfConfig.lic;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (n > ((LicenceRecord)object).intMaxDomains) {
            stringBuffer.append("Domains (" + n + ", max: " + ((LicenceRecord)object).intMaxDomains + "), ");
            bl |= n > ((LicenceRecord)object).intMaxDomains + 1;
        }
        if (n2 > ((LicenceRecord)object).intMaxUsers) {
            stringBuffer.append("Users (" + n2 + ", max: " + ((LicenceRecord)object).intMaxUsers + "), ");
            bl |= n2 > ((LicenceRecord)object).intMaxUsers + 2;
        }
        if (n3 > ((LicenceRecord)object).intMaxLists) {
            stringBuffer.append("Mailinglists (" + n3 + ", max: " + ((LicenceRecord)object).intMaxLists + "), ");
            bl |= n3 > ((LicenceRecord)object).intMaxLists + 1;
        }
        if (stringBuffer.length() > 2) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        String string = LicenceRecord.long2date(((LicenceRecord)object).lngValidTo);
        String string2 = LicenceRecord.long2date(32004L);
        long l = Long.parseLong(String.valueOf(string.substring(3)) + string.substring(0, 2));
        long l2 = Long.parseLong(String.valueOf(string2.substring(3)) + string2.substring(0, 2));
        if (l2 > l) {
            stringBuffer.setLength(0);
            stringBuffer.append("Licence expired. Please backup to previous version.");
            bl = false;
            bl2 = true;
        }
        if (stringBuffer.length() == 0) {
            this.logContext.setSlowDown(0L);
            return "";
        }
        if (bl || bl2) {
            if (!bl2) {
                stringBuffer.insert(0, "Error: Too many ");
            }
            stringBuffer.append(". Server will run slower.");
            long l3 = this.logContext.getSlowDown();
            if (l3 == 0L) {
                l3 = 2000L;
            }
            this.logContext.setSlowDown(l3 += 50L);
            this.logContext.write("? " + stringBuffer.toString());
            MTAEventQueue.postEvent(new PostmasterAlert("ZeroToaster Licencemanager:\r\n" + stringBuffer.toString()));
            return stringBuffer.toString();
        }
        if (!bl2) {
            stringBuffer.insert(0, "Warning: Too many ");
            stringBuffer.append(".");
        }
        this.logContext.setSlowDown(0L);
        this.logContext.write("! " + stringBuffer.toString());
        MTAEventQueue.postEvent(new PostmasterAlert("ZeroToaster Licencemanager:\r\n" + stringBuffer.toString()));
        return stringBuffer.toString();
    }

    public final String[] logGet() {
        try {
            return this.logGet_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract String[] logGet_Impl() throws Throwable;

    public final Vector mailGetAllHeaders() {
        try {
            return this.mailGetAllHeaders_Impl();
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector mailGetAllHeaders_Impl() throws Throwable;

    public final Vector mailGetHeadersForDomain(String string) {
        try {
            return this.mailGetHeadersForDomain_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector mailGetHeadersForDomain_Impl(String var1) throws Throwable;

    public final Vector mailGetHeadersForUser(String string) {
        try {
            return this.mailGetHeadersForUser_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector mailGetHeadersForUser_Impl(String var1) throws Throwable;

    public final Vector mailGetHeadersToSend(int n, long l) {
        try {
            return this.mailGetHeadersToSend_Impl(n, l);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector mailGetHeadersToSend_Impl(int var1, long var2) throws Throwable;

    public void mailinglistDelete(String string) {
        try {
            this.mailinglistDelete_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void mailinglistDelete_Impl(String var1) throws Throwable;

    public MailingListRecord mailinglistRead(String string) {
        try {
            return this.mailinglistRead_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    public Vector mailinglistReadAll() {
        try {
            return this.mailinglistReadAll_Impl();
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector mailinglistReadAll_Impl() throws Throwable;

    protected abstract MailingListRecord mailinglistRead_Impl(String var1) throws Throwable;

    public void mailinglistWrite(MailingListRecord mailingListRecord) {
        try {
            this.mailinglistWrite_Impl(mailingListRecord);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void mailinglistWrite_Impl(MailingListRecord var1) throws Throwable;

    public final void mailMove(MailHeaderRecord mailHeaderRecord, MailHeaderRecord mailHeaderRecord2) {
        try {
            this.mailMove_Impl(mailHeaderRecord, mailHeaderRecord2);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void mailMove_Impl(MailHeaderRecord var1, MailHeaderRecord var2) throws Throwable;

    public final void mailProcessQueueAdd(MailQueueRecord mailQueueRecord) {
        try {
            this.mailProcessQueueAdd_Impl(mailQueueRecord);
            MPA_ServerContainer.notify_me();
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void mailProcessQueueAdd_Impl(MailQueueRecord var1) throws Throwable;

    public final Vector mailProcessQueueNext(int n) {
        try {
            return this.mailProcessQueueNext_Impl(n);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector mailProcessQueueNext_Impl(int var1) throws Throwable;

    public final void mailProcessQueueRemove(MailQueueRecord mailQueueRecord) {
        try {
            this.mailProcessQueueRemove_Impl(mailQueueRecord);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void mailProcessQueueRemove_Impl(MailQueueRecord var1) throws Throwable;

    public final LineReader mailReadBody(MailHeaderRecord mailHeaderRecord) {
        try {
            return this.mailReadBody_Impl(mailHeaderRecord);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    public final void mailReadBody(MailHeaderRecord mailHeaderRecord, POP3OutputWriter pOP3OutputWriter) {
        try {
            this.mailReadBody_Impl(mailHeaderRecord, pOP3OutputWriter);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract LineReader mailReadBody_Impl(MailHeaderRecord var1) throws Throwable;

    protected abstract void mailReadBody_Impl(MailHeaderRecord var1, POP3OutputWriter var2) throws Throwable;

    public final MailHeaderRecord mailReadHeader(String string) {
        try {
            return this.mailReadHeader_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract MailHeaderRecord mailReadHeader_Impl(String var1) throws Throwable;

    public final void mailWriteFromString(MailHeaderRecord mailHeaderRecord, String string) {
        try {
            this.mailWriteFromString_Impl(mailHeaderRecord, string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void mailWriteFromString_Impl(MailHeaderRecord var1, String var2) throws Throwable;

    public final void mailWriteFromTemp(MailFilterChain mailFilterChain, MailHeaderRecord mailHeaderRecord, String string) {
        try {
            this.mailWriteFromTemp_Impl(mailFilterChain, mailHeaderRecord, string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void mailWriteFromTemp_Impl(MailFilterChain var1, MailHeaderRecord var2, String var3) throws Throwable;

    public final void mailWriteHeader(MailHeaderRecord mailHeaderRecord) {
        try {
            this.mailWriteHeader_Impl(mailHeaderRecord);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void mailWriteHeader_Impl(MailHeaderRecord var1) throws Throwable;

    public final void quotaCleanup() {
        try {
            this.quotaCleanup_Impl();
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void quotaCleanup_Impl() throws Throwable;

    public final boolean quotaExceeded(String string) {
        try {
            return this.quotaExceeded_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract boolean quotaExceeded_Impl(String var1) throws Throwable;

    public final void rollback() {
        try {
            this.rollback_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void rollback_Impl() throws Throwable;

    public final StatisticsRecord statsGet() {
        try {
            return this.statsGet_Impl();
        }
        catch (Throwable throwable) {
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract StatisticsRecord statsGet_Impl() throws Throwable;

    public final void tempDelete(String string) {
        try {
            this.tempDelete_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void tempDelete_Impl(String var1) throws Throwable;

    public final LineReader tempRead(String string) {
        try {
            return this.tempRead_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract LineReader tempRead_Impl(String var1) throws Throwable;

    public final LineWriter tempWrite(String string) {
        try {
            return this.tempWrite_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    public final void tempWrite(String string, LineReader lineReader) {
        try {
            this.tempWrite_Impl(string, lineReader);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract LineWriter tempWrite_Impl(String var1) throws Throwable;

    protected abstract void tempWrite_Impl(String var1, LineReader var2) throws Throwable;

    public abstract String toString();

    public final void userDelete(String string) {
        try {
            this.userDelete_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void userDelete_Impl(String var1) throws Throwable;

    public final UserRecord userRead(String string) {
        try {
            return this.userRead_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    public final Vector userReadAllByDomain(String string) {
        try {
            return this.userReadAllByDomain_Impl(string);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract Vector userReadAllByDomain_Impl(String var1) throws Throwable;

    protected abstract UserRecord userRead_Impl(String var1) throws Throwable;

    public final void userWrite(UserRecord userRecord) {
        try {
            this.userWrite_Impl(userRecord);
        }
        catch (Throwable throwable) {
            this.rollback();
            this.logContext.write(throwable);
            throw new StorageException();
        }
    }

    protected abstract void userWrite_Impl(UserRecord var1) throws Throwable;
}

