/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.InitializationException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.io.LineReader;
import net.zerotoaster.io.LineWriter;
import net.zerotoaster.io.POP3OutputWriter;
import net.zerotoaster.io.RemoteFile;
import net.zerotoaster.mailfilters.MailFilterChain;
import net.zerotoaster.mta.ZeroToaster;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.FilterRecord;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.MailQueueRecord;
import net.zerotoaster.storage.MailingListRecord;
import net.zerotoaster.storage.RemoteStorageManager_Const;
import net.zerotoaster.storage.StatisticsRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.storage.UserRecord;
import net.zerotoaster.storage.VoidAnswer;
import net.zerotoaster.util.Helper;

public class RemoteStorageManager_Server
extends StorageManager
implements RemoteStorageManager_Const,
Runnable {
    private StorageManager smLocal = null;
    private Configuration cnfConfig = null;
    private ServerSocket ssok = null;
    private boolean blnRemoteRunning = false;
    private Vector vecThreads = null;
    private Thread thrdRemote = null;
    private String strLocalPassword = null;

    public RemoteStorageManager_Server(StorageManager storageManager, Configuration configuration) {
        super(storageManager.logContext, configuration);
        this.smLocal = storageManager;
    }

    protected Vector accountingReadAll_Impl() throws Throwable {
        return this.smLocal.accountingReadAll_Impl();
    }

    protected Vector accountingRead_Impl(String string) throws Throwable {
        return this.smLocal.accountingRead_Impl(string);
    }

    protected void accountingStore_Impl(String string, String string2, long l, long l2) {
        this.smLocal.accountingStore_Impl(string, string2, l, l2);
    }

    protected void adminForceFetchmail_Impl() throws Throwable {
        this.smLocal.adminForceFetchmail_Impl();
    }

    protected void adminFullRestart_Impl() throws Throwable {
        this.smLocal.adminFullRestart_Impl();
    }

    protected void adminRestart_Impl() throws Throwable {
        this.smLocal.adminRestart_Impl();
    }

    protected void adminShutdown_Impl() throws Throwable {
        this.smLocal.adminShutdown_Impl();
    }

    protected void cleanup_Impl(boolean bl) throws Throwable {
        this.smLocal.cleanup_Impl(bl);
    }

    protected void commit_Impl() throws Throwable {
        this.smLocal.commit_Impl();
    }

    private void dispatch(int n, ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Throwable {
        VoidAnswer voidAnswer = new VoidAnswer();
        try {
            try {
                switch (n) {
                    case 1: {
                        this.logContext.write("R noop");
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 2: {
                        this.logContext.write("R licence status get");
                        objectOutputStream.writeObject(this.licenceCheck_Impl());
                        break;
                    }
                    case 10: {
                        this.logContext.write("R domain delete");
                        this.domainDelete_Impl(objectInputStream.readUTF());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 12: {
                        this.logContext.write("R domain read");
                        objectOutputStream.writeObject(this.domainRead_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 11: {
                        this.logContext.write("R domain read all");
                        objectOutputStream.writeObject(this.domainReadAll_Impl());
                        break;
                    }
                    case 13: {
                        this.logContext.write("R domain write");
                        this.domainWrite_Impl((DomainRecord)objectInputStream.readObject());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 14: {
                        this.logContext.write("R domain rename");
                        this.domainRename_Impl(objectInputStream.readUTF(), objectInputStream.readUTF());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 70: {
                        this.logContext.write("R file delete");
                        this.fileDelete_Impl(objectInputStream.readUTF());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 74: {
                        this.logContext.write("R file get");
                        objectOutputStream.writeObject(this.fileGet_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 73: {
                        this.logContext.write("R file list");
                        objectOutputStream.writeObject(this.fileList_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 71: {
                        this.logContext.write("R file load");
                        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(objectOutputStream);
                        this.fileLoad_Impl(objectInputStream.readUTF(), deflaterOutputStream);
                        deflaterOutputStream.finish();
                        objectOutputStream.flush();
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 72: {
                        this.logContext.write("R file save");
                        InflaterInputStream inflaterInputStream = new InflaterInputStream(objectInputStream);
                        this.fileSave_Impl(objectInputStream.readUTF(), inflaterInputStream);
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 67: {
                        this.logContext.write("R server shutdown");
                        this.adminShutdown_Impl();
                        break;
                    }
                    case 68: {
                        this.logContext.write("R server restart");
                        this.adminRestart_Impl();
                        break;
                    }
                    case 69: {
                        this.logContext.write("R server full restart");
                        this.adminFullRestart_Impl();
                        break;
                    }
                    case 22: {
                        this.logContext.write("R mail get headers for user");
                        objectOutputStream.writeObject(this.mailGetHeadersForUser_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 24: {
                        this.logContext.write("R mail get headers to send");
                        objectOutputStream.writeObject(this.mailGetHeadersToSend_Impl(objectInputStream.readInt(), objectInputStream.readLong()));
                        break;
                    }
                    case 25: {
                        this.logContext.write("R mail get all headers");
                        objectOutputStream.writeObject(this.mailGetAllHeaders());
                        break;
                    }
                    case 26: {
                        this.logContext.write("R mail read body");
                        this.mailReadBody_Impl((MailHeaderRecord)objectInputStream.readObject(), new POP3OutputWriter(new LineWriter(objectOutputStream), 50));
                        objectOutputStream.flush();
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 27: {
                        this.logContext.write("R mail read header");
                        objectOutputStream.writeObject(this.mailReadHeader_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 29: {
                        this.logContext.write("R mail write header");
                        this.mailWriteHeader_Impl((MailHeaderRecord)objectInputStream.readObject());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 30: {
                        this.logContext.write("R mail write from string");
                        this.mailWriteFromString_Impl((MailHeaderRecord)objectInputStream.readObject(), objectInputStream.readUTF());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 31: {
                        this.logContext.write("R mail move");
                        this.mailMove_Impl((MailHeaderRecord)objectInputStream.readObject(), (MailHeaderRecord)objectInputStream.readObject());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 51: {
                        this.logContext.write("R user delete");
                        this.userDelete_Impl(objectInputStream.readUTF());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 53: {
                        this.logContext.write("R user read");
                        objectOutputStream.writeObject(this.userRead_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 52: {
                        this.logContext.write("R user read all by domain");
                        objectOutputStream.writeObject(this.userReadAllByDomain_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 54: {
                        this.logContext.write("R user write");
                        this.userWrite_Impl((UserRecord)objectInputStream.readObject());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 60: {
                        this.logContext.write("R commit");
                        this.commit();
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 61: {
                        this.logContext.write("R rollback");
                        this.rollback();
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 62: {
                        this.logContext.write("R cleanup");
                        this.cleanup(objectInputStream.readBoolean());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 81: {
                        this.logContext.write("R stats poll");
                        objectOutputStream.writeObject(this.statsGet());
                        break;
                    }
                    case 82: {
                        this.logContext.write("R logging poll");
                        objectOutputStream.writeObject(this.logGet());
                        break;
                    }
                    case 85: {
                        this.logContext.write("R force fetchmail");
                        this.adminForceFetchmail_Impl();
                        break;
                    }
                    case 40: {
                        this.logContext.write("R filter delete");
                        this.filterDelete_Impl(objectInputStream.readUTF());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 42: {
                        this.logContext.write("R filter read");
                        objectOutputStream.writeObject(this.filterRead_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 41: {
                        this.logContext.write("R filter read all");
                        objectOutputStream.writeObject(this.filterReadAll_Impl());
                        break;
                    }
                    case 43: {
                        this.logContext.write("R filter write");
                        this.filterWrite_Impl((FilterRecord)objectInputStream.readObject());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 90: {
                        this.logContext.write("R keydata delete");
                        this.keyDataDelete_Impl(objectInputStream.readUTF(), objectInputStream.readUTF(), objectInputStream.readUTF());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 92: {
                        this.logContext.write("R keydata read");
                        objectOutputStream.writeObject(this.keyDataRead_Impl(objectInputStream.readUTF(), objectInputStream.readUTF(), objectInputStream.readUTF()));
                        break;
                    }
                    case 91: {
                        this.logContext.write("R keydata read all");
                        objectOutputStream.writeObject(this.keyDataReadAll_Impl(objectInputStream.readUTF(), objectInputStream.readUTF()));
                        break;
                    }
                    case 93: {
                        this.logContext.write("R keydata write");
                        this.keyDataWrite_Impl(objectInputStream.readUTF(), objectInputStream.readUTF(), objectInputStream.readUTF(), objectInputStream.readUTF());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 100: {
                        this.logContext.write("R accounting read all");
                        objectOutputStream.writeObject(this.accountingReadAll_Impl());
                        break;
                    }
                    case 101: {
                        this.logContext.write("R accounting read");
                        objectOutputStream.writeObject(this.accountingRead_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 110: {
                        this.logContext.write("R mailinglist delete");
                        this.mailinglistDelete_Impl(objectInputStream.readUTF());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 112: {
                        this.logContext.write("R mailinglist read");
                        objectOutputStream.writeObject(this.mailinglistRead_Impl(objectInputStream.readUTF()));
                        break;
                    }
                    case 111: {
                        this.logContext.write("R mailinglist read all");
                        objectOutputStream.writeObject(this.mailinglistReadAll_Impl());
                        break;
                    }
                    case 113: {
                        this.logContext.write("R mailinglist write");
                        this.mailinglistWrite_Impl((MailingListRecord)objectInputStream.readObject());
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    case 120: {
                        this.logContext.write("R quota exceeded");
                        objectOutputStream.writeObject(new Boolean(this.quotaExceeded_Impl(objectInputStream.readUTF())));
                        break;
                    }
                    case 121: {
                        this.logContext.write("R quota cleanup");
                        this.quotaCleanup_Impl();
                        objectOutputStream.writeObject(voidAnswer);
                        break;
                    }
                    default: {
                        this.logContext.write("R unknown command " + n);
                        throw new RuntimeException("Unknown remote command " + n);
                    }
                }
            }
            catch (Throwable throwable) {
                objectOutputStream.writeObject(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            objectOutputStream.flush();
            objectOutputStream.reset();
            throw throwable;
        }
        Object var7_10 = null;
        objectOutputStream.flush();
        objectOutputStream.reset();
    }

    public void dispose() {
        if (this.ssok != null) {
            this.blnRemoteRunning = false;
            Helper.close(this.ssok);
            this.ssok = null;
            this.thrdRemote = null;
        }
        if (this.vecThreads != null) {
            while (this.vecThreads.size() > 0) {
                ((Scheduler)this.vecThreads.elementAt(0)).dispose();
            }
        }
        super.dispose();
    }

    protected void domainDelete_Impl(String string) throws Throwable {
        this.smLocal.domainDelete_Impl(string);
    }

    protected Vector domainReadAll_Impl() throws Throwable {
        return this.smLocal.domainReadAll_Impl();
    }

    protected DomainRecord domainRead_Impl(String string) throws Throwable {
        return this.smLocal.domainRead_Impl(string);
    }

    protected void domainRename_Impl(String string, String string2) throws Throwable {
        this.smLocal.domainRename_Impl(string, string2);
    }

    protected void domainWrite_Impl(DomainRecord domainRecord) throws Throwable {
        this.smLocal.domainWrite_Impl(domainRecord);
    }

    protected void fileDelete_Impl(String string) throws Throwable {
        this.smLocal.fileDelete_Impl(string);
    }

    protected RemoteFile fileGet_Impl(String string) throws Throwable {
        return this.smLocal.fileGet_Impl(string);
    }

    protected RemoteFile[] fileList_Impl(String string) throws Throwable {
        return this.smLocal.fileList_Impl(string);
    }

    protected void fileLoad_Impl(String string, OutputStream outputStream) throws Throwable {
        this.smLocal.fileLoad_Impl(string, outputStream);
    }

    protected void fileSave_Impl(String string, InputStream inputStream) throws Throwable {
        this.smLocal.fileSave_Impl(string, inputStream);
    }

    protected void filterDelete_Impl(String string) throws Throwable {
        this.smLocal.filterDelete_Impl(string);
    }

    protected Vector filterReadAll_Impl() throws Throwable {
        return this.smLocal.filterReadAll_Impl();
    }

    protected FilterRecord filterRead_Impl(String string) throws Throwable {
        return this.smLocal.filterRead_Impl(string);
    }

    protected void filterWrite_Impl(FilterRecord filterRecord) throws Throwable {
        this.smLocal.filterWrite_Impl(filterRecord);
    }

    public void initRemoteControl(Configuration configuration) {
        this.cnfConfig = configuration;
        if (this.ssok != null) {
            this.logContext.write("? Remote control service already started");
            throw new InitializationException();
        }
        try {
            InetAddress inetAddress = null;
            if (!configuration.strRemote_Host.startsWith("*")) {
                inetAddress = InetAddress.getByName(HelperExtract.splitIP_getHost((String)configuration.strRemote_Host));
            }
            this.ssok = new ServerSocket(HelperExtract.splitIP_getPort((String)configuration.strRemote_Host, (int)411), 5, inetAddress);
        }
        catch (Throwable throwable) {
            this.logContext.write("? Cannot start remote control socket", throwable);
            throw new InitializationException();
        }
        this.strLocalPassword = this.strLocalPassword;
        this.blnRemoteRunning = true;
        this.thrdRemote = new Thread((Runnable)this, "Remote-Control");
        this.thrdRemote.start();
    }

    protected void keyDataDelete_Impl(String string, String string2, String string3) throws Throwable {
        this.smLocal.keyDataDelete_Impl(string, string2, string3);
    }

    protected Vector keyDataReadAll_Impl(String string, String string2) {
        return this.smLocal.keyDataReadAll(string, string2);
    }

    protected String keyDataRead_Impl(String string, String string2, String string3) throws Throwable {
        return this.smLocal.keyDataRead_Impl(string, string2, string3);
    }

    protected void keyDataWrite_Impl(String string, String string2, String string3, String string4) throws Throwable {
        this.smLocal.keyDataWrite_Impl(string, string2, string3, string4);
    }

    protected String licenceCheck_Impl() throws Throwable {
        return this.smLocal.licenceCheck_Impl();
    }

    protected String[] logGet_Impl() throws Throwable {
        return this.smLocal.logGet_Impl();
    }

    protected Vector mailGetAllHeaders_Impl() throws Throwable {
        return this.smLocal.mailGetAllHeaders();
    }

    protected Vector mailGetHeadersForDomain_Impl(String string) throws Throwable {
        return this.smLocal.mailGetHeadersForDomain_Impl(string);
    }

    protected Vector mailGetHeadersForUser_Impl(String string) throws Throwable {
        return this.smLocal.mailGetHeadersForUser_Impl(string);
    }

    protected Vector mailGetHeadersToSend_Impl(int n, long l) throws Throwable {
        return this.smLocal.mailGetHeadersToSend_Impl(n, l);
    }

    protected void mailinglistDelete_Impl(String string) throws Throwable {
        this.smLocal.mailinglistDelete_Impl(string);
    }

    protected Vector mailinglistReadAll_Impl() throws Throwable {
        return this.smLocal.mailinglistReadAll_Impl();
    }

    protected MailingListRecord mailinglistRead_Impl(String string) throws Throwable {
        return this.smLocal.mailinglistRead_Impl(string);
    }

    protected void mailinglistWrite_Impl(MailingListRecord mailingListRecord) throws Throwable {
        this.smLocal.mailinglistWrite_Impl(mailingListRecord);
    }

    protected void mailMove_Impl(MailHeaderRecord mailHeaderRecord, MailHeaderRecord mailHeaderRecord2) throws Throwable {
        this.smLocal.mailMove_Impl(mailHeaderRecord, mailHeaderRecord2);
    }

    protected void mailProcessQueueAdd_Impl(MailQueueRecord mailQueueRecord) throws Throwable {
        this.smLocal.mailProcessQueueAdd_Impl(mailQueueRecord);
    }

    protected Vector mailProcessQueueNext_Impl(int n) throws Throwable {
        return this.smLocal.mailProcessQueueNext_Impl(n);
    }

    protected void mailProcessQueueRemove_Impl(MailQueueRecord mailQueueRecord) throws Throwable {
        this.smLocal.mailProcessQueueRemove_Impl(mailQueueRecord);
    }

    protected LineReader mailReadBody_Impl(MailHeaderRecord mailHeaderRecord) throws Throwable {
        return this.smLocal.mailReadBody_Impl(mailHeaderRecord);
    }

    protected void mailReadBody_Impl(MailHeaderRecord mailHeaderRecord, POP3OutputWriter pOP3OutputWriter) throws Throwable {
        this.smLocal.mailReadBody_Impl(mailHeaderRecord, pOP3OutputWriter);
    }

    protected MailHeaderRecord mailReadHeader_Impl(String string) throws Throwable {
        return this.smLocal.mailReadHeader_Impl(string);
    }

    protected void mailWriteFromString_Impl(MailHeaderRecord mailHeaderRecord, String string) throws Throwable {
        this.smLocal.mailWriteFromString_Impl(mailHeaderRecord, string);
    }

    protected void mailWriteFromTemp_Impl(MailFilterChain mailFilterChain, MailHeaderRecord mailHeaderRecord, String string) throws Throwable {
        this.smLocal.mailWriteFromTemp_Impl(mailFilterChain, mailHeaderRecord, string);
    }

    protected void mailWriteHeader_Impl(MailHeaderRecord mailHeaderRecord) throws Throwable {
        this.smLocal.mailWriteHeader_Impl(mailHeaderRecord);
    }

    protected void quotaCleanup_Impl() throws Throwable {
        this.smLocal.quotaCleanup_Impl();
    }

    protected boolean quotaExceeded_Impl(String string) throws Throwable {
        return this.smLocal.quotaExceeded_Impl(string);
    }

    protected void rollback_Impl() throws Throwable {
        this.smLocal.rollback_Impl();
    }

    public void run() {
        this.vecThreads = new Vector();
        this.logContext.write("# Remote control starting on " + this.ssok.getInetAddress());
        while (this.blnRemoteRunning) {
            Closeable closeable;
            Socket socket = null;
            try {
                socket = this.ssok.accept();
                if (!this.blnRemoteRunning) {
                    this.logContext.write("# Remote control closing");
                    return;
                }
                this.logContext.write("! Incoming remote control: " + socket.getInetAddress());
                closeable = new ObjectInputStream(socket.getInputStream());
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                Scheduler scheduler = new Scheduler(this, this, socket, objectOutputStream, (ObjectInputStream)closeable);
                scheduler.setName("Remote-Control " + socket.getInetAddress());
            }
            catch (StreamCorruptedException streamCorruptedException) {
                try {
                    closeable = new PrintWriter(socket.getOutputStream());
                    closeable.println("You failed.");
                    Helper.close(socket);
                    this.logContext.write("? Remote control server rejected incoming TELNET session");
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Helper.close(socket);
                if (!this.blnRemoteRunning) continue;
                this.logContext.write("? Remote control server", throwable);
            }
        }
    }

    protected StatisticsRecord statsGet_Impl() throws Throwable {
        StatisticsRecord statisticsRecord = this.smLocal.statsGet_Impl();
        return (StatisticsRecord)statisticsRecord.clone();
    }

    protected void tempDelete_Impl(String string) throws Throwable {
        this.smLocal.tempDelete_Impl(string);
    }

    protected LineReader tempRead_Impl(String string) throws Throwable {
        return this.smLocal.tempRead_Impl(string);
    }

    protected LineWriter tempWrite_Impl(String string) throws Throwable {
        return this.smLocal.tempWrite_Impl(string);
    }

    protected void tempWrite_Impl(String string, LineReader lineReader) throws Throwable {
        this.smLocal.tempWrite_Impl(string, lineReader);
    }

    public String toString() {
        return "remote storage manager server";
    }

    protected void userDelete_Impl(String string) throws Throwable {
        this.smLocal.userDelete_Impl(string);
    }

    protected Vector userReadAllByDomain_Impl(String string) throws Throwable {
        return this.smLocal.userReadAllByDomain_Impl(string);
    }

    protected UserRecord userRead_Impl(String string) throws Throwable {
        return this.smLocal.userRead_Impl(string);
    }

    protected void userWrite_Impl(UserRecord userRecord) throws Throwable {
        this.smLocal.userWrite_Impl(userRecord);
    }

    static Vector access$vecThreads(RemoteStorageManager_Server remoteStorageManager_Server) {
        return remoteStorageManager_Server.vecThreads;
    }

    static Configuration access$cnfConfig(RemoteStorageManager_Server remoteStorageManager_Server) {
        return remoteStorageManager_Server.cnfConfig;
    }

    static void access$dispatch(RemoteStorageManager_Server remoteStorageManager_Server, int n, ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Throwable {
        remoteStorageManager_Server.dispatch(n, objectInputStream, objectOutputStream);
    }

    public class Scheduler
    extends Thread {
        /* synthetic */ RemoteStorageManager_Server this$0;
        private Socket sok;
        private StorageManager sm;
        private InputStream in;
        private OutputStream out;
        private ObjectInputStream ois;
        private ObjectOutputStream oos;
        private boolean blnSchedulerRunning = true;

        public Scheduler(RemoteStorageManager_Server remoteStorageManager_Server, StorageManager storageManager, Socket socket, ObjectOutputStream objectOutputStream, ObjectInputStream objectInputStream) throws IOException {
            this.this$0 = remoteStorageManager_Server;
            this.sm = storageManager;
            this.ois = objectInputStream;
            this.oos = objectOutputStream;
            this.sok = socket;
            RemoteStorageManager_Server.access$vecThreads(remoteStorageManager_Server).addElement(this);
            this.start();
        }

        public void run() {
            boolean bl = false;
            while (this.blnSchedulerRunning) {
                try {
                    int n;
                    try {
                        n = this.ois.readInt();
                    }
                    catch (IOException iOException) {
                        n = 66;
                    }
                    if (n == 66) {
                        this.dispose();
                        return;
                    }
                    if (!bl) {
                        if (n != 65) {
                            this.oos.writeInt(-3);
                            this.oos.writeUTF(ZeroToaster.getVersion());
                            this.oos.flush();
                            this.oos.reset();
                            this.dispose();
                            return;
                        }
                        String string = this.ois.readUTF();
                        String string2 = this.ois.readUTF();
                        if (string.equals(RemoteStorageManager_Server.access$cnfConfig((RemoteStorageManager_Server)this.this$0).strRemote_Admin_User) && string2.equals(RemoteStorageManager_Server.access$cnfConfig((RemoteStorageManager_Server)this.this$0).strRemote_Admin_Pass)) {
                            this.oos.writeInt(5);
                            this.oos.writeUTF(ZeroToaster.getVersion());
                            this.oos.flush();
                            this.oos.reset();
                            bl = true;
                            continue;
                        }
                        UserRecord userRecord = this.sm.userRead(string);
                        if (userRecord == null) {
                            this.oos.writeInt(-1);
                            this.oos.writeUTF(ZeroToaster.getVersion());
                            this.oos.flush();
                            this.oos.reset();
                            this.dispose();
                            return;
                        }
                        if (!string2.equalsIgnoreCase(userRecord.getPassWord())) {
                            this.oos.writeInt(-2);
                            this.oos.writeUTF(ZeroToaster.getVersion());
                            this.oos.flush();
                            this.oos.reset();
                            this.dispose();
                            return;
                        }
                        this.oos.writeInt(userRecord.getPrivilege());
                        this.oos.writeUTF(ZeroToaster.getVersion());
                        this.oos.flush();
                        this.oos.reset();
                        bl = true;
                        continue;
                    }
                    RemoteStorageManager_Server.access$dispatch(this.this$0, n, this.ois, this.oos);
                }
                catch (Throwable throwable) {
                    this.this$0.logContext.write("? Remotecontrol:", throwable);
                    this.blnSchedulerRunning = false;
                    break;
                }
            }
            this.dispose();
        }

        public void dispose() {
            this.this$0.logContext.write("# Remote control end");
            this.blnSchedulerRunning = false;
            Helper.flush(this.oos);
            Helper.close(this.sok);
            RemoteStorageManager_Server.access$vecThreads(this.this$0).removeElement(this);
        }
    }
}

