/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.io.LineReader;
import net.zerotoaster.io.LineWriter;
import net.zerotoaster.io.POP3OutputWriter;
import net.zerotoaster.io.RemoteFile;
import net.zerotoaster.mailfilters.MailFilterChain;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.FilterRecord;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.MailQueueRecord;
import net.zerotoaster.storage.MailingListRecord;
import net.zerotoaster.storage.RemoteStorageManager_Const;
import net.zerotoaster.storage.StatisticsRecord;
import net.zerotoaster.storage.StorageException;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.storage.UserRecord;
import net.zerotoaster.util.Helper;

public class RemoteStorageManager_Client
extends StorageManager
implements RemoteStorageManager_Const {
    private Socket sok = null;
    private ObjectOutputStream oos = null;
    private ObjectInputStream ois = null;
    private String strRemote_IP = null;
    private int intRemote_Port = 0;
    private String strRemote_User = null;
    private String strRemote_Pass = null;
    private String strRemote_Version = null;
    private NoopThread thrdNoop = null;

    public RemoteStorageManager_Client(LogContext logContext, Configuration configuration) {
        super(logContext, configuration);
    }

    protected Vector accountingReadAll_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(100);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected Vector accountingRead_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(101);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected void accountingStore_Impl(String string, String string2, long l, long l2) {
        throw new StorageException();
    }

    protected void adminForceFetchmail_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(85);
            this.oos.flush();
            this.oos.reset();
        }
    }

    protected void adminFullRestart_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(69);
            this.oos.flush();
            this.oos.reset();
        }
    }

    protected void adminRestart_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(68);
            this.oos.flush();
            this.oos.reset();
        }
    }

    protected void adminShutdown_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(67);
            this.oos.flush();
            this.oos.reset();
        }
    }

    protected void cleanup_Impl(boolean bl) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(62);
            this.oos.writeBoolean(bl);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void commit_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(60);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    public int connectToServer(String string, String string2, String string3) {
        if (this.sok != null) {
            this.dispose();
        }
        this.strRemote_User = "";
        this.strRemote_Pass = "";
        this.strRemote_IP = HelperExtract.splitIP_getHost((String)string);
        this.intRemote_Port = HelperExtract.splitIP_getPort((String)string, (int)411);
        this.strRemote_Version = "";
        try {
            this.sok = new Socket(this.strRemote_IP, this.intRemote_Port);
        }
        catch (Throwable throwable) {
            this.logContext.write("? Cannot open Socket IP=" + this.strRemote_IP + ", Port=" + this.intRemote_Port, throwable);
            throw new InitializationException();
        }
        try {
            this.oos = new ObjectOutputStream(this.sok.getOutputStream());
            this.ois = new ObjectInputStream(this.sok.getInputStream());
        }
        catch (Throwable throwable) {
            this.logContext.write("? Cannot create streams", throwable);
            throw new InitializationException();
        }
        int n = -3;
        try {
            this.oos.writeInt(65);
            this.oos.writeUTF(string2);
            this.oos.writeUTF(string3);
            this.oos.flush();
            n = this.ois.readInt();
            this.strRemote_Version = this.ois.readUTF();
            this.oos.reset();
        }
        catch (Throwable throwable) {
            this.logContext.write("? Error during logon", throwable);
            throw new InitializationException();
        }
        this.thrdNoop = new NoopThread(this, 30000L);
        this.strRemote_User = string2;
        this.strRemote_Pass = string3;
        return n;
    }

    public void dispose() {
        if (this.sok != null) {
            if (this.thrdNoop != null) {
                this.thrdNoop.dispose();
                this.thrdNoop = null;
            }
            Socket socket = this.sok;
            synchronized (socket) {
                try {
                    this.oos.writeInt(66);
                    this.oos.flush();
                    this.oos.reset();
                }
                catch (Throwable throwable) {}
                Helper.close(this.oos);
                Helper.close(this.ois);
                Helper.close(this.sok);
            }
            this.oos = null;
            this.ois = null;
            this.sok = null;
        }
        super.dispose();
    }

    protected void domainDelete_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(10);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected Vector domainReadAll_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(11);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected DomainRecord domainRead_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(12);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (DomainRecord)object;
        }
    }

    protected void domainRename_Impl(String string, String string2) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(14);
            this.oos.writeUTF(string);
            this.oos.writeUTF(string2);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void domainWrite_Impl(DomainRecord domainRecord) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(13);
            this.oos.writeObject(domainRecord);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void fileDelete_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(70);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected RemoteFile fileGet_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(74);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (RemoteFile)object;
        }
    }

    protected RemoteFile[] fileList_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(73);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (RemoteFile[])object;
        }
    }

    protected void fileLoad_Impl(String string, OutputStream outputStream) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(71);
            this.oos.writeUTF(string);
            this.oos.flush();
            byte[] byArray = new byte[1024];
            int n = 0;
            InflaterInputStream inflaterInputStream = new InflaterInputStream(this.ois);
            while ((n = inflaterInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void fileSave_Impl(String string, InputStream inputStream) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(72);
            this.oos.writeUTF(string);
            this.oos.flush();
            byte[] byArray = new byte[1024];
            int n = 0;
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(this.oos);
            while ((n = inputStream.read(byArray)) != -1) {
                deflaterOutputStream.write(byArray, 0, n);
            }
            deflaterOutputStream.finish();
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void filterDelete_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(40);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected Vector filterReadAll_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(41);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected FilterRecord filterRead_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(42);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (FilterRecord)object;
        }
    }

    protected void filterWrite_Impl(FilterRecord filterRecord) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(43);
            this.oos.writeObject(filterRecord);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void keyDataDelete_Impl(String string, String string2, String string3) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(90);
            this.oos.writeUTF(string);
            this.oos.writeUTF(string2);
            this.oos.writeUTF(string3);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected Vector keyDataReadAll_Impl(String string, String string2) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(91);
            this.oos.writeUTF(string);
            this.oos.writeUTF(string2);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected String keyDataRead_Impl(String string, String string2, String string3) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(92);
            this.oos.writeUTF(string);
            this.oos.writeUTF(string2);
            this.oos.writeUTF(string3);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (String)object;
        }
    }

    protected void keyDataWrite_Impl(String string, String string2, String string3, String string4) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(93);
            this.oos.writeUTF(string);
            this.oos.writeUTF(string2);
            this.oos.writeUTF(string3);
            this.oos.writeUTF(string4);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected String licenceCheck_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(2);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            if (object == null) {
                return null;
            }
            return (String)object;
        }
    }

    protected String[] logGet_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(82);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            if (object == null) {
                return null;
            }
            return (String[])object;
        }
    }

    protected Vector mailGetAllHeaders_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(25);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected Vector mailGetHeadersForDomain_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(23);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected Vector mailGetHeadersForUser_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(22);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected Vector mailGetHeadersToSend_Impl(int n, long l) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(24);
            this.oos.writeInt(n);
            this.oos.writeLong(l);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected void mailinglistDelete_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(110);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected Vector mailinglistReadAll_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(111);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected MailingListRecord mailinglistRead_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(112);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (MailingListRecord)object;
        }
    }

    protected void mailinglistWrite_Impl(MailingListRecord mailingListRecord) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(113);
            this.oos.writeObject(mailingListRecord);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void mailMove_Impl(MailHeaderRecord mailHeaderRecord, MailHeaderRecord mailHeaderRecord2) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(31);
            this.oos.writeObject(mailHeaderRecord);
            this.oos.writeObject(mailHeaderRecord2);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void mailProcessQueueAdd_Impl(MailQueueRecord mailQueueRecord) throws Throwable {
    }

    protected Vector mailProcessQueueNext_Impl(int n) throws Throwable {
        return null;
    }

    protected void mailProcessQueueRemove_Impl(MailQueueRecord mailQueueRecord) throws Throwable {
    }

    protected LineReader mailReadBody_Impl(MailHeaderRecord mailHeaderRecord) throws Throwable {
        throw new StorageException();
    }

    protected void mailReadBody_Impl(MailHeaderRecord mailHeaderRecord, POP3OutputWriter pOP3OutputWriter) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(26);
            this.oos.writeObject(mailHeaderRecord);
            this.oos.flush();
            String string = null;
            LineReader lineReader = new LineReader(this.ois);
            while ((string = lineReader.readln()) != null) {
                pOP3OutputWriter.println(string);
            }
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected MailHeaderRecord mailReadHeader_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(27);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (MailHeaderRecord)object;
        }
    }

    protected void mailWriteFromString_Impl(MailHeaderRecord mailHeaderRecord, String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(30);
            this.oos.writeObject(mailHeaderRecord);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void mailWriteFromTemp_Impl(MailFilterChain mailFilterChain, MailHeaderRecord mailHeaderRecord, String string) throws Throwable {
        throw new StorageException();
    }

    protected void mailWriteHeader_Impl(MailHeaderRecord mailHeaderRecord) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(29);
            this.oos.writeObject(mailHeaderRecord);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected void quotaCleanup_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(121);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected boolean quotaExceeded_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(120);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Boolean)object;
        }
    }

    protected void rollback_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(61);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected StatisticsRecord statsGet_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(81);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            if (object == null) {
                return null;
            }
            return (StatisticsRecord)object;
        }
    }

    protected void tempDelete_Impl(String string) throws Throwable {
        throw new StorageException();
    }

    protected LineReader tempRead_Impl(String string) throws Throwable {
        throw new StorageException();
    }

    protected LineWriter tempWrite_Impl(String string) throws Throwable {
        throw new StorageException();
    }

    protected void tempWrite_Impl(String string, LineReader lineReader) throws Throwable {
        throw new StorageException();
    }

    public String toString() {
        return String.valueOf(this.strRemote_IP) + " / " + this.strRemote_User + " / " + this.strRemote_Version;
    }

    protected void userDelete_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(51);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    protected Vector userReadAllByDomain_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(52);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (Vector)object;
        }
    }

    protected UserRecord userRead_Impl(String string) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(53);
            this.oos.writeUTF(string);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            return (UserRecord)object;
        }
    }

    protected void userWrite_Impl(UserRecord userRecord) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(54);
            this.oos.writeObject(userRecord);
            this.oos.flush();
            Object object = this.ois.readObject();
            this.oos.reset();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
        }
    }

    static ObjectOutputStream access$oos(RemoteStorageManager_Client remoteStorageManager_Client) {
        return remoteStorageManager_Client.oos;
    }

    static Socket access$sok(RemoteStorageManager_Client remoteStorageManager_Client) {
        return remoteStorageManager_Client.sok;
    }

    static ObjectInputStream access$ois(RemoteStorageManager_Client remoteStorageManager_Client) {
        return remoteStorageManager_Client.ois;
    }

    public class NoopThread
    extends Thread {
        /* synthetic */ RemoteStorageManager_Client this$0;
        private long lngNT_Timer = 0L;
        private boolean blnNT_IsRunning = false;
        private LockObject objNT_Lock = new LockObject();

        public NoopThread(RemoteStorageManager_Client remoteStorageManager_Client, long l) {
            this.this$0 = remoteStorageManager_Client;
            this.lngNT_Timer = l;
            this.setName("Noop-Thread");
            this.start();
        }

        public void dispose() {
            this.blnNT_IsRunning = false;
            this.objNT_Lock.lo_notify();
            this.objNT_Lock.dispose();
        }

        public void run() {
            this.blnNT_IsRunning = true;
            this.this$0.logContext.write("# Started. Ping: " + this.lngNT_Timer / 1000L + " sec");
            while (true) {
                this.objNT_Lock.lo_wait(this.lngNT_Timer);
                if (!this.blnNT_IsRunning) break;
                Socket socket = RemoteStorageManager_Client.access$sok(this.this$0);
                synchronized (socket) {
                    try {
                        RemoteStorageManager_Client.access$oos(this.this$0).writeInt(1);
                        RemoteStorageManager_Client.access$oos(this.this$0).flush();
                        Object object = RemoteStorageManager_Client.access$ois(this.this$0).readObject();
                        RemoteStorageManager_Client.access$oos(this.this$0).reset();
                        if (object instanceof Throwable) {
                            throw (Throwable)object;
                        }
                    }
                    catch (Throwable throwable) {
                        this.this$0.logContext.write("? Error in NoopThread", throwable);
                        break;
                    }
                }
            }
            this.this$0.logContext.write("# Stop");
        }
    }
}

