/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import de.zwanzigeins.util.HelperValidate;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.Helper;

public class MailingListRecord
extends StorageRecord
implements Serializable {
    public static final String[] COMMANDS = new String[]{"help", "subscribe", "unsubscribe"};
    private String strName = null;
    private String[] strOwner = null;
    private boolean blnModerated = true;
    private String[] strCommands = null;
    private String[] strSubscriber = null;

    public MailingListRecord() {
        this.init();
    }

    public String[] getCommands() {
        return this.strCommands;
    }

    public String getName() {
        return this.strName;
    }

    public String[] getOwner() {
        return this.strOwner;
    }

    public String[] getSubscribers() {
        return this.strSubscriber;
    }

    public void init() {
        this.strName = "";
        this.strOwner = new String[]{""};
        this.blnModerated = true;
        this.strCommands = COMMANDS;
        this.strSubscriber = new String[0];
    }

    public boolean isModerated() {
        return this.blnModerated;
    }

    public String recordExport() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("name=");
        stringBuffer.append(this.strName);
        stringBuffer.append(string);
        stringBuffer.append("owner=");
        int n = 0;
        while (n < this.strCommands.length) {
            stringBuffer.append(this.strOwner[n]);
            if (n < this.strCommands.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append(this.strOwner);
        stringBuffer.append(string);
        stringBuffer.append("moderated=");
        stringBuffer.append(this.blnModerated ? "1" : "0");
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append("commands=");
        n = 0;
        while (n < this.strCommands.length) {
            stringBuffer.append(this.strCommands[n]);
            if (n < this.strCommands.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append(string);
        n = 0;
        while (n < this.strSubscriber.length) {
            stringBuffer.append("subscriber=");
            stringBuffer.append(this.strSubscriber[n]);
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void recordImport(String string) {
        try {
            Vector<String> vector = new Vector<String>(50, 25);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("#") || string2.startsWith(";")) continue;
                int n = string2.indexOf("=");
                String string3 = null;
                String string4 = null;
                if (n > 0) {
                    string3 = string2.substring(0, n).trim().toLowerCase();
                    string4 = string2.substring(n + 1).trim();
                } else {
                    string3 = string2.toLowerCase();
                    string4 = "";
                }
                if (string3.equals("name")) {
                    this.strName = string4;
                    continue;
                }
                if (string3.equals("owner")) {
                    this.strOwner = StorageRecord.conv_string2array(string4);
                    continue;
                }
                if (string3.equals("commands")) {
                    this.strCommands = StorageRecord.conv_string2array(string4);
                    continue;
                }
                if (!string3.equals("subscriber")) continue;
                vector.addElement(string4);
            }
            this.strSubscriber = new String[vector.size()];
            vector.copyInto(this.strSubscriber);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
    }

    public void setCommands(String[] stringArray) {
        this.strCommands = stringArray;
    }

    public void setModerated(boolean bl) {
        this.blnModerated = bl;
    }

    public void setName(String string) {
        String string2 = Helper.limit(string.toLowerCase(), 129);
        if ((string2 = HelperValidate.validateRFC822_User((String)string2)) == null) {
            throw new IllegalArgumentException(String.valueOf(string) + " is not a valid user name");
        }
        this.strName = string2;
    }

    public void setOwner(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = Helper.limit(stringArray[n].toLowerCase(), 129);
            if ((string = HelperValidate.validateRFC822_User((String)string)) == null) {
                throw new IllegalArgumentException(stringArray + " is not a valid user name");
            }
            this.strOwner[n] = string;
            ++n;
        }
    }

    public void setSubscribers(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = Helper.limit(stringArray[n].toLowerCase(), 129);
            if ((string = HelperValidate.validateRFC822_User((String)string)) == null) {
                throw new IllegalArgumentException(String.valueOf(stringArray[n]) + " is not a valid user name");
            }
            ++n;
        }
        this.strSubscriber = new String[stringArray.length];
        n = 0;
        while (n < stringArray.length) {
            this.strSubscriber[n] = stringArray[n];
            ++n;
        }
    }

    public String toString() {
        return this.getName();
    }
}

