/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.event.ForceFetchmailEvent;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.event.RestartEvent;
import net.zerotoaster.event.RestartFullyEvent;
import net.zerotoaster.event.ShutdownEvent;
import net.zerotoaster.io.RemoteFile;
import net.zerotoaster.storage.StatisticsRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.util.Helper;

public abstract class LocalStorageManager
extends StorageManager {
    public LocalStorageManager(LogContext logContext, Configuration configuration) {
        super(logContext, configuration);
    }

    protected void adminForceFetchmail_Impl() throws IOException {
        MTAEventQueue.postEvent(new ForceFetchmailEvent());
    }

    protected void adminFullRestart_Impl() throws IOException {
        MTAEventQueue.postEvent(new RestartFullyEvent());
    }

    protected void adminRestart_Impl() throws IOException {
        MTAEventQueue.postEvent(new RestartEvent());
    }

    protected void adminShutdown_Impl() throws IOException {
        MTAEventQueue.postEvent(new ShutdownEvent());
    }

    protected void fileDelete_Impl(String string) throws Throwable {
        string = Helper.platformPath(string);
        new File(string).delete();
    }

    protected RemoteFile fileGet_Impl(String string) throws Throwable {
        string = Helper.platformPath(string);
        return new RemoteFile(string);
    }

    protected RemoteFile[] fileList_Impl(String string) throws Throwable {
        string = Helper.platformPath(string);
        File file = new File(string);
        String[] stringArray = file.list();
        RemoteFile[] remoteFileArray = new RemoteFile[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            remoteFileArray[n] = new RemoteFile(string, stringArray[n]);
            ++n;
        }
        return remoteFileArray;
    }

    protected void fileLoad_Impl(String string, OutputStream outputStream) throws Throwable {
        string = Helper.platformPath(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    protected void fileSave_Impl(String string, InputStream inputStream) throws Throwable {
        string = Helper.platformPath(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    protected String[] logGet_Impl() throws Throwable {
        return this.logContext.getLogBuffer();
    }

    protected StatisticsRecord statsGet_Impl() throws Throwable {
        return this.cnfConfig.statrec;
    }
}

