/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.Helper;

public class LicenceRecord
extends StorageRecord {
    public static final String KEYFILE = "zerotoaster.key";
    public String strLicence_Serial = null;
    public String strLicence_User1 = null;
    public String strLicence_User2 = null;
    public int intMaxDomains;
    public int intMaxUsers;
    public int intMaxLists;
    public boolean blnMailHub_Server;
    public boolean blnMailHub_Client;
    public boolean blnAVScan;
    public long lngValidTo = 0L;

    public LicenceRecord() {
        this.init();
    }

    public void init() {
        this.strLicence_Serial = "";
        this.strLicence_User1 = "UNREGISTERED";
        this.strLicence_User2 = "EVALUATION COPY";
        this.intMaxDomains = 2;
        this.intMaxUsers = 5;
        this.intMaxLists = 999;
        this.blnMailHub_Server = true;
        this.blnMailHub_Client = true;
        this.blnAVScan = true;
        new GregorianCalendar();
        Calendar calendar = Calendar.getInstance();
        this.lngValidTo = (long)(calendar.get(2) + 1) * 10000L + (long)calendar.get(1);
        File file = new File(KEYFILE);
        if (!file.exists()) {
            return;
        }
        DataInputStream dataInputStream = null;
        try {
            try {
                dataInputStream = new DataInputStream(new FileInputStream(file));
                Random random = new Random(dataInputStream.readInt() & 0xFFFF);
                int n = dataInputStream.readByte();
                StringBuffer stringBuffer = new StringBuffer(n);
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append((char)(dataInputStream.readChar() ^ random.nextInt()));
                    ++n2;
                }
                this.recordImport(stringBuffer.toString());
            }
            catch (IOException iOException) {
                throw new RuntimeException("Damaged licence file");
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            Helper.close(dataInputStream);
            throw throwable;
        }
        Object var4_10 = null;
        Helper.close(dataInputStream);
    }

    public static final String long2date(long l) {
        String string = String.valueOf(l);
        if (string.length() == 5) {
            string = "0" + string;
        }
        string = String.valueOf(string.substring(0, 2)) + "/" + string.substring(2);
        return string;
    }

    public String recordExport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.strLicence_Serial);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strLicence_User1);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strLicence_User2);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intMaxDomains);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intMaxUsers);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnMailHub_Client);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnMailHub_Server);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnAVScan);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.lngValidTo);
        stringBuffer.append('\u0014');
        return stringBuffer.toString();
    }

    public void recordImport(String string) {
        this.initTokenizer(string);
        this.strLicence_Serial = this.nextToken();
        this.strLicence_User1 = this.nextToken();
        this.strLicence_User2 = this.nextToken();
        this.intMaxDomains = this.nextTokenInteger();
        this.intMaxUsers = this.nextTokenInteger();
        this.blnMailHub_Client = this.nextTokenBoolean();
        this.blnMailHub_Server = this.nextTokenBoolean();
        this.blnAVScan = this.nextTokenBoolean();
        this.lngValidTo = this.hasMoreTokens() ? this.nextTokenLong() : 92004L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#" + this.strLicence_Serial + "; " + this.strLicence_User1 + "; " + this.strLicence_User2 + "; ");
        stringBuffer.append(" ");
        stringBuffer.append(this.intMaxDomains + " Domains; ");
        stringBuffer.append(this.intMaxUsers + " Users; ");
        stringBuffer.append("MH Server " + this.blnMailHub_Server + "; ");
        stringBuffer.append("MH Client " + this.blnMailHub_Client + "; ");
        stringBuffer.append("AV Scan " + this.blnAVScan + "; ");
        stringBuffer.append("Valid to: " + LicenceRecord.long2date(this.lngValidTo));
        return stringBuffer.toString();
    }
}

