/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import java.io.Serializable;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.Helper;

public class FilterRecord
extends StorageRecord
implements Serializable {
    public static final int FILTER_RELAY = 1;
    public static final int FILTER_WHITELIST = 2;
    public static final int FILTER_BLACKLIST = 3;
    public static final int TYPE_USER = 1;
    public static final int TYPE_DOMAIN = 2;
    public static final int TYPE_NETWORK = 3;
    private int intFilterType = 0;
    private String strName = null;
    private String strMask = null;
    private int intType = 0;
    private String strMemo = null;
    private boolean blnAVScan;
    private boolean blnRBLcheck;

    public FilterRecord() {
        this.init();
    }

    public boolean getAVScan() {
        return this.blnAVScan;
    }

    public int getFilterType() {
        return this.intFilterType;
    }

    public String getMask() {
        return this.strMask;
    }

    public String getMemo() {
        return this.strMemo;
    }

    public String getName() {
        return this.strName;
    }

    public boolean getRBLCheck() {
        return this.blnRBLcheck;
    }

    public int getType() {
        return this.intType;
    }

    public void init() {
        this.intFilterType = 1;
        this.strName = "";
        this.strMask = "";
        this.intType = -1;
        this.strMemo = "";
        this.blnAVScan = false;
        this.blnRBLcheck = false;
    }

    public String recordExport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.intFilterType);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strName);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strMask);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intType);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strMemo);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnAVScan);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnRBLcheck);
        stringBuffer.append('\u0014');
        return stringBuffer.toString();
    }

    public void recordImport(String string) {
        this.initTokenizer(string);
        this.intFilterType = Integer.parseInt(this.nextToken());
        this.strName = this.nextToken();
        this.strMask = this.nextToken();
        this.intType = Integer.parseInt(this.nextToken());
        this.strMemo = this.nextToken();
        if (this.hasMoreTokens()) {
            this.blnAVScan = Boolean.valueOf(this.nextToken());
        }
        if (this.hasMoreTokens()) {
            this.blnRBLcheck = Boolean.valueOf(this.nextToken());
        }
    }

    public void setAVScan(boolean bl) {
        this.blnAVScan = bl;
    }

    public void setFilterType(int n) {
        this.intFilterType = n;
    }

    public void setMask(String string) {
        if ((string = string.toLowerCase()).indexOf("@") != -1) {
            if (HelperValidate.validateRFC822_User((String)string) == null) {
                throw new IllegalArgumentException("Not a valid username");
            }
            this.strMask = string;
            this.intType = 1;
            return;
        }
        if (string.indexOf(",") != -1) {
            try {
                new IP_Network(string);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException(String.valueOf(string) + " is not a valid network,netmask");
            }
            this.strMask = string;
            this.intType = 3;
            return;
        }
        if (HelperValidate.validateRFC822_Domain((String)string) == null) {
            throw new IllegalArgumentException(String.valueOf(string) + " is not a valid domain name");
        }
        this.strMask = string;
        this.intType = 2;
    }

    public void setMemo(String string) {
        this.strMemo = Helper.limit(string, 512);
    }

    public void setName(String string) {
        this.strName = string;
    }

    public void setRBLcheck(boolean bl) {
        this.blnRBLcheck = bl;
    }

    public String toString() {
        return this.getName();
    }
}

