/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import java.io.Serializable;
import net.zerotoaster.storage.StorageRecord;

public class FetchmailRecord
extends StorageRecord
implements Serializable {
    public static final String KEYDATA_APPL_RECORD = "FETCHMAIL_RECORD";
    private String strUserFrom = null;
    private String strHost = null;
    private String strPassword = null;
    private String strUserTo = null;
    private int intPollFrequency = 0;

    public FetchmailRecord() {
        this.init();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FetchmailRecord)) {
            return false;
        }
        FetchmailRecord fetchmailRecord = (FetchmailRecord)object;
        if (!fetchmailRecord.strUserFrom.equals(this.strUserFrom)) {
            return false;
        }
        if (!fetchmailRecord.strHost.equals(this.strHost)) {
            return false;
        }
        if (!fetchmailRecord.strPassword.equals(this.strPassword)) {
            return false;
        }
        if (!fetchmailRecord.strUserTo.equals(this.strUserTo)) {
            return false;
        }
        return fetchmailRecord.intPollFrequency == this.intPollFrequency;
    }

    public String getHost() {
        return this.strHost;
    }

    public String getPassword() {
        return this.strPassword;
    }

    public int getPollFrequency() {
        return this.intPollFrequency;
    }

    public String getUserFrom() {
        return this.strUserFrom;
    }

    public String getUserTo() {
        return this.strUserTo;
    }

    public void init() {
        this.strUserFrom = "";
        this.strHost = "";
        this.strPassword = "";
        this.strUserTo = "";
        this.intPollFrequency = 120;
    }

    public String recordExport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.strUserFrom);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strHost);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strPassword);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strUserTo);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intPollFrequency);
        stringBuffer.append('\u0014');
        return stringBuffer.toString();
    }

    public void recordImport(String string) {
        this.initTokenizer(string);
        this.strUserFrom = this.nextToken();
        this.strHost = this.nextToken();
        this.strPassword = this.nextToken();
        this.strUserTo = this.nextToken();
        this.intPollFrequency = this.nextTokenInteger();
    }

    public void setHost(String string) {
        this.strHost = string.toLowerCase().trim();
    }

    public void setPassword(String string) {
        this.strPassword = string.trim();
    }

    public void setPollFrequency(int n) {
        this.intPollFrequency = n;
    }

    public void setUserFrom(String string) {
        this.strUserFrom = string.toLowerCase().trim();
    }

    public void setUserTo(String string) {
        this.strUserTo = string.toLowerCase().trim();
    }

    public String toString() {
        return String.valueOf(this.getUserFrom()) + " " + this.getPollFrequency() + " sec interval";
    }
}

