/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.storage;

import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import java.io.Serializable;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.Helper;

public class DomainRecord
extends StorageRecord
implements Serializable {
    public static final int ROLE_STANDALONE = 0;
    public static final int ROLE_SERVER = 1;
    public static final int ROLE_CLIENT = 2;
    public static final int CONNECTION_PASSIVE = 0;
    public static final int CONNECTION_CURRENT_IP = 1;
    public static final int CONNECTION_NEW_IP = 2;
    private String strDomainName = null;
    private boolean blnEnable_POP3 = false;
    private boolean blnEnable_SMTP = false;
    private boolean blnSMTP_after_POP3 = false;
    private int intSessionTimeout = -1;
    private IP_Network[] ipNetwork = null;
    private String strCatchAll = null;
    private String strMemo = null;
    private boolean blnAVScan = false;
    private int intMailHub_Role = -1;
    private String strMailHub_Password = null;
    private String strMailHub_PollHost = null;
    private int intMailHub_PollFrequency = 0;
    private int intMailHub_SocketUsage = -1;
    private int intMailHub_CallBack_Port = 0;
    private String strMailHub_CallBack_Host = "";
    private int intQuota_Days;
    private int intQuota_Mails;
    private int intQuota_MB;
    private String strDomainAlias = null;

    public DomainRecord() {
        this.init();
    }

    public boolean getAVScan() {
        return this.blnAVScan;
    }

    public String getCatchAll() {
        return this.strCatchAll;
    }

    public String getDomainAlias() {
        return this.strDomainAlias;
    }

    public String getDomainName() {
        return this.strDomainName;
    }

    public boolean getEnable_POP3() {
        return this.blnEnable_POP3;
    }

    public boolean getEnable_SMTP() {
        return this.blnEnable_SMTP;
    }

    public IP_Network[] getIP_Networks() {
        return this.ipNetwork;
    }

    public String getMailHub_CallBackHost() {
        return this.strMailHub_CallBack_Host;
    }

    public int getMailHub_CallBackPort() {
        return this.intMailHub_CallBack_Port;
    }

    public String getMailHub_Password() {
        return this.strMailHub_Password;
    }

    public int getMailHub_PollFrequency() {
        return this.intMailHub_PollFrequency;
    }

    public String getMailHub_PollHost() {
        return this.strMailHub_PollHost;
    }

    public int getMailHub_Role() {
        return this.intMailHub_Role;
    }

    public int getMailHub_SocketUsage() {
        return this.intMailHub_SocketUsage;
    }

    public String getMemo() {
        return this.strMemo;
    }

    public int getQuota_Days() {
        return this.intQuota_Days;
    }

    public int getQuota_Mails() {
        return this.intQuota_Mails;
    }

    public int getQuota_MB() {
        return this.intQuota_MB;
    }

    public int getSessionTimeout() {
        return this.intSessionTimeout;
    }

    public boolean getSMTP_after_POP3() {
        return this.blnSMTP_after_POP3;
    }

    public void init() {
        this.strDomainName = "";
        this.blnEnable_POP3 = true;
        this.blnEnable_SMTP = true;
        this.blnSMTP_after_POP3 = false;
        this.intSessionTimeout = 30;
        this.ipNetwork = new IP_Network[0];
        this.strCatchAll = "";
        this.strMemo = "";
        this.intMailHub_Role = 0;
        this.strMailHub_Password = "";
        this.strMailHub_PollHost = "";
        this.intMailHub_PollFrequency = 60;
        this.intMailHub_SocketUsage = 0;
        this.intMailHub_CallBack_Port = 25;
        this.strMailHub_CallBack_Host = "localhost:25";
        this.intQuota_Days = 0;
        this.intQuota_Mails = 0;
        this.intQuota_MB = 0;
        this.strDomainAlias = "";
    }

    public String recordExport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.strDomainName);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnEnable_POP3);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnEnable_SMTP);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnSMTP_after_POP3);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intSessionTimeout);
        stringBuffer.append('\u0014');
        stringBuffer.append(StorageRecord.conv_networks2string(this.ipNetwork));
        stringBuffer.append('\u0014');
        stringBuffer.append("");
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strCatchAll);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strMemo);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnAVScan);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intMailHub_Role);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strMailHub_Password);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strMailHub_PollHost);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intMailHub_PollFrequency);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intMailHub_SocketUsage);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intMailHub_CallBack_Port);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strMailHub_CallBack_Host);
        stringBuffer.append('\u0014');
        stringBuffer.append(0);
        stringBuffer.append('\u0014');
        stringBuffer.append(0);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intQuota_Days);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intQuota_Mails);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intQuota_MB);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strDomainAlias);
        stringBuffer.append('\u0014');
        return stringBuffer.toString();
    }

    public void recordImport(String string) {
        this.initTokenizer(string);
        this.strDomainName = this.nextToken();
        this.blnEnable_POP3 = this.nextTokenBoolean();
        this.blnEnable_SMTP = this.nextTokenBoolean();
        this.blnSMTP_after_POP3 = this.nextTokenBoolean();
        this.intSessionTimeout = this.nextTokenInteger();
        this.ipNetwork = StorageRecord.conv_string2networks(this.nextToken());
        this.nextToken();
        this.strCatchAll = this.nextToken();
        this.strMemo = this.nextToken();
        if (this.hasMoreTokens()) {
            this.blnAVScan = this.nextTokenBoolean();
        }
        if (this.hasMoreTokens()) {
            try {
                this.intMailHub_Role = this.nextTokenInteger();
                this.strMailHub_Password = this.nextToken();
                this.strMailHub_PollHost = this.nextToken();
                this.intMailHub_PollFrequency = this.nextTokenInteger();
                this.intMailHub_SocketUsage = this.nextTokenInteger();
                this.intMailHub_CallBack_Port = this.nextTokenInteger();
                this.strMailHub_CallBack_Host = this.nextToken();
                this.nextTokenInteger();
                this.nextTokenInteger();
                this.intQuota_Days = this.nextTokenInteger();
                this.intQuota_Mails = this.nextTokenInteger();
                this.intQuota_MB = this.nextTokenInteger();
            }
            catch (Throwable throwable) {}
        }
        if (this.hasMoreTokens()) {
            this.strDomainAlias = this.nextToken();
        }
    }

    public void setAVScan(boolean bl) {
        this.blnAVScan = bl;
    }

    public void setCatchAll(String string) {
        this.strCatchAll = Helper.limit(string.toLowerCase(), 129);
    }

    public void setDomainAlias(String string) {
        this.strDomainAlias = Helper.limit(string, 64);
    }

    public void setDomainName(String string) {
        String string2 = Helper.limit(string.toLowerCase(), 64);
        if ((string2 = HelperValidate.validateRFC822_Domain((String)string2)) == null) {
            throw new IllegalArgumentException(String.valueOf(string) + " is not a valid domain name");
        }
        this.strDomainName = string2;
    }

    public void setEnable_POP3(boolean bl) {
        this.blnEnable_POP3 = bl;
    }

    public void setEnable_SMTP(boolean bl) {
        this.blnEnable_SMTP = bl;
    }

    public void setIP_Networks(IP_Network[] iP_NetworkArray) {
        this.ipNetwork = iP_NetworkArray;
    }

    public void setMailHub_CallBack_Host(String string) {
        this.strMailHub_CallBack_Host = string.toLowerCase();
    }

    public void setMailHub_CallBack_Port(int n) {
        this.intMailHub_CallBack_Port = n;
    }

    public void setMailHub_Password(String string) {
        this.strMailHub_Password = string.toLowerCase();
    }

    public void setMailHub_PollFrequency(int n) {
        this.intMailHub_PollFrequency = n;
    }

    public void setMailHub_PollHost(String string) {
        this.strMailHub_PollHost = string.toLowerCase();
    }

    public void setMailHub_Role(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.intMailHub_Role = n;
                return;
            }
        }
        throw new RuntimeException("Unknown role: " + n);
    }

    public void setMailHub_SocketUsage(int n) {
        this.intMailHub_SocketUsage = n;
    }

    public void setMemo(String string) {
        this.strMemo = Helper.limit(string, 512);
    }

    public void setQuota_Days(int n) {
        this.intQuota_Days = n;
    }

    public void setQuota_Mails(int n) {
        this.intQuota_Mails = n;
    }

    public void setQuota_MB(int n) {
        this.intQuota_MB = n;
    }

    public void setSessionTimeout(int n) {
        this.intSessionTimeout = n;
    }

    public void setSMTP_after_POP3(boolean bl) {
        this.blnSMTP_after_POP3 = bl;
    }

    public String toString() {
        return this.getDomainName();
    }
}

