/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.config.Constants;
import net.zerotoaster.event.CleanupEvent;
import net.zerotoaster.event.KickForwarder;
import net.zerotoaster.event.MTAEvent;
import net.zerotoaster.event.MTAEventListener;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.event.PostmasterAlert;
import net.zerotoaster.event.RescanEvent;
import net.zerotoaster.event.RestartEvent;
import net.zerotoaster.event.RestartFullyEvent;
import net.zerotoaster.event.ShutdownEvent;
import net.zerotoaster.mta.FWD_ServerContainer;
import net.zerotoaster.mta.MHUB_Client;
import net.zerotoaster.mta.ML_Import;
import net.zerotoaster.mta.MPA_ServerContainer;
import net.zerotoaster.mta.Mail;
import net.zerotoaster.mta.POP3_Fetchmail;
import net.zerotoaster.mta.POP3_ServerContainer;
import net.zerotoaster.mta.SMTP_ServerContainer;
import net.zerotoaster.mta.ServerContainer;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.storage.RemoteStorageManager_Server;
import net.zerotoaster.storage.StorageException;
import net.zerotoaster.util.Helper;
import org.xbill.Task.WorkerThread;

public class ZeroToaster
extends Application
implements Runnable,
MTAEventListener,
Constants {
    private LogContext logContext = null;
    private Configuration cnfConfig = null;
    private Vector vecContainers = null;
    private Thread thrd = null;
    private boolean blnIsRunning = false;
    private LockObject objLock = null;
    private RemoteStorageManager_Server rsmManager = null;
    private MHUB_Client mhubClient = null;
    private POP3_Fetchmail popFetchmail = null;
    private ML_Import mlImport = null;

    public ZeroToaster() {
        this.init();
    }

    private LogContext createLogContext() {
        LogContext logContext = null;
        if (this.cnfConfig.strLogScrn_Options.length() == 0) {
            this.cnfConfig.strLogScrn_Options = this.cnfConfig.strLogFile_Options;
        }
        try {
            logContext = new LogContext(this.cnfConfig.strLogFile_Path, this.cnfConfig.strLogFile_Praefix, this.cnfConfig.strLogFile_Suffix);
            logContext.setDateFormat(this.cnfConfig.strLogFile_DateFormat);
            logContext.setTimeFormat(this.cnfConfig.strLogFile_TimeFormat);
            logContext.setFilter_File(this.cnfConfig.strLogFile_Options);
            logContext.setFilter_Screen(this.cnfConfig.strLogScrn_Options);
            logContext.setYesterdayFile(this.cnfConfig.strLogFile_Yesterday);
            logContext.setLogfileKeep(this.cnfConfig.intLogFile_Keep);
            logContext.write("# Logfile opened");
            return logContext;
        }
        catch (IOException iOException) {
            System.err.println("Cannot open logfile");
            System.err.println(iOException);
            return null;
        }
    }

    private boolean createServerContainers() {
        ServerContainer serverContainer;
        this.vecContainers = new Vector(3);
        ServerContainerConfig serverContainerConfig = new ServerContainerConfig();
        serverContainerConfig.cnf = this.cnfConfig;
        serverContainerConfig.logContext = this.logContext;
        try {
            this.logContext.write("# Starting POP3 container");
            serverContainer = new POP3_ServerContainer(serverContainerConfig);
            this.vecContainers.addElement(serverContainer);
        }
        catch (InitializationException initializationException) {
            return false;
        }
        catch (Throwable throwable) {
            this.logContext.write("? Unhandled exception during creation of POP3 server container", throwable);
            return false;
        }
        try {
            this.logContext.write("# Starting SMTP container");
            serverContainer = new SMTP_ServerContainer(serverContainerConfig);
            this.vecContainers.addElement(serverContainer);
        }
        catch (InitializationException initializationException) {
            return false;
        }
        catch (Throwable throwable) {
            this.logContext.write("? Unhandled exception during creation of SMTP server container", throwable);
            return false;
        }
        try {
            this.logContext.write("# Starting FWD container");
            serverContainer = new FWD_ServerContainer(serverContainerConfig);
            this.vecContainers.addElement(serverContainer);
        }
        catch (InitializationException initializationException) {
            return false;
        }
        catch (Throwable throwable) {
            this.logContext.write("? Unhandled exception during creation of FWD server container", throwable);
            return false;
        }
        try {
            this.logContext.write("# Starting MPA server container");
            serverContainer = new MPA_ServerContainer(serverContainerConfig);
            this.vecContainers.addElement(serverContainer);
        }
        catch (InitializationException initializationException) {
            return false;
        }
        catch (Throwable throwable) {
            this.logContext.write("? Unhandled exception during creation of MPA server container", throwable);
            return false;
        }
        if (this.cnfConfig.lic.blnMailHub_Client) {
            this.logContext.write("# Starting mailhub client");
            try {
                this.mhubClient = new MHUB_Client(serverContainerConfig);
            }
            catch (InitializationException initializationException) {
                return false;
            }
            catch (Throwable throwable) {
                this.logContext.write("? Unhandled exception during creation of Mail Hub Client", throwable);
                return false;
            }
        }
        try {
            this.logContext.write("# Starting POP3 fetchmail");
            this.popFetchmail = new POP3_Fetchmail(serverContainerConfig);
        }
        catch (Throwable throwable) {
            this.logContext.write("? Unhandled exception during creation of POP3 Fetcher", throwable);
            return false;
        }
        if (this.cnfConfig.blnMailImportEnabled) {
            this.logContext.write("# Starting mail import process");
            try {
                this.mlImport = new ML_Import(serverContainerConfig);
            }
            catch (Throwable throwable) {
                this.logContext.write("? Unhandled exception during creation of MailImport", throwable);
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        if (this.logContext != null) {
            this.logContext.setSlowDown(0L);
        }
        this.blnDisposed = true;
        Thread thread = this.thrd;
        if (thread != null) {
            this.blnIsRunning = false;
            this.objLock.lo_notify();
            this.thrd = null;
        }
        if (this.objLock != null) {
            this.objLock.dispose();
            this.objLock = null;
        }
        if (this.mhubClient != null) {
            this.logContext.write("D Initiating dispose MHUB Client");
            this.mhubClient.dispose();
            this.mhubClient = null;
        }
        if (this.popFetchmail != null) {
            this.logContext.write("D Initiating dispose POP3 Fetchmail");
            this.popFetchmail.dispose();
            this.popFetchmail = null;
        }
        if (this.mlImport != null) {
            this.logContext.write("D Initiating dispose MailImport");
            this.mlImport.dispose();
            this.mlImport = null;
        }
        if (this.vecContainers != null) {
            int n = 0;
            while (n < this.vecContainers.size()) {
                ServerContainer serverContainer = (ServerContainer)this.vecContainers.elementAt(n);
                this.logContext.write("D Initiating dispose " + serverContainer.getClass().getName());
                serverContainer.dispose();
                ++n;
            }
            this.vecContainers.removeAllElements();
            this.vecContainers = null;
        }
        if (this.rsmManager != null) {
            this.logContext.write("D Initiating dispose RSM Manager");
            this.rsmManager.dispose();
            this.rsmManager = null;
        }
        if (this.logContext != null) {
            this.logContext.write("# Stopped ---------------------------");
            this.logContext.dispose();
            this.logContext = null;
        }
        MTAEventQueue.dispose();
        Configuration.dispose();
    }

    public static final String getCopyRight() {
        return Constants.COPYRIGHT;
    }

    public static final String getVersion() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("os.name");
        string = String.valueOf(string) + " v" + properties.getProperty("os.version");
        string = String.valueOf(string) + " (" + properties.getProperty("os.arch") + ")";
        String string2 = Configuration.getConfig().strFakedOS;
        if (string2.length() > 0) {
            string = string2;
        }
        return "ZeroToaster 2.51 " + string;
    }

    private void init() {
        this.blnDisposed = false;
        this.setThreadName("ZeroToaster");
        MTAEventQueue.addListener(this);
        this.objLock = new LockObject();
        this.cnfConfig = Configuration.getConfig();
        if (this.cnfConfig == null) {
            this.dispose();
        }
        WorkerThread.setMaxThreads((int)50);
        this.stats_read();
        this.logContext = this.createLogContext();
        if (this.logContext == null) {
            this.dispose();
            return;
        }
        MTAEventQueue.setConfiguration(this.logContext, this.cnfConfig);
        this.sysinfo();
        try {
            this.logContext.write("# loading storage manager");
            this.rsmManager = new RemoteStorageManager_Server(Configuration.getStorageManager(this.logContext), this.cnfConfig);
            this.rsmManager.quotaCleanup();
            this.rsmManager.cleanup(true);
        }
        catch (Throwable throwable) {
            this.logContext.write("? Error loading storage manager", throwable);
            this.dispose();
            return;
        }
        try {
            this.rsmManager.licenceCheck();
        }
        catch (StorageException storageException) {
            this.logContext.write("? Error during licence check", (Throwable)storageException);
            this.dispose();
            return;
        }
        try {
            this.rsmManager.initRemoteControl(this.cnfConfig);
        }
        catch (InitializationException initializationException) {
            this.dispose();
            return;
        }
        if (!this.createServerContainers()) {
            this.dispose();
            return;
        }
        this.thrd = new Thread(this);
        this.thrd.setName("Watchdog");
        this.thrd.setPriority(1);
        this.blnIsRunning = true;
        this.thrd.start();
        this.logContext.write("# Started ---------------------------");
        if (this.cnfConfig.blnNotify_Startup) {
            MTAEventQueue.postEvent(new PostmasterAlert("Zerotoaster started"));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].equals("-version")) {
            System.out.println("ZeroToaster 2.51");
            System.exit(0);
        }
        System.out.println(ZeroToaster.getVersion());
        System.out.println(Constants.COPYRIGHT);
        ZeroToaster zeroToaster = null;
        try {
            zeroToaster = new ZeroToaster();
        }
        catch (Throwable throwable) {
            if (zeroToaster != null && zeroToaster.logContext != null) {
                zeroToaster.logContext.write("? Unhandled exception in .init():", throwable);
                zeroToaster.logContext.dispose();
            }
            System.out.println("Unhandled exception in .init():");
            throwable.printStackTrace();
        }
    }

    public void mtaEvent(MTAEvent mTAEvent) {
        if (mTAEvent instanceof ShutdownEvent) {
            this.dispose();
            Runtime.runFinalizersOnExit((boolean)this.cnfConfig.blnRunFinalizersOnExit);
            System.exit(0);
            return;
        }
        if (mTAEvent instanceof RestartEvent) {
            this.stats_write();
            this.dispose();
            if (this.cnfConfig.blnRunFinalizers) {
                Runtime.getRuntime().runFinalization();
                System.gc();
            }
            this.init();
            return;
        }
        if (mTAEvent instanceof RestartFullyEvent) {
            this.stats_write();
            this.dispose();
            Runtime.runFinalizersOnExit((boolean)this.cnfConfig.blnRunFinalizersOnExit);
            System.exit(50);
            return;
        }
        if (mTAEvent instanceof CleanupEvent) {
            this.rsmManager.quotaCleanup();
            this.rsmManager.cleanup(false);
            return;
        }
        if (mTAEvent instanceof RescanEvent) {
            MTAEventQueue.postEvent(new KickForwarder());
            return;
        }
        if (mTAEvent instanceof PostmasterAlert) {
            PostmasterAlert postmasterAlert = (PostmasterAlert)mTAEvent;
            Mail mail = new Mail(this.logContext, this.cnfConfig, this.rsmManager);
            String string = "ZeroToaster 2.51";
            StringBuffer stringBuffer = new StringBuffer();
            if (this.cnfConfig.strSystemName.length() > 0) {
                stringBuffer.append(string);
                stringBuffer.append("@");
                stringBuffer.append(this.cnfConfig.strSystemName);
                mail.setSubject(stringBuffer.toString());
                mail.setMailFrom_Name(this.cnfConfig.strSystemName);
            } else {
                stringBuffer.append("Alert from ");
                stringBuffer.append(string);
                mail.setSubject(stringBuffer.toString());
                mail.setMailFrom_Name(string);
            }
            stringBuffer.setLength(0);
            stringBuffer.append("Message:\r\n");
            stringBuffer.append("-----------------------------------------------------\r\n");
            stringBuffer.append(postmasterAlert.strMessage);
            stringBuffer.append("\r\n");
            stringBuffer.append("-----------------------------------------------------\r\n");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            Properties properties = System.getProperties();
            stringBuffer.append(properties.getProperty("os.name"));
            stringBuffer.append(" v");
            stringBuffer.append(properties.getProperty("os.version"));
            stringBuffer.append(" (");
            stringBuffer.append(properties.getProperty("os.arch"));
            stringBuffer.append(")\r\n");
            mail.setMailFrom_EMail("");
            mail.setMailTo_EMail("postmaster");
            mail.setContent(stringBuffer.toString());
            mail.store();
        }
    }

    public void run() {
        boolean bl = false;
        Throwable throwable = null;
        try {
            this.watchdog();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            try {
                this.logContext.write("? Unhandled exception", throwable2);
                this.logContext.write("? Watchdog is stopped");
                bl = true;
            }
            catch (Throwable throwable3) {}
        }
        if (!bl && throwable != null) {
            System.out.println("ZeroToaster Watchdog error, stop");
            throwable.printStackTrace();
            Helper.writeLog("ZeroToaster Watchdog error, stop");
            Helper.writeLog(throwable);
        }
    }

    private void stats_read() {
        File file = new File("stats.$$$");
        if (!file.exists()) {
            return;
        }
        if (!this.cnfConfig.blnKeepStats) {
            file.delete();
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("stats.$$$"));
            this.cnfConfig.statrec.recordImport(bufferedReader.readLine());
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.logContext.write("? Cannot read statistics record", (Throwable)iOException);
        }
        file.delete();
    }

    private void stats_write() {
        if (!this.cnfConfig.blnKeepStats) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter("stats.$$$"));
            printWriter.println(this.cnfConfig.statrec.recordExport());
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            this.logContext.write("? Cannot write statistics record", (Throwable)iOException);
        }
    }

    private void sysinfo() {
        Properties properties = System.getProperties();
        this.logContext.write("# ---------------------------------------------------------------------------");
        this.logContext.write("# ZeroToaster 2.51");
        this.logContext.write("# Operating System: " + properties.getProperty("os.name") + ", " + properties.getProperty("os.version") + ", " + properties.getProperty("os.arch"));
        this.logContext.write("# Java System     : " + properties.getProperty("java.version") + ", " + properties.getProperty("java.vendor"));
        this.logContext.write("# Available Memory: " + Helper.formatMemoryString(Runtime.getRuntime().totalMemory()));
        this.logContext.write("# Timezone used   : " + TimeZone.getDefault());
        this.logContext.write("# Nameservers     : " + this.cnfConfig.strNameServer);
        this.logContext.write("# Licence         : " + this.cnfConfig.lic.toString());
        this.logContext.write("# ---------------------------------------------------------------------------");
    }

    private void watchdog() {
        long l;
        this.logContext.write("D Started");
        File file = new File("shutdown");
        File file2 = new File("restart");
        File file3 = new File("fullrestart");
        File file4 = new File("cleanup");
        File file5 = new File("rescan");
        File file6 = new File("liccheck");
        File file7 = new File("debugdump");
        file.delete();
        file2.delete();
        file3.delete();
        file4.delete();
        file5.delete();
        file6.delete();
        file7.delete();
        long l2 = l = TimeFactory.getTime();
        long l3 = l;
        long l4 = l;
        while (this.blnIsRunning) {
            long l5 = TimeFactory.getTime();
            if (l5 - l2 > (long)this.cnfConfig.intSemaphoreCheck) {
                if (file.exists()) {
                    file.delete();
                    this.logContext.write("# Shutdown initiated");
                    MTAEventQueue.postEvent(new ShutdownEvent());
                    break;
                }
                if (file2.exists()) {
                    file2.delete();
                    this.logContext.write("# Restart initiated");
                    MTAEventQueue.postEvent(new RestartEvent());
                    break;
                }
                if (file3.exists()) {
                    file3.delete();
                    this.logContext.write("# Full restart initiated");
                    MTAEventQueue.postEvent(new RestartFullyEvent());
                    break;
                }
                if (file5.exists()) {
                    file5.delete();
                    this.logContext.write("# Rescan initiated");
                    MTAEventQueue.postEvent(new RescanEvent());
                }
                if (file7.exists()) {
                    file7.delete();
                    this.logContext.write("# Debug dump");
                    Application.dump();
                }
                if (this.cnfConfig.blnRestartWhenConfigChanged && Configuration.isModified()) {
                    this.logContext.write("# Restart initiated by config change");
                    MTAEventQueue.postEvent(new RestartEvent());
                    break;
                }
                l2 = l5;
            }
            if (l5 - l > (long)this.cnfConfig.intMailCleanup * 60L * 1000L || file4.exists()) {
                file4.delete();
                MTAEventQueue.postEvent(new CleanupEvent());
                l = l5;
            }
            if (this.cnfConfig.intMemorycheck != 0 && l5 - l3 > (long)this.cnfConfig.intMemorycheck * 1000L) {
                if (this.cnfConfig.blnMemorycheck_finalisation) {
                    this.logContext.write("D Memcheck:finalizer");
                    Runtime.getRuntime().runFinalization();
                }
                if (this.cnfConfig.blnMemorycheck_gc) {
                    this.logContext.write("D Memcheck:GC");
                    System.gc();
                }
                long l6 = Runtime.getRuntime().totalMemory() / 1024L;
                long l7 = Runtime.getRuntime().freeMemory() / 1024L;
                this.logContext.write("! Mem. total " + l6 + "kB used: " + (l6 - l7) + "kB");
                l3 = TimeFactory.getTime();
            }
            this.cnfConfig.statrec.lngMemory_total = Runtime.getRuntime().totalMemory();
            this.cnfConfig.statrec.lngMemory_free = Runtime.getRuntime().freeMemory();
            if (l5 - l4 > 1800000L || file6.exists()) {
                file6.delete();
                this.rsmManager.licenceCheck();
                l4 = l5;
            }
            this.objLock.lo_wait(1000L);
        }
        if (this.logContext != null) {
            this.logContext.write("# Watchdog closed without error");
        }
    }
}

