/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.HelperFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import net.zerotoaster.config.Constants;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.mta.ServerInstance;
import net.zerotoaster.storage.StorageException;
import net.zerotoaster.util.Helper;

public abstract class ServerSocketInstance
extends ServerInstance
implements Runnable,
Constants {
    protected LineSocket lsok = null;
    protected boolean blnCloseSocket = true;
    protected boolean blnSupressSocketOutput = false;
    protected String strLastReceivedPlain = "";

    public ServerSocketInstance(String string, ServerContainerConfig serverContainerConfig) {
        super(string, serverContainerConfig);
        this.strInstanceID = string;
        this.scc = serverContainerConfig;
        this.setThreadName(string);
        this.resetThreadName();
    }

    protected String cmdReceive() throws IOException {
        String string = this.lsok.readln();
        if (string == null) {
            throw new IOException("Got NULL from input stream");
        }
        this.strLastReceivedPlain = string;
        string = string.toLowerCase().trim();
        this.scc.logContext.write("M I:" + string);
        return HelperFilter.filterBackspace((String)string);
    }

    protected boolean cmdSend(String string) throws IOException {
        this.scc.logContext.write("M O:" + string);
        if (!this.blnSupressSocketOutput) {
            this.lsok.println(string);
            this.lsok.flush();
        }
        return true;
    }

    public void dispose() {
        this.setThreadName();
        Helper.close(this.lsok);
        super.dispose();
        this.resetThreadName();
    }

    public void run() {
        this.init0();
        while (this.blnIsRunning) {
            this.loNotify.lo_wait();
            if (!this.blnIsRunning) {
                return;
            }
            this.strTransactionID = this.getTransactionID();
            this.blnCloseSocket = true;
            this.scc.logContext.write("# TS " + this.strTransactionID);
            try {
                this.service();
                if (this.blnCloseSocket) {
                    Helper.flush(this.lsok);
                    Helper.close(this.lsok);
                }
            }
            catch (StorageException storageException) {
                Helper.close(this.lsok);
                this.scc.logContext.write("! Handled exception", (Throwable)storageException);
            }
            catch (InterruptedIOException interruptedIOException) {
                Helper.close(this.lsok);
                this.scc.logContext.write("? Timeout during read/write");
            }
            catch (IOException iOException) {
                Helper.close(this.lsok);
                this.scc.logContext.write("? Socket closed by remote");
            }
            catch (Throwable throwable) {
                Helper.close(this.lsok);
                this.scc.logContext.write("? Unhandled exception", throwable);
            }
            try {
                this.servicePostProcess();
            }
            catch (Throwable throwable) {
                this.scc.logContext.write("? servicePostProcess:", throwable);
            }
            this.lsok = null;
            this.smManager.rollback();
            this.scc.logContext.write("# TE " + this.strTransactionID);
            this.setBusy(false);
        }
    }
}

