/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.HelperExtract;
import java.net.InetAddress;
import net.zerotoaster.io.LineServerSocket;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.mta.ServerContainer;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.mta.ServerInstance;
import net.zerotoaster.util.Helper;

public abstract class ServerSocketContainer
extends ServerContainer {
    private LineServerSocket lssok = null;
    protected String strHost = null;
    protected int intPort = -1;
    protected int intSocketTimeout = 0;

    public ServerSocketContainer(ServerContainerConfig serverContainerConfig, String string) {
        super(serverContainerConfig, string);
    }

    public void dispose() {
        this.blnIsRunning = false;
        super.dispose();
        if (this.lssok != null) {
            try {
                this.lssok.close();
            }
            catch (Throwable throwable) {
                this.scc.logContext.write("? Problems disposing ServerSocket", throwable);
            }
            this.lssok = null;
        }
    }

    protected abstract String getBusyMessage();

    protected boolean init() throws Throwable {
        if (!super.init()) {
            return false;
        }
        String string = this.strContainerName.toUpperCase().trim();
        if (string.equals("POP3")) {
            this.strHost = HelperExtract.splitIP_getHost((String)this.scc.cnf.strPOP3_Host);
            this.intPort = HelperExtract.splitIP_getPort((String)this.scc.cnf.strPOP3_Host, (int)110);
            this.intSocketTimeout = this.scc.cnf.intPOP3_Socket_Timeout;
        }
        if (string.equals("SMTP")) {
            this.strHost = HelperExtract.splitIP_getHost((String)this.scc.cnf.strSMTP_Host);
            this.intPort = HelperExtract.splitIP_getPort((String)this.scc.cnf.strSMTP_Host, (int)25);
            this.intSocketTimeout = this.scc.cnf.intSMTP_Socket_Timeout;
        }
        return true;
    }

    public void run() {
        Object object;
        this.scc.logContext.write("D Opening Server Socket on " + this.strHost + ":" + this.intPort);
        try {
            object = null;
            if (!this.strHost.equals("*")) {
                object = InetAddress.getByName(this.strHost);
            }
            this.lssok = new LineServerSocket(this.intPort, this.intInstances, (InetAddress)object);
            this.scc.logContext.write("D Server Socket opened (" + this.lssok.getInetAddress() + ")");
            this.blnIsRunning = true;
            this.loThreadStarted.lo_notify();
        }
        catch (Throwable throwable) {
            this.scc.logContext.write("? Error creating server socket", throwable);
            this.blnIsRunning = false;
            this.loThreadStarted.lo_notify();
            return;
        }
        object = null;
        while (this.blnIsRunning) {
            try {
                this.scc.logContext.write("D Waiting for requests");
                object = this.lssok.accept();
                if (!this.blnIsRunning) {
                    this.scc.logContext.write("# Shutdown");
                    return;
                }
                ((LineSocket)object).setSoTimeout(this.intSocketTimeout * 1000);
                this.scc.logContext.write("D Incoming request " + ((LineSocket)object).getInetAddress());
            }
            catch (Throwable throwable) {
                Helper.close(object);
                Helper.close(this.lssok);
                object = null;
                this.lssok = null;
                if (!this.blnIsRunning) {
                    return;
                }
                this.scc.logContext.write("? Problem in ssok.accept() - abort ", throwable);
                this.dispose();
                return;
            }
            ServerInstance serverInstance = this.getFreeInstance();
            if (serverInstance == null) {
                try {
                    ((LineSocket)object).println(this.getBusyMessage());
                    ((LineSocket)object).flush();
                    ((LineSocket)object).close();
                    continue;
                }
                catch (Throwable throwable) {}
            }
            serverInstance.kickInstance(object);
        }
    }
}

