/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.config.Constants;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.storage.StorageException;
import net.zerotoaster.storage.StorageManager;

public abstract class ServerInstance
extends Application
implements Runnable,
Constants {
    private Thread thrd = null;
    protected boolean blnIsRunning = false;
    protected LockObject loNotify = null;
    protected String strInstanceID = null;
    protected ServerContainerConfig scc = null;
    protected boolean blnIsBusy = false;
    private long lngLastTransactionID = -1L;
    protected StorageManager smManager = null;
    protected String strTransactionID = null;
    protected Throwable thrwCapturedError = null;

    public ServerInstance(String string, ServerContainerConfig serverContainerConfig) {
        this.strInstanceID = string;
        this.scc = serverContainerConfig;
        this.setThreadName(string);
        this.resetThreadName();
    }

    public void dispose() {
        Thread thread;
        this.setThreadName();
        this.blnDisposed = true;
        this.blnIsRunning = false;
        if (this.loNotify != null) {
            this.loNotify.lo_notify();
            this.loNotify.dispose();
        }
        if ((thread = this.thrd) != null) {
            try {
                thread.join(1000L);
                if (thread.isAlive()) {
                    this.scc.logContext.write("! Forced shutdown");
                    thread.stop();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.smManager != null) {
            this.smManager.dispose();
            this.smManager = null;
        }
        this.scc.logContext.write("D Instance disposed");
        this.resetThreadName();
    }

    protected synchronized String getTransactionID() {
        long l = -1L;
        while (this.lngLastTransactionID == (l = TimeFactory.getTime())) {
        }
        this.lngLastTransactionID = l;
        return String.valueOf(this.strInstanceID) + "/" + Long.toHexString(l);
    }

    protected void init0() {
        this.scc.logContext.write("D Starting ServerInstance");
        this.loNotify = new LockObject();
        try {
            this.smManager = Configuration.getStorageManager(this.scc.logContext);
        }
        catch (Throwable throwable) {
            this.scc.logContext.write(throwable);
            this.dispose();
            throw new InitializationException();
        }
        this.scc.logContext.write("D Instance started");
    }

    public boolean isBusy() {
        return this.blnIsBusy;
    }

    public boolean isRunning() {
        return this.blnIsRunning;
    }

    public abstract boolean kickInstance(Object var1);

    protected void kickThread() {
        this.blnIsRunning = true;
        this.thrd = new Thread(this);
        this.thrd.setName(this.strInstanceID);
        this.thrd.setPriority(5);
        this.thrd.start();
    }

    public void run() {
        this.init0();
        while (this.blnIsRunning) {
            this.loNotify.lo_wait();
            if (!this.blnIsRunning) {
                return;
            }
            this.strTransactionID = this.getTransactionID();
            this.scc.logContext.write("# TS " + this.strTransactionID);
            try {
                this.service();
            }
            catch (StorageException storageException) {
                this.scc.logContext.write("! Handled exception", (Throwable)storageException);
            }
            catch (Throwable throwable) {
                this.scc.logContext.write("? Unhandled exception", throwable);
            }
            try {
                this.servicePostProcess();
            }
            catch (Throwable throwable) {
                this.scc.logContext.write("? servicePostProcess:", throwable);
            }
            this.smManager.rollback();
            this.scc.logContext.write("# TE " + this.strTransactionID);
            this.setBusy(false);
        }
    }

    protected abstract void service() throws Throwable;

    protected abstract void servicePostProcess();

    public void setBusy(boolean bl) {
        this.blnIsBusy = bl;
    }
}

