/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import java.util.Vector;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.mta.ServerInstance;

public abstract class ServerContainer
extends Application
implements Runnable {
    protected static final String ID_POP3 = "POP3";
    protected static final String ID_SMTP = "SMTP";
    protected static final String ID_FWD = "FWD";
    protected static final String ID_MPA = "MPA";
    protected ServerContainerConfig scc = null;
    protected LockObject loThreadStarted = null;
    protected String strContainerName = null;
    protected int intInstances = -1;
    protected Thread thrd = null;
    protected boolean blnIsRunning = false;
    private Vector vecInstances = null;
    private boolean blnRoundRobin = true;
    private int intLastResource = -1;

    public ServerContainer(ServerContainerConfig serverContainerConfig, String string) {
        this.scc = serverContainerConfig;
        this.strContainerName = string;
    }

    protected void addInstance(ServerInstance serverInstance) {
        this.vecInstances.addElement(serverInstance);
    }

    public synchronized void dispose() {
        Thread thread;
        this.setThreadName();
        this.scc.logContext.write("D Starting dispose of container");
        this.blnDisposed = true;
        if (this.loThreadStarted != null) {
            this.loThreadStarted.dispose();
            this.loThreadStarted = null;
        }
        if (this.vecInstances != null) {
            int n = 0;
            while (n < this.vecInstances.size()) {
                ServerInstance serverInstance = (ServerInstance)this.vecInstances.elementAt(n);
                serverInstance.dispose();
                ++n;
            }
            this.vecInstances.removeAllElements();
            this.vecInstances = null;
        }
        if ((thread = this.thrd) != null) {
            this.blnIsRunning = false;
            try {
                thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {}
            this.thrd = null;
            thread = null;
        }
        this.scc.logContext.write("D container disposed");
        this.resetThreadName();
    }

    protected int getBusyInstanceCount() {
        return this.getInstanceCount() - this.getFreeInstanceCount();
    }

    protected ServerInstance getFreeInstance() {
        if (this.vecInstances == null || this.vecInstances.size() == 0 || this.blnDisposed) {
            return null;
        }
        int n = 0;
        if (this.blnRoundRobin) {
            n = this.intLastResource + 1;
        }
        Vector vector = this.vecInstances;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.vecInstances.size()) {
                if (n >= this.vecInstances.size()) {
                    n = 0;
                }
                ServerInstance serverInstance = (ServerInstance)this.vecInstances.elementAt(n);
                if (this.blnDisposed) {
                    return null;
                }
                if (serverInstance != null && !serverInstance.isBusy()) {
                    this.intLastResource = n;
                    serverInstance.setBusy(true);
                    return serverInstance;
                }
                ++n;
                ++n2;
            }
        }
        return null;
    }

    protected int getFreeInstanceCount() {
        int n = 0;
        Vector vector = this.vecInstances;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.vecInstances.size()) {
                ServerInstance serverInstance = (ServerInstance)this.vecInstances.elementAt(n2);
                if (serverInstance != null && !serverInstance.isBusy()) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    protected int getInstanceCount() {
        return this.vecInstances.size();
    }

    protected boolean init() throws Throwable {
        String string = this.strContainerName.toUpperCase().trim();
        if (string.equals(ID_POP3)) {
            this.intInstances = this.scc.cnf.intPOP3_Instances;
            this.blnRoundRobin = this.scc.cnf.blnPOP3_RoundRobin;
        }
        if (string.equals(ID_SMTP)) {
            this.intInstances = this.scc.cnf.intSMTP_Instances;
            this.blnRoundRobin = this.scc.cnf.blnSMTP_RoundRobin;
        }
        if (string.equals(ID_FWD)) {
            this.intInstances = this.scc.cnf.intFWD_Instances;
            this.blnRoundRobin = this.scc.cnf.blnFWD_RoundRobin;
        }
        if (string.equals(ID_MPA)) {
            this.intInstances = this.scc.cnf.intMPA_Instances;
            this.blnRoundRobin = this.scc.cnf.blnMPA_RoundRobin;
        }
        this.vecInstances = new Vector(this.intInstances);
        this.loThreadStarted = new LockObject();
        return this.intInstances > 0;
    }

    public boolean isRunning() {
        return !this.blnDisposed && this.blnIsRunning;
    }

    protected void kickThread() {
        this.blnIsRunning = false;
        this.thrd = new Thread((Runnable)this, this.getThreadName());
        this.thrd.setPriority(1);
        this.thrd.start();
        this.loThreadStarted.lo_wait();
        if (!this.blnIsRunning) {
            this.dispose();
            throw new InitializationException();
        }
    }

    public abstract void run();
}

