/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.Encoding;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.io.SMTPInputReader;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.mta.ServerSocketInstance;
import net.zerotoaster.mta.ZeroToaster;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.FilterRecord;
import net.zerotoaster.storage.MailQueueRecord;
import net.zerotoaster.storage.MailingListRecord;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.storage.UserRecord;
import net.zerotoaster.util.Helper;
import net.zerotoaster.util.HostIP;
import net.zerotoaster.util.RBLCheck;
import net.zerotoaster.util.UserAlias;

public class SMTP_ServerInstance
extends ServerSocketInstance {
    private static final int CMD_NOTFOUND = 0;
    private static final int CMD_HELO = 1;
    private static final int CMD_EHLO = 2;
    private static final int CMD_NOOP = 3;
    private static final int CMD_RSET = 4;
    private static final int CMD_QUIT = 5;
    private static final int CMD_MAIL = 6;
    private static final int CMD_RCPT = 7;
    private static final int CMD_DATA = 8;
    private static final int CMD_HELP = 9;
    private static final int CMD_AUTH = 10;
    private static final int CMD_ILLEGAL_TRANSACTION_STATE = 99;
    private static String[] CMDS = null;
    private boolean blnIllegalTransactionState = false;
    private int intIllegalTransactionCount = 0;
    private boolean blnFatalError = false;
    private UserInfo uiMailFrom = null;
    private Vector vecRecipients = null;
    private int intAdditionalRecipients = 0;
    private Vector vecHeader = null;
    private boolean blnSenderIntern = false;
    private boolean blnTrustedNetwork = false;
    private boolean blnSMTP_AUTH = false;
    private String strSMTP_AUTH_User = null;
    private boolean blnToMailinglist = false;
    private String strAccUser = null;
    boolean blnAVScan = false;
    private FilterRecord[] flFilters = null;
    private static int intInstances = 0;
    private String strHELO = null;
    private RBLCheck rbl = null;
    private UserAlias uaAlias = null;

    public SMTP_ServerInstance(String string, ServerContainerConfig serverContainerConfig) {
        super(string, serverContainerConfig);
        this.init();
        this.kickThread();
    }

    private String alias_smart_delivery(String string) {
        if (string.indexOf("@") == -1) {
            return string;
        }
        if (this.smManager.userRead(string) != null) {
            return string;
        }
        String string2 = HelperExtract.splitUserName_getUser((String)string);
        String string3 = HelperExtract.splitUserName_getDomain((String)string);
        if (this.smManager.domainRead(string3) == null) {
            return string;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.scc.cnf.strAlias_SmartDelivery.length) {
            if (this.scc.cnf.strAlias_SmartDelivery[n].equalsIgnoreCase(string2)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return string;
        }
        this.logUserRedirection(string, string2, "smart delivery");
        return string2;
    }

    private void buildNewHeader() {
        this.vecHeader.removeAllElements();
        String string = new String(new byte[]{9});
        this.vecHeader.addElement("Received: from " + this.lsok.getInetAddress().getHostName() + " [" + this.lsok.getInetAddress().getHostAddress() + "]");
        this.vecHeader.addElement(String.valueOf(string) + "by   " + this.lsok.getLocalAddress().getHostName() + " [" + this.lsok.getLocalAddress().getHostAddress() + "]");
        this.vecHeader.addElement(String.valueOf(string) + "MTA  " + ZeroToaster.getVersion());
        this.vecHeader.addElement(String.valueOf(string) + "at   " + new Date().toString());
        this.vecHeader.addElement(String.valueOf(string) + "id   " + this.strTransactionID);
        this.vecHeader.addElement(String.valueOf(string) + "HELO [" + this.strHELO + "]");
        if (this.blnSMTP_AUTH) {
            this.vecHeader.addElement("X-ZeroToaster-Info: SMTP AUTH User was " + this.strSMTP_AUTH_User);
        }
        this.vecHeader.addElement("X-PLACEHOLDER");
    }

    protected boolean cmdSend(String string) throws IOException {
        if (string.startsWith("5")) {
            this.scc.logContext.write("! " + string);
        }
        return super.cmdSend(string);
    }

    private void cmd_auth(String string) throws IOException {
        Object object;
        Encoding encoding = Encoding.createEncodingInstance((String)"base64");
        String string2 = Helper.getArg(string);
        String string3 = Helper.getCmd(string2);
        String string4 = "";
        String string5 = "";
        UserRecord userRecord = null;
        String string6 = "555 Unknown error in AUTH";
        int n = 0;
        if (string3.equals("plain")) {
            n = 1;
        }
        if (string3.equals("login")) {
            n = 2;
        }
        if (string3.equals("cram-md5")) {
            n = 3;
        }
        if (this.scc.cnf.strSMTP_AuthMethods.toLowerCase().indexOf(string3) == -1) {
            this.cmdSend("504 SMTP AUTH method not allowed [" + string3 + "]");
            return;
        }
        switch (n) {
            case 0: {
                string6 = "504 Unrecognized authentication type";
                break;
            }
            case 1: {
                object = new StringTokenizer(this.strLastReceivedPlain, " ");
                ((StringTokenizer)object).nextToken();
                ((StringTokenizer)object).nextToken();
                if (!((StringTokenizer)object).hasMoreTokens()) {
                    string6 = "500 Missing Base64 domain/user/password phrase in AUTH PLAIN";
                    break;
                }
                String string7 = encoding.decodeString(((StringTokenizer)object).nextToken());
                try {
                    object = new StringTokenizer(string7, String.valueOf('\u0000'));
                    ((StringTokenizer)object).nextToken();
                    string4 = ((StringTokenizer)object).nextToken();
                    string5 = ((StringTokenizer)object).nextToken();
                }
                catch (Throwable throwable) {
                    try {
                        object = new StringTokenizer(string7, String.valueOf('\u0000'));
                        string4 = ((StringTokenizer)object).nextToken();
                        string5 = ((StringTokenizer)object).nextToken();
                    }
                    catch (Throwable throwable2) {
                        string6 = "500 Error parsing your response [" + string7 + "]";
                        break;
                    }
                }
                userRecord = this.smManager.userRead(HelperValidate.validateRFC822_User((String)string4));
                if (userRecord == null) {
                    string6 = "500 Authentication failed, unknown user [" + string4 + "]";
                    this.scc.logContext.write("! Decoded User/Pass: " + string4 + " / " + string5);
                    break;
                }
                if (!string5.equalsIgnoreCase(userRecord.getPassWord())) {
                    string6 = "500 Authentication failed, wrong password";
                    this.scc.logContext.write("! Decoded User/Pass: " + string4 + " / " + string5);
                    break;
                }
                this.blnSMTP_AUTH = true;
                this.strSMTP_AUTH_User = string4;
                break;
            }
            case 2: {
                this.cmdSend("334 " + encoding.encodeString("Username:"));
                this.cmdReceive();
                String string8 = encoding.decodeString(this.strLastReceivedPlain);
                this.cmdSend("334 " + encoding.encodeString("Password:"));
                this.cmdReceive();
                String string9 = encoding.decodeString(this.strLastReceivedPlain);
                userRecord = this.smManager.userRead(HelperValidate.validateRFC822_User((String)string8));
                if (userRecord != null) {
                    string4 = string8;
                    string5 = string9;
                } else {
                    userRecord = this.smManager.userRead(HelperValidate.validateRFC822_User((String)string9));
                    string4 = string9;
                    string5 = string8;
                }
                if (userRecord == null) {
                    string6 = "500 AUTH LOGIN Authentication failed, unknown user [" + string4 + "]";
                    this.scc.logContext.write("! Decoded User/Pass: " + string4 + " / " + string5);
                    break;
                }
                if (!string5.equals(userRecord.getPassWord())) {
                    string6 = "500 AUTH LOGIN Authentication failed, wrong password";
                    this.scc.logContext.write("! Decoded User/Pass: " + string4 + " / " + string5);
                    break;
                }
                this.blnSMTP_AUTH = true;
                this.strSMTP_AUTH_User = string4;
                break;
            }
            case 3: {
                String string10 = "<" + TimeFactory.createUID() + "@" + this.lsok.getLocalAddress().getHostName() + ">";
                this.cmdSend("334 " + encoding.encodeString(string10));
                this.cmdReceive();
                String string11 = encoding.decodeString(this.strLastReceivedPlain);
                string4 = Helper.getCmd(string11);
                String string12 = Helper.getArg(string11).toLowerCase();
                userRecord = this.smManager.userRead(HelperValidate.validateRFC822_User((String)string4));
                if (userRecord == null) {
                    string6 = "500 Authentication failed, unknown user";
                    this.scc.logContext.write("! Challenge was: " + string10);
                    this.scc.logContext.write("! Decoded User/Pass: " + string4 + " / " + string12);
                    break;
                }
                byte[] byArray = Helper.hmac_md5(userRecord.getPassWord(), string10);
                String string13 = HelperFormat.hexDigit((byte[])byArray);
                if (!string12.equals(string13)) {
                    string6 = "500 Authentication failed, wrong password";
                    this.scc.logContext.write("! Challenge was: " + string10);
                    this.scc.logContext.write("! Decoded User/Pass: " + string4 + " / " + string12);
                    this.scc.logContext.write("! Needed  User/Pass: " + string4 + " / " + string13);
                    break;
                }
                this.blnSMTP_AUTH = true;
                this.strSMTP_AUTH_User = string4;
            }
        }
        encoding.dispose();
        if (!this.blnSMTP_AUTH) {
            this.cmdSend(string6);
            return;
        }
        if (userRecord == null) {
            this.cmdSend("599 Internal error - usr in SMTP AUTH is NULL");
            this.blnSMTP_AUTH = false;
            return;
        }
        if (!userRecord.getEnabled()) {
            this.blnSMTP_AUTH = false;
            this.cmdSend("500 Account disabled");
            return;
        }
        object = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)this.strSMTP_AUTH_User));
        if (object == null) {
            this.cmdSend("599 Internal error - dom in SMTP AUTH is NULL");
            this.blnSMTP_AUTH = false;
            return;
        }
        this.blnAVScan |= ((DomainRecord)object).getAVScan();
        this.strAccUser = this.strSMTP_AUTH_User;
        this.cmdSend("235 Authentication successful.");
    }

    private void cmd_data(String string) throws IOException {
        if (this.uiMailFrom == null) {
            this.cmdSend("554 Sender not valid");
            return;
        }
        if (this.vecRecipients.size() == 0) {
            this.cmdSend("554 No valid recipients");
            return;
        }
        this.cmdSend("354 Enter your mail, end with \".\" on a line by itself");
        String string2 = TimeFactory.createUID();
        SMTPInputReader sMTPInputReader = new SMTPInputReader(this.lsok.getLineReader(), this.vecHeader, this.scc.logContext);
        long l = this.lsok.getBytesReceived();
        this.smManager.tempWrite(string2, sMTPInputReader);
        l = this.lsok.getBytesReceived() - l;
        if (!sMTPInputReader.canStore()) {
            this.smManager.rollback();
            if (sMTPInputReader.getRejectMessage().length() == 0) {
                this.cmdSend("554 Could not receive data");
            } else {
                this.cmdSend("554 " + sMTPInputReader.getRejectMessage());
            }
            this.blnFatalError = true;
            return;
        }
        if (this.strAccUser == null) {
            this.strAccUser = "<>";
        }
        this.scc.logContext.write("D Body received");
        long l2 = TimeFactory.getTime();
        MailQueueRecord mailQueueRecord = new MailQueueRecord(this.vecRecipients.size());
        mailQueueRecord.blnAVScan = this.blnAVScan;
        mailQueueRecord.strUID_Queue = string2;
        mailQueueRecord.strUID_Temp = string2;
        int n = 0;
        while (n < this.vecRecipients.size()) {
            UserInfo userInfo = (UserInfo)this.vecRecipients.elementAt(n);
            mailQueueRecord.arrMHR[n].setEnvelopeFrom_Redirected(this.uiMailFrom.strUser);
            mailQueueRecord.arrMHR[n].setEnvelopeFrom_Orginal(this.uiMailFrom.strOrgUser);
            mailQueueRecord.arrMHR[n].setEnvelopeTo_Redirected(userInfo.strUser);
            mailQueueRecord.arrMHR[n].setEnvelopeTo_Orginal(userInfo.strOrgUser);
            mailQueueRecord.arrMHR[n].setMailSize(l);
            mailQueueRecord.arrMHR[n].setTimeReceived(l2);
            mailQueueRecord.arrMHR[n].setTimeNextRetry(l2);
            mailQueueRecord.arrMHR[n].setTimeFetched(0L);
            mailQueueRecord.arrMHR[n].setRetryCount(0);
            mailQueueRecord.arrMHR[n].setMailDeleted(false);
            mailQueueRecord.arrMHR[n].setUID(TimeFactory.createUID());
            mailQueueRecord.arrMHR[n].setAccounting(this.strAccUser);
            mailQueueRecord.arrMHR[n].setHELO(this.strHELO);
            DomainRecord domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)userInfo.strUser));
            UserRecord userRecord = this.smManager.userRead(userInfo.strUser);
            String string3 = "";
            if (userInfo.blnRelayMail) {
                mailQueueRecord.arrMHR[n].setExternalMail(true);
                mailQueueRecord.arrMHR[n].setIsRelayMail(true);
                string3 = "R";
            } else if (domainRecord == null) {
                mailQueueRecord.arrMHR[n].setExternalMail(true);
                mailQueueRecord.arrMHR[n].setIsRelayMail(false);
                string3 = "I";
            } else {
                mailQueueRecord.arrMHR[n].setExternalMail(userRecord == null && !userInfo.blnHubMail);
                mailQueueRecord.arrMHR[n].setIsRelayMail(false);
                mailQueueRecord.arrMHR[n].setIsHubMail(userInfo.blnHubMail);
                string3 = "I";
            }
            if (this.strAccUser != null) {
                this.smManager.accountingStore(string3, this.strAccUser, this.lsok.getBytesReceived(), this.lsok.getBytesSent());
            }
            ++n;
        }
        this.smManager.mailProcessQueueAdd(mailQueueRecord);
        this.smManager.commit();
        this.cmdSend("250 OK DATA Mail received");
        this.scc.logContext.write("# Mail received.");
        this.initSession();
    }

    private void cmd_ehlo(String string) throws IOException {
        if (this.strHELO.length() == 0) {
            this.strHELO = Helper.getArg(string);
            if (this.strHELO == null) {
                this.strHELO = "";
            }
            this.cmdSend("250-" + this.lsok.getLocalAddress().getHostName() + " Hello " + this.lsok.getInetAddress().getHostName() + ", pleased to meet you");
            if (this.scc.cnf.strSMTP_AuthMethods.length() > 0) {
                this.cmdSend("250-AUTH " + this.scc.cnf.strSMTP_AuthMethods);
            }
            this.cmdSend("250 HELP");
        } else {
            this.cmdSend("550 Additional EHLO ignored");
        }
    }

    private void cmd_helo(String string) throws IOException {
        if (this.strHELO.length() == 0) {
            this.strHELO = Helper.getArg(string);
            if (this.strHELO == null) {
                this.strHELO = "";
            }
            this.cmdSend("250 OK " + string);
        } else {
            this.cmdSend("550 Additional HELO ignored [" + string + "]");
        }
    }

    private void cmd_help(String string) throws IOException {
        this.cmdSend("214-Help for " + ZeroToaster.getVersion());
        this.cmdSend("214-Implemented commands are:");
        int n = 0;
        while (n < CMDS.length) {
            if (CMDS[n] != null) {
                this.cmdSend("214- " + CMDS[n]);
            }
            ++n;
        }
        this.cmdSend("214 [End of help]");
    }

    private void cmd_illegaltransactionstate(String string) throws IOException {
        ++this.intIllegalTransactionCount;
        if (this.intIllegalTransactionCount < 5) {
            this.cmdSend("500 Not a valid transaction state. Try RSET or QUIT");
        } else {
            this.blnFatalError = true;
            this.cmdSend("599 Too many transaction errors, closing connection");
        }
    }

    private void cmd_mail(String string) throws IOException {
        String string2 = Helper.getSMTPUser(this.getArgument(string));
        if (HelperValidate.validateRFC822_User((String)string2) == null && string2.length() > 0) {
            this.cmdSend("550 Username syntactically incorrect '" + string + "'");
            return;
        }
        this.uiMailFrom = new UserInfo(this);
        this.uiMailFrom.strUser = string2;
        this.uiMailFrom.strOrgUser = string2;
        this.buildNewHeader();
        this.cmdSend("250 OK " + string);
    }

    private void cmd_noop(String string) throws IOException {
        this.cmdSend("250 OK " + string);
    }

    private void cmd_notfound(String string) throws IOException {
        this.cmdSend("500 Command not recognized [" + string + "]");
    }

    private void cmd_notimplemented(String string) throws IOException {
        this.cmdSend("500 Command not implemented [" + string + "]");
    }

    private void cmd_quit(String string) throws IOException {
        this.cmdSend("221 OK " + this.lsok.getLocalAddress().getHostName() + " says goodbye");
    }

    private void cmd_rcpt(String string) throws IOException {
        Object object;
        if (this.uiMailFrom == null) {
            this.cmdSend("550 Missing 'mail from'. Cannot continue");
            return;
        }
        String string2 = Helper.getSMTPUser(this.getArgument(string));
        String string3 = HelperExtract.splitUserName_getUser((String)string2);
        String string4 = HelperExtract.splitUserName_getDomain((String)string2);
        String string5 = this.lsok.getLocalAddress().getHostAddress();
        if (string4.startsWith("[") && string4.endsWith("]")) {
            object = string4.substring(1);
            if (!HelperValidate.isIP((String)(object = ((String)object).substring(0, ((String)object).length() - 1)))) {
                this.cmdSend("550 Not a valid IP4 as domain part [" + string + "]");
                return;
            }
            if (!((String)object).equals(string5)) {
                this.cmdSend("550 This is not our IP Address [" + string + "]");
                return;
            }
            string2 = string3;
        }
        string2 = this.alias_smart_delivery(string2);
        object = this.uaAlias.resolve(string2);
        int n = 0;
        while (n < ((String[])object).length) {
            if (HelperValidate.validateRFC822_User((String)object[n]) == null) {
                this.cmdSend("550 Username syntactically incorrect [" + (String)object[n] + "]");
            } else {
                UserInfo userInfo = new UserInfo(this);
                userInfo.strUser = object[n];
                userInfo.strOrgUser = object[n];
                userInfo.blnRelayMail = false;
                if (!this.blnSenderIntern && this.vecRecipients.size() >= this.scc.cnf.intSMTP_Max_Recipients + this.intAdditionalRecipients) {
                    this.cmdSend("452 Too many recipients, user ignored");
                    return;
                }
                DomainRecord domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)userInfo.strUser));
                boolean bl = domainRecord != null;
                this.uiMailFrom = this.validateMailFrom(this.uiMailFrom, bl);
                if (this.uiMailFrom == null) {
                    this.blnIllegalTransactionState = true;
                    return;
                }
                if (!this.processML_Message(userInfo) && (userInfo = this.validateMailTo(userInfo)) != null && (this.blnSenderIntern && !userInfo.blnRelayRBLCheck || this.rblCheck())) {
                    this.vecRecipients.addElement(userInfo);
                    this.cmdSend("250 OK " + string + " [" + userInfo.strUser + "]");
                }
            }
            ++n;
        }
    }

    private void cmd_rset(String string) throws IOException {
        this.initSession();
        this.blnFatalError = false;
        this.blnIllegalTransactionState = false;
        this.intIllegalTransactionCount = 0;
        this.blnAVScan = false;
        this.blnSenderIntern = false;
        this.blnToMailinglist = false;
        if (string == null) {
            this.blnSMTP_AUTH = false;
            this.strSMTP_AUTH_User = null;
        }
        this.smManager.rollback();
        if (string != null) {
            this.cmdSend("250 OK RSET, Session invalidated");
        }
    }

    public void dispose() {
        this.setThreadName();
        super.dispose();
        this.uiMailFrom = null;
        this.vecRecipients = null;
        this.vecHeader = null;
        this.rbl.dispose();
        this.resetThreadName();
    }

    private String getArgument(String string) {
        int n = string.indexOf(58) + 1;
        if (n == -1) {
            return string;
        }
        return string.substring(n);
    }

    private int getCommand(String string) {
        String string2 = Helper.getCmd(string);
        int n = 0;
        int n2 = 0;
        while (n2 < CMDS.length) {
            String string3 = CMDS[n2];
            if (string3 != null && string3.equals(string2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (this.blnIllegalTransactionState) {
            switch (n) {
                case 4: 
                case 5: {
                    return n;
                }
            }
            return 99;
        }
        return n;
    }

    private void init() {
        if (CMDS == null) {
            CMDS = new String[11];
            SMTP_ServerInstance.CMDS[1] = "helo";
            SMTP_ServerInstance.CMDS[2] = "ehlo";
            SMTP_ServerInstance.CMDS[3] = "noop";
            SMTP_ServerInstance.CMDS[4] = "rset";
            SMTP_ServerInstance.CMDS[5] = "quit";
            SMTP_ServerInstance.CMDS[6] = "mail";
            SMTP_ServerInstance.CMDS[7] = "rcpt";
            SMTP_ServerInstance.CMDS[8] = "data";
            SMTP_ServerInstance.CMDS[9] = "help";
            SMTP_ServerInstance.CMDS[10] = "auth";
        }
        this.vecRecipients = new Vector(this.scc.cnf.intSMTP_Max_Recipients);
        this.vecHeader = new Vector();
        this.rbl = new RBLCheck(this.scc.logContext, this.scc.cnf);
    }

    private void initSession() {
        this.uiMailFrom = null;
        this.vecRecipients.removeAllElements();
        this.intAdditionalRecipients = 0;
        this.vecHeader.removeAllElements();
        this.blnSenderIntern = false;
        this.strAccUser = null;
        this.strHELO = "";
        this.uiMailFrom = null;
        this.scc.cnf.statrec.lngSMTP_bytes += this.lsok.getBytesTotal();
        this.lsok.resetCount();
        this.uaAlias = new UserAlias(this.scc.cnf.strAliases, this.scc.logContext);
    }

    public boolean kickInstance(Object object) {
        this.lsok = (LineSocket)object;
        this.loNotify.lo_notify();
        return true;
    }

    private void logUserRedirection(String string, String string2, String string3) {
        this.vecHeader.addElement("X-ZeroToaster-Info: Renamed '" + string + "' to '" + string2 + "' (" + string3 + ")");
        this.scc.logContext.write("D Renamed '" + string + "' to '" + string2 + "' (" + string3 + ")");
    }

    private void processGroup(String string) {
        Vector vector = Helper.processGroup(string);
        int n = 0;
        while (n < vector.size()) {
            UserInfo userInfo = new UserInfo(this);
            userInfo.strUser = (String)vector.elementAt(n);
            userInfo.strOrgUser = "<group copy>";
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.vecRecipients.size()) {
                UserInfo userInfo2 = (UserInfo)this.vecRecipients.elementAt(n2);
                if (userInfo2.strUser.equals(userInfo.strUser)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.vecRecipients.addElement(userInfo);
                ++this.intAdditionalRecipients;
            }
            ++n;
        }
    }

    private boolean processML_Message(UserInfo userInfo) throws IOException {
        if (userInfo.strUser.length() == 0) {
            return false;
        }
        if (this.uiMailFrom.strUser.length() == 0) {
            return false;
        }
        MailingListRecord mailingListRecord = this.smManager.mailinglistRead(userInfo.strUser);
        if (mailingListRecord == null) {
            return false;
        }
        String[] stringArray = mailingListRecord.getOwner();
        if (stringArray.length == 0) {
            return false;
        }
        this.blnSenderIntern = true;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(this.uiMailFrom.strUser)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            userInfo.strUser = stringArray[0];
            this.cmdSend("250 OK, Message sent to the list owner");
            return true;
        }
        String[] stringArray2 = mailingListRecord.getSubscribers();
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray2.length) {
            ++this.intAdditionalRecipients;
            UserInfo userInfo2 = new UserInfo(this);
            userInfo2.strUser = stringArray2[n3];
            userInfo2.strOrgUser = userInfo.strOrgUser;
            this.blnSupressSocketOutput = true;
            userInfo2 = this.validateMailTo(userInfo2);
            this.blnSupressSocketOutput = false;
            if (userInfo2 != null) {
                ++n2;
                this.vecRecipients.addElement(userInfo2);
            }
            ++n3;
        }
        this.cmdSend("250 OK Mailinglist processed");
        return true;
    }

    private boolean rblCheck() throws IOException {
        Object object;
        Object object2;
        if (this.scc.cnf.strRBL_BlackList.length == 0) {
            return true;
        }
        String string = this.lsok.getInetAddress().getHostAddress();
        int n = 0;
        while (n < this.scc.cnf.strRBL_WhiteList.length) {
            object2 = this.scc.cnf.strRBL_WhiteList[n];
            if (((String)object2).length() != 0) {
                if (Character.isDigit(((String)object2).charAt(0))) {
                    object = new IP_Network((String)object2);
                    if (object.match(string)) {
                        this.scc.logContext.write("! RBL passed IP on whitelist");
                        return true;
                    }
                } else if (this.uiMailFrom.strUser.equalsIgnoreCase((String)object2)) {
                    this.scc.logContext.write("! RBL passed user on whitelist");
                    return true;
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.scc.cnf.strRBL_BlackList.length) {
            object2 = new StringTokenizer(this.scc.cnf.strRBL_BlackList[n], ",");
            object = "";
            String string2 = "";
            if (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken().trim();
            }
            if (((StringTokenizer)object2).hasMoreTokens()) {
                string2 = ((StringTokenizer)object2).nextToken().trim();
            }
            if (((String)object).length() != 0) {
                this.scc.logContext.write("D RBL " + string + " on " + (String)object + " must match '" + string2 + "'");
                if (this.rbl.check(string, (String)object, string2)) {
                    this.cmdSend("556 " + this.rbl.getMessage());
                    return false;
                }
                this.scc.logContext.write("D RBL " + string + " " + this.rbl.getMessage());
            }
            ++n;
        }
        return true;
    }

    private boolean sendWelcome() throws IOException {
        if (!this.scc.cnf.blnSMTP_Welcome_Multiline) {
            this.cmdSend("220 " + ZeroToaster.getVersion());
            return true;
        }
        File file = new File("motd.txt");
        if (file.exists()) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                this.cmdSend("220-" + string);
            }
            this.cmdSend("220 " + ZeroToaster.getVersion());
            Helper.close(bufferedReader);
            return true;
        }
        this.cmdSend("220-Welcome to " + this.lsok.getLocalAddress().getHostName());
        this.cmdSend("220-Our local Date is " + new Date(TimeFactory.getTime()).toString());
        this.cmdSend("220-Our mailsystem is " + ZeroToaster.getVersion());
        this.cmdSend("220 " + this.scc.cnf.strSMTP_Welcome_Message);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void service() throws Throwable {
        this.scc.cnf.statrec.intSMTP_peak = Math.max(this.scc.cnf.statrec.intSMTP_peak, ++SMTP_ServerInstance.intInstances);
        this.scc.logContext.write("# " + this.lsok.getInetAddress() + " is coming in");
        this.cmd_rset(null);
        var1_1 = this.smManager.filterReadAll();
        this.flFilters = new FilterRecord[var1_1.size()];
        var2_2 = 0;
        while (var2_2 < var1_1.size()) {
            this.flFilters[var2_2] = this.smManager.filterRead((String)var1_1.elementAt(var2_2));
            ++var2_2;
        }
        this.blnTrustedNetwork = false;
        var2_3 = this.scc.cnf.ipnTrustedNetworks;
        var3_4 = 0;
        while (var3_4 < var2_3.length) {
            if (var2_3[var3_4].match(this.lsok.getInetAddress().getHostAddress())) {
                this.blnTrustedNetwork = true;
                this.scc.logContext.write("D Trusted Network: " + this.lsok.getInetAddress());
                break;
            }
            ++var3_4;
        }
        if (this.sendWelcome()) ** GOTO lbl70
        return;
lbl-1000:
        // 1 sources

        {
            var3_5 = null;
            try {
                var3_5 = this.cmdReceive();
            }
            catch (InterruptedIOException var4_6) {
                this.cmdSend("503 Session timeout");
                throw var4_6;
            }
            switch (this.getCommand(var3_5)) {
                case 0: {
                    this.cmd_notfound(var3_5);
                    break;
                }
                case 99: {
                    this.cmd_illegaltransactionstate(var3_5);
                    break;
                }
                case 1: {
                    this.cmd_helo(var3_5);
                    break;
                }
                case 2: {
                    this.cmd_ehlo(var3_5);
                    break;
                }
                case 3: {
                    this.cmd_noop(var3_5);
                    break;
                }
                case 4: {
                    this.cmd_rset(var3_5);
                    break;
                }
                case 6: {
                    this.cmd_mail(var3_5);
                    break;
                }
                case 7: {
                    this.cmd_rcpt(var3_5);
                    break;
                }
                case 8: {
                    this.cmd_data(var3_5);
                    break;
                }
                case 9: {
                    this.cmd_help(var3_5);
                    break;
                }
                case 10: {
                    this.cmd_auth(var3_5);
                    break;
                }
                case 5: {
                    this.cmd_quit(var3_5);
                    return;
                }
                default: {
                    this.cmd_notimplemented(var3_5);
                }
            }
lbl70:
            // 13 sources

            ** while (!this.blnFatalError && this.blnIsRunning)
        }
lbl71:
        // 1 sources

    }

    protected void servicePostProcess() {
        --intInstances;
        if (this.uiMailFrom != null && this.blnSenderIntern && this.lsok != null) {
            UserRecord userRecord = this.smManager.userRead(this.uiMailFrom.strUser);
            userRecord.setPOP3_IP(this.lsok.getInetAddress().getHostAddress());
            userRecord.setPOP3_Time(TimeFactory.getTime());
            this.smManager.userWrite(userRecord);
            this.scc.logContext.write("D SMTP after POP3 timestamp updated");
        }
        ++this.scc.cnf.statrec.lngSMTP_accesses;
        this.initSession();
    }

    private UserInfo validateMailFrom(UserInfo userInfo, boolean bl) throws IOException {
        boolean bl2;
        int n;
        StorageRecord storageRecord;
        this.blnSenderIntern = false;
        if (userInfo == null) {
            return null;
        }
        this.processGroup(userInfo.strUser);
        String string = this.lsok.getInetAddress().getHostAddress();
        int n2 = 0;
        while (n2 < this.flFilters.length) {
            storageRecord = this.flFilters[n2];
            if (((FilterRecord)storageRecord).getFilterType() == 3) {
                if (((FilterRecord)storageRecord).getType() == 1 && userInfo.strUser.equals(((FilterRecord)storageRecord).getMask())) {
                    this.scc.logContext.write("# Rejected user by filter '" + ((FilterRecord)storageRecord).getName() + "'");
                    this.cmdSend("554 We do not accept mail from your user");
                    return null;
                }
                if (((FilterRecord)storageRecord).getType() == 2 && userInfo.strUser.endsWith("@" + ((FilterRecord)storageRecord).getMask())) {
                    this.scc.logContext.write("# Rejected domain by filter '" + ((FilterRecord)storageRecord).getName() + "'");
                    this.cmdSend("554 We do not accept mail from your domain");
                    return null;
                }
                if (((FilterRecord)storageRecord).getType() == 3 && IP_Network.match((String)((FilterRecord)storageRecord).getMask(), (String)string)) {
                    this.scc.logContext.write("# Rejected IP by filter '" + ((FilterRecord)storageRecord).getName() + "'");
                    this.cmdSend("554 We do not accept mail from your network");
                    return null;
                }
            }
            ++n2;
        }
        if (this.blnTrustedNetwork) {
            this.scc.logContext.write("D validateMailFrom: OK, user is in trusted network");
            this.blnSenderIntern = true;
            return userInfo;
        }
        if (this.blnSMTP_AUTH) {
            this.blnSenderIntern = true;
            this.scc.logContext.write("D validateMailFrom: OK, user had SMTP AUTH");
            return userInfo;
        }
        if (userInfo.strUser.length() == 0) {
            this.scc.logContext.write("D validateMailFrom: OK, user was <>");
            return userInfo;
        }
        DomainRecord domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)userInfo.strUser));
        if (domainRecord == null) {
            this.scc.logContext.write("D validateMailFrom: OK, domSender == null");
            return userInfo;
        }
        if (!domainRecord.getEnable_SMTP()) {
            this.cmdSend("550 SMTP Access isn't allowed for your Domain");
            return null;
        }
        if (bl) {
            this.scc.logContext.write("D validateMailFrom: OK, receiver is intern");
            return userInfo;
        }
        storageRecord = this.smManager.userRead(userInfo.strUser);
        if (storageRecord == null) {
            if (domainRecord.getMailHub_Role() == 1 || domainRecord.getMailHub_Role() == 2) {
                this.blnAVScan |= domainRecord.getAVScan();
                this.strAccUser = userInfo.strUser;
                this.blnSenderIntern = true;
                this.scc.logContext.write("D validateMailFrom: OK, mailhub");
                return userInfo;
            }
            this.cmdSend("552 No such user [" + userInfo.strUser + "]");
            return null;
        }
        if (!((UserRecord)storageRecord).getEnabled()) {
            this.cmdSend("550 Account disabled [" + userInfo.strUser + "]");
            return null;
        }
        IP_Network[] iP_NetworkArray = new IP_Network[]{};
        switch (((UserRecord)storageRecord).getRestrictIP_SMTP()) {
            case 0: {
                break;
            }
            case 1: {
                iP_NetworkArray = domainRecord.getIP_Networks();
                break;
            }
            case 2: {
                iP_NetworkArray = ((UserRecord)storageRecord).getIP_Networks();
                break;
            }
            case 3: {
                iP_NetworkArray = new IP_Network[domainRecord.getIP_Networks().length + ((UserRecord)storageRecord).getIP_Networks().length];
                int n3 = 0;
                n = 0;
                while (n < domainRecord.getIP_Networks().length) {
                    iP_NetworkArray[n3++] = domainRecord.getIP_Networks()[n];
                    ++n;
                }
                n = 0;
                while (n < ((UserRecord)storageRecord).getIP_Networks().length) {
                    iP_NetworkArray[n3++] = ((UserRecord)storageRecord).getIP_Networks()[n];
                    ++n;
                }
                break;
            }
        }
        String string2 = this.lsok.getInetAddress().getHostAddress();
        n = iP_NetworkArray.length == 0 ? 1 : 0;
        boolean bl3 = false;
        while (bl3 < iP_NetworkArray.length) {
            if (iP_NetworkArray[bl3].match(string2)) {
                n = 1;
                break;
            }
            bl3 += 1;
        }
        bl3 = false;
        int n4 = 0;
        switch (((UserRecord)storageRecord).getSMTP_after_POP3()) {
            case 0: {
                bl3 = false;
                n4 = 0;
                break;
            }
            case 2: {
                bl3 = true;
                n4 = ((UserRecord)storageRecord).getSessionTimeout();
                break;
            }
            case 1: {
                bl3 = domainRecord.getSMTP_after_POP3();
                n4 = domainRecord.getSessionTimeout();
            }
        }
        boolean bl4 = bl2 = n == 0;
        if (this.blnSMTP_AUTH) {
            bl2 = false;
        }
        this.scc.logContext.write("D validateMailFrom: validatePOP2=" + bl2 + ",useSmtpAfterPOP3=" + bl3);
        if (bl2) {
            if (bl3) {
                InetAddress inetAddress = InetAddress.getByName(((UserRecord)storageRecord).getPOP3_IP());
                if (!this.lsok.getInetAddress().equals(inetAddress)) {
                    this.cmdSend("554 IP Adress changed after last POP3 login (SMTP after POP3)");
                    return null;
                }
                if (TimeFactory.getTime() - ((UserRecord)storageRecord).getPOP3_Time() > (long)n4 * 1000L) {
                    this.cmdSend("554 SMTP after POP3 session timeout");
                    return null;
                }
            } else if (iP_NetworkArray.length != 0) {
                this.cmdSend("554 Your IP isn't in the range of allowed networks");
                return null;
            }
        }
        this.blnAVScan |= domainRecord.getAVScan();
        this.strAccUser = userInfo.strUser;
        this.blnSenderIntern = true;
        this.scc.logContext.write("D validateMailFrom: OK, sender is intern");
        return userInfo;
    }

    private UserInfo validateMailTo(UserInfo userInfo) throws IOException {
        boolean bl;
        this.processGroup(userInfo.strUser);
        String string = userInfo.strUser.toLowerCase().trim();
        if (HelperExtract.splitUserName_getDomain((String)userInfo.strUser).length() == 0) {
            this.scc.logContext.write("? Missing domain part in user '" + userInfo.strUser + "'");
            this.cmdSend("550 Missing domain part in user [" + userInfo.strUser + "]");
            return null;
        }
        if (HelperExtract.splitUserName_getUser((String)userInfo.strUser).length() == 0) {
            this.scc.logContext.write("? Missing user part in user '" + userInfo.strUser + "'");
            this.cmdSend("550 Missing user part in user [" + userInfo.strUser + "]");
            return null;
        }
        if (HelperValidate.validateRFC822_User((String)userInfo.strUser) == null) {
            this.scc.logContext.write("? invalid name '" + userInfo.strUser + "'");
            this.cmdSend("550 Invalid Name [" + userInfo.strUser + "]");
            return null;
        }
        DomainRecord domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)userInfo.strUser));
        boolean bl2 = bl = domainRecord != null;
        if (this.blnSenderIntern && !bl) {
            this.scc.logContext.write("D validateMailTop: OK, sender intern, receiver outside");
            return userInfo;
        }
        if (!(this.blnSenderIntern || bl || this.blnSMTP_AUTH)) {
            int n = 0;
            while (n < this.flFilters.length) {
                FilterRecord filterRecord = this.flFilters[n];
                if (filterRecord.getFilterType() == 1) {
                    if (filterRecord.getType() == 1 && userInfo.strUser.equals(filterRecord.getMask())) {
                        this.scc.logContext.write("# Relay accepted by filter '" + filterRecord.getName() + "'");
                        userInfo.blnRelayMail = true;
                        userInfo.blnRelayRBLCheck = filterRecord.getRBLCheck();
                        this.blnAVScan |= filterRecord.getAVScan();
                        break;
                    }
                    if (filterRecord.getType() == 2 && HelperExtract.splitUserName_getDomain((String)userInfo.strUser).equals(filterRecord.getMask())) {
                        this.scc.logContext.write("# Relay accepted by filter '" + filterRecord.getName() + "'");
                        userInfo.blnRelayMail = true;
                        userInfo.blnRelayRBLCheck = filterRecord.getRBLCheck();
                        this.blnAVScan |= filterRecord.getAVScan();
                        break;
                    }
                    if (filterRecord.getType() == 3) {
                        try {
                            HostIP[] hostIPArray = Helper.getMXHosts(HelperExtract.splitUserName_getDomain((String)userInfo.strUser), true);
                            if (hostIPArray != null && IP_Network.match((String)filterRecord.getMask(), (String)hostIPArray[0].strIP)) {
                                userInfo.blnRelayMail = true;
                                userInfo.blnRelayRBLCheck = filterRecord.getRBLCheck();
                                this.blnAVScan |= filterRecord.getAVScan();
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            this.scc.logContext.write("? Error in Relaycheck", throwable);
                        }
                    }
                }
                ++n;
            }
            if (!userInfo.blnRelayMail) {
                this.cmdSend("550 Relaying denied [" + this.uiMailFrom.strUser + " -> " + userInfo.strUser + "]");
                return null;
            }
            this.strAccUser = userInfo.strUser;
            this.scc.logContext.write("D validateMailTop: OK, relaying accepted");
            return userInfo;
        }
        String string2 = Helper.redirectUser(userInfo.strUser, this.smManager);
        if (!string2.equals(userInfo.strUser)) {
            this.logUserRedirection(userInfo.strUser, string2, "User/Domain redirection");
            this.strAccUser = userInfo.strUser;
            userInfo.strUser = string2;
        }
        boolean bl3 = bl = (domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)userInfo.strUser))) != null;
        if (!bl) {
            this.scc.logContext.write("D validateMailTop: OK, message to the outside");
            return userInfo;
        }
        UserRecord userRecord = this.smManager.userRead(userInfo.strUser);
        if (userRecord == null) {
            if (domainRecord.getMailHub_Role() == 1) {
                userInfo.blnHubMail = true;
                domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)userInfo.strUser));
                this.blnAVScan |= domainRecord != null && domainRecord.getAVScan();
                this.scc.logContext.write("D validateMailTop: OK, hubmail");
                return userInfo;
            }
            String string3 = domainRecord.getCatchAll();
            if (string3.length() != 0) {
                string3 = Helper.redirectUser(string3, this.smManager);
                this.logUserRedirection(userInfo.strUser, string3, "Catch-All");
                userInfo.strUser = string3;
                if (this.strAccUser == null) {
                    this.strAccUser = userInfo.strUser;
                }
                userRecord = this.smManager.userRead(userInfo.strUser);
                this.scc.logContext.write("D validateMailTop: OK, catchall");
            }
        }
        if (userRecord == null) {
            this.cmdSend("552 No such user [" + userInfo.strUser + "]");
            return null;
        }
        if (this.smManager.quotaExceeded(userInfo.strUser)) {
            this.cmdSend("550 Quota exceeded [" + userInfo.strUser + "]");
            return null;
        }
        if (!userRecord.getEnabled()) {
            this.cmdSend("550 User disabled [" + userInfo.strUser + "]");
            return null;
        }
        int n = 0;
        while (n < userRecord.getCopy().length) {
            ++this.intAdditionalRecipients;
            UserInfo userInfo2 = new UserInfo(this);
            userInfo2.strUser = userRecord.getCopy()[n];
            userInfo2.strOrgUser = userInfo.strUser;
            this.vecRecipients.addElement(userInfo2);
            this.scc.logContext.write("# Created mail copy to " + userInfo2.strUser);
            ++n;
        }
        if (!userInfo.strUser.equals(string)) {
            this.processGroup(userInfo.strUser);
        }
        if (this.strAccUser == null) {
            this.strAccUser = userInfo.strUser;
        }
        this.blnAVScan |= (domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)userInfo.strUser))) != null && domainRecord.getAVScan();
        return userInfo;
    }

    class UserInfo {
        /* synthetic */ SMTP_ServerInstance this$0;
        String strUser;
        String strOrgUser;
        boolean blnRelayMail = false;
        boolean blnRelayRBLCheck = false;
        boolean blnHubMail = false;
        boolean blnListRobot = false;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("User <");
            stringBuffer.append(this.strUser);
            stringBuffer.append(">; OrgUser:<");
            stringBuffer.append(this.strOrgUser);
            stringBuffer.append("> RelayMail:");
            stringBuffer.append(this.blnRelayMail);
            stringBuffer.append("; HubMail:");
            stringBuffer.append(this.blnHubMail);
            stringBuffer.append("; ListRobot:");
            stringBuffer.append(this.blnListRobot);
            stringBuffer.append(";");
            return stringBuffer.toString();
        }

        UserInfo(SMTP_ServerInstance sMTP_ServerInstance) {
            this.this$0 = sMTP_ServerInstance;
        }
    }
}

