/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.InitializationException;
import net.zerotoaster.event.KickSMTP_MailHub;
import net.zerotoaster.event.MTAEvent;
import net.zerotoaster.event.MTAEventListener;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.mta.SMTP_ServerInstance;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.mta.ServerInstance;
import net.zerotoaster.mta.ServerSocketContainer;
import net.zerotoaster.util.Helper;

public class SMTP_ServerContainer
extends ServerSocketContainer
implements MTAEventListener {
    public SMTP_ServerContainer(ServerContainerConfig serverContainerConfig) throws Throwable {
        super(serverContainerConfig, "SMTP");
        this.setThreadName("SMTP-Container");
        this.init();
        this.resetThreadName();
    }

    protected String getBusyMessage() {
        return "250 Too many Users";
    }

    protected boolean init() throws Throwable {
        if (!super.init()) {
            return false;
        }
        try {
            int n = 0;
            while (n < this.intInstances) {
                SMTP_ServerInstance sMTP_ServerInstance = new SMTP_ServerInstance(String.valueOf(this.strContainerName) + " " + Helper.buildID(n + 1, this.intInstances), this.scc);
                this.addInstance(sMTP_ServerInstance);
                ++n;
            }
        }
        catch (InitializationException initializationException) {
            this.dispose();
            throw new InitializationException();
        }
        catch (Throwable throwable) {
            this.scc.logContext.write("? Unhandled exception during creating instances", throwable);
            this.dispose();
            throw new InitializationException();
        }
        this.kickThread();
        MTAEventQueue.addListener(this);
        this.scc.logContext.write("# Created " + String.valueOf(this.intInstances) + " SMTP instances");
        return true;
    }

    public void mtaEvent(MTAEvent mTAEvent) {
        if (mTAEvent instanceof KickSMTP_MailHub) {
            LineSocket lineSocket = ((KickSMTP_MailHub)mTAEvent).getSocket();
            this.scc.logContext.write("D Incoming request " + lineSocket.getInetAddress());
            ServerInstance serverInstance = this.getFreeInstance();
            if (serverInstance == null) {
                try {
                    lineSocket.println(this.getBusyMessage());
                    lineSocket.close();
                    return;
                }
                catch (Throwable throwable) {}
            }
            serverInstance.kickInstance(lineSocket);
        }
    }
}

