/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;
import net.zerotoaster.event.KickFWD_MailHub;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.io.POP3OutputWriter;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.mta.ServerSocketInstance;
import net.zerotoaster.mta.ZeroToaster;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.UserRecord;
import net.zerotoaster.util.Helper;

public class POP3_ServerInstance
extends ServerSocketInstance {
    private static final int CMD_NOTFOUND = 0;
    private static final int CMD_HELP = 1;
    private static final int CMD_QUIT = 2;
    private static final int CMD_NOOP = 3;
    private static final int CMD_USER = 4;
    private static final int CMD_PASS = 5;
    private static final int CMD_LAST = 6;
    private static final int CMD_RSET = 7;
    private static final int CMD_STAT = 8;
    private static final int CMD_UIDL = 9;
    private static final int CMD_LIST = 10;
    private static final int CMD_DELE = 11;
    private static final int CMD_TOP = 12;
    private static final int CMD_RETR = 13;
    private static final int CMD_MODE = 14;
    private static final int CMD_LIC = 15;
    private static final int CMD_XREN = 16;
    private static final int CMD_ILLEGAL = 99;
    private static String[] CMDS = null;
    private Vector vecMails = null;
    private boolean blnLoggedIn = false;
    private UserRecord usr = null;
    private static int intInstances = 0;
    private DomainRecord domHub = null;
    private static Vector vecActiveUsers = null;

    public POP3_ServerInstance(String string, ServerContainerConfig serverContainerConfig) {
        super(string, serverContainerConfig);
        this.init();
        this.kickThread();
    }

    private void cmdSend_ERR(String string) throws IOException {
        if (string.length() > 0) {
            this.cmdSend("-ERR " + string);
        } else {
            this.cmdSend("-ERR");
        }
    }

    private void cmdSend_OK(String string) throws IOException {
        if (string.length() > 0) {
            this.cmdSend("+OK " + string);
        } else {
            this.cmdSend("+OK");
        }
    }

    private void cmd_dele(String string) throws IOException {
        String string2 = Helper.getArg(string);
        MailHeaderRecord mailHeaderRecord = this.getMailHeaderForNumber(string2);
        if (mailHeaderRecord != null) {
            mailHeaderRecord.setMailDeleted(true);
            this.cmdSend_OK("Mail marked for deletion");
        }
    }

    private void cmd_help(String string) throws IOException {
        this.cmdSend_OK("HELP");
        this.cmdSend(String.valueOf(ZeroToaster.getVersion()) + " POP3 Help");
        this.cmdSend("HELP            - this help");
        this.cmdSend("USER [username] - sets the username");
        this.cmdSend("PASS [password] - sets the password");
        this.cmdSend("QUIT            - ends this session");
        this.cmdSend("LAST            - returns '0' in every case");
        this.cmdSend("RSET            - resets all actions/deletes");
        this.cmdSend("NOOP            . does nothing");
        this.cmdSend("STAT            - returns number of mails and current size of your maildrop");
        this.cmdSend("UIDL            - returns all undeleted mails with their ID");
        this.cmdSend("UIDL [number]   - returns the ID of this message");
        this.cmdSend("LIST            - lists all undeleted messages");
        this.cmdSend("DELE [number]   - marks a message for deletion");
        this.cmdSend("TOP [number]    - returns [number] lines of the message text");
        this.cmdSend("RETR [number]   - retrieves a message");
    }

    private void cmd_illegal(String string) throws IOException {
        this.cmdSend_ERR("Command " + string + " not valid in this context");
    }

    private void cmd_last(String string) throws IOException {
        this.cmdSend_OK("0");
    }

    private void cmd_lic(String string) throws IOException {
        this.cmdSend_OK(this.scc.cnf.lic.toString());
    }

    private void cmd_list(String string) throws IOException {
        String string2 = Helper.getArg(string);
        if (string2 == null) {
            this.cmdSend_OK("scan listing follows");
            int n = 0;
            while (n < this.vecMails.size()) {
                MailHeaderRecord mailHeaderRecord = (MailHeaderRecord)this.vecMails.elementAt(n);
                if (!mailHeaderRecord.getMailDeleted()) {
                    this.cmdSend(n + 1 + " " + mailHeaderRecord.getMailSize());
                }
                ++n;
            }
            this.cmdSend(".");
        } else {
            MailHeaderRecord mailHeaderRecord = this.getMailHeaderForNumber(string2);
            if (mailHeaderRecord != null) {
                this.cmdSend_OK(String.valueOf(string2) + " " + mailHeaderRecord.getMailSize());
            }
        }
    }

    private void cmd_mode(String string) throws IOException {
        Vector vector = this.smManager.mailGetHeadersForDomain(this.domHub.getDomainName());
        if (vector.size() == 0) {
            this.cmdSend_ERR("No mails to transfer for domain " + this.domHub.getDomainName());
            return;
        }
        String string2 = Helper.getArg(string).toLowerCase();
        if (string2.startsWith("passive")) {
            this.blnCloseSocket = false;
            this.cmdSend_OK("Starting passive transfer to " + this.lsok.getLocalAddress());
            MTAEventQueue.postEvent(new KickFWD_MailHub(this.domHub.getDomainName(), this.lsok));
            return;
        }
        if (string2.startsWith("active")) {
            this.blnCloseSocket = true;
            if ((string2 = Helper.getArg(string2)).startsWith(":")) {
                string2 = String.valueOf(this.lsok.getInetAddress().getHostName()) + string2;
            }
            this.cmdSend_OK("Starting active transfer to " + string2);
            MTAEventQueue.postEvent(new KickFWD_MailHub(this.domHub.getDomainName(), string2));
            return;
        }
        this.cmdSend_ERR("Argument missing or wrong argument " + string2);
    }

    private void cmd_noop(String string) throws IOException {
        this.cmdSend_OK("NOOP");
    }

    private void cmd_notfound(String string) throws IOException {
        this.cmdSend_ERR("Command \"" + string + "\" not found");
    }

    private void cmd_pass(String string) throws IOException {
        String string2 = Helper.getArg(string);
        if (string2 == null) {
            this.cmdSend_ERR("Argument missing");
            return;
        }
        string2 = string2.toLowerCase();
        if (this.domHub == null) {
            this.cmd_pass_user(string2);
        } else {
            this.cmd_pass_domain(string2);
        }
    }

    private void cmd_pass_domain(String string) throws IOException {
        if (!this.domHub.getMailHub_Password().equals(string)) {
            this.cmdSend_ERR("Password mismatch");
            return;
        }
        if (!this.domHub.getEnable_POP3()) {
            this.cmdSend_ERR("POP3 disabled for domain");
            return;
        }
        IP_Network[] iP_NetworkArray = this.domHub.getIP_Networks();
        if (iP_NetworkArray != null) {
            String string2 = this.lsok.getInetAddress().getHostAddress();
            int n = 0;
            while (n < iP_NetworkArray.length) {
                if (!iP_NetworkArray[n].match(string2)) {
                    this.cmdSend_ERR("Your IP isn't in the range of allowed networks");
                    return;
                }
                ++n;
            }
        }
        this.blnLoggedIn = true;
    }

    private void cmd_pass_user(String string) throws IOException {
        int n;
        if (this.usr == null) {
            this.cmdSend_ERR("User not found");
            return;
        }
        if (!this.usr.getPassWord().equals(string)) {
            this.cmdSend_ERR("Password mismatch");
            return;
        }
        if (!this.usr.getEnabled()) {
            this.cmdSend_ERR("Account disabled");
            return;
        }
        DomainRecord domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)this.usr.getUserName()));
        if (domainRecord == null) {
            this.cmdSend_ERR("Domain missing in configuration");
            return;
        }
        if (!domainRecord.getEnable_POP3()) {
            this.cmdSend_ERR("POP3 disabled for domain");
            return;
        }
        IP_Network[] iP_NetworkArray = new IP_Network[]{};
        switch (this.usr.getRestrictIP_POP3()) {
            case 0: {
                break;
            }
            case 1: {
                iP_NetworkArray = domainRecord.getIP_Networks();
                break;
            }
            case 2: {
                iP_NetworkArray = this.usr.getIP_Networks();
                break;
            }
            case 3: {
                iP_NetworkArray = new IP_Network[domainRecord.getIP_Networks().length + this.usr.getIP_Networks().length];
                int n2 = 0;
                n = 0;
                while (n < domainRecord.getIP_Networks().length) {
                    iP_NetworkArray[n2++] = domainRecord.getIP_Networks()[n];
                    ++n;
                }
                n = 0;
                while (n < this.usr.getIP_Networks().length) {
                    iP_NetworkArray[n2++] = this.usr.getIP_Networks()[n];
                    ++n;
                }
                break;
            }
        }
        String string2 = this.lsok.getInetAddress().getHostAddress();
        n = iP_NetworkArray.length == 0 ? 1 : 0;
        int n3 = 0;
        while (n3 < iP_NetworkArray.length) {
            this.scc.logContext.write("M " + string2 + " -> " + iP_NetworkArray[n3]);
            if (iP_NetworkArray[n3].match(string2)) {
                n = 1;
                break;
            }
            ++n3;
        }
        if (n == 0) {
            this.cmdSend_ERR("Your IP isn't in the range of allowed networks");
            return;
        }
        if (!this.mbxLock(this.usr)) {
            this.cmdSend_ERR("You are already logged in. Please try again later");
            return;
        }
        this.usr.setPOP3_IP(this.lsok.getInetAddress().getHostAddress());
        this.usr.setPOP3_Time(TimeFactory.getTime());
        this.smManager.userWrite(this.usr);
        this.scc.logContext.write("D SMTP after POP3 timestamp updated");
        this.cmd_rset("");
        this.blnLoggedIn = true;
    }

    private void cmd_quit(String string) throws IOException {
        int n = 0;
        while (n < this.vecMails.size()) {
            MailHeaderRecord mailHeaderRecord = (MailHeaderRecord)this.vecMails.elementAt(n);
            this.smManager.mailWriteHeader(mailHeaderRecord);
            ++n;
        }
        try {
            this.cmdSend_OK("QUIT");
        }
        catch (Throwable throwable) {}
        this.smManager.commit();
    }

    private void cmd_retr(String string) throws IOException {
        MailHeaderRecord mailHeaderRecord = this.getMailHeaderForNumber(string = Helper.getArg(string).trim());
        if (mailHeaderRecord == null) {
            return;
        }
        this.cmdSend_OK("Message follows");
        this.scc.logContext.write("D Sending message " + mailHeaderRecord.toString());
        this.smManager.mailReadBody(mailHeaderRecord, new POP3OutputWriter(this.lsok.getLineWriter()));
        this.scc.logContext.write("D Message " + mailHeaderRecord.toString() + " sent");
        mailHeaderRecord.setTimeFetched(TimeFactory.getTime());
    }

    private void cmd_rset(String string) throws IOException {
        this.vecMails = this.smManager.mailGetHeadersForUser(this.usr.getUserName());
        long l = 0L;
        int n = 0;
        while (n < this.vecMails.size()) {
            MailHeaderRecord mailHeaderRecord = (MailHeaderRecord)this.vecMails.elementAt(n);
            l += mailHeaderRecord.getMailSize();
            ++n;
        }
        this.cmdSend_OK("Maildrop has " + this.vecMails.size() + " messages (" + l + " octets)");
    }

    private void cmd_stat(String string) throws IOException {
        long l = 0L;
        int n = 0;
        int n2 = 0;
        while (n2 < this.vecMails.size()) {
            MailHeaderRecord mailHeaderRecord = (MailHeaderRecord)this.vecMails.elementAt(n2);
            if (!mailHeaderRecord.getMailDeleted()) {
                ++n;
                l += mailHeaderRecord.getMailSize();
            }
            ++n2;
        }
        this.cmdSend_OK(n + " " + l + " messages/octets");
    }

    private void cmd_top(String string) throws IOException {
        if ((string = Helper.getArg(string)) == null) {
            this.cmdSend_ERR("Argument missing");
        }
        String string2 = Helper.getCmd(string);
        String string3 = Helper.getArg(string);
        if (string3 == null) {
            this.cmdSend_ERR("Argument missing");
            return;
        }
        MailHeaderRecord mailHeaderRecord = this.getMailHeaderForNumber(string2);
        if (mailHeaderRecord == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            this.cmdSend_ERR(String.valueOf(string3) + " is not a valid argument");
            return;
        }
        this.cmdSend_OK("Message follows");
        this.scc.logContext.write("D Sending message " + mailHeaderRecord.toString() + ", first " + n + " lines");
        this.smManager.mailReadBody(mailHeaderRecord, new POP3OutputWriter(this.lsok.getLineWriter(), n));
        this.scc.logContext.write("D Message " + mailHeaderRecord.toString() + ", first " + n + " lines sent");
    }

    private void cmd_uidl(String string) throws IOException {
        if ((string = Helper.getArg(string)) == null) {
            this.cmdSend_OK("");
            int n = 0;
            while (n < this.vecMails.size()) {
                MailHeaderRecord mailHeaderRecord = (MailHeaderRecord)this.vecMails.elementAt(n);
                if (!mailHeaderRecord.getMailDeleted()) {
                    this.cmdSend(n + 1 + " " + mailHeaderRecord.getUID());
                }
                ++n;
            }
            this.cmdSend(".");
        } else {
            MailHeaderRecord mailHeaderRecord = this.getMailHeaderForNumber(string);
            if (mailHeaderRecord != null) {
                this.cmdSend_OK(String.valueOf(string) + " " + mailHeaderRecord.getUID());
            }
        }
    }

    private void cmd_user(String string) throws IOException {
        String string2;
        String string3 = Helper.getArg(string);
        if (string3 == null) {
            this.cmdSend_ERR("Argument missing");
            return;
        }
        string3 = string3.toLowerCase();
        this.scc.logContext.write("# User '" + string3 + "' is coming in");
        int n = string3.indexOf("%");
        int n2 = string3.indexOf("@");
        if (n != -1 && n2 == -1) {
            string3 = string3.replace('%', '@');
        }
        if (string3.startsWith("@")) {
            if (!this.scc.cnf.lic.blnMailHub_Server) {
                this.cmdSend_ERR("Mailhub Server not licenced");
                return;
            }
            string2 = HelperValidate.validateRFC822_Domain((String)string3.substring(1));
            if (string2 != null) {
                this.domHub = this.smManager.domainRead(string2);
                if (this.domHub != null && this.domHub.getMailHub_Role() == 1) {
                    this.cmdSend_OK("Password required for domain " + string2);
                    this.usr = null;
                    return;
                }
            }
        }
        if ((string2 = HelperValidate.validateRFC822_User((String)string3)) == null) {
            this.cmdSend_ERR(String.valueOf(string) + " is syntactically incorrect");
            return;
        }
        this.usr = this.smManager.userRead(string2);
        this.domHub = null;
        this.cmdSend_OK("Password required for user " + string2);
    }

    private void cmd_xren(String string) throws IOException {
        if (!this.usr.getAllowXREN()) {
            this.cmdSend_ERR("Command not allowed for your account");
            return;
        }
        string = Helper.getArg(string).trim();
        String string2 = Helper.getCmd(string).trim();
        String string3 = Helper.getArg(string).trim();
        MailHeaderRecord mailHeaderRecord = this.getMailHeaderForNumber(string2);
        if (mailHeaderRecord == null) {
            return;
        }
        String string4 = HelperValidate.validateRFC822_User((String)string3);
        if (string4 == null) {
            this.cmdSend_ERR("'" + string3 + "' is not a valid e-mail address");
            return;
        }
        string3 = string4;
        if (this.smManager.userRead(string3) == null) {
            this.cmdSend_ERR("'" + string3 + "' is not a user on this system");
            return;
        }
        MailHeaderRecord mailHeaderRecord2 = mailHeaderRecord;
        MailHeaderRecord mailHeaderRecord3 = (MailHeaderRecord)mailHeaderRecord.clone();
        mailHeaderRecord3.setEnvelopeTo_Redirected(string3);
        this.smManager.mailMove(mailHeaderRecord2, mailHeaderRecord3);
        this.cmdSend_OK("Message renamed");
        this.scc.logContext.write("D Message renamed from " + mailHeaderRecord2.getEnvelopeTo_Redirected() + "to " + mailHeaderRecord3.getEnvelopeTo_Redirected());
        mailHeaderRecord.setEnvelopeTo_Redirected(string3);
    }

    public void dispose() {
        this.setThreadName();
        super.dispose();
        if (this.vecMails != null) {
            this.vecMails.removeAllElements();
            this.vecMails = null;
        }
        this.usr = null;
        this.resetThreadName();
    }

    private int getCommand(String string) {
        String string2 = Helper.getCmd(string);
        int n = 0;
        int n2 = 0;
        while (n2 < CMDS.length) {
            String string3 = CMDS[n2];
            if (string3 != null && string3.equals(string2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 7: 
            case 15: {
                return n;
            }
            case 4: 
            case 5: {
                if (this.blnLoggedIn) {
                    return 99;
                }
                return n;
            }
            case 3: 
            case 16: {
                if (!this.blnLoggedIn) {
                    return 99;
                }
                return n;
            }
            case 14: {
                if (this.domHub == null) {
                    return 99;
                }
                return n;
            }
        }
        if (!this.blnLoggedIn || this.domHub != null) {
            return 99;
        }
        return n;
    }

    private MailHeaderRecord getMailHeaderForNumber(String string) throws IOException {
        if (string == null) {
            this.cmdSend_ERR("Numeric argument missing");
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.cmdSend_ERR(String.valueOf(string) + " is not a number");
            return null;
        }
        if (n < 1 || n > this.vecMails.size()) {
            this.cmdSend_ERR("Message " + n + " is out of range");
            return null;
        }
        MailHeaderRecord mailHeaderRecord = (MailHeaderRecord)this.vecMails.elementAt(n - 1);
        if (mailHeaderRecord.getMailDeleted()) {
            this.cmdSend_ERR("Message " + n + " has been marked for deletion");
            return null;
        }
        return mailHeaderRecord;
    }

    private void init() {
        if (CMDS == null) {
            CMDS = new String[20];
            POP3_ServerInstance.CMDS[1] = "help";
            POP3_ServerInstance.CMDS[4] = "user";
            POP3_ServerInstance.CMDS[5] = "pass";
            POP3_ServerInstance.CMDS[2] = "quit";
            POP3_ServerInstance.CMDS[6] = "last";
            POP3_ServerInstance.CMDS[7] = "rset";
            POP3_ServerInstance.CMDS[3] = "noop";
            POP3_ServerInstance.CMDS[8] = "stat";
            POP3_ServerInstance.CMDS[9] = "uidl";
            POP3_ServerInstance.CMDS[10] = "list";
            POP3_ServerInstance.CMDS[11] = "dele";
            POP3_ServerInstance.CMDS[12] = "top";
            POP3_ServerInstance.CMDS[13] = "retr";
            POP3_ServerInstance.CMDS[14] = "mode";
            POP3_ServerInstance.CMDS[15] = "lic";
            POP3_ServerInstance.CMDS[16] = "xren";
            vecActiveUsers = new Vector(this.scc.cnf.intPOP3_Instances);
        }
        this.vecMails = new Vector();
    }

    public boolean kickInstance(Object object) {
        this.lsok = (LineSocket)object;
        this.loNotify.lo_notify();
        return true;
    }

    public boolean mbxLock(UserRecord userRecord) {
        String string = userRecord.getUserName();
        Vector vector = vecActiveUsers;
        synchronized (vector) {
            if (vecActiveUsers.indexOf(string) == -1) {
                vecActiveUsers.addElement(string);
                return true;
            }
            return false;
        }
    }

    public void mbxUnlockLock(UserRecord userRecord) {
        if (userRecord == null) {
            return;
        }
        vecActiveUsers.removeElement(userRecord.getUserName());
    }

    private boolean sendWelcome() throws IOException {
        this.cmdSend_OK(String.valueOf(ZeroToaster.getVersion()) + " greets you !");
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void service() throws IOException {
        this.scc.cnf.statrec.intPOP3_peak = Math.max(this.scc.cnf.statrec.intPOP3_peak, ++POP3_ServerInstance.intInstances);
        this.scc.logContext.write("# " + this.lsok.getInetAddress() + " is coming in");
        this.vecMails.removeAllElements();
        this.blnLoggedIn = false;
        this.usr = null;
        if (this.sendWelcome()) ** GOTO lbl72
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = null;
            try {
                var1_1 = this.cmdReceive();
            }
            catch (InterruptedIOException var2_2) {
                this.cmdSend_ERR("Session timeout");
                throw var2_2;
            }
            switch (this.getCommand(var1_1)) {
                case 0: {
                    this.cmd_notfound(var1_1);
                    break;
                }
                case 99: {
                    this.cmd_illegal(var1_1);
                    break;
                }
                case 1: {
                    this.cmd_help(var1_1);
                    break;
                }
                case 3: {
                    this.cmd_noop(var1_1);
                    break;
                }
                case 7: {
                    this.cmd_rset(var1_1);
                    break;
                }
                case 6: {
                    this.cmd_last(var1_1);
                    break;
                }
                case 4: {
                    this.cmd_user(var1_1);
                    break;
                }
                case 5: {
                    this.cmd_pass(var1_1);
                    break;
                }
                case 8: {
                    this.cmd_stat(var1_1);
                    break;
                }
                case 9: {
                    this.cmd_uidl(var1_1);
                    break;
                }
                case 10: {
                    this.cmd_list(var1_1);
                    break;
                }
                case 11: {
                    this.cmd_dele(var1_1);
                    break;
                }
                case 12: {
                    this.cmd_top(var1_1);
                    break;
                }
                case 13: {
                    this.cmd_retr(var1_1);
                    break;
                }
                case 14: {
                    this.cmd_mode(var1_1);
                    break;
                }
                case 15: {
                    this.cmd_lic(var1_1);
                    break;
                }
                case 16: {
                    this.cmd_xren(var1_1);
                    break;
                }
                case 2: {
                    this.cmd_quit(var1_1);
                    return;
                }
                default: {
                    this.cmdSend_ERR("You did something we never thinked about...");
                }
            }
lbl72:
            // 19 sources

            ** while (this.blnIsRunning)
        }
lbl73:
        // 1 sources

    }

    protected void servicePostProcess() {
        --intInstances;
        ++this.scc.cnf.statrec.lngPOP3_accesses;
        this.scc.cnf.statrec.lngPOP3_bytes += this.lsok.getBytesTotal();
        if (this.usr != null) {
            this.smManager.accountingStore("I", this.usr.getUserName(), this.lsok.getBytesReceived(), this.lsok.getBytesSent());
            this.mbxUnlockLock(this.usr);
        }
    }
}

