/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFilter;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.config.Constants;
import net.zerotoaster.event.ForceFetchmailEvent;
import net.zerotoaster.event.MTAEvent;
import net.zerotoaster.event.MTAEventListener;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.io.SMTPInputReader;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.mta.ZeroToaster;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.FetchmailRecord;
import net.zerotoaster.storage.MailQueueRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.storage.UserRecord;
import net.zerotoaster.util.Helper;
import net.zerotoaster.util.HostIP;
import net.zerotoaster.util.UserAlias;

public class POP3_Fetchmail
extends Thread
implements Constants,
MTAEventListener {
    private LineSocket lsok = null;
    private LockObject objLock = new LockObject();
    private boolean blnIsRunning = false;
    private StorageManager smManager = null;
    private ServerContainerConfig scc = null;
    private Vector vecPolls = null;
    private boolean blnForcePoll = false;

    public POP3_Fetchmail(ServerContainerConfig serverContainerConfig) throws Throwable {
        super("POP3F");
        this.scc = serverContainerConfig;
        this.setName("POP3 Fetchmail");
        this.smManager = Configuration.getStorageManager(serverContainerConfig.logContext);
        MTAEventQueue.addListener(this);
        this.start();
    }

    private String cmdReceive() throws IOException {
        String string = this.lsok.readln();
        if (string == null) {
            throw new IOException("Got NULL from input stream");
        }
        string = string.toLowerCase().trim();
        this.scc.logContext.write("M I:" + string);
        return HelperFilter.filterBackspace((String)string);
    }

    private void cmdSend(String string) throws IOException {
        this.scc.logContext.write("M O:" + string);
        this.lsok.println(string);
        this.lsok.flush();
    }

    private boolean cmdSendVerify(String string) throws IOException {
        this.cmdSend(string);
        if (!this.cmdReceive().startsWith("+")) {
            try {
                this.cmdSend("QUIT");
            }
            catch (Throwable throwable) {}
            this.scc.logContext.write("? Error on command '" + string + "'");
            return false;
        }
        return true;
    }

    public void dispose() {
        this.blnIsRunning = false;
        Helper.close(this.lsok);
        this.objLock.lo_notify();
        this.objLock.dispose();
        this.objLock = null;
        if (this.smManager != null) {
            this.smManager.dispose();
            this.smManager = null;
        }
        MTAEventQueue.removeListener(this);
    }

    public void mtaEvent(MTAEvent mTAEvent) {
        if (mTAEvent instanceof ForceFetchmailEvent) {
            this.blnForcePoll = true;
            this.objLock.lo_notify();
        }
    }

    private void performPoll(FetchmailRecord fetchmailRecord) throws Throwable {
        Object object;
        HostIP[] hostIPArray;
        String string = fetchmailRecord.getHost();
        if (string.length() == 0) {
            hostIPArray = Helper.getMXHosts(HelperExtract.splitUserName_getDomain((String)fetchmailRecord.getUserFrom()), false);
            if (hostIPArray == null) {
                this.scc.logContext.write("? Cannot find a mail host to poll for user " + fetchmailRecord.getUserFrom());
                return;
            }
            string = hostIPArray[0].strHost;
        }
        hostIPArray = HelperExtract.splitIP_getHost((String)string);
        int n = HelperExtract.splitIP_getPort((String)string, (int)110);
        InetAddress inetAddress = null;
        if (!this.scc.cnf.strFetchmail_Host.startsWith("*")) {
            inetAddress = InetAddress.getByName(HelperExtract.splitIP_getHost((String)this.scc.cnf.strFetchmail_Host));
        }
        this.scc.logContext.write("# Connecting to " + (String)hostIPArray);
        try {
            object = new Socket((String)hostIPArray, n, inetAddress, 0);
            ((Socket)object).setSoTimeout(this.scc.cnf.intFetchmail_Socket_Timeout * 1000);
            this.scc.logContext.write("D Connected to " + (String)hostIPArray + ":" + n);
            this.lsok = new LineSocket((Socket)object);
        }
        catch (IOException iOException) {
            this.scc.logContext.write("D " + (String)hostIPArray + ": " + iOException.toString());
            return;
        }
        object = this.cmdReceive();
        if (!((String)object).startsWith("+")) {
            this.scc.logContext.write("? Remote service: " + (String)object);
            return;
        }
        if (!this.cmdSendVerify("USER " + fetchmailRecord.getUserFrom())) {
            return;
        }
        if (!this.cmdSendVerify("PASS " + fetchmailRecord.getPassword())) {
            return;
        }
        this.cmdSend("STAT");
        object = this.cmdReceive();
        object = Helper.getArg((String)object);
        object = Helper.getCmd((String)object);
        int n2 = Integer.parseInt((String)object);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if (!this.cmdSendVerify("RETR " + (n3 + 1))) {
                this.smManager.rollback();
                return;
            }
            long l = TimeFactory.getTime();
            String string2 = TimeFactory.createUID();
            Vector<String> vector = new Vector<String>();
            String string3 = new String(new byte[]{9});
            vector.addElement("Fetched: from " + this.lsok.getInetAddress().getHostName() + " [" + this.lsok.getInetAddress().getHostAddress() + "]");
            vector.addElement(String.valueOf(string3) + "by   " + this.lsok.getLocalAddress().getHostName() + " [" + this.lsok.getLocalAddress().getHostAddress() + "]");
            vector.addElement(String.valueOf(string3) + "MTA  " + ZeroToaster.getVersion());
            vector.addElement(String.valueOf(string3) + "at   " + new Date().toString());
            vector.addElement(String.valueOf(string3) + "id   POP3Fetch-" + string2);
            vector.addElement("X-PLACEHOLDER");
            SMTPInputReader sMTPInputReader = new SMTPInputReader(this.lsok.getLineReader(), vector, this.scc.logContext);
            this.smManager.tempWrite(string2, sMTPInputReader);
            long l2 = sMTPInputReader.getBytes();
            Vector vector2 = Helper.processGroup(fetchmailRecord.getUserTo());
            String string4 = Helper.redirectUser(fetchmailRecord.getUserTo(), this.smManager);
            vector2.addElement(string4);
            UserRecord userRecord = this.smManager.userRead(string4);
            if (userRecord != null) {
                n4 = 0;
                while (n4 < userRecord.getCopy().length) {
                    string4 = userRecord.getCopy()[n4];
                    vector2.addElement(string4);
                    ++n4;
                }
            }
            n4 = 0;
            MailQueueRecord mailQueueRecord = new MailQueueRecord(vector2.size());
            int n5 = 0;
            while (n5 < vector2.size()) {
                string4 = (String)vector2.elementAt(n5);
                DomainRecord domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)string4));
                if (domainRecord == null) {
                    mailQueueRecord.arrMHR[n5].setExternalMail(true);
                } else {
                    n4 |= domainRecord.getAVScan();
                    mailQueueRecord.arrMHR[n5].setExternalMail(false);
                    userRecord = this.smManager.userRead(string4);
                    if (userRecord == null) {
                        fetchmailRecord.setUserTo(domainRecord.getCatchAll());
                    }
                    if (string4.length() == 0) {
                        UserAlias userAlias = new UserAlias(this.scc.cnf.strAliases);
                        string4 = userAlias.resolve("postmaster")[0];
                        vector.addElement("X-ZeroToaster-Info:  Fetchmail target address not configured");
                    }
                }
                this.scc.logContext.write("# Created mail for " + string4 + (mailQueueRecord.arrMHR[n5].getExternalMail() ? " (extern)" : " (intern)"));
                mailQueueRecord.arrMHR[n5].setEnvelopeFrom_Orginal(fetchmailRecord.getUserFrom());
                mailQueueRecord.arrMHR[n5].setEnvelopeFrom_Redirected(fetchmailRecord.getUserFrom());
                if (mailQueueRecord.arrMHR[n5].getExternalMail()) {
                    mailQueueRecord.arrMHR[n5].setEnvelopeFrom_Redirected(fetchmailRecord.getUserTo());
                }
                mailQueueRecord.arrMHR[n5].setEnvelopeTo_Orginal(fetchmailRecord.getUserTo());
                mailQueueRecord.arrMHR[n5].setEnvelopeTo_Redirected(string4);
                mailQueueRecord.arrMHR[n5].setMailSize(l2);
                mailQueueRecord.arrMHR[n5].setTimeReceived(l);
                mailQueueRecord.arrMHR[n5].setTimeNextRetry(l);
                mailQueueRecord.arrMHR[n5].setTimeFetched(0L);
                mailQueueRecord.arrMHR[n5].setRetryCount(0);
                mailQueueRecord.arrMHR[n5].setMailDeleted(false);
                mailQueueRecord.arrMHR[n5].setUID(TimeFactory.createUID());
                mailQueueRecord.arrMHR[n5].setAccounting(string4);
                mailQueueRecord.arrMHR[n5].setIsRelayMail(false);
                mailQueueRecord.arrMHR[n5].setIsHubMail(false);
                this.smManager.accountingStore("F", string4, this.lsok.getBytesReceived(), this.lsok.getBytesSent());
                ++n5;
            }
            this.cmdSendVerify("DELE " + (n3 + 1));
            this.smManager.commit();
            mailQueueRecord.strUID_Queue = string2;
            mailQueueRecord.strUID_Temp = string2;
            mailQueueRecord.blnAVScan = n4;
            this.smManager.mailProcessQueueAdd(mailQueueRecord);
            ++n3;
        }
        this.cmdSend("QUIT");
        this.scc.logContext.write("# Finished " + (String)hostIPArray);
    }

    public void run() {
        this.blnIsRunning = true;
        this.vecPolls = new Vector();
        while (this.blnIsRunning) {
            Object object;
            long l = TimeFactory.getTime();
            int n = 0;
            while (n < this.vecPolls.size()) {
                ((PollRecord)this.vecPolls.elementAt((int)n)).blnTouched = false;
                ++n;
            }
            this.scc.logContext.write("D Re-read configuration");
            Vector vector = this.smManager.keyDataReadAll("FETCHMAIL_RECORD", "");
            int n2 = 0;
            while (n2 < vector.size()) {
                object = this.smManager.keyDataRead("FETCHMAIL_RECORD", (String)vector.elementAt(n2), "");
                FetchmailRecord fetchmailRecord = new FetchmailRecord();
                fetchmailRecord.recordImport((String)object);
                boolean bl = false;
                int n3 = 0;
                while (n3 < this.vecPolls.size()) {
                    PollRecord pollRecord = (PollRecord)this.vecPolls.elementAt(n3);
                    if (pollRecord.fm.equals(fetchmailRecord)) {
                        this.scc.logContext.write("D Found record " + pollRecord.fm.toString());
                        pollRecord.lngInterval = (long)fetchmailRecord.getPollFrequency() * 1000L;
                        pollRecord.blnTouched = true;
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl && fetchmailRecord.getPollFrequency() > 0) {
                    this.scc.logContext.write("# Adding record " + fetchmailRecord.toString());
                    PollRecord pollRecord = new PollRecord(this);
                    pollRecord.fm = fetchmailRecord;
                    pollRecord.lngInterval = (long)fetchmailRecord.getPollFrequency() * 1000L;
                    pollRecord.lngLastPoll = 0L;
                    pollRecord.blnTouched = true;
                    this.vecPolls.addElement(pollRecord);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.vecPolls.size()) {
                object = (PollRecord)this.vecPolls.elementAt(n2);
                if (!((PollRecord)object).blnTouched) {
                    this.scc.logContext.write("# Removing record " + ((PollRecord)object).fm.toString());
                    this.vecPolls.removeElementAt(n2);
                    --n2;
                } else if (this.blnForcePoll) {
                    ((PollRecord)object).lngLastPoll = 0L;
                }
                ++n2;
            }
            this.blnForcePoll = false;
            n2 = 0;
            while (n2 < this.vecPolls.size()) {
                object = (PollRecord)this.vecPolls.elementAt(n2);
                if (((PollRecord)object).lngLastPoll + ((PollRecord)object).lngInterval < l) {
                    try {
                        this.performPoll(((PollRecord)object).fm);
                    }
                    catch (Throwable throwable) {
                        this.scc.logContext.write("? Exception while processing " + ((PollRecord)object).fm.getUserFrom(), throwable);
                    }
                    Helper.close(this.lsok);
                    this.lsok = null;
                    ((PollRecord)object).lngLastPoll = TimeFactory.getTime();
                }
                ++n2;
            }
            this.objLock.lo_wait((long)this.scc.cnf.intFetchmail_JobRescan * 1000L);
        }
    }

    class PollRecord {
        /* synthetic */ POP3_Fetchmail this$0;
        FetchmailRecord fm = null;
        long lngInterval = 0L;
        long lngLastPoll = 0L;
        boolean blnTouched = false;

        PollRecord(POP3_Fetchmail pOP3_Fetchmail) {
            this.this$0 = pOP3_Fetchmail;
        }
    }
}

