/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.event.KickForwarder;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.mta.ZeroToaster;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.storage.UserRecord;
import net.zerotoaster.util.UserAlias;

public class Mail {
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 1;
    public static final int PRIORITY_LOW = 0;
    private StorageManager smManager = null;
    private Configuration cnf = null;
    private LogContext logContext = null;
    private String strMailFrom_Name = "";
    private String strMailFrom_EMail = "<>";
    private String strMailTo_Name = "";
    private Vector vecMailTo_EMail = new Vector();
    private String strSubject = "(No Subject)";
    private String strContent = "(no mail)";
    private int intPriority = 1;
    private boolean blnIsBounce = false;

    private Mail() {
    }

    public Mail(LogContext logContext, Configuration configuration, StorageManager storageManager) {
        this.smManager = storageManager;
        this.cnf = configuration;
        this.logContext = logContext;
    }

    public void setContent(String string) {
        int n;
        this.strContent = string;
        while ((n = this.strContent.indexOf("\r\n.\r\n")) > 0) {
            this.strContent = String.valueOf(this.strContent.substring(0, n + 3)) + "." + this.strContent.substring(n + 4);
        }
    }

    public void setIsBounce(boolean bl) {
        this.blnIsBounce = bl;
    }

    public void setMailFrom_EMail(String string) {
        this.strMailFrom_EMail = string;
    }

    public void setMailFrom_Name(String string) {
        this.strMailFrom_Name = string;
    }

    public void setMailTo_EMail(String string) {
        UserAlias userAlias = new UserAlias(this.cnf.strAliases, this.logContext);
        String[] stringArray = userAlias.resolve(string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            UserRecord userRecord = this.smManager.userRead(string);
            int n2 = 0;
            while (n2 < 5) {
                if (userRecord != null && userRecord.getRedirect().length() != 0) {
                    string2 = userRecord.getRedirect();
                    userRecord = this.smManager.userRead(string2);
                }
                ++n2;
            }
            this.vecMailTo_EMail.addElement(string2);
            ++n;
        }
    }

    public void setMailTo_Name(String string) {
        this.strMailTo_Name = string;
    }

    public void setPriority(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.intPriority = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Priority out of range (" + n + ")");
            }
        }
    }

    public void setSubject(String string) {
        this.strSubject = string;
    }

    public boolean store() {
        long l = TimeFactory.getTime();
        String string = TimeFactory.createUID();
        if (this.vecMailTo_EMail.size() == 0) {
            this.logContext.write("? 'Mail' no users to send to ");
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.strMailFrom_Name.length() == 0) {
            stringBuffer.append("From: <" + this.strMailFrom_EMail + ">\r\n");
        } else {
            stringBuffer.append("From: \"" + this.strMailFrom_Name + "\" <" + this.strMailFrom_EMail + ">\r\n");
        }
        if (this.strMailTo_Name.length() == 0) {
            stringBuffer.append("To: <" + (String)this.vecMailTo_EMail.elementAt(0) + ">\r\n");
        } else {
            stringBuffer.append("To: \"" + this.strMailTo_Name + "\" <" + (String)this.vecMailTo_EMail.elementAt(0) + ">\r\n");
        }
        stringBuffer.append("Subject: " + this.strSubject + "\r\n");
        stringBuffer.append("Date: " + new Date(l).toString());
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(DateFormat.getTimeInstance().format(new Date(l))) + "\r\n");
        switch (this.intPriority) {
            case 2: {
                stringBuffer.append("Priority: High\r\n");
                break;
            }
            case 1: {
                stringBuffer.append("Priority: Normal\r\n");
                break;
            }
            case 0: {
                stringBuffer.append("Priority: Low\r\n");
            }
        }
        stringBuffer.append("Message-ID: <" + string + "@" + HelperExtract.splitIP_getHost((String)this.cnf.strFWD_Host) + ">\r\n");
        stringBuffer.append("X-Mailer: " + ZeroToaster.getVersion() + "\r\n");
        stringBuffer.append("MIME-Version: 1.0\r\n");
        stringBuffer.append("Content-Type: text/plain; charset=\"iso-8859-1\"\r\n");
        stringBuffer.append("Content-Transfer-Encoding: 8bit\r\n");
        stringBuffer.append("\r\n");
        stringBuffer.append(this.strContent);
        stringBuffer.append("\r\n.\r\n");
        int n = 0;
        while (n < this.vecMailTo_EMail.size()) {
            String string2 = (String)this.vecMailTo_EMail.elementAt(n);
            MailHeaderRecord mailHeaderRecord = new MailHeaderRecord();
            mailHeaderRecord.setUID(TimeFactory.createUID());
            mailHeaderRecord.setEnvelopeFrom_Orginal(this.strMailFrom_EMail);
            mailHeaderRecord.setEnvelopeFrom_Redirected(this.strMailFrom_EMail);
            mailHeaderRecord.setEnvelopeTo_Orginal(string2);
            mailHeaderRecord.setEnvelopeTo_Redirected(string2);
            mailHeaderRecord.setMailSize(stringBuffer.length());
            mailHeaderRecord.setTimeReceived(l);
            mailHeaderRecord.setTimeNextRetry(l);
            mailHeaderRecord.setRetryCount(0);
            mailHeaderRecord.setMailDeleted(false);
            mailHeaderRecord.setIsBounce(this.blnIsBounce);
            DomainRecord domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)string2));
            if (domainRecord == null) {
                mailHeaderRecord.setExternalMail(true);
            } else {
                mailHeaderRecord.setExternalMail(false);
            }
            this.smManager.mailWriteFromString(mailHeaderRecord, stringBuffer.toString());
            this.smManager.mailWriteHeader(mailHeaderRecord);
            this.smManager.commit();
            this.logContext.write("# Mail: Stored.");
            if (mailHeaderRecord.getExternalMail()) {
                MTAEventQueue.postEvent(new KickForwarder());
            }
            ++n;
        }
        return true;
    }
}

