/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.config.Constants;
import net.zerotoaster.io.LineReader;
import net.zerotoaster.io.LineWriter;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.MailQueueRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.util.Helper;
import net.zerotoaster.util.UserAlias;

public class ML_Import
extends Thread
implements Constants {
    private LockObject objLock = new LockObject();
    private boolean blnIsRunning = false;
    private StorageManager smManager = null;
    private ServerContainerConfig scc = null;

    public ML_Import(ServerContainerConfig serverContainerConfig) throws Throwable {
        super("MAILIMP");
        this.scc = serverContainerConfig;
        this.setName("MailImport");
        this.smManager = Configuration.getStorageManager(serverContainerConfig.logContext);
        this.start();
    }

    public void dispose() {
        this.blnIsRunning = false;
        this.objLock.lo_notify();
        this.objLock.dispose();
        this.objLock = null;
        if (this.smManager != null) {
            this.smManager.dispose();
            this.smManager = null;
        }
    }

    private boolean import_mail(File file) {
        int n;
        Object object;
        String string;
        Object object2;
        Vector<String> vector;
        LineReader lineReader = null;
        try {
            lineReader = new LineReader(new FileInputStream(file));
        }
        catch (IOException iOException) {
            this.scc.logContext.write("? Cannot open importmail " + file + ": " + iOException.getMessage());
            Helper.close(lineReader);
            return false;
        }
        String string2 = TimeFactory.createUID();
        LineWriter lineWriter = this.smManager.tempWrite(string2);
        boolean bl = false;
        boolean bl2 = true;
        String string3 = "";
        Object object3 = new Vector<String>();
        String string4 = null;
        Object var10_11 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        while (true) {
            try {
                String[] stringArray;
                int n2;
                string4 = lineReader.readLine();
                if (string4 == null || string4.equals(".")) {
                    lineWriter.println(".");
                    break;
                }
                if (!bl2) {
                    lineWriter.println(string4);
                    continue;
                }
                if (string4.length() == 0 && bl2) {
                    bl2 = false;
                    lineWriter.println("");
                    continue;
                }
                if (string4.charAt(0) == ' ' || string4.charAt(0) == '\t' && var10_11 != null) {
                    string4 = String.valueOf(var10_11) + " " + string4.trim();
                }
                if ((n2 = string4.indexOf(":")) == -1) continue;
                vector = string4.substring(0, n2 + 1).trim().toLowerCase();
                object2 = string4.substring(n2 + 1).trim();
                if (((String)((Object)vector)).equals("snd-recipients:")) {
                    stringArray = new StringTokenizer((String)object2, " ");
                    while (stringArray.hasMoreTokens()) {
                        string = stringArray.nextToken();
                        ((Vector)object3).addElement(Helper.getSMTPUser(string));
                        this.scc.logContext.write("# Added snd-recipient '" + string + "'");
                    }
                    bl3 = true;
                    continue;
                }
                if (((String)((Object)vector)).equals("snd-sender:")) {
                    string3 = Helper.getSMTPUser((String)object2);
                    bl4 = true;
                    continue;
                }
                if (((String)((Object)vector)).equals("snd-readheader:")) continue;
                if (!bl3 && (((String)((Object)vector)).equals("to:") || ((String)((Object)vector)).equals("cc:") || ((String)((Object)vector)).equals("bcc:") || ((String)((Object)vector)).equals("x-envelope-to:") || ((String)((Object)vector)).equals("x-delivered-to:"))) {
                    stringArray = HelperExtract.getRFC822_Recipients((String)object2);
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        ((Vector)object3).addElement(stringArray[n3]);
                        this.scc.logContext.write("# Added " + vector + "-recipient '" + stringArray[n3] + "'");
                        ++n3;
                    }
                    if (((String)((Object)vector)).equals("bcc:")) continue;
                }
                if (!bl4 && (((String)((Object)vector)).equals("from") || ((String)((Object)vector)).equals("x-envelope-from"))) {
                    string3 = Helper.getSMTPUser((String)object2);
                }
                lineWriter.println(string4);
            }
            catch (IOException iOException) {
                bl = true;
                this.scc.logContext.write("? Error during import of " + file + ": " + iOException.getMessage());
                break;
            }
        }
        if (((Vector)object3).size() == 0) {
            this.scc.logContext.write("? " + file + " does not contain any valid recipient");
            bl = true;
        }
        Helper.close(lineReader);
        Helper.close(lineWriter);
        if (bl) {
            this.smManager.tempDelete(string2);
            return false;
        }
        this.scc.logContext.write("D Have " + ((Vector)object3).size() + " recipients before aliasing");
        int n4 = (int)((double)((Vector)object3).size() * 1.5);
        vector = new Vector(n4);
        object2 = new UserAlias(this.scc.cnf.strAliases, this.scc.logContext);
        int n5 = 0;
        while (n5 < ((Vector)object3).size()) {
            string = (String)((Vector)object3).elementAt(n5);
            object = ((UserAlias)object2).resolve(string);
            n = 0;
            while (n < ((String[])object).length) {
                vector.addElement(object[n]);
                ++n;
            }
            ++n5;
        }
        this.scc.logContext.write("D Have " + vector.size() + " recipients after aliasing");
        object3 = vector;
        vector = null;
        vector = new Vector<String>(((Vector)object3).size());
        n5 = 0;
        while (n5 < ((Vector)object3).size()) {
            string = (String)((Vector)object3).elementAt(n5);
            if (!string.equals(object = Helper.redirectUser(string, this.smManager))) {
                this.scc.logContext.write("# Redirected " + string + " -> " + (String)object);
            }
            ++n5;
        }
        long l = TimeFactory.getTime();
        object = new MailQueueRecord(((Vector)object3).size());
        object.blnAVScan = false;
        object.strUID_Queue = string2;
        object.strUID_Temp = string2;
        n = 0;
        while (n < ((Vector)object3).size()) {
            String string5 = (String)((Vector)object3).elementAt(n);
            object.arrMHR[n].setEnvelopeFrom_Redirected(string3);
            object.arrMHR[n].setEnvelopeFrom_Orginal(string3);
            object.arrMHR[n].setEnvelopeTo_Redirected(string5);
            object.arrMHR[n].setEnvelopeTo_Orginal(string5);
            object.arrMHR[n].setMailSize(lineWriter.getBytes());
            object.arrMHR[n].setTimeReceived(l);
            object.arrMHR[n].setTimeNextRetry(l);
            object.arrMHR[n].setTimeFetched(0L);
            object.arrMHR[n].setRetryCount(0);
            object.arrMHR[n].setMailDeleted(false);
            object.arrMHR[n].setUID(TimeFactory.createUID());
            object.arrMHR[n].setAccounting(string3);
            object.arrMHR[n].setHELO("");
            DomainRecord domainRecord = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)string5));
            this.smManager.userRead(string5);
            if (domainRecord == null) {
                object.arrMHR[n].setExternalMail(true);
                object.arrMHR[n].setIsRelayMail(false);
            } else {
                object.arrMHR[n].setExternalMail(domainRecord == null);
                object.arrMHR[n].setIsRelayMail(false);
                object.arrMHR[n].setIsHubMail(false);
            }
            this.scc.logContext.write("# Created " + object.arrMHR[n]);
            ++n;
        }
        this.smManager.mailProcessQueueAdd((MailQueueRecord)object);
        this.smManager.commit();
        this.scc.logContext.write("# Mail imported.");
        return true;
    }

    public void run() {
        String string;
        File file;
        long l = (long)this.scc.cnf.intMailImportRescan * 1000L;
        if (l <= 0L) {
            l = 2000L;
        }
        if (!(file = new File(string = Helper.platformPath(this.scc.cnf.strMailImportPath))).exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            this.scc.logContext.write("? Cannot create or access mail import directory [" + file.getPath() + "]");
            return;
        }
        this.blnIsRunning = true;
        block0: while (this.blnIsRunning) {
            this.objLock.lo_wait(l);
            if (!this.blnIsRunning) break;
            String[] stringArray = file.list();
            if (stringArray.length == 0) continue;
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (file2.exists() && file2.length() != 0L) {
                    this.import_mail(file2);
                    file2.delete();
                    if (file2.exists()) {
                        this.scc.logContext.write("? Imported mail was not deleted, stopping import thread");
                        this.blnIsRunning = false;
                        continue block0;
                    }
                }
                ++n;
            }
        }
        this.scc.logContext.write("# Import thread was shut down");
    }
}

