/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFilter;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.event.KickSMTP_MailHub;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.util.Helper;
import net.zerotoaster.util.HostIP;

public class MHUB_Client
extends Thread {
    private LineSocket lsok = null;
    private LockObject objLock = new LockObject();
    private boolean blnIsRunning = false;
    private StorageManager smManager = null;
    private ServerContainerConfig scc = null;

    public MHUB_Client(ServerContainerConfig serverContainerConfig) throws Throwable {
        super("MHUB");
        this.scc = serverContainerConfig;
        this.setName("MHUB-Server");
        this.smManager = Configuration.getStorageManager(serverContainerConfig.logContext);
        this.start();
    }

    private String cmdReceive() throws IOException {
        String string = this.lsok.readln();
        if (string == null) {
            throw new IOException("Got NULL from input stream");
        }
        string = string.toLowerCase().trim();
        this.scc.logContext.write("M I:" + string);
        return HelperFilter.filterBackspace((String)string);
    }

    private boolean cmdSend(String string) throws IOException {
        this.scc.logContext.write("M O:" + string);
        this.lsok.println(string);
        this.lsok.flush();
        return this.cmdReceive().startsWith("+");
    }

    public void dispose() {
        this.blnIsRunning = false;
        Helper.close(this.lsok);
        this.objLock.lo_notify();
        this.objLock.dispose();
        this.objLock = null;
        if (this.smManager != null) {
            this.smManager.dispose();
            this.smManager = null;
        }
    }

    private void initiatePoll(String string) throws Throwable {
        HostIP[] hostIPArray;
        DomainRecord domainRecord = this.smManager.domainRead(string);
        if (domainRecord == null) {
            this.scc.logContext.write("? Domain not found: " + string);
            return;
        }
        String string2 = domainRecord.getMailHub_PollHost();
        if (string2.length() == 0) {
            hostIPArray = Helper.getMXHosts(string, false);
            if (hostIPArray == null) {
                this.scc.logContext.write("? Cannot find a mail hub to poll for domain " + string);
                return;
            }
            string2 = hostIPArray[0].strHost;
        }
        hostIPArray = HelperExtract.splitIP_getHost((String)string2);
        int n = HelperExtract.splitIP_getPort((String)string2, (int)110);
        InetAddress inetAddress = null;
        if (!this.scc.cnf.strMHUB_Host.startsWith("*")) {
            inetAddress = InetAddress.getByName(HelperExtract.splitIP_getHost((String)this.scc.cnf.strMHUB_Host));
        }
        this.scc.logContext.write("# Connecting to " + (String)hostIPArray);
        try {
            Socket socket = new Socket((String)hostIPArray, n, inetAddress, 0);
            socket.setSoTimeout(this.scc.cnf.intMHUB_Socket_Timeout * 1000);
            this.scc.logContext.write("D Connected to " + (String)hostIPArray + ":" + n);
            this.lsok = new LineSocket(socket);
        }
        catch (IOException iOException) {
            this.scc.logContext.write("D " + (String)hostIPArray + ": " + iOException.toString());
            return;
        }
        if (!this.cmdSend("USER @" + domainRecord.getDomainName())) {
            this.cmdSend("QUIT");
            this.scc.logContext.write("? Error on command USER (" + string + ")");
            return;
        }
        if (!this.cmdSend("PASS " + domainRecord.getMailHub_Password())) {
            this.cmdSend("QUIT");
            this.scc.logContext.write("? Error on command PASS (" + string + ")");
            return;
        }
        boolean bl = true;
        switch (domainRecord.getMailHub_SocketUsage()) {
            case 0: {
                if (!this.cmdSend("MODE PASSIVE")) break;
                this.scc.logContext.write("# Retrieving in passive mode");
                bl = false;
                break;
            }
            case 1: {
                if (!this.cmdSend("MODE ACTIVE :" + domainRecord.getMailHub_CallBackPort())) break;
                this.scc.logContext.write("# Retrieving in active mode, port: " + domainRecord.getMailHub_CallBackPort());
                bl = true;
                break;
            }
            case 2: {
                if (!this.cmdSend("MODE PASSIVE " + domainRecord.getMailHub_CallBackHost())) break;
                this.scc.logContext.write("# Retrieving in active mode, host: " + domainRecord.getMailHub_CallBackHost());
                bl = true;
            }
        }
        this.cmdSend("QUIT");
        this.scc.logContext.write("# Finished " + (String)hostIPArray);
        if (!bl) {
            MTAEventQueue.postEvent(new KickSMTP_MailHub(domainRecord.getDomainName(), this.lsok));
        } else {
            Helper.close(this.lsok);
            this.lsok = null;
        }
    }

    public void run() {
        this.blnIsRunning = true;
        Vector<PollRecord> vector = new Vector<PollRecord>();
        while (this.blnIsRunning) {
            Object object;
            long l = TimeFactory.getTime();
            this.scc.logContext.write("D Re-read configuration");
            Vector vector2 = this.smManager.domainReadAll();
            int n = 0;
            while (n < vector2.size()) {
                object = this.smManager.domainRead((String)vector2.elementAt(n));
                if (((DomainRecord)object).getMailHub_Role() == 2) {
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        PollRecord pollRecord = (PollRecord)vector.elementAt(n2);
                        DomainRecord domainRecord = pollRecord.dr;
                        boolean bl2 = true;
                        bl2 &= domainRecord.getMailHub_CallBackHost().equals(((DomainRecord)object).getMailHub_CallBackHost());
                        bl2 &= domainRecord.getMailHub_CallBackPort() == ((DomainRecord)object).getMailHub_CallBackPort();
                        bl2 &= domainRecord.getMailHub_Password().equals(((DomainRecord)object).getMailHub_Password());
                        bl2 &= domainRecord.getMailHub_PollFrequency() == ((DomainRecord)object).getMailHub_PollFrequency();
                        bl2 &= domainRecord.getMailHub_PollHost().equals(((DomainRecord)object).getMailHub_PollHost());
                        bl2 &= domainRecord.getMailHub_Role() == ((DomainRecord)object).getMailHub_Role();
                        if (bl2 &= domainRecord.getMailHub_SocketUsage() == ((DomainRecord)object).getMailHub_SocketUsage()) {
                            pollRecord.blnTouched = true;
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl && ((DomainRecord)object).getMailHub_PollFrequency() > 0) {
                        PollRecord pollRecord = new PollRecord(this);
                        pollRecord.dr = object;
                        pollRecord.lngInterval = (long)((DomainRecord)object).getMailHub_PollFrequency() * 1000L;
                        pollRecord.lngLastPoll = 0L;
                        vector.addElement(pollRecord);
                        this.scc.logContext.write("# Adding/changing mailhub " + pollRecord.dr.getDomainName() + " in poll list");
                    }
                }
                ++n;
            }
            n = 0;
            while (n < vector.size()) {
                object = (PollRecord)vector.elementAt(n);
                ((PollRecord)object).blnTouched = false;
                if (false) {
                    this.scc.logContext.write("# Deleting mailhub " + ((PollRecord)object).dr.getDomainName() + " from poll list");
                    vector.removeElementAt(n);
                    --n;
                }
                ++n;
            }
            this.scc.logContext.write("D Re-read done");
            this.scc.logContext.write("D Scanning queue");
            n = 0;
            while (n < vector.size()) {
                object = (PollRecord)vector.elementAt(n);
                if (((PollRecord)object).lngLastPoll + ((PollRecord)object).lngInterval < l) {
                    try {
                        this.initiatePoll(((PollRecord)object).dr.getDomainName());
                    }
                    catch (Throwable throwable) {
                        this.scc.logContext.write("? While processing " + ((PollRecord)object).dr.getDomainName(), throwable);
                    }
                    ((PollRecord)object).lngLastPoll = l;
                }
                ++n;
            }
            this.objLock.lo_wait((long)this.scc.cnf.intMHUB_JobRescan * 1000L);
        }
    }

    class PollRecord {
        /* synthetic */ MHUB_Client this$0;
        DomainRecord dr = null;
        long lngInterval = 0L;
        long lngLastPoll = 0L;
        boolean blnTouched = false;

        PollRecord(MHUB_Client mHUB_Client) {
            this.this$0 = mHUB_Client;
        }
    }
}

