/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import net.zerotoaster.event.KickFWD_MailHub;
import net.zerotoaster.io.FWDOutputWriter;
import net.zerotoaster.io.LineReader;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.mta.Mail;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.mta.ServerSocketInstance;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.util.Helper;
import net.zerotoaster.util.HostIP;

public class FWD_ServerInstance
extends ServerSocketInstance {
    private static final int ERR_NONE = -1;
    private static final int ERR_NO_MX_FOUND = 1;
    private static final int ERR_CANNOT_CONNECT_TO_MX = 2;
    private static final int ERR_DATA_ERROR = 3;
    private static final int ERR_USER_REJECTED = 4;
    private static final int ERR_IO_EXCEPTION = 5;
    private int intLastError = -1;
    private boolean blnRetryableError = false;
    private MailHeaderRecord mhr = null;
    private HostIP[] hipMX_Hosts = new HostIP[0];
    private String strLastCommand = "";
    private String strLastResponse = "";
    private KickFWD_MailHub mailHubKicker;
    private static int intInstances;

    public FWD_ServerInstance(String string, ServerContainerConfig serverContainerConfig) {
        super(string, serverContainerConfig);
        this.setThreadName(string);
        this.kickThread();
        this.resetThreadName();
    }

    private boolean analyzeResponse(String string) {
        switch (string.charAt(0)) {
            case '2': 
            case '3': {
                return true;
            }
            case '4': {
                this.intLastError = 3;
                this.blnRetryableError = true;
                return false;
            }
            case '5': {
                this.intLastError = 3;
                this.blnRetryableError = false;
                return false;
            }
        }
        return false;
    }

    protected String cmdReceive() throws IOException {
        if (!this.blnIsRunning) {
            return "";
        }
        do {
            this.strLastResponse = super.cmdReceive();
            this.strLastResponse = String.valueOf(this.strLastResponse) + "    ";
        } while (this.strLastResponse.substring(3, 4).equals("-"));
        return this.strLastResponse;
    }

    protected boolean cmdSend(String string) throws IOException {
        this.strLastCommand = string;
        if (!this.blnIsRunning) {
            return false;
        }
        super.cmdSend(string);
        this.strLastResponse = this.cmdReceive();
        return this.analyzeResponse(this.strLastResponse);
    }

    public void dispose() {
        this.setThreadName();
        super.dispose();
        this.mhr = null;
        this.hipMX_Hosts = null;
        this.strLastCommand = null;
        this.strLastResponse = null;
        this.resetThreadName();
    }

    private LineSocket getMXConnection(String string, boolean bl) throws Throwable {
        Object object;
        int n;
        Object object2;
        if (this.mailHubKicker != null) {
            if (this.mailHubKicker.getSocket() != null) {
                return this.mailHubKicker.getSocket();
            }
            try {
                this.scc.logContext.write("D Connecting to " + this.mailHubKicker.getIP());
                Socket socket = new Socket(HelperExtract.splitIP_getHost((String)this.mailHubKicker.getIP()), HelperExtract.splitIP_getPort((String)this.mailHubKicker.getIP(), (int)25));
                this.scc.logContext.write("D Connected " + this.mailHubKicker.getIP());
                return new LineSocket(socket);
            }
            catch (Throwable throwable) {
                this.scc.logContext.write("D " + this.mailHubKicker.getIP() + ": " + throwable.toString());
                this.intLastError = 2;
                this.blnRetryableError = true;
                return null;
            }
        }
        if (this.scc.cnf.strNameServer.length() == 0) {
            object2 = InetAddress.getByName(string);
            this.hipMX_Hosts = new HostIP[0];
            this.hipMX_Hosts[0].strHost = ((InetAddress)object2).getHostName();
            this.hipMX_Hosts[0].strIP = ((InetAddress)object2).getHostAddress();
        } else {
            this.hipMX_Hosts = Helper.getMXHosts(string, false);
        }
        if (this.hipMX_Hosts != null && this.scc.cnf.ipnFWD_NoDelivery.length > 0) {
            object2 = new Vector(this.hipMX_Hosts.length);
            n = 0;
            while (n < this.hipMX_Hosts.length) {
                object = this.hipMX_Hosts[n].strIP;
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < this.scc.cnf.ipnFWD_NoDelivery.length) {
                    if (this.scc.cnf.ipnFWD_NoDelivery[n2].match((String)object)) {
                        bl2 = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl2) {
                    ((Vector)object2).addElement(this.hipMX_Hosts[n]);
                } else {
                    this.scc.logContext.write("D MX Host " + this.hipMX_Hosts[n].toString() + " found in fwd_no_delivery, ignored");
                }
                ++n;
            }
            this.hipMX_Hosts = new HostIP[((Vector)object2).size()];
            ((Vector)object2).copyInto(this.hipMX_Hosts);
        }
        if (this.hipMX_Hosts == null || this.hipMX_Hosts.length == 0) {
            this.intLastError = 1;
            this.blnRetryableError = false;
            return null;
        }
        if (bl) {
            object2 = this.hipMX_Hosts[0];
            this.hipMX_Hosts = new HostIP[]{object2};
        }
        object2 = null;
        if (!this.scc.cnf.strFWD_Host.startsWith("*")) {
            object2 = InetAddress.getByName(HelperExtract.splitIP_getHost((String)this.scc.cnf.strFWD_Host));
        }
        n = 0;
        while (n < this.hipMX_Hosts.length) {
            this.scc.logContext.write("D Connecting to " + this.hipMX_Hosts[n]);
            try {
                object = new Socket(this.hipMX_Hosts[n].strIP, HelperExtract.splitIP_getPort((String)this.scc.cnf.strFWD_Host, (int)25), (InetAddress)object2, 0);
                ((Socket)object).setSoTimeout(this.scc.cnf.intFWD_Socket_Timeout * 1000);
                this.scc.logContext.write("D Connected to " + this.hipMX_Hosts[n]);
                return new LineSocket((Socket)object);
            }
            catch (IOException iOException) {
                this.scc.logContext.write("D " + this.hipMX_Hosts[n] + ": " + iOException.toString());
                ++n;
            }
        }
        this.intLastError = 2;
        this.blnRetryableError = true;
        return null;
    }

    public boolean kickInstance(Object object) {
        this.mhr = (MailHeaderRecord)object;
        this.loNotify.lo_notify();
        return true;
    }

    public boolean kickInstance(Object object, KickFWD_MailHub kickFWD_MailHub) {
        this.mhr = (MailHeaderRecord)object;
        this.mailHubKicker = kickFWD_MailHub;
        this.loNotify.lo_notify();
        return true;
    }

    private void sendNotify(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append("\r\n");
        stringBuffer.append("Original message follows\r\n");
        stringBuffer.append("============================================================\r\n");
        String string3 = null;
        int n = 0;
        boolean bl = false;
        LineReader lineReader = this.smManager.mailReadBody(this.mhr);
        do {
            try {
                string3 = lineReader.readln();
            }
            catch (IOException iOException) {
                break;
            }
            if (string3 == null || string3.equals(".")) break;
            stringBuffer.append("| ");
            stringBuffer.append(string3);
            stringBuffer.append("\r\n");
            if (string3.length() != 0) continue;
            bl = true;
        } while (!bl || string3.length() <= 0 || ++n <= this.scc.cnf.intFWD_BounceIncludeLines);
        Helper.close(lineReader);
        stringBuffer.append("============================================================\r\n");
        string2 = stringBuffer.toString();
        this.scc.logContext.write("# Notify " + this.mhr.getEnvelopeFrom_Redirected());
        Mail mail = new Mail(this.scc.logContext, this.scc.cnf, this.smManager);
        mail.setMailFrom_EMail(this.scc.cnf.strPostmaster_Name);
        mail.setMailFrom_Name(this.scc.cnf.strPostmaster_Name);
        if (this.mhr.getIsRelayMail()) {
            mail.setIsBounce(true);
        }
        mail.setMailTo_EMail(this.mhr.getEnvelopeFrom_Redirected());
        mail.setSubject(string);
        mail.setContent(string2);
        if (mail.store()) {
            this.scc.logContext.write("# Message for " + this.mhr.getEnvelopeFrom_Redirected() + " created.");
        }
    }

    protected void service() throws Throwable {
        this.scc.cnf.statrec.intFWD_peak = Math.max(this.scc.cnf.statrec.intFWD_peak, ++intInstances);
        this.strLastCommand = "";
        this.strLastResponse = "";
        this.intLastError = -1;
        this.hipMX_Hosts = new HostIP[0];
        this.scc.logContext.write("# Processing " + this.mhr.toString());
        this.lsok = this.getMXConnection(HelperExtract.splitUserName_getDomain((String)this.mhr.getEnvelopeTo_Redirected()), this.mhr.getIsRelayMail());
        if (this.lsok == null) {
            return;
        }
        try {
            String string = this.scc.cnf.strFWD_HeloHost;
            if (string.length() == 0) {
                string = this.lsok.getLocalAddress().getHostName();
            }
            if (!this.waitFor("220")) {
                return;
            }
            if (!this.cmdSend("HELO " + string)) {
                return;
            }
            if (!this.strLastResponse.startsWith("250") && !this.waitFor("250")) {
                return;
            }
            String string2 = "";
            if (!this.mhr.getIsBounce()) {
                string2 = this.mhr.getEnvelopeFrom_Redirected();
            }
            if (!this.cmdSend("MAIL FROM:<" + string2 + ">")) {
                this.intLastError = 4;
                return;
            }
            if (!this.cmdSend("RCPT TO:<" + this.mhr.getEnvelopeTo_Redirected() + ">")) {
                this.intLastError = 4;
                return;
            }
            if (!this.cmdSend("DATA")) {
                return;
            }
            this.scc.logContext.write("# Sending mail " + this.mhr.toString() + " (" + this.lsok.getInetAddress() + ")");
            this.smManager.mailReadBody(this.mhr, new FWDOutputWriter(this.lsok.getLineWriter()));
            this.scc.logContext.write("# Mail sent " + this.mhr.toString() + " (" + this.lsok.getInetAddress() + ")");
            if (!this.waitFor("250")) {
                return;
            }
        }
        catch (Throwable throwable) {
            this.intLastError = 5;
            this.blnRetryableError = true;
            this.strLastResponse = throwable.getMessage();
            this.scc.logContext.write("? Send failed after " + Helper.formatMemoryString(this.lsok.getBytesSent()));
            return;
        }
        try {
            this.cmdSend("QUIT");
        }
        catch (Throwable throwable) {}
    }

    protected void servicePostProcess() {
        int n;
        --intInstances;
        ++this.scc.cnf.statrec.lngFWD_accesses;
        if (this.lsok != null) {
            ++this.scc.cnf.statrec.lngFWD_accesses;
            this.scc.cnf.statrec.lngFWD_bytes += this.lsok.getBytesTotal();
            if (this.mhr.getIsRelayMail()) {
                this.smManager.accountingStore("R", this.mhr.getAccounting(), this.lsok.getBytesReceived(), this.lsok.getBytesSent());
            } else {
                this.smManager.accountingStore("I", this.mhr.getAccounting(), this.lsok.getBytesReceived(), this.lsok.getBytesSent());
            }
        }
        this.mhr.setMailLocked(false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Dear " + this.mhr.getEnvelopeFrom_Redirected() + ",\r\n\r\n");
        if (this.intLastError == -1) {
            this.mhr.setMailDeleted(true);
            this.smManager.mailWriteHeader(this.mhr);
            this.smManager.commit();
            if (this.mhr.getRetryCount() > 0 && this.scc.cnf.intFWD_RetryNotify.length > 0 && this.mhr.getRetryCount() > this.scc.cnf.intFWD_RetryNotify[0]) {
                stringBuffer.append("we were able to transfer your mail to " + this.mhr.getEnvelopeTo_Redirected() + " after " + this.mhr.getRetryCount() + " retries.");
                this.sendNotify("Mail delivery success", stringBuffer.toString());
            }
            return;
        }
        String string = "";
        if (this.lsok != null) {
            string = String.valueOf(string) + "While talking to " + this.lsok.getInetAddress().toString() + ":\r\n\r\n";
            string = String.valueOf(string) + "Last command send:\r\n";
            string = String.valueOf(string) + "  \"" + this.strLastCommand + "\"\r\n";
            string = String.valueOf(string) + "Last response got:\r\n";
            string = String.valueOf(string) + "  \"" + this.strLastResponse + "\"\r\n\r\n";
        }
        stringBuffer.append("we cannot transfer your mail to user " + this.mhr.getEnvelopeTo_Redirected() + "\r\n\r\n");
        switch (this.intLastError) {
            case 1: {
                this.scc.logContext.write("? Didn't found any MX/A record for " + this.mhr.getEnvelopeTo_Redirected());
                stringBuffer.append("We didn't found any MX/A Host for user " + this.mhr.getEnvelopeTo_Redirected() + " !\r\n\r\n");
                stringBuffer.append("Please verify the email address and resend the mail.\r\n");
                break;
            }
            case 2: {
                StringBuffer stringBuffer2 = new StringBuffer();
                n = 0;
                while (n < this.hipMX_Hosts.length) {
                    stringBuffer2.append(this.hipMX_Hosts[n]);
                    stringBuffer2.append(",");
                    ++n;
                }
                stringBuffer2.setLength(stringBuffer2.length() - 1);
                this.scc.logContext.write("? Cannot connect to any MX/A record for " + this.mhr.getEnvelopeTo_Redirected());
                this.scc.logContext.write("? Tried " + stringBuffer2.toString());
                stringBuffer.append("We cannot connect to any mailhost for user " + this.mhr.getEnvelopeTo_Redirected() + "\r\n\r\n");
                stringBuffer.append("The system tried this servers:\r\n\r\n");
                n = 0;
                while (n < this.hipMX_Hosts.length) {
                    stringBuffer.append("  " + this.hipMX_Hosts[n] + "\r\n");
                    ++n;
                }
                stringBuffer.append("\r\n");
                break;
            }
            case 3: {
                this.scc.logContext.write("? Error during transfer to " + this.mhr.getEnvelopeTo_Redirected());
                stringBuffer.append(string);
                break;
            }
            case 4: {
                this.scc.logContext.write("? User rejected by remote " + this.mhr.getEnvelopeTo_Redirected());
                string = String.valueOf(string) + "Please verify the email address and resend the mail.\r\n";
                stringBuffer.append(string);
                break;
            }
            case 5: {
                this.scc.logContext.write("? IO Exception " + this.strLastResponse + " sending to " + this.mhr.getEnvelopeTo_Redirected());
                stringBuffer.append(string);
            }
        }
        if (this.mhr.getEnvelopeFrom_Redirected().length() == 0) {
            stringBuffer.append("Message was a bounce, we stop all actions.");
            this.blnRetryableError = false;
            this.mhr.setEnvelopeFrom_Redirected("postmaster");
        }
        if (this.blnRetryableError) {
            this.mhr.setRetryCount(this.mhr.getRetryCount() + 1);
            this.mhr.setTimeNextRetry(TimeFactory.getTime() + 60000L * (long)this.scc.cnf.intFWD_RetryDelay);
            int n2 = this.scc.cnf.intFWD_MaxRetries - this.mhr.getRetryCount();
            if (n2 <= 0) {
                this.scc.logContext.write("? Reached retry limit for " + this.mhr.toString());
                this.blnRetryableError = false;
                stringBuffer.append("We reached the retry limit and declare this mail as undeliverable.\r\n");
            } else {
                stringBuffer.append("We will retry the action every " + this.scc.cnf.intFWD_RetryDelay + " minutes ");
                stringBuffer.append("for another " + n2 + " times.\r\n");
            }
        }
        if (!this.blnRetryableError) {
            this.mhr.setMailDeleted(true);
            this.smManager.mailWriteHeader(this.mhr);
            this.smManager.commit();
            this.sendNotify("Notify of mail delivery failure", stringBuffer.toString());
            return;
        }
        this.smManager.mailWriteHeader(this.mhr);
        this.smManager.commit();
        this.scc.logContext.write("! Retry Nr." + this.mhr.getRetryCount() + " " + this.mhr.toString());
        boolean bl = false;
        n = 0;
        while (n < this.scc.cnf.intFWD_RetryNotify.length) {
            if (this.scc.cnf.intFWD_RetryNotify[n] == this.mhr.getRetryCount()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        this.sendNotify("Notify of mail delivery failure/retry", stringBuffer.toString());
    }

    private boolean waitFor(String string) throws IOException {
        this.strLastCommand = "(waitFor: " + string + ")";
        String string2 = this.cmdReceive();
        if (!this.analyzeResponse(string2)) {
            return false;
        }
        if (!string2.startsWith(string)) {
            this.intLastError = 3;
            return false;
        }
        return true;
    }
}

