/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta;

import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.event.KickFWD_MailHub;
import net.zerotoaster.event.KickForwarder;
import net.zerotoaster.event.MTAEvent;
import net.zerotoaster.event.MTAEventListener;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.mta.FWD_ServerInstance;
import net.zerotoaster.mta.ServerContainer;
import net.zerotoaster.mta.ServerContainerConfig;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.util.Helper;

public class FWD_ServerContainer
extends ServerContainer
implements MTAEventListener {
    private static LockObject objLock = null;
    protected StorageManager smManager = null;
    private KickFWD_MailHub mailHubKicker = null;

    public FWD_ServerContainer(ServerContainerConfig serverContainerConfig) throws Throwable {
        super(serverContainerConfig, "FWD");
        this.setThreadName("FWD-Container");
        this.init();
        this.resetThreadName();
    }

    public void dispose() {
        this.setThreadName();
        this.blnIsRunning = false;
        if (objLock != null) {
            objLock.lo_notify();
            objLock.dispose();
        }
        super.dispose();
        if (this.smManager != null) {
            this.smManager.dispose();
        }
        this.resetThreadName();
    }

    protected boolean init() throws Throwable {
        if (!super.init()) {
            return false;
        }
        MTAEventQueue.addListener(this);
        try {
            int n = 0;
            while (n < this.intInstances) {
                FWD_ServerInstance fWD_ServerInstance = new FWD_ServerInstance(String.valueOf(this.strContainerName) + " " + Helper.buildID(n + 1, this.intInstances), this.scc);
                this.addInstance(fWD_ServerInstance);
                ++n;
            }
        }
        catch (InitializationException initializationException) {
            this.dispose();
            throw new InitializationException();
        }
        catch (Throwable throwable) {
            this.scc.logContext.write("? Unhandled exception during creating instances", throwable);
            this.dispose();
            throw new InitializationException();
        }
        this.smManager = Configuration.getStorageManager(this.scc.logContext);
        this.kickThread();
        this.scc.logContext.write("# Created " + String.valueOf(this.intInstances) + " FWD instances");
        return true;
    }

    public void mtaEvent(MTAEvent mTAEvent) {
        if (mTAEvent instanceof KickForwarder) {
            objLock.lo_notify();
            return;
        }
        if (mTAEvent instanceof KickFWD_MailHub) {
            this.mailHubKicker = (KickFWD_MailHub)mTAEvent;
            objLock.lo_notify();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        FWD_ServerContainer.objLock = new LockObject();
        this.blnIsRunning = true;
        this.loThreadStarted.lo_notify();
        while (this.blnIsRunning) {
            this.scc.logContext.write("D Scanning for outgoing mails");
            var1_1 = null;
            if (this.mailHubKicker == null) {
                var1_1 = this.smManager.mailGetHeadersToSend(this.getFreeInstanceCount(), this.scc.cnf.intFWD_RetryDelay);
                this.scc.logContext.write("# " + var1_1.size() + " mails to forward");
            } else {
                var1_1 = this.smManager.mailGetHeadersForDomain(this.mailHubKicker.getDomain());
                this.scc.logContext.write("# " + var1_1.size() + " hub mails to send");
            }
            var2_2 = false;
            var3_3 = 0;
            while (var3_3 < var1_1.size()) {
                var4_4 = (MailHeaderRecord)var1_1.elementAt(var3_3);
                var5_5 = (FWD_ServerInstance)this.getFreeInstance();
                if (var5_5 == null) {
                    var2_2 = true;
                    break;
                }
                var4_4.setMailLocked(true);
                var4_4.setMailLockedTimestamp(TimeFactory.getTime());
                this.smManager.mailWriteHeader(var4_4);
                this.smManager.commit();
                if (this.mailHubKicker == null) {
                    this.scc.logContext.write("D Kick FWD instance for " + var4_4.toString());
                    var5_5.kickInstance(var4_4);
                } else {
                    this.scc.logContext.write("D Kick FWD/Hub mail instance for " + var4_4.toString());
                    var5_5.kickInstance(var4_4, this.mailHubKicker);
                }
                ++var3_3;
            }
            this.mailHubKicker = null;
            if (var2_2) ** GOTO lbl43
            this.scc.logContext.write("D Waiting " + this.scc.cnf.intFWD_Rescan + " seconds or instance kick");
            FWD_ServerContainer.objLock.lo_wait((long)(this.scc.cnf.intFWD_Rescan * 1000));
            this.scc.logContext.write("D Instance kicked");
            continue;
lbl-1000:
            // 1 sources

            {
                this.scc.logContext.write("D Waiting for a free instance");
                FWD_ServerContainer.objLock.lo_wait(1000L);
lbl43:
                // 2 sources

                ** while (this.getFreeInstanceCount() < this.getInstanceCount() / 2)
            }
lbl44:
            // 1 sources

        }
    }
}

