/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mailfilters.avscan;

import de.zwanzigeins.util.Encoding;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.config.Constants;
import net.zerotoaster.io.LineReader;
import net.zerotoaster.mailfilters.avscan.AVScanExec;
import net.zerotoaster.mailfilters.avscan.AVScanResult;
import net.zerotoaster.util.Helper;

public class AVScan
implements Constants {
    private static final String AV_CONFIGFILE = "avscan.ini";
    private static Properties prpConfig = null;
    boolean blnHadInit = false;
    private LogContext logContext = null;
    private LineReader lrIn = null;
    private Vector vecScanFiles = new Vector(5, 2);
    private String strTempDir = null;
    private OutputStream out = null;
    private static int intExtCnt = 0;
    private AVScanExec avScanExec = null;
    private boolean blnHasInfection = false;
    static Class class$java$util$Properties;
    static Class class$de$zwanzigeins$util$LogContext;

    public AVScan(LogContext logContext) {
        this.logContext = logContext;
        this.init();
    }

    private void cleanup() {
        if (prpConfig.getProperty("avscan_keep").equals("1")) {
            return;
        }
        Helper.close(this.out);
        File file = new File(this.strTempDir);
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            new File(this.strTempDir, stringArray[n]).delete();
            ++n;
        }
        new File(this.strTempDir).delete();
    }

    /*
     * Unable to fully structure code
     */
    private void export() throws IOException {
        var1_1 = null;
        var2_2 = null;
        var3_3 = "";
        var4_4 = null;
        var5_5 = false;
        var6_6 = new Vector<Content>(10);
        var7_7 = null;
        var8_8 = new byte[8192];
        var9_9 = null;
        block0: while (true) {
            var3_3 = var1_1;
            var1_1 = this.lrIn.readln();
            if (var1_1 == null) {
                return;
            }
            var2_2 = var1_1.toLowerCase();
            if (var7_7 != null && var2_2.length() == 0) {
                var5_5 = true;
                var6_6.addElement(var7_7);
                if (var7_7.C_ENCODING.equals("base64")) {
                    var9_9 = new AVScanResult();
                    var9_9.strDir = this.strTempDir;
                    var9_9.strFile_Attachment = var7_7.C_NAME;
                    var9_9.strFile_DOS = this.getTempName();
                    var9_9.strInfection = "not scanned";
                    var9_9.blnInfected = false;
                    this.vecScanFiles.addElement(var9_9);
                    var4_4 = Encoding.createEncodingInstance((String)var7_7.C_ENCODING);
                    if (var4_4 == null) {
                        var9_9.strInfection = "Unsupported encoding: " + var7_7.C_ENCODING;
                        return;
                    }
                    var4_4.startDecode();
                    this.out = new FileOutputStream(new File(var9_9.strDir, var9_9.strFile_DOS));
                }
                var7_7 = null;
                continue;
            }
            if (var7_7 == null && var2_2.startsWith("content-type:")) {
                var7_7 = new Content(this);
                var10_10 = new StringTokenizer(var1_1, " ");
                var10_10.nextToken();
                var7_7.C_TYPE = this.stripQuotes(var10_10.nextToken());
            }
            if (var7_7 != null) {
                var10_11 = 0;
                var11_13 = "";
                var10_11 = var2_2.indexOf("boundary=");
                if (var10_11 != -1) {
                    var11_13 = var1_1.substring(var10_11 + "boundary=".length());
                    var7_7.C_BOUNDARY = this.stripQuotes(var11_13);
                }
                if ((var10_11 = var2_2.indexOf("content-transfer-encoding:")) != -1) {
                    var11_13 = var1_1.substring(var10_11 + "content-transfer-encoding:".length());
                    var7_7.C_ENCODING = this.stripQuotes(var11_13);
                }
                if ((var10_11 = var2_2.indexOf("content-id:")) != -1) {
                    var11_13 = var1_1.substring(var10_11 + "content-id:".length());
                    var7_7.C_NAME = this.stripQuotes(var11_13);
                }
                if ((var10_11 = var2_2.indexOf("name=")) == -1) continue;
                var11_13 = var1_1.substring(var10_11 + "name=".length());
                var7_7.C_NAME = this.stripQuotes(var11_13);
                continue;
            }
            if (!var5_5 || this.out == null || var1_1.length() == 0) continue;
            var10_12 = false;
            if (var3_3.length() == 0) {
                var11_14 = 0;
                while (var11_14 < var6_6.size()) {
                    var12_17 = (Content)var6_6.elementAt(var11_14);
                    if (var1_1.equals("--" + var12_17.C_BOUNDARY + "--")) {
                        var10_12 = true;
                        break;
                    }
                    ++var11_14;
                }
            }
            if (var10_12) {
                var4_4.finish();
                var11_15 = 0;
                while ((var11_15 = var4_4.convert(var8_8, 0, var8_8.length)) > 0) {
                    this.out.write(var8_8, 0, var11_15);
                }
                this.out.close();
                this.out = null;
                continue;
            }
            var4_4.setInput(var1_1.getBytes(), 0, var1_1.length());
            var11_16 = 0;
            while (true) {
                if ((var11_16 = var4_4.convert(var8_8, 0, var8_8.length)) > 0) ** break;
                continue block0;
                this.out.write(var8_8, 0, var11_16);
            }
            break;
        }
    }

    private void export_old() throws IOException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        String string5 = "";
        Encoding encoding = null;
        byte[] byArray = new byte[8192];
        AVScanResult aVScanResult = null;
        while ((string = this.lrIn.readln()) != null) {
            int n;
            string2 = string.toLowerCase();
            if (string.length() == 0 && !bl) {
                bl = true;
                if (string5.length() == 0) {
                    return;
                }
            }
            if (!bl && string2.startsWith("content-type:")) {
                n = string.indexOf("boundary=");
                if (n == -1) {
                    string = this.lrIn.readln();
                    string2 = string.toLowerCase();
                    n = string.indexOf("boundary=");
                }
                if (n == -1) continue;
                string5 = string.substring(n + "boundary=".length());
                string5 = this.stripQuotes(string5);
                string5 = "--" + string5;
            }
            if (!bl) continue;
            if (this.out != null && string.startsWith(string5)) {
                encoding.finish();
                n = 0;
                while ((n = encoding.convert(byArray, 0, byArray.length)) > 0) {
                    this.out.write(byArray, 0, n);
                }
                this.out.close();
                this.out = null;
                string4 = null;
                string3 = null;
                continue;
            }
            if (this.out != null) {
                if (string.length() <= 0) continue;
                encoding.setInput(string.getBytes(), 0, string.length());
                n = 0;
                while ((n = encoding.convert(byArray, 0, byArray.length)) > 0) {
                    this.out.write(byArray, 0, n);
                }
                continue;
            }
            if (string2.startsWith("content-type:")) {
                int n2;
                n = string2.indexOf("name=");
                if (n == -1) {
                    string = this.lrIn.readln();
                    string2 = string.toLowerCase();
                    n = string.indexOf("name=");
                    if (n == -1) continue;
                }
                if ((n2 = string2.indexOf(";", n)) == -1) {
                    n2 = string.length();
                }
                string3 = string.substring(n + "name=".length(), n2).trim();
                string3 = this.stripQuotes(string3);
                continue;
            }
            if (string2.startsWith("content-transfer-encoding:")) {
                string4 = string.substring("content-transfer-encoding:".length()).trim();
                continue;
            }
            if (string2.length() != 0 || string3 == null || string4 == null) continue;
            aVScanResult = new AVScanResult();
            aVScanResult.strDir = this.strTempDir;
            aVScanResult.strFile_Attachment = string3;
            aVScanResult.strFile_DOS = this.getTempName();
            aVScanResult.strInfection = "not scanned";
            aVScanResult.blnInfected = false;
            this.vecScanFiles.addElement(aVScanResult);
            encoding = Encoding.createEncodingInstance((String)string4);
            if (encoding == null) {
                aVScanResult.strInfection = "Unsupported encoding: " + string4;
                return;
            }
            encoding.startDecode();
            this.out = new FileOutputStream(new File(aVScanResult.strDir, aVScanResult.strFile_DOS));
        }
    }

    public String getInfo() {
        return this.avScanExec.getInfo();
    }

    public String getMarker() {
        return prpConfig.getProperty("avscan_marker");
    }

    public String getQuarantine() {
        return prpConfig.getProperty("avscan_quarantine");
    }

    private synchronized String getTempName() {
        String string = String.valueOf(Long.toHexString(TimeFactory.getTime()).substring(2)) + "." + Helper.rset(intExtCnt, 3, '0');
        if (++intExtCnt == 100) {
            intExtCnt = 0;
        }
        return string;
    }

    public boolean hasInfection() {
        return this.blnHasInfection;
    }

    private void init() {
        if (this.blnHadInit) {
            return;
        }
        File file = new File(AV_CONFIGFILE);
        if (!file.exists()) {
            prpConfig = null;
            return;
        }
        prpConfig = new Properties();
        ((Hashtable)prpConfig).put("avscan_class", "net.zerotoaster.mailfilters.avscan.DummyScan");
        ((Hashtable)prpConfig).put("avscan_temp", "avtemp");
        ((Hashtable)prpConfig).put("avscan_keep", "0");
        ((Hashtable)prpConfig).put("avscan_quarantine", "");
        ((Hashtable)prpConfig).put("avscan_marker", "** Infected **");
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                prpConfig.load(fileInputStream);
            }
            catch (IOException iOException) {
                this.logContext.write("? Error loading " + file, (Throwable)iOException);
                Object var3_7 = null;
                Helper.close(fileInputStream);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            Helper.close(fileInputStream);
            throw throwable;
        }
        String string = null;
        Helper.close(fileInputStream);
        if (prpConfig.getProperty("avscan_quarantine").length() == 0) {
            prpConfig = null;
            throw new RuntimeException("You must define a quarantine account !");
        }
        string = prpConfig.getProperty("avscan_class");
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$java$util$Properties;
            if (clazz2 == null) {
                try {
                    clazz2 = class$java$util$Properties = Class.forName("java.util.Properties");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$de$zwanzigeins$util$LogContext;
            if (clazz3 == null) {
                try {
                    clazz3 = class$de$zwanzigeins$util$LogContext = Class.forName("de.zwanzigeins.util.LogContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Class[] classArray2 = classArray;
            Constructor<?> constructor = clazz.getConstructor(classArray2);
            this.avScanExec = (AVScanExec)constructor.newInstance(prpConfig, this.logContext);
            this.blnHadInit = true;
        }
        catch (Throwable throwable) {
            this.logContext.write("? Error loading " + string, throwable);
        }
    }

    public static void main(String[] stringArray) throws Throwable {
        LogContext logContext = new LogContext();
        AVScan aVScan = new AVScan(logContext);
        LineReader lineReader = new LineReader(new FileInputStream("c:/2/worm.tmp"));
        aVScan.process(lineReader);
        lineReader.close();
        logContext.dispose();
    }

    public Vector process(LineReader lineReader) {
        this.lrIn = lineReader;
        this.vecScanFiles.removeAllElements();
        if (prpConfig == null) {
            return this.vecScanFiles;
        }
        this.strTempDir = String.valueOf(prpConfig.getProperty("avscan_temp")) + File.separator + this.getTempName();
        new File(this.strTempDir).mkdirs();
        try {
            this.logContext.write("D Exporting attachments");
            this.export();
        }
        catch (Throwable throwable) {
            this.vecScanFiles.removeAllElements();
            this.cleanup();
            this.logContext.write(throwable);
            return this.vecScanFiles;
        }
        if (this.vecScanFiles.size() == 0) {
            this.logContext.write("D No attachments found");
            this.cleanup();
            return this.vecScanFiles;
        }
        try {
            this.logContext.write("D AV scan " + this.vecScanFiles.size() + " files");
            this.blnHasInfection = this.avScanExec.scan(this.vecScanFiles);
            this.logContext.write("D AV scan done");
        }
        catch (Throwable throwable) {
            this.cleanup();
            this.logContext.write(throwable);
            return this.vecScanFiles;
        }
        this.cleanup();
        this.logContext.write("D AV scan finished");
        if (this.hasInfection()) {
            int n = 0;
            while (n < this.vecScanFiles.size()) {
                AVScanResult aVScanResult = (AVScanResult)this.vecScanFiles.elementAt(n);
                this.logContext.write("! Infected " + aVScanResult.strFile_Attachment + ": " + aVScanResult.strInfection);
                ++n;
            }
        }
        return this.vecScanFiles;
    }

    private String stripQuotes(String string) {
        if ((string = string.trim()).endsWith(";")) {
            string = string.substring(0, string.length() - 1).trim();
        }
        if (string.startsWith("<")) {
            string = string.substring(1).trim();
        }
        if (string.endsWith(">")) {
            string = string.substring(0, string.length() - 1).trim();
        }
        if (string.startsWith("\"")) {
            string = string.substring(1).trim();
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1).trim();
        }
        return string;
    }

    class Content {
        /* synthetic */ AVScan this$0;
        String C_BOUNDARY = "";
        String C_ENCODING = "";
        String C_TYPE = "";
        String C_NAME = "";

        Content(AVScan aVScan) {
            this.this$0 = aVScan;
        }
    }
}

