/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mailfilters;

import de.zwanzigeins.util.LogContext;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.config.Constants;
import net.zerotoaster.mailfilters.MailFilter;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.StorageManager;

public class MailFilterChain
implements Constants {
    private Vector vecFilters = new Vector();
    private LogContext logContext = null;
    private StorageManager smManager = null;
    private MailHeaderRecord mhr = null;
    private Configuration cnf = null;
    private boolean blnInBody = false;
    private boolean blnDelete = false;
    private boolean blnAbort = false;
    private boolean blnHeaderBodyJump = false;
    private boolean blnEOF = false;
    private int STATE_NONE = 0;
    private int STATE_ANALYZE = 1;
    private int STATE_PROCESS = 2;
    private int intCurrentState = this.STATE_NONE;

    public MailFilterChain(MailHeaderRecord mailHeaderRecord, LogContext logContext, StorageManager storageManager, Configuration configuration) {
        this.mhr = mailHeaderRecord;
        this.logContext = logContext;
        this.smManager = storageManager;
        this.cnf = configuration;
    }

    public void analyze(String string) {
        string = this.preProcess(this.STATE_ANALYZE, string);
        int n = 0;
        while (n < this.vecFilters.size()) {
            MailFilter mailFilter = (MailFilter)this.vecFilters.elementAt(n);
            this.blnDelete |= mailFilter.canDelete();
            this.blnAbort |= mailFilter.canAbort();
            if (this.blnAbort) break;
            if (mailFilter.canFilter()) {
                try {
                    if (this.blnEOF) {
                        mailFilter.analyzePost();
                    } else if (!this.blnInBody) {
                        mailFilter.analyzeHeader(string);
                    } else {
                        mailFilter.analyzeBody(string);
                    }
                }
                catch (Throwable throwable) {
                    this.logContext.write("? MailFilter analyze " + mailFilter.toString(), throwable);
                    mailFilter.filterDisable();
                }
            }
            ++n;
        }
        this.postProcess(string);
    }

    public boolean canAbort() {
        return this.blnAbort;
    }

    public boolean canDelete() {
        return this.blnDelete;
    }

    public void dispose() {
        if (this.vecFilters != null) {
            int n = 0;
            while (n < this.vecFilters.size()) {
                MailFilter mailFilter = (MailFilter)this.vecFilters.elementAt(n);
                mailFilter.dispose();
                ++n;
            }
            this.vecFilters.removeAllElements();
        }
    }

    private String postProcess(String string) {
        int n = 0;
        while (n < string.length() && (string.charAt(n) == '\r' || string.charAt(n) == '\n')) {
            ++n;
        }
        if (n != 0) {
            string = string.substring(n);
        }
        if (this.blnHeaderBodyJump) {
            if (string.length() != 0 && !string.endsWith("\r\n")) {
                string = String.valueOf(string) + "\r\n";
            }
            this.blnHeaderBodyJump = false;
        }
        if (this.blnEOF) {
            string = String.valueOf(string) + ".";
        }
        if (string.length() == 0 && !this.blnInBody && !this.blnHeaderBodyJump) {
            return null;
        }
        return string;
    }

    private String preProcess(int n, String string) {
        if (this.intCurrentState != n) {
            this.intCurrentState = n;
            this.blnInBody = false;
            this.blnDelete = false;
            this.blnAbort = false;
            this.blnHeaderBodyJump = false;
            this.blnEOF = false;
        }
        if (!this.blnInBody && string.length() == 0) {
            this.blnInBody = true;
            this.blnHeaderBodyJump = true;
        }
        if (string.length() == 1 && string.charAt(0) == '.') {
            this.blnEOF = true;
            string = "";
        }
        return string;
    }

    public String process(String string) {
        string = this.preProcess(this.STATE_PROCESS, string);
        int n = 0;
        while (n < this.vecFilters.size()) {
            MailFilter mailFilter = (MailFilter)this.vecFilters.elementAt(n);
            if (mailFilter.canFilter()) {
                try {
                    string = this.blnEOF ? mailFilter.processPost(string) : (this.blnHeaderBodyJump ? mailFilter.processNewHeaders(string) : (!this.blnInBody ? mailFilter.processHeader(string) : mailFilter.processBody(string)));
                }
                catch (Throwable throwable) {
                    this.logContext.write("? MailFilter process " + mailFilter.toString(), throwable);
                    mailFilter.filterDisable();
                }
            }
            ++n;
        }
        return this.postProcess(string);
    }

    public void registerFilter(MailFilter mailFilter) {
        mailFilter.init(this.mhr, this.logContext, this.smManager, this.cnf);
        this.vecFilters.addElement(mailFilter);
    }
}

