/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mailfilters;

import de.zwanzigeins.util.LogContext;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.config.Constants;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.StorageManager;

public abstract class MailFilter
implements Constants {
    private LogContext logContext = null;
    private boolean blnAbort = false;
    private boolean blnDelete = false;
    private boolean blnFilter = false;
    protected StorageManager smManager = null;
    protected MailHeaderRecord mhr = null;
    protected Configuration cnf = null;

    public abstract void analyzeBody(String var1) throws Throwable;

    public abstract void analyzeHeader(String var1) throws Throwable;

    public abstract void analyzePost() throws Throwable;

    public boolean canAbort() {
        return this.blnAbort;
    }

    public boolean canDelete() {
        return this.blnDelete;
    }

    public boolean canFilter() {
        return this.blnFilter;
    }

    public abstract void dispose();

    public void doAbort() {
        this.blnAbort = true;
    }

    public void doDelete() {
        this.blnDelete = true;
    }

    public void filterDisable() {
        this.blnFilter = false;
    }

    public void filterEnable() {
        this.blnFilter = true;
    }

    void init(MailHeaderRecord mailHeaderRecord, LogContext logContext, StorageManager storageManager, Configuration configuration) {
        this.mhr = mailHeaderRecord;
        this.logContext = logContext;
        this.smManager = storageManager;
        this.cnf = configuration;
        this.blnFilter = true;
    }

    public void log(String string) {
        this.logContext.write(string);
    }

    public void log(String string, Throwable throwable) {
        this.logContext.write(string, throwable);
    }

    public void log(Throwable throwable) {
        this.logContext.write(throwable);
    }

    public abstract String processBody(String var1) throws Throwable;

    public abstract String processHeader(String var1) throws Throwable;

    public abstract String processNewHeaders(String var1) throws Throwable;

    public abstract String processPost(String var1) throws Throwable;
}

