/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mailfilters;

import java.io.Serializable;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.Helper;

public class BayesianRBLRecord
extends StorageRecord
implements Serializable {
    public static final String KEYDATA_APPL_RECORD = "BAYESIAN_RBL_RECORD";
    private String strUserName = null;
    private String strServer = null;
    private String strResponse = null;
    private int intProbability = 0;

    public BayesianRBLRecord() {
        this.init();
    }

    public int getProbability() {
        return this.intProbability;
    }

    public String getResponse() {
        return this.strResponse;
    }

    public String getServer() {
        return this.strServer;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public void init() {
        this.strUserName = "";
        this.strServer = "";
        this.strResponse = "";
        this.intProbability = 0;
    }

    public String recordExport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.strUserName);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strServer);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strResponse);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intProbability);
        stringBuffer.append('\u0014');
        return stringBuffer.toString();
    }

    public void recordImport(String string) {
        this.initTokenizer(string);
        this.strUserName = this.nextToken();
        this.strServer = this.nextToken();
        this.strResponse = this.nextToken();
        this.intProbability = Integer.parseInt(this.nextToken());
    }

    public void setProbability(int n) {
        this.intProbability = n;
    }

    public void setResponse(String string) {
        this.strResponse = Helper.limit(string, 60);
    }

    public void setServer(String string) {
        this.strServer = Helper.limit(string.toLowerCase(), 50);
    }

    public void setUserName(String string) {
        this.strUserName = Helper.limit(string.toLowerCase(), 129);
    }

    public String toString() {
        return String.valueOf(this.getUserName()) + "/" + this.getServer();
    }
}

