/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mailfilters;

import java.io.Serializable;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.Helper;

public class BayesianFilterRecord
extends StorageRecord
implements Serializable {
    public static final String KEYDATA_APPL_RECORD = "BAYESIAN_FILTER_RECORD";
    private String strUserName = null;
    private String strWord = null;
    private int intProbability = 0;
    private boolean blnTestBody = true;
    private boolean blnTestHeader = true;
    private long lngTimesUsed = 0L;
    private long lngLastUsed = 0L;

    public BayesianFilterRecord() {
        this.init();
    }

    public long getLastUsed() {
        return this.lngLastUsed;
    }

    public int getProbability() {
        return this.intProbability;
    }

    public boolean getTestBody() {
        return this.blnTestBody;
    }

    public boolean getTestHeader() {
        return this.blnTestHeader;
    }

    public long getTimesUsed() {
        return this.lngTimesUsed;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public String getWord() {
        return this.strWord;
    }

    public void init() {
        this.strUserName = "";
        this.strWord = "";
        this.intProbability = 50;
        this.blnTestBody = true;
        this.blnTestHeader = true;
        this.lngTimesUsed = 0L;
        this.lngLastUsed = 0L;
    }

    public String recordExport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.strUserName);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strWord);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intProbability);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnTestBody);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.blnTestHeader);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.lngTimesUsed);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.lngLastUsed);
        stringBuffer.append('\u0014');
        return stringBuffer.toString();
    }

    public void recordImport(String string) {
        this.initTokenizer(string);
        this.strUserName = this.nextToken();
        this.strWord = this.nextToken();
        this.intProbability = Integer.parseInt(this.nextToken());
        this.blnTestBody = Boolean.valueOf(this.nextToken());
        this.blnTestHeader = Boolean.valueOf(this.nextToken());
        if (this.hasMoreTokens()) {
            this.lngTimesUsed = Long.parseLong(this.nextToken());
            this.lngLastUsed = Long.parseLong(this.nextToken());
        }
    }

    public void setLastUsed(long l) {
        this.lngLastUsed = l;
    }

    public void setProbability(int n) {
        this.intProbability = n;
    }

    public void setTestBody(boolean bl) {
        this.blnTestBody = bl;
    }

    public void setTestHeader(boolean bl) {
        this.blnTestHeader = bl;
    }

    public void setTimesUsed(long l) {
        this.lngTimesUsed = l;
    }

    public void setUserName(String string) {
        this.strUserName = Helper.limit(string.toLowerCase(), 129);
    }

    public void setWord(String string) {
        this.strWord = string.toLowerCase().trim();
    }

    public String toString() {
        return String.valueOf(this.getUserName()) + "/" + this.getWord();
    }
}

