/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mailfilters;

import de.zwanzigeins.util.HelperValidate;
import java.io.Serializable;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.Helper;

public class BayesianFilterConfig
extends StorageRecord
implements Serializable {
    public static final String KEYDATA_APPL_CONFIG = "BAYESIAN_FILTER_CONFIG";
    public static final int ACTION_MOVE = 0;
    public static final int ACTION_DELETE = 1;
    public static final int ACTION_MARK = 2;
    private String strUserName = null;
    private int intProbability_1 = 0;
    private int intAction_1 = 0;
    private int intProbability_2 = 0;
    private int intAction_2 = 0;
    private String strEMail = null;
    private String strMarker = null;
    private String strWordListSource = null;

    public BayesianFilterConfig() {
        this.init();
    }

    public int getAction_1() {
        return this.intAction_1;
    }

    public int getAction_2() {
        return this.intAction_2;
    }

    public String getEMail() {
        return this.strEMail;
    }

    public String getMarker() {
        return this.strMarker;
    }

    public int getProbability_1() {
        return this.intProbability_1;
    }

    public int getProbability_2() {
        return this.intProbability_2;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public String getWordListSource() {
        return this.strWordListSource;
    }

    public void init() {
        this.strUserName = "";
        this.intProbability_1 = 100;
        this.intAction_1 = 0;
        this.intProbability_2 = 100;
        this.intAction_2 = 0;
        this.strEMail = "";
        this.strMarker = "** SPAM **";
        this.strWordListSource = "";
    }

    public String recordExport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.strUserName);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intProbability_1);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intAction_1);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intProbability_2);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.intAction_2);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strEMail);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strMarker);
        stringBuffer.append('\u0014');
        stringBuffer.append(this.strWordListSource);
        stringBuffer.append('\u0014');
        return stringBuffer.toString();
    }

    public void recordImport(String string) {
        this.initTokenizer(string);
        this.strUserName = this.nextToken();
        this.intProbability_1 = this.nextTokenInteger();
        this.intAction_1 = this.nextTokenInteger();
        this.intProbability_2 = this.nextTokenInteger();
        this.intAction_2 = this.nextTokenInteger();
        this.strEMail = this.nextToken();
        if (this.hasMoreTokens()) {
            this.strMarker = this.nextToken();
        }
        if (this.hasMoreTokens()) {
            this.strWordListSource = this.nextToken();
        }
    }

    public void setAction_1(int n) {
        this.intAction_1 = n;
    }

    public void setAction_2(int n) {
        this.intAction_2 = n;
    }

    public void setEMail(String string) {
        this.strEMail = HelperValidate.validateRFC822_User((String)string);
    }

    public void setMarker(String string) {
        this.strMarker = string.trim();
    }

    public void setProbability_1(int n) {
        this.intProbability_1 = n;
    }

    public void setProbability_2(int n) {
        this.intProbability_2 = n;
    }

    public void setUserName(String string) {
        this.strUserName = Helper.limit(string.toLowerCase(), 129);
    }

    public void setWordListSource(String string) {
        this.strWordListSource = HelperValidate.validateRFC822_User((String)string);
        if (this.strWordListSource == null) {
            this.strWordListSource = "";
        }
    }

    public String toString() {
        return this.getUserName();
    }
}

