/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mailfilters;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import de.zwanzigeins.util.VectorObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.mailfilters.BayesianFilterConfig;
import net.zerotoaster.mailfilters.BayesianFilterRecord;
import net.zerotoaster.mailfilters.BayesianRBLRecord;
import net.zerotoaster.mailfilters.MailFilter;
import net.zerotoaster.storage.MailHeaderRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.Helper;
import net.zerotoaster.util.RBLCheck;

public class BayesianFilter
extends MailFilter {
    public static final String STOP_CHARS = " <>.,;:!=()?!\r\n\t\"\u00a0";
    private BayesianFilterConfig bfc = null;
    private String strUserToUse = null;
    private Hashtable hshRecords = new Hashtable();
    private VectorObject vecRecords = new VectorObject();
    private Hashtable hshWordsFound = new Hashtable();
    private int intMailAction = 0;
    private boolean blnSubjectFound = false;
    private double dblA = 0.0;
    private double dblB = 0.0;
    private RBLCheck rbl = null;
    private Vector vecRBL = null;
    private Vector vecRBLResults = null;

    private void analyze(String string, boolean bl) throws Throwable {
        string = string.toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, STOP_CHARS);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            BayesianFilterRecord bayesianFilterRecord = (BayesianFilterRecord)this.hshRecords.get(string2);
            if (bayesianFilterRecord == null || !bayesianFilterRecord.getTestBody() && bl || !bayesianFilterRecord.getTestHeader() && !bl) continue;
            double d = (double)bayesianFilterRecord.getProbability() / 100.0;
            this.dblA *= d;
            this.dblB *= 1.0 - d;
            Integer n = (Integer)this.hshWordsFound.get(string2);
            if (n == null) {
                n = new Integer(0);
            }
            n = new Integer(n + 1);
            this.hshWordsFound.put(string2, n);
        }
        int n = 0;
        while (n < this.vecRecords.size()) {
            BayesianFilterRecord bayesianFilterRecord = (BayesianFilterRecord)this.vecRecords.elementAt(n);
            if (bayesianFilterRecord != null && (bayesianFilterRecord.getTestBody() || !bl) && (bayesianFilterRecord.getTestHeader() || bl) && string.indexOf(string2 = bayesianFilterRecord.getWord()) != -1) {
                double d = (double)bayesianFilterRecord.getProbability() / 100.0;
                this.dblA *= d;
                this.dblB *= 1.0 - d;
                Integer n2 = (Integer)this.hshWordsFound.get(string2);
                if (n2 == null) {
                    n2 = new Integer(0);
                }
                n2 = new Integer(n2 + 1);
                this.hshWordsFound.put(string2, n2);
            }
            ++n;
        }
    }

    public void analyzeBody(String string) throws Throwable {
        this.analyze(string, true);
    }

    public void analyzeHeader(String string) throws Throwable {
        if (string.toLowerCase().startsWith("subject:")) {
            this.analyze(string, true);
        } else {
            this.analyze(string, false);
        }
    }

    public void analyzePost() {
        Object object;
        this.rblCheck();
        this.intMailAction = 0;
        int n = this.getProbability();
        int n2 = 0;
        while (n2 < 2) {
            int n3 = 0;
            int n4 = 0;
            switch (n2) {
                case 0: {
                    n3 = this.bfc.getProbability_1();
                    n4 = this.bfc.getAction_1();
                    break;
                }
                case 1: {
                    n3 = this.bfc.getProbability_2();
                    n4 = this.bfc.getAction_2();
                }
            }
            if (n > n3) {
                this.intMailAction = n4;
                switch (this.intMailAction) {
                    case 1: {
                        this.doDelete();
                        this.log("# Bayesian filter deleted " + this.mhr.toString());
                        break;
                    }
                    case 0: {
                        object = this.mhr.getEnvelopeTo_Redirected();
                        this.mhr.setEnvelopeTo_Redirected(this.bfc.getEMail());
                        this.log("# Bayesian filter moved " + (String)object + " -> " + this.mhr.getEnvelopeTo_Redirected());
                        break;
                    }
                    case 2: {
                        this.log("# Bayesian filter marked " + this.mhr.toString());
                    }
                }
                break;
            }
            ++n2;
        }
        BayesianFilterRecord bayesianFilterRecord = new BayesianFilterRecord();
        long l = TimeFactory.getTime();
        object = this.hshWordsFound.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            try {
                String string2 = this.smManager.keyDataRead("BAYESIAN_FILTER_RECORD", this.strUserToUse, string);
                bayesianFilterRecord.recordImport(string2);
                bayesianFilterRecord.setTimesUsed(bayesianFilterRecord.getTimesUsed() + 1L);
                bayesianFilterRecord.setLastUsed(l);
                this.smManager.keyDataWrite("BAYESIAN_FILTER_RECORD", this.strUserToUse, string, bayesianFilterRecord.recordExport());
            }
            catch (Throwable throwable) {}
        }
    }

    public void dispose() {
        if (this.rbl != null) {
            this.rbl.dispose();
        }
        if (this.hshRecords != null) {
            this.hshRecords.clear();
        }
        if (this.hshWordsFound != null) {
            this.hshWordsFound.clear();
        }
        if (this.vecRBL != null) {
            this.vecRBL.removeAllElements();
        }
        if (this.vecRBLResults != null) {
            this.vecRBLResults.removeAllElements();
        }
        if (this.vecRecords != null) {
            this.vecRecords.removeAllElements();
        }
    }

    public int getProbability() {
        double d = this.dblA / (this.dblA + this.dblB);
        return (int)Math.round(d * 100.0);
    }

    public Vector getProbabilityList() {
        BayesianFilterRecord bayesianFilterRecord;
        Vector<Object> vector = new Vector<Object>(this.hshWordsFound.size());
        Enumeration enumeration = this.hshWordsFound.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            bayesianFilterRecord = (BayesianFilterRecord)this.hshRecords.get(string);
            if (bayesianFilterRecord == null) {
                int n = 0;
                while (n < this.vecRecords.size()) {
                    if (((BayesianFilterRecord)this.vecRecords.elementAt(n)).getWord().equals(string)) {
                        bayesianFilterRecord = (BayesianFilterRecord)this.vecRecords.elementAt(n);
                    }
                    ++n;
                }
            }
            if (bayesianFilterRecord == null) continue;
            String string2 = String.valueOf(bayesianFilterRecord.getProbability());
            string2 = Helper.rset(string2, 3, ' ');
            String string3 = String.valueOf((Integer)this.hshWordsFound.get(string));
            string3 = Helper.rset(string3, 3, ' ');
            vector.addElement(String.valueOf(string2) + "% " + string3 + " " + string);
        }
        Helper.sortVector(vector);
        int n = vector.size() - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            bayesianFilterRecord = vector.elementAt(n2);
            vector.setElementAt(vector.elementAt(n - n2), n2);
            vector.setElementAt(bayesianFilterRecord, n - n2);
            --n2;
        }
        return vector;
    }

    public void init(MailHeaderRecord mailHeaderRecord, LogContext logContext, StorageManager storageManager, Configuration configuration) {
        StorageRecord storageRecord;
        String string;
        super.init(mailHeaderRecord, logContext, storageManager, configuration);
        this.hshRecords = new Hashtable();
        this.hshWordsFound = new Hashtable();
        this.filterDisable();
        this.strUserToUse = mailHeaderRecord.getEnvelopeTo_Redirected();
        int n = 0;
        while (n < 5) {
            this.bfc = this.readBFC(this.strUserToUse);
            if (this.bfc == null) {
                return;
            }
            if (this.bfc.getWordListSource().length() == 0) break;
            this.strUserToUse = this.bfc.getWordListSource();
            ++n;
        }
        this.log("D Using Bayesian Filter from " + this.strUserToUse);
        Vector vector = this.smManager.keyDataReadAll("BAYESIAN_FILTER_RECORD", this.strUserToUse);
        if (vector.size() == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            string = this.smManager.keyDataRead("BAYESIAN_FILTER_RECORD", this.strUserToUse, (String)vector.elementAt(n2));
            storageRecord = new BayesianFilterRecord();
            try {
                ((BayesianFilterRecord)storageRecord).recordImport(string);
            }
            catch (Throwable throwable) {
                this.log("? Corrupted bayesian filter record", throwable);
                return;
            }
            String string2 = ((BayesianFilterRecord)storageRecord).getWord();
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1);
                string2 = string2.substring(0, string2.length() - 1);
                ((BayesianFilterRecord)storageRecord).setWord(string2);
                this.vecRecords.addElement((Object)storageRecord);
            } else {
                this.hshRecords.put(((BayesianFilterRecord)storageRecord).getWord(), storageRecord);
            }
            ++n2;
        }
        this.rbl = new RBLCheck(logContext, configuration);
        vector = this.smManager.keyDataReadAll("BAYESIAN_RBL_RECORD", this.strUserToUse);
        this.vecRBL = new Vector(vector.size());
        n2 = 0;
        while (n2 < vector.size()) {
            string = this.smManager.keyDataRead("BAYESIAN_RBL_RECORD", this.strUserToUse, (String)vector.elementAt(n2));
            storageRecord = new BayesianRBLRecord();
            try {
                ((BayesianRBLRecord)storageRecord).recordImport(string);
            }
            catch (Throwable throwable) {
                this.log("? Corrupted bayesian RBL record", throwable);
                return;
            }
            this.vecRBL.addElement(storageRecord);
            ++n2;
        }
        this.vecRBLResults = new Vector();
        this.filterEnable();
        this.dblA = 1.0;
        this.dblB = 1.0;
    }

    public String processBody(String string) {
        return string;
    }

    public String processHeader(String string) {
        if (!this.blnSubjectFound && this.intMailAction == 2 && string.toLowerCase().startsWith("subject:")) {
            string = string.substring("subject:".length()).trim();
            string = "Subject: " + this.bfc.getMarker() + " " + this.getProbability() + "% " + string;
            this.blnSubjectFound = true;
        }
        return string;
    }

    public String processNewHeaders(String string) throws Throwable {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.intMailAction == 2 && !this.blnSubjectFound) {
            stringBuffer.append("\r\n");
            stringBuffer.append("Subject: ");
            stringBuffer.append(this.bfc.getMarker());
            stringBuffer.append(" ");
            stringBuffer.append(this.getProbability());
            stringBuffer.append("%");
        }
        stringBuffer.append("\r\n");
        stringBuffer.append("X-Bayesian-Filter: Spam Probability ");
        stringBuffer.append(this.getProbability());
        stringBuffer.append("%");
        Vector vector = this.getProbabilityList();
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append("\r\n");
            stringBuffer.append("X-Bayesian-Filter: Word ");
            stringBuffer.append((String)vector.elementAt(n));
            ++n;
        }
        n = 0;
        while (n < this.vecRBLResults.size()) {
            stringBuffer.append("\r\n");
            stringBuffer.append("X-Bayesian-Filter: RBL ");
            stringBuffer.append((String)this.vecRBLResults.elementAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public String processPost(String string) {
        return string;
    }

    private void rblCheck() {
        String string = this.mhr.getRoutedIP();
        this.vecRBLResults.addElement("Checking IP " + string);
        if (string.length() == 0) {
            this.vecRBLResults.addElement("-- not checked, no routed ip found --");
            return;
        }
        if (this.mhr.getExternalMail()) {
            this.vecRBLResults.addElement("-- not checked, transit mail --");
            return;
        }
        String string2 = HelperExtract.splitUserName_getDomain((String)this.mhr.getEnvelopeFrom_Redirected());
        if (this.smManager.domainRead(string2) != null) {
            this.vecRBLResults.addElement("-- not checked, sender is local --");
            return;
        }
        int n = 0;
        while (n < this.vecRBL.size()) {
            BayesianRBLRecord bayesianRBLRecord = (BayesianRBLRecord)this.vecRBL.elementAt(n);
            if (this.rbl.check(string, bayesianRBLRecord.getServer(), bayesianRBLRecord.getResponse())) {
                double d = (double)bayesianRBLRecord.getProbability() / 100.0;
                this.dblA *= d;
                this.dblB *= 1.0 - d;
                this.vecRBLResults.addElement(bayesianRBLRecord.getProbability() + "% " + this.rbl.getMessage());
            } else {
                this.vecRBLResults.addElement("passed " + bayesianRBLRecord.getServer());
            }
            ++n;
        }
    }

    private BayesianFilterConfig readBFC(String string) {
        BayesianFilterConfig bayesianFilterConfig = new BayesianFilterConfig();
        String string2 = this.smManager.keyDataRead("BAYESIAN_FILTER_CONFIG", string, "config");
        if (string2 == null) {
            return null;
        }
        try {
            bayesianFilterConfig.recordImport(string2);
        }
        catch (Throwable throwable) {
            this.log("? Corrupted config record", throwable);
            return null;
        }
        return bayesianFilterConfig;
    }
}

