/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import net.zerotoaster.io.LineReader;
import net.zerotoaster.io.LineWriter;
import net.zerotoaster.util.Helper;

public class LineSocket {
    private Socket sok = null;
    private LineWriter lwOut = null;
    private LineReader lrIn = null;
    private boolean blnDisposed = false;
    private InetAddress inaLocal = null;
    private InetAddress inaRemote = null;

    public LineSocket(Socket socket) throws IOException {
        this.sok = socket;
        this.inaLocal = socket.getLocalAddress();
        this.inaRemote = socket.getInetAddress();
        this.lrIn = new LineReader(socket.getInputStream());
        this.lwOut = new LineWriter(socket.getOutputStream());
    }

    public void close() {
        if (this.blnDisposed) {
            return;
        }
        this.blnDisposed = true;
        Helper.flush(this.lwOut);
        Helper.close(this.sok);
        this.sok = null;
    }

    public void finalize() throws Throwable {
        if (!this.blnDisposed) {
            this.close();
        }
    }

    public void flush() throws IOException {
        this.lwOut.flush();
    }

    public long getBytesReceived() {
        return this.lrIn.getBytes();
    }

    public long getBytesSent() {
        return this.lwOut.getBytes();
    }

    public long getBytesTotal() {
        return this.getBytesReceived() + this.getBytesSent();
    }

    public InetAddress getInetAddress() {
        return this.inaRemote;
    }

    public LineReader getLineReader() throws IOException {
        return this.lrIn;
    }

    public LineWriter getLineWriter() throws IOException {
        return this.lwOut;
    }

    public InetAddress getLocalAddress() {
        return this.inaLocal;
    }

    public void println(String string) throws IOException {
        this.lwOut.println(string);
    }

    public String readln() throws IOException {
        return this.lrIn.readln();
    }

    public void resetCount() {
        this.lrIn.resetCount();
        this.lwOut.resetCount();
    }

    public void setSoTimeout(long l) throws SocketException {
        this.sok.setSoTimeout((int)l);
    }

    public String toString() {
        return "LineSocket:" + this.sok.toString();
    }
}

