/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.io;

import de.zwanzigeins.util.LockObject;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.util.Helper;

public class LineServerSocket {
    private ServerSocket ssok = null;
    private boolean blnDisposed = false;
    private LockObject objLock = new LockObject();

    public LineServerSocket(int n) throws IOException {
        this.ssok = new ServerSocket(n);
    }

    public LineServerSocket(int n, int n2) throws IOException {
        this.ssok = new ServerSocket(n, n2);
    }

    public LineServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this.ssok = new ServerSocket(n, n2, inetAddress);
    }

    public LineSocket accept() throws IOException {
        Socket socket;
        block4: {
            if (this.blnDisposed) {
                return null;
            }
            socket = null;
            try {
                socket = this.ssok.accept();
            }
            catch (IOException iOException) {
                if (!this.blnDisposed) break block4;
                return null;
            }
        }
        if (this.blnDisposed) {
            Helper.close(socket);
            this.objLock.lo_notify();
            return null;
        }
        return new LineSocket(socket);
    }

    public void close() throws IOException {
        if (this.blnDisposed) {
            return;
        }
        this.blnDisposed = true;
        String string = this.getInetAddress().getHostAddress();
        if (string.equals("0.0.0.0")) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable throwable) {
                string = "127.0.0.1";
            }
        }
        try {
            new Socket(string, this.getLocalPort());
        }
        catch (Throwable throwable) {}
        this.objLock.lo_wait(2000L);
        this.objLock.dispose();
        this.objLock = null;
        Helper.close(this.ssok);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public InetAddress getInetAddress() {
        return this.ssok.getInetAddress();
    }

    public int getLocalPort() {
        return this.ssok.getLocalPort();
    }

    public String toString() {
        return "LineServerSocket[addr=" + this.getInetAddress() + ", localport=" + this.getLocalPort() + "]";
    }
}

