/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.event;

import de.zwanzigeins.util.LogContext;
import java.util.Vector;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.event.MTAEvent;
import net.zerotoaster.event.MTAEventListener;
import net.zerotoaster.event.PostmasterAlert;

public class MTAEventQueue
extends Thread {
    private static Vector vecListeners = new Vector();
    private static transient boolean blnIsRunning = false;
    private static Vector vecQueue = null;
    private static MTAEventQueue mtaq = null;
    private static LogContext logContext = null;
    private static Configuration cnfConfig = null;
    private static boolean blnConsumed = false;

    private MTAEventQueue() {
        super("MTAEventQueue");
        vecQueue = new Vector(50);
        this.setPriority(1);
        this.start();
    }

    public static final void addListener(MTAEventListener mTAEventListener) {
        if (vecListeners.indexOf(mTAEventListener) == -1) {
            vecListeners.addElement(mTAEventListener);
        }
    }

    public static final void consume() {
        blnConsumed = true;
    }

    public static final void dispose() {
        vecListeners.removeAllElements();
        if (mtaq == null) {
            return;
        }
        Vector vector = vecQueue;
        synchronized (vector) {
            vecQueue.removeAllElements();
            if (blnIsRunning) {
                blnIsRunning = false;
                vecQueue.notify();
            }
        }
        vecQueue = null;
        mtaq = null;
    }

    public static final synchronized void postEvent(MTAEvent mTAEvent) {
        if (mtaq == null) {
            mtaq = new MTAEventQueue();
        }
        if (vecQueue.capacity() == vecQueue.size()) {
            vecQueue.ensureCapacity(vecQueue.size() + 5);
            if (logContext != null) {
                logContext.write("? MTA event queue overflow. Queuesize is " + vecQueue.capacity() + " now");
                if (MTAEventQueue.cnfConfig.blnNotify_Queue) {
                    MTAEventQueue.postEvent(new PostmasterAlert("MTAEventQueue: Message queue resized to " + vecQueue.capacity()));
                }
            }
        }
        Vector vector = vecQueue;
        synchronized (vector) {
            vecQueue.addElement(mTAEvent);
            vecQueue.notify();
        }
    }

    public static final synchronized void postEventSync(MTAEvent mTAEvent) {
        Vector vector = vecListeners;
        synchronized (vector) {
            int n = 0;
            while (n < vecListeners.size()) {
                try {
                    MTAEventListener mTAEventListener = (MTAEventListener)vecListeners.elementAt(n);
                    blnConsumed = false;
                    mTAEventListener.mtaEvent(mTAEvent);
                    if (blnConsumed) {
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (logContext != null) {
                        logContext.write("? Exception in MTA Event Queue Sync:", throwable);
                    } else {
                        System.out.println("? Exception in MTA Event Queue Sync: ");
                    }
                    throwable.printStackTrace();
                }
                ++n;
            }
        }
    }

    public static final void removeAll() {
        vecListeners.removeAllElements();
    }

    public static final void removeListener(MTAEventListener mTAEventListener) {
        vecListeners.removeElement(mTAEventListener);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        MTAEventQueue.blnIsRunning = true;
        var1_1 = null;
        var2_2 = MTAEventQueue.vecQueue;
        if (var2_2 != null) ** GOTO lbl50
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2;
            synchronized (var3_3) {
                while (true) {
                    if (!MTAEventQueue.blnIsRunning || var2_2.size() != 0) {
                        if (MTAEventQueue.blnIsRunning) break;
                        return;
                    }
                    try {
                        var2_2.wait(0L);
                    }
                    catch (InterruptedException v0) {
                    }
                    catch (ThreadDeath v1) {
                        MTAEventQueue.blnIsRunning = false;
                    }
                }
                var1_1 = (MTAEvent)var2_2.elementAt(0);
                var2_2.removeElementAt(0);
            }
            var3_3 = MTAEventQueue.vecListeners;
            synchronized (var3_3) {
                var4_4 = 0;
                while (var4_4 < MTAEventQueue.vecListeners.size()) {
                    block17: {
                        try {
                            var5_5 = (MTAEventListener)MTAEventQueue.vecListeners.elementAt(var4_4);
                            MTAEventQueue.blnConsumed = false;
                            var5_5.mtaEvent(var1_1);
                            if (MTAEventQueue.blnConsumed) {
                            }
                            break block17;
                        }
                        catch (Throwable var5_6) {
                            if (MTAEventQueue.logContext != null) {
                                MTAEventQueue.logContext.write("? Exception in MTA Event Queue:", var5_6);
                                break;
                            }
                            System.err.println("Exception in MTA Event Queue: " + var5_6);
                        }
                        break;
                    }
                    ++var4_4;
                }
                continue;
            }
lbl50:
            // 3 sources

            ** while (MTAEventQueue.blnIsRunning)
        }
lbl51:
        // 1 sources

    }

    public static final void setConfiguration(LogContext logContext, Configuration configuration) {
        MTAEventQueue.logContext = logContext;
        cnfConfig = configuration;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = vecQueue;
        synchronized (vector) {
            Vector vector2 = vecQueue;
            stringBuffer.append("Dump of EventQueue follows.\n");
            stringBuffer.append("Queue contains ");
            stringBuffer.append(vector2.size());
            stringBuffer.append(" Elements\n");
            int n = 0;
            while (n < vector2.size()) {
                MTAEvent mTAEvent = (MTAEvent)vector2.elementAt(n);
                stringBuffer.append(" -- ");
                stringBuffer.append(n);
                stringBuffer.append(" ");
                stringBuffer.append(mTAEvent.toString());
                stringBuffer.append('\n');
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

