/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.config;

import de.zwanzigeins.util.IP_Network;
import de.zwanzigeins.util.IniManager;
import de.zwanzigeins.util.LogContext;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.TimeZone;
import net.zerotoaster.storage.LicenceRecord;
import net.zerotoaster.storage.StatisticsRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.storage.StorageRecord;
import net.zerotoaster.util.UserAlias;

public class Configuration {
    private static Configuration cfg = null;
    public static IniManager iniMgr = null;
    public StatisticsRecord statrec = new StatisticsRecord();
    public String strStorageManager = null;
    public LicenceRecord lic = null;
    public String strPOP3_Host = null;
    public int intPOP3_Instances = -1;
    public int intPOP3_Socket_Timeout = -1;
    public boolean blnPOP3_RoundRobin = false;
    public String strSMTP_Host = null;
    public int intSMTP_Instances = -1;
    public int intSMTP_Socket_Timeout = -1;
    public boolean blnSMTP_RoundRobin = false;
    public String strSMTP_Welcome_Message = null;
    public boolean blnSMTP_Welcome_Multiline = false;
    public int intSMTP_Max_Recipients = 0;
    public String strSMTP_AuthMethods = "";
    public String strFWD_Host = null;
    public int intFWD_Instances = -1;
    public int intFWD_Socket_Timeout = -1;
    public boolean blnFWD_RoundRobin = false;
    public int intFWD_MaxRetries = -1;
    public int intFWD_RetryDelay = -1;
    public int[] intFWD_RetryNotify = null;
    public int intFWD_Rescan = -1;
    public String strFWD_HeloHost = null;
    public IP_Network[] ipnFWD_NoDelivery = null;
    public int intFWD_BounceIncludeLines = -1;
    public int intMPA_Instances = -1;
    public boolean blnMPA_RoundRobin = false;
    public boolean blnMPA_StopFilterAfterAV = true;
    public String strMHUB_Host = null;
    public int intMHUB_Socket_Timeout = -1;
    public int intMHUB_JobRescan = -1;
    public String strFetchmail_Host = null;
    public int intFetchmail_Socket_Timeout = -1;
    public int intFetchmail_JobRescan = -1;
    public String strRemote_Host = "";
    public String strRemote_Admin_User = "";
    public String strRemote_Admin_Pass = "";
    public String strLogFile_Path = null;
    public String strLogFile_Praefix = null;
    public String strLogFile_Suffix = null;
    public String strLogFile_Options = null;
    public String strLogScrn_Options = null;
    public String strLogFile_DateFormat = null;
    public String strLogFile_TimeFormat = null;
    public String strLogFile_Yesterday = null;
    public int intLogFile_Keep = 0;
    public boolean blnNotify_Startup = false;
    public boolean blnNotify_Queue = false;
    public boolean blnNotify_OutOfServers = false;
    public String strNameServer = null;
    public int intSemaphoreCheck = 0;
    public int intMailCleanup = 0;
    public String strPostmaster_Name = null;
    public String strFakedOS = null;
    public boolean blnKeepStats = false;
    public IP_Network[] ipnTrustedNetworks = null;
    public IP_Network[] ipnTrustedRouters = null;
    public boolean blnRestartWhenConfigChanged = false;
    public String strTimeZone = null;
    public String strSystemName = null;
    public String[] strAliases = null;
    public String[] strAlias_SmartDelivery = null;
    public boolean blnMailImportEnabled = false;
    public String strMailImportPath = "";
    public int intMailImportRescan = 0;
    public String[] strFilters = null;
    public boolean blnRunFinalizersOnExit = false;
    public boolean blnRunFinalizers = false;
    public int intMemorycheck = 0;
    public boolean blnMemorycheck_finalisation = false;
    public boolean blnMemorycheck_gc = false;
    public String[] strRBL_BlackList = null;
    public String[] strRBL_WhiteList = null;
    public String strRBL_Logfile = null;
    static Class class$de$zwanzigeins$util$LogContext;
    static Class class$net$zerotoaster$config$Configuration;

    private Configuration() {
        this.readConfig();
    }

    public static final void dispose() {
        cfg = null;
    }

    public static final Configuration getConfig() {
        if (cfg == null) {
            cfg = new Configuration();
        }
        return cfg;
    }

    public static final StorageManager getStorageManager(LogContext logContext) throws Throwable {
        Configuration configuration = Configuration.getConfig();
        String string = configuration.strStorageManager.trim();
        Object[] objectArray = new Object[]{logContext, configuration};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$de$zwanzigeins$util$LogContext;
        if (clazz == null) {
            try {
                clazz = class$de$zwanzigeins$util$LogContext = Class.forName("de.zwanzigeins.util.LogContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$net$zerotoaster$config$Configuration;
        if (clazz2 == null) {
            try {
                clazz2 = class$net$zerotoaster$config$Configuration = Class.forName("net.zerotoaster.config.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        Constructor<?> constructor = Class.forName(string).getConstructor(classArray2);
        return (StorageManager)((Object)constructor.newInstance(objectArray));
    }

    public static final boolean isModified() {
        if (iniMgr == null) {
            return false;
        }
        return iniMgr.isModified();
    }

    private final void readConfig() {
        UserAlias userAlias;
        String[] stringArray;
        this.lic = new LicenceRecord();
        String string = "";
        iniMgr = new IniManager("zerotoaster.ini");
        this.strStorageManager = iniMgr.getPropertyString("", "storage_manager", "net.zerotoaster.storage.file.FileStorage");
        this.strPOP3_Host = iniMgr.getPropertyString("", "pop3_host", "*:110");
        this.intPOP3_Instances = iniMgr.getPropertyInt("", "pop3_instances", 5);
        this.intPOP3_Socket_Timeout = iniMgr.getPropertyInt("", "pop3_socket_timeout", 120);
        this.blnPOP3_RoundRobin = iniMgr.getPropertyBoolean("", "pop3_roundrobin", false);
        this.strSMTP_Host = iniMgr.getPropertyString("", "smtp_host", "*:25");
        this.intSMTP_Instances = iniMgr.getPropertyInt("", "smtp_instances", 5);
        this.intSMTP_Socket_Timeout = iniMgr.getPropertyInt("", "smtp_socket_timeout", 120);
        this.blnSMTP_RoundRobin = iniMgr.getPropertyBoolean("", "smtp_roundrobin", false);
        this.strSMTP_Welcome_Message = iniMgr.getPropertyString("", "smtp_welcome_message", "Idiots abroad !");
        this.blnSMTP_Welcome_Multiline = iniMgr.getPropertyBoolean("", "smtp_welcome_multiline", true);
        this.intSMTP_Max_Recipients = iniMgr.getPropertyInt("", "smtp_max_recipients", 10);
        this.strSMTP_AuthMethods = iniMgr.getPropertyString("", "smtp_auth_methods", "PLAIN LOGIN CRAM-MD5");
        this.strFWD_Host = iniMgr.getPropertyString("", "fwd_host", "*:25");
        this.intFWD_Instances = iniMgr.getPropertyInt("", "fwd_instances", 5);
        this.intFWD_Socket_Timeout = iniMgr.getPropertyInt("", "fwd_socket_timeout", 120);
        this.blnFWD_RoundRobin = iniMgr.getPropertyBoolean("", "fwd_roundrobin", false);
        this.intFWD_MaxRetries = iniMgr.getPropertyInt("", "fwd_max_retries", 500);
        this.intFWD_RetryDelay = iniMgr.getPropertyInt("", "fwd_retry_delay", 10);
        this.intFWD_RetryNotify = iniMgr.getPropertyIntAsArray("", "fwd_retry_notify", new int[]{2, 10, 100, 250});
        this.intFWD_Rescan = iniMgr.getPropertyInt("", "fwd_rescan", 240);
        this.strFWD_HeloHost = iniMgr.getPropertyString("", "fwd_helo_host", "");
        this.ipnFWD_NoDelivery = StorageRecord.conv_string2networks(iniMgr.getPropertyString("", "fwd_no_delivery", ""));
        this.intFWD_BounceIncludeLines = iniMgr.getPropertyInt("", "fwd_bounce_include_lines", 25);
        this.intMPA_Instances = iniMgr.getPropertyInt("", "mpa_instances", 5);
        this.blnMPA_RoundRobin = iniMgr.getPropertyBoolean("", "mpa_roundrobin", false);
        this.blnMPA_StopFilterAfterAV = iniMgr.getPropertyBoolean("", "mpa_stopfilterafterav", true);
        this.strMHUB_Host = iniMgr.getPropertyString("", "mhub_host", "*");
        this.intMHUB_Socket_Timeout = iniMgr.getPropertyInt("", "mhub_socket_timeout", 120);
        this.intMHUB_JobRescan = iniMgr.getPropertyInt("", "mhub_jobrescan", 60);
        this.strFetchmail_Host = iniMgr.getPropertyString("", "fetchmail_host", "*");
        this.intFetchmail_Socket_Timeout = iniMgr.getPropertyInt("", "fetchmail_socket_timeout", 120);
        this.intFetchmail_JobRescan = iniMgr.getPropertyInt("", "fetchmail_jobrescan", 60);
        this.strLogFile_Path = iniMgr.getPropertyString("", "logfile_path", "");
        this.strLogFile_Praefix = iniMgr.getPropertyString("", "logfile_praefix", "mta_");
        this.strLogFile_Suffix = iniMgr.getPropertyString("", "logfile_suffix", ".log");
        this.strLogFile_Options = iniMgr.getPropertyString("", "logfile_options", "#!?DMAR");
        this.strLogScrn_Options = iniMgr.getPropertyString("", "logscrn_options", "#!?DMAR");
        this.strLogFile_DateFormat = iniMgr.getPropertyString("", "logfile_dateformat", "dd.MM.yyyy");
        this.strLogFile_TimeFormat = iniMgr.getPropertyString("", "logfile_timeformat", "HH:mm:ss");
        this.strLogFile_Yesterday = iniMgr.getPropertyString("", "logfile_yesterday", "");
        this.intLogFile_Keep = iniMgr.getPropertyInt("", "logfile_keep", 0);
        this.strRemote_Host = iniMgr.getPropertyString("", "remote_host", "localhost:411");
        this.strRemote_Admin_User = iniMgr.getPropertyString("", "remote_admin_user");
        this.strRemote_Admin_Pass = iniMgr.getPropertyString("", "remote_admin_pass");
        this.blnNotify_Startup = iniMgr.getPropertyBoolean("", "postmaster_notify_startup", true);
        this.blnNotify_Queue = iniMgr.getPropertyBoolean("", "postmaster_notify_queue", true);
        this.blnNotify_OutOfServers = iniMgr.getPropertyBoolean("", "postmaster_notify_outofservers", true);
        this.strNameServer = iniMgr.getPropertyString("", "nameserver", "127.0.0.1");
        this.intSemaphoreCheck = iniMgr.getPropertyInt("", "semaphorecheck", 2);
        this.intMailCleanup = iniMgr.getPropertyInt("", "mailcleanup", 60);
        this.strPostmaster_Name = iniMgr.getPropertyString("", "postmaster_name", "");
        this.strFakedOS = iniMgr.getPropertyString("", "faked_os", "");
        this.blnKeepStats = iniMgr.getPropertyBoolean("", "keep_stats", true);
        this.ipnTrustedNetworks = StorageRecord.conv_string2networks(iniMgr.getPropertyString("", "trusted_networks", ""));
        this.ipnTrustedRouters = StorageRecord.conv_string2networks(iniMgr.getPropertyString("", "trusted_routers", ""));
        this.blnRestartWhenConfigChanged = iniMgr.getPropertyBoolean("", "restart_when_config_changed", false);
        this.strTimeZone = iniMgr.getPropertyString("", "timezone", "");
        this.strSystemName = iniMgr.getPropertyString("", "system_name", "");
        this.blnRunFinalizers = iniMgr.getPropertyBoolean("", "finalization", false);
        this.blnRunFinalizersOnExit = iniMgr.getPropertyBoolean("", "runfinalizersonexit", false);
        this.intMemorycheck = iniMgr.getPropertyInt("", "memorycheck", 0);
        this.blnMemorycheck_finalisation = iniMgr.getPropertyBoolean("", "memorycheck_finalization", false);
        this.blnMemorycheck_gc = iniMgr.getPropertyBoolean("", "memorycheck_gc", false);
        string = "USER_ALIAS";
        this.strAliases = iniMgr.getPropertiesString(string, "alias", new String[0]);
        this.strAlias_SmartDelivery = iniMgr.getPropertyStringAsArray(string, "smart_delivery", new String[0]);
        string = "MAIL_IMPORT";
        this.blnMailImportEnabled = iniMgr.getPropertyBoolean(string, "enabled", true);
        this.strMailImportPath = iniMgr.getPropertyString(string, "path", "./import/");
        this.intMailImportRescan = iniMgr.getPropertyInt(string, "rescan", 2);
        string = "MAILFILTERS";
        this.strFilters = iniMgr.getPropertiesString(string, "class");
        string = "RBL";
        this.strRBL_BlackList = iniMgr.getPropertiesString(string, "blacklist");
        this.strRBL_WhiteList = iniMgr.getPropertiesString(string, "whitelist");
        this.strRBL_Logfile = iniMgr.getPropertyString(string, "logfile", "");
        if (!iniMgr.hasLoaded()) {
            iniMgr.save();
        }
        if ((stringArray = (userAlias = new UserAlias(this.strAliases)).resolve("postmaster")).length <= 1 && stringArray[0].equalsIgnoreCase("postmaster")) {
            throw new RuntimeException("You must setup a 'postmaster' alias in the configuration !");
        }
        if (this.strPostmaster_Name.length() == 0) {
            throw new RuntimeException("You must setup the 'postmaster_name' field in the configuration !");
        }
        boolean bl = false;
        int n = 0;
        while (n < this.strAlias_SmartDelivery.length) {
            if (this.strAlias_SmartDelivery[n].equalsIgnoreCase("postmaster")) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            String[] stringArray2 = new String[this.strAlias_SmartDelivery.length + 1];
            System.arraycopy(this.strAlias_SmartDelivery, 0, stringArray2, 0, this.strAlias_SmartDelivery.length);
            stringArray2[this.strAlias_SmartDelivery.length] = "postmaster";
            this.strAlias_SmartDelivery = stringArray2;
        }
        ((Hashtable)System.getProperties()).put("dns.server", this.strNameServer);
        if (this.strTimeZone.length() != 0) {
            TimeZone.setDefault(TimeZone.getTimeZone(this.strTimeZone));
        }
    }
}

