/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.admin.awt;

import java.awt.FontMetrics;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import net.zerotoaster.admin.awt.IntegerStack;

public final class StringBufferExtended
implements Serializable,
Cloneable {
    private static final int CASEDIFF = 32;
    public static final String LS = System.getProperty("line.separator");
    public static final char N = LS.charAt(LS.length() - 1);
    public static final char R = LS.charAt(0);
    private static final char[] chrDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] chrUnits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] chrTenthsUnits = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private char[] charsValue = null;
    private int intLength = 0;
    private int intNextLineStart = 0;

    public StringBufferExtended() {
        this(16);
    }

    public StringBufferExtended(int n) {
        this.charsValue = new char[n];
    }

    public StringBufferExtended(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public StringBufferExtended(StringBuffer stringBuffer) {
        this(stringBuffer.length() + 16);
        this.append(stringBuffer);
    }

    public StringBufferExtended(StringBufferExtended stringBufferExtended) {
        this(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength);
    }

    public StringBufferExtended(StringBufferExtended stringBufferExtended, int n, int n2) {
        this(stringBufferExtended.charsValue, n, n2);
    }

    public StringBufferExtended(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public StringBufferExtended(char[] cArray, int n, int n2) {
        this(cArray.length + 16);
        this.append(cArray, n, n2);
    }

    public final StringBufferExtended append(byte by) {
        int n = this.intLength + 1;
        if (n > this.charsValue.length) {
            this.ensureCapacity(n);
        }
        this.charsValue[this.intLength++] = (char)(by & 0xFF);
        return this;
    }

    public final StringBufferExtended append(char c) {
        int n = this.intLength + 1;
        if (n > this.charsValue.length) {
            this.ensureCapacity(n);
        }
        this.charsValue[this.intLength++] = c;
        return this;
    }

    public final StringBufferExtended append(double d) {
        return this.append(String.valueOf(d));
    }

    public final StringBufferExtended append(float f) {
        return this.append(String.valueOf(f));
    }

    public final StringBufferExtended append(int n) {
        if (n == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        char[] cArray = new char[12];
        boolean bl = n < 0;
        int n2 = 12;
        if (bl) {
            n = -n;
            this.append('-');
        }
        if (n < 10) {
            this.append((char)(n + 48));
            return this;
        }
        do {
            int n3 = n % 100;
            cArray[--n2] = chrUnits[n3];
            cArray[--n2] = chrTenthsUnits[n3];
        } while ((n /= 100) != 0);
        if (cArray[n2] == '0') {
            ++n2;
        }
        this.append(cArray, n2, 12 - n2);
        return this;
    }

    public final StringBufferExtended append(long l) {
        return this.append(String.valueOf(l));
    }

    public final StringBufferExtended append(Object object) {
        return this.append(String.valueOf(object));
    }

    public final StringBufferExtended append(String string) {
        int n;
        int n2;
        if (string == null) {
            string = "null";
        }
        if ((n2 = this.intLength + (n = string.length())) > this.charsValue.length) {
            this.ensureCapacity(n2);
        }
        string.getChars(0, n, this.charsValue, this.intLength);
        this.intLength = n2;
        return this;
    }

    public final StringBufferExtended append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        int n = stringBuffer.length();
        if (n == 0) {
            return this;
        }
        int n2 = this.intLength + n;
        if (n2 > this.charsValue.length) {
            this.ensureCapacity(n2);
        }
        stringBuffer.getChars(0, n, this.charsValue, this.intLength);
        this.intLength = n2;
        return this;
    }

    public final StringBufferExtended append(StringBufferExtended stringBufferExtended) {
        if (stringBufferExtended == null) {
            return this.append("null");
        }
        return this.append(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength);
    }

    public final StringBufferExtended append(StringBufferExtended stringBufferExtended, int n, int n2) {
        if (stringBufferExtended == null) {
            this.append("null");
        }
        return this.append(stringBufferExtended.charsValue, n, n2);
    }

    public final StringBufferExtended append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public final StringBufferExtended append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public final StringBufferExtended append(byte[] byArray, int n, int n2) {
        int n3 = this.intLength + n2;
        if (n3 > this.charsValue.length) {
            this.ensureCapacity(n3);
        }
        int n4 = this.intLength;
        char[] cArray = this.charsValue;
        while (n4 < n3) {
            cArray[n4++] = (char)(byArray[n++] & 0xFF);
        }
        this.intLength = n3;
        return this;
    }

    public final StringBufferExtended append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public final StringBufferExtended append(char[] cArray, int n, int n2) {
        int n3 = this.intLength + n2;
        if (n3 > this.charsValue.length) {
            this.ensureCapacity(n3);
        }
        System.arraycopy(cArray, n, this.charsValue, this.intLength, n2);
        this.intLength = n3;
        return this;
    }

    private final StringBufferExtended append_(int n) {
        if (n == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        char[] cArray = new char[12];
        boolean bl = n < 0;
        int n2 = 12;
        if (bl) {
            n = -n;
            this.append('-');
        }
        if (n < 10) {
            this.append((char)(n + 48));
            return this;
        }
        do {
            int n3 = n % 100;
            cArray[--n2] = chrUnits[n3];
            cArray[--n2] = chrTenthsUnits[n3];
        } while ((n /= 100) != 0);
        if (cArray[n2] == '0') {
            ++n2;
        }
        this.append(cArray, n2, 12 - n2);
        return this;
    }

    public final void clear() {
        this.intLength = 0;
    }

    public final Object clone() {
        try {
            StringBufferExtended stringBufferExtended = (StringBufferExtended)super.clone();
            stringBufferExtended.charsValue = (char[])this.charsValue.clone();
            return stringBufferExtended;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone failed on StringBufferExtended");
        }
    }

    public final int compareTo(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.compareTo(cArray, 0, n, false);
    }

    public final int compareTo(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return this.compareTo(cArray, 0, n, false);
    }

    public final int compareTo(StringBufferExtended stringBufferExtended) {
        return this.compareTo(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, false);
    }

    public final int compareTo(char[] cArray) {
        return this.compareTo(cArray, 0, cArray.length, false);
    }

    public final int compareTo(char[] cArray, int n, int n2) {
        return this.compareTo(cArray, n, n2, false);
    }

    private final int compareTo(char[] cArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n2 + n > cArray.length) {
            throw new IllegalArgumentException();
        }
        int n3 = Math.min(this.intLength, n2);
        char[] cArray2 = this.charsValue;
        int n4 = 0;
        int n5 = n;
        while (n3-- != 0) {
            char c;
            char c2;
            if ((c2 = cArray2[n4++]) == (c = cArray[n5++])) continue;
            if (bl) {
                char c3;
                if (Character.toUpperCase(c2) == Character.toUpperCase(c)) continue;
                char c4 = Character.toLowerCase(c2);
                if (c4 != (c3 = Character.toLowerCase(c))) {
                    return c4 - c3;
                }
            }
            return c2 - c;
        }
        return this.intLength - n2;
    }

    public final int compareToIgnoreCase(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.compareTo(cArray, 0, n, true);
    }

    public final int compareToIgnoreCase(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return this.compareTo(cArray, 0, n, true);
    }

    public final int compareToIgnoreCase(StringBufferExtended stringBufferExtended) {
        return this.compareTo(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, true);
    }

    public final int compareToIgnoreCase(char[] cArray) {
        return this.compareTo(cArray, 0, cArray.length, true);
    }

    public final int compareToIgnoreCase(char[] cArray, int n, int n2) {
        return this.compareTo(cArray, n, n2, true);
    }

    final StringBufferExtended convert(boolean bl, String string, int n) {
        boolean bl2 = true;
        if (string == null) {
            string = "";
            bl2 = false;
        }
        if (n < 3) {
            bl2 = false;
        }
        int n2 = this.intLength;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        char[] cArray = this.charsValue;
        char c = '\u0000';
        boolean bl3 = false;
        boolean bl4 = false;
        while (n3 < n2) {
            boolean bl5;
            char c2 = cArray[n3++];
            if (bl2) {
                if (c2 == c) {
                    if (bl4) continue;
                    if (++n5 == n) {
                        bl4 = true;
                        n4 = n6;
                        cArray[n4++] = 32;
                        continue;
                    }
                    cArray[n4++] = c2;
                    continue;
                }
                bl4 = false;
                if (string.indexOf(c2) > -1) {
                    c = c2;
                    n5 = 1;
                    n6 = n4;
                    cArray[n4++] = c2;
                    continue;
                }
                c = '\u0000';
                n5 = 0;
            }
            if (bl && c2 > '\u007f') continue;
            boolean bl6 = bl5 = c2 == '\n' || c2 == '\r' || c2 == '\t';
            if (c2 > ' ' || bl5) {
                cArray[n4++] = c2;
                bl3 = !bl5;
                continue;
            }
            if (!bl3) continue;
            cArray[n4++] = 32;
            bl3 = false;
        }
        this.intLength = n4;
        return this;
    }

    public final StringBufferExtended convertASCIIToLowerCase() {
        int n = this.intLength;
        char[] cArray = this.charsValue;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= 'A' && c <= 'Z') {
                int n3 = n2;
                cArray[n3] = (char)(cArray[n3] + 32);
            }
            ++n2;
        }
        return this;
    }

    public final StringBufferExtended convertASCIIToUpperCase() {
        int n = this.intLength;
        char[] cArray = this.charsValue;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= 'a' && c <= 'z') {
                int n3 = n2;
                cArray[n3] = (char)(cArray[n3] - 32);
            }
            ++n2;
        }
        return this;
    }

    public final StringBufferExtended convertToLowerCase() {
        return this.convertToLowerCase(Locale.getDefault());
    }

    public final StringBufferExtended convertToLowerCase(Locale locale) {
        int n = this.intLength;
        char[] cArray = this.charsValue;
        if (locale.getLanguage().equals("tr")) {
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                cArray[n2] = c == 'I' ? 305 : (c == '\u0130' ? 105 : Character.toLowerCase(c));
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                cArray[n3] = Character.toLowerCase(cArray[n3]);
                ++n3;
            }
        }
        return this;
    }

    public final StringBufferExtended convertToUpperCase() {
        return this.convertToUpperCase(Locale.getDefault());
    }

    public final StringBufferExtended convertToUpperCase(Locale locale) {
        int n = this.intLength;
        char[] cArray = this.charsValue;
        if (locale.getLanguage().equals("tr")) {
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c == 'i') {
                    cArray[n2] = 304;
                } else if (c == '\u0131') {
                    cArray[n2] = 73;
                } else if (c == '\u00df') {
                    cArray[n2] = 83;
                    this.insert(n2++, 'S');
                    cArray = this.charsValue;
                    n = this.intLength;
                } else {
                    cArray[n2] = Character.toUpperCase(c);
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c = cArray[n3];
                if (c == '\u00df') {
                    cArray[n3] = 83;
                    this.insert(n3++, 'S');
                    cArray = this.charsValue;
                    n = this.intLength;
                } else {
                    cArray[n3] = Character.toUpperCase(c);
                }
                ++n3;
            }
        }
        return this;
    }

    public static final char[] createFilledCharArray(char c, int n) {
        char[] cArray = new char[n];
        int n2 = n;
        while (n2-- > 0) {
            cArray[n2] = c;
        }
        return cArray;
    }

    public final StringBufferExtended decLength() {
        if (--this.intLength < 0) {
            this.intLength = 0;
        }
        return this;
    }

    public final StringBufferExtended delete(int n) {
        return this.delete(n, Integer.MAX_VALUE);
    }

    public final StringBufferExtended delete(int n, int n2) {
        if (n < 0 || n >= this.intLength) {
            throw new StringIndexOutOfBoundsException("offset out of bounds: " + n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("len must be >= 0: " + n2);
        }
        if (n2 == 0) {
            return this;
        }
        int n3 = n + n2;
        if (n3 >= this.intLength || n3 < 0) {
            this.setLength(n);
            return this;
        }
        System.arraycopy(this.charsValue, n + n2, this.charsValue, n, this.intLength - (n + n2));
        this.intLength -= n2;
        return this;
    }

    public void dispose() {
        this.charsValue = null;
        this.intLength = 0;
        this.intNextLineStart = 0;
    }

    public final boolean endsWith(String string) {
        int n = string.length();
        if (this.intLength < n) {
            return false;
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.isMatchingRegion(cArray, 0, n, this.intLength - n, false);
    }

    public final boolean endsWith(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (this.intLength < n) {
            return false;
        }
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return this.isMatchingRegion(cArray, 0, n, this.intLength - n, false);
    }

    public final boolean endsWith(StringBufferExtended stringBufferExtended) {
        if (this.intLength < stringBufferExtended.intLength) {
            return false;
        }
        return this.isMatchingRegion(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, this.intLength - stringBufferExtended.intLength, false);
    }

    public final boolean endsWith(StringBufferExtended stringBufferExtended, int n, int n2) {
        if (this.intLength < n2) {
            return false;
        }
        return this.isMatchingRegion(stringBufferExtended.charsValue, n, n2, this.intLength - n2, false);
    }

    public final boolean endsWith(char[] cArray) {
        if (this.intLength < cArray.length) {
            return false;
        }
        return this.isMatchingRegion(cArray, 0, cArray.length, this.intLength - cArray.length, false);
    }

    public final boolean endsWith(char[] cArray, int n, int n2) {
        if (this.intLength < n2) {
            return false;
        }
        return this.isMatchingRegion(cArray, n, n2, this.intLength - n2, false);
    }

    public final void ensureCapacity(int n) {
        if (n > this.charsValue.length) {
            int n2 = (this.charsValue.length + 1) * 2;
            if (n > n2) {
                n2 = n;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.charsValue, 0, cArray, 0, this.intLength);
            this.charsValue = cArray;
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            StringBufferExtended stringBufferExtended = (StringBufferExtended)object;
            int n = this.intLength;
            if (n == stringBufferExtended.intLength) {
                char[] cArray = this.charsValue;
                char[] cArray2 = stringBufferExtended.charsValue;
                int n2 = 0;
                while (n-- > 0) {
                    if (cArray[n2] == cArray2[n2++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final StringBufferExtended erase(int n, int n2) {
        return this.overwrite(' ', n, n2);
    }

    public String fillInNameTemplate(Dictionary dictionary) {
        return this.fillInNameTemplate(null, dictionary).toString();
    }

    public StringBufferExtended fillInNameTemplate(StringBufferExtended stringBufferExtended, Dictionary dictionary) {
        int n = dictionary.size();
        boolean bl = stringBufferExtended != null;
        if (!bl) {
            stringBufferExtended = new StringBufferExtended(this.intLength + n * 80);
        } else {
            stringBufferExtended.clear();
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.intLength && (n3 = this.getIndexOf(123, n3)) > -1) {
            int n4 = this.getIndexOf(125, n3);
            if (n4 == -1) break;
            String string = this.getSubstring(n3 + 1, n4);
            Object v = dictionary.get(string);
            if (v == null && (v = dictionary.get(string.toLowerCase())) == null && (v = dictionary.get(string.toUpperCase())) == null) {
                if (!bl) {
                    throw new IllegalArgumentException("place holder in buffer not matched by element in argument list: {" + string + '}');
                }
                ++n3;
                continue;
            }
            if (n3 > n2) {
                stringBufferExtended.append(this.charsValue, n2, n3 - n2);
            }
            n2 = n3 = n4 + 1;
            stringBufferExtended.append(v.toString());
        }
        if (n2 < this.intLength) {
            stringBufferExtended.append(this.charsValue, n2, this.intLength - n2);
        }
        return stringBufferExtended;
    }

    public StringBufferExtended fillInNumberTemplate(StringBufferExtended stringBufferExtended, Object[] objectArray) {
        int n = objectArray.length;
        boolean bl = stringBufferExtended != null;
        if (!bl) {
            stringBufferExtended = new StringBufferExtended(this.intLength + n * 80);
        } else {
            stringBufferExtended.clear();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.intLength && (n3 = this.getIndexOf(123, n3)) > -1) {
            int n5 = this.getIndexOf(125, n3);
            if (n5 == -1) break;
            try {
                n4 = Integer.parseInt(this.getSubstring(n3 + 1, n5));
            }
            catch (NumberFormatException numberFormatException) {
                ++n3;
                continue;
            }
            if (n4 < 0 || n4 > n - 1) {
                if (bl) {
                    ++n3;
                    continue;
                }
                throw new IllegalArgumentException("place holder in buffer not matched by argument array: {" + n4 + '}');
            }
            if (n3 > n2) {
                stringBufferExtended.append(this.charsValue, n2, n3 - n2);
            }
            n2 = n3 = n5 + 1;
            stringBufferExtended.append(objectArray[n4]);
        }
        if (n2 < this.intLength) {
            stringBufferExtended.append(this.charsValue, n2, this.intLength - n2);
        }
        return stringBufferExtended;
    }

    public String fillInNumberTemplate(Object[] objectArray) {
        return this.fillInNumberTemplate(null, objectArray).toString();
    }

    public final int getCapacity() {
        return this.charsValue.length;
    }

    public final char[] getCharArray() {
        return this.charsValue;
    }

    public final char getCharAt(int n) {
        if (n >= this.intLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.charsValue[n];
    }

    public final int getCharCount(char c) {
        return this.getCharCount(c, 0, this.intLength, false);
    }

    public final int getCharCount(char c, int n, int n2) {
        return this.getCharCount(c, n, n2, false);
    }

    public final int getCharCount(char c, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n > n2 || n > this.intLength) {
            throw new StringIndexOutOfBoundsException("start=" + n + "; end=" + n2 + ";buffer size=" + this.intLength);
        }
        if (n2 > this.intLength) {
            n2 = this.intLength;
        }
        int n3 = 0;
        char[] cArray = this.charsValue;
        int n4 = n2;
        while (n4-- > n) {
            char c2 = cArray[n4];
            if (c2 == c) {
                ++n3;
                continue;
            }
            if (!bl) continue;
            if (Character.toUpperCase(c) == Character.toUpperCase(c2)) {
                ++n3;
                continue;
            }
            if (Character.toLowerCase(c) != Character.toLowerCase(c2)) continue;
            ++n3;
        }
        return n3;
    }

    public final void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < n2) {
            System.arraycopy(this.charsValue, n, cArray, n3, n2 - n);
        }
    }

    public final int getIndexOf(int n) {
        return this.getIndexOf(n, 0);
    }

    public final int getIndexOf(int n, int n2) {
        int n3 = this.intLength;
        char[] cArray = this.charsValue;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.intLength) {
            return -1;
        }
        int n4 = n2;
        while (n4 < n3) {
            if (cArray[n4] == n) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public final int getIndexOf(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.getIndexOf(cArray, 0, n, 0);
    }

    public final int getIndexOf(String string, int n) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        return this.getIndexOf(cArray, 0, n2, n);
    }

    public final int getIndexOf(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return this.getIndexOf(cArray, 0, n, 0);
    }

    public final int getIndexOf(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return this.getIndexOf(cArray, 0, n2, n);
    }

    public final int getIndexOf(StringBufferExtended stringBufferExtended) {
        return this.getIndexOf(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, 0);
    }

    public final int getIndexOf(StringBufferExtended stringBufferExtended, int n) {
        return this.getIndexOf(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, n);
    }

    public final int getIndexOf(StringBufferExtended stringBufferExtended, int n, int n2) {
        return this.getIndexOf(stringBufferExtended.charsValue, n, n2, 0);
    }

    public final int getIndexOf(StringBufferExtended stringBufferExtended, int n, int n2, int n3) {
        return this.getIndexOf(stringBufferExtended.charsValue, n, n2, n3);
    }

    public final int getIndexOf(char[] cArray) {
        return this.getIndexOf(cArray, 0, cArray.length, 0);
    }

    public final int getIndexOf(char[] cArray, int n) {
        return this.getIndexOf(cArray, 0, cArray.length, n);
    }

    public final int getIndexOf(char[] cArray, int n, int n2) {
        return this.getIndexOf(cArray, n, n2, 0);
    }

    public final int getIndexOf(char[] cArray, int n, int n2, int n3) {
        char[] cArray2 = this.charsValue;
        int n4 = this.intLength;
        int n5 = n4 - n2;
        if (n3 >= n4) {
            return -1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 == 0) {
            return n3;
        }
        char c = cArray[n];
        block0: while (true) {
            if (n3 <= n5 && cArray2[n3] != c) {
                ++n3;
                continue;
            }
            if (n3 > n5) {
                return -1;
            }
            int n6 = n3 + 1;
            int n7 = n6 + n2 - 1;
            int n8 = n + 1;
            while (n6 < n7) {
                if (cArray2[n6++] == cArray[n8++]) continue;
                ++n3;
                continue block0;
            }
            break;
        }
        return n3;
    }

    public final int getIndexOfIgnoreCase(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.getIndexOfIgnoreCase(cArray, 0, n, 0);
    }

    public final int getIndexOfIgnoreCase(String string, int n) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        return this.getIndexOfIgnoreCase(cArray, 0, n2, n);
    }

    public final int getIndexOfIgnoreCase(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return this.getIndexOfIgnoreCase(cArray, 0, n, 0);
    }

    public final int getIndexOfIgnoreCase(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return this.getIndexOfIgnoreCase(cArray, 0, n2, n);
    }

    public final int getIndexOfIgnoreCase(StringBufferExtended stringBufferExtended) {
        return this.getIndexOfIgnoreCase(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, 0);
    }

    public final int getIndexOfIgnoreCase(StringBufferExtended stringBufferExtended, int n) {
        return this.getIndexOfIgnoreCase(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, n);
    }

    public final int getIndexOfIgnoreCase(StringBufferExtended stringBufferExtended, int n, int n2) {
        return this.getIndexOfIgnoreCase(stringBufferExtended.charsValue, n, n2, 0);
    }

    public final int getIndexOfIgnoreCase(StringBufferExtended stringBufferExtended, int n, int n2, int n3) {
        return this.getIndexOfIgnoreCase(stringBufferExtended.charsValue, n, n2, n3);
    }

    public final int getIndexOfIgnoreCase(char[] cArray) {
        return this.getIndexOfIgnoreCase(cArray, 0, cArray.length, 0);
    }

    public final int getIndexOfIgnoreCase(char[] cArray, int n) {
        return this.getIndexOfIgnoreCase(cArray, 0, cArray.length, n);
    }

    public final int getIndexOfIgnoreCase(char[] cArray, int n, int n2) {
        return this.getIndexOfIgnoreCase(cArray, n, n2, 0);
    }

    public final int getIndexOfIgnoreCase(char[] cArray, int n, int n2, int n3) {
        char[] cArray2 = this.charsValue;
        int n4 = this.intLength;
        int n5 = n4 - n2;
        if (n3 >= n4) {
            return -1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 == 0) {
            return n3;
        }
        char c = cArray[n];
        char c2 = Character.toUpperCase(c);
        char c3 = Character.toLowerCase(c);
        block0: while (true) {
            int n6;
            if (n3 <= n5) {
                n6 = cArray2[n3];
                if (n6 != c && Character.toUpperCase((char)n6) != c2 && Character.toLowerCase((char)n6) != c3) {
                    ++n3;
                    continue;
                }
            }
            if (n3 > n5) {
                return -1;
            }
            n6 = n3 + 1;
            int n7 = n6 + n2 - 1;
            int n8 = n + 1;
            while (n6 < n7) {
                char c4;
                char c5 = cArray2[n6++];
                char c6 = Character.toUpperCase(c5);
                char c7 = Character.toLowerCase(c5);
                if ((c4 = cArray[n8++]) == c5 || c6 == Character.toUpperCase(c4) || c7 == Character.toLowerCase(c4)) continue;
                ++n3;
                continue block0;
            }
            break;
        }
        return n3;
    }

    public final int getLastIndexOf(int n) {
        return this.getLastIndexOf(n, this.intLength - 1);
    }

    public final int getLastIndexOf(int n, int n2) {
        char[] cArray = this.charsValue;
        int n3 = n2 >= this.intLength ? this.intLength - 1 : n2;
        while (n3 >= 0) {
            if (cArray[n3] == n) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public final int getLastIndexOf(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.getLastIndexOf(cArray, 0, n, this.intLength - 1);
    }

    public final int getLastIndexOf(String string, int n) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        return this.getLastIndexOf(cArray, 0, n2, n);
    }

    public final int getLastIndexOf(String string, int n, boolean bl) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        return this.getLastIndexOf(cArray, 0, n2, n, bl);
    }

    public final int getLastIndexOf(String string, boolean bl) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.getLastIndexOf(cArray, 0, n, this.intLength - 1, bl);
    }

    public final int getLastIndexOf(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return this.getLastIndexOf(cArray, 0, n, this.intLength - 1);
    }

    public final int getLastIndexOf(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return this.getLastIndexOf(cArray, 0, n2, n);
    }

    public final int getLastIndexOf(StringBuffer stringBuffer, int n, boolean bl) {
        int n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return this.getLastIndexOf(cArray, 0, n2, n, bl);
    }

    public final int getLastIndexOf(StringBuffer stringBuffer, boolean bl) {
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return this.getLastIndexOf(cArray, 0, n, this.intLength - 1, bl);
    }

    public final int getLastIndexOf(StringBufferExtended stringBufferExtended) {
        return this.getLastIndexOf(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, this.intLength - 1);
    }

    public final int getLastIndexOf(StringBufferExtended stringBufferExtended, int n) {
        return this.getLastIndexOf(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, n);
    }

    public final int getLastIndexOf(StringBufferExtended stringBufferExtended, int n, int n2) {
        return this.getLastIndexOf(stringBufferExtended.charsValue, n, n2, this.intLength - 1);
    }

    public final int getLastIndexOf(StringBufferExtended stringBufferExtended, int n, int n2, int n3) {
        return this.getLastIndexOf(stringBufferExtended.charsValue, n, n2, n3);
    }

    public final int getLastIndexOf(StringBufferExtended stringBufferExtended, int n, int n2, int n3, boolean bl) {
        return this.getLastIndexOf(stringBufferExtended.charsValue, n, n2, n3, bl);
    }

    public final int getLastIndexOf(StringBufferExtended stringBufferExtended, int n, int n2, boolean bl) {
        return this.getLastIndexOf(stringBufferExtended.charsValue, n, n2, this.intLength - 1, bl);
    }

    public final int getLastIndexOf(StringBufferExtended stringBufferExtended, int n, boolean bl) {
        return this.getLastIndexOf(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, n, bl);
    }

    public final int getLastIndexOf(StringBufferExtended stringBufferExtended, boolean bl) {
        return this.getLastIndexOf(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, this.intLength - 1, bl);
    }

    public final int getLastIndexOf(char[] cArray) {
        return this.getLastIndexOf(cArray, 0, cArray.length, this.intLength - 1);
    }

    public final int getLastIndexOf(char[] cArray, int n) {
        return this.getLastIndexOf(cArray, 0, cArray.length, n);
    }

    public final int getLastIndexOf(char[] cArray, int n, int n2) {
        return this.getLastIndexOf(cArray, n, n2, this.intLength - 1);
    }

    public final int getLastIndexOf(char[] cArray, int n, int n2, int n3) {
        int n4;
        if (n3 < 0) {
            return -1;
        }
        int n5 = this.intLength - n2;
        if (n3 > n5) {
            n3 = n5;
        }
        if (n2 == 0) {
            return n3;
        }
        char[] cArray2 = this.charsValue;
        int n6 = n + n2 - 1;
        char c = cArray[n6];
        int n7 = n2 - 1;
        int n8 = n7 + n3;
        block0: while (true) {
            if (n8 >= n7 && cArray2[n8] != c) {
                --n8;
                continue;
            }
            if (n8 < n7) {
                return -1;
            }
            int n9 = n8 - 1;
            n4 = n9 - (n2 - 1);
            int n10 = n6 - 1;
            while (n9 > n4) {
                if (cArray2[n9--] == cArray[n10--]) continue;
                --n8;
                continue block0;
            }
            break;
        }
        return n4 + 1;
    }

    public final int getLastIndexOf(char[] cArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (!bl) {
            return this.getLastIndexOf(cArray, n, n2, n3);
        }
        if (n3 < 0) {
            return -1;
        }
        int n5 = this.intLength - n2;
        if (n3 > n5) {
            n3 = n5;
        }
        if (n2 == 0) {
            return n3;
        }
        char[] cArray2 = this.charsValue;
        int n6 = n + n2 - 1;
        char c = cArray[n6];
        char c2 = Character.toUpperCase(c);
        char c3 = Character.toLowerCase(c);
        int n7 = n2 - 1;
        int n8 = n7 + n3;
        block0: while (true) {
            int n9;
            if (n8 >= n7) {
                n9 = cArray2[n8];
                if (n9 != c && Character.toUpperCase((char)n9) != c2 && Character.toLowerCase((char)n9) != c3) {
                    --n8;
                    continue;
                }
            }
            if (n8 < n7) {
                return -1;
            }
            n9 = n8 - 1;
            n4 = n9 - (n2 - 1);
            int n10 = n6 - 1;
            while (n9 > n4) {
                char c4;
                char c5 = cArray2[n9--];
                char c6 = Character.toUpperCase(c5);
                char c7 = Character.toLowerCase(c5);
                if ((c4 = cArray[n10--]) == c5 || Character.toUpperCase(c4) == c6 || Character.toLowerCase(c4) == c7) continue;
                --n8;
                continue block0;
            }
            break;
        }
        return n4 + 1;
    }

    public final int getLastIndexOf(char[] cArray, int n, int n2, boolean bl) {
        return this.getLastIndexOf(cArray, n, n2, this.intLength - 1, bl);
    }

    public final int getLastIndexOf(char[] cArray, int n, boolean bl) {
        return this.getLastIndexOf(cArray, 0, cArray.length, n, bl);
    }

    public final int getLastIndexOf(char[] cArray, boolean bl) {
        return this.getLastIndexOf(cArray, 0, cArray.length, this.intLength - 1, bl);
    }

    public final int getLength() {
        return this.intLength;
    }

    public final int getLineCount() {
        if (this.intLength == 0) {
            return 0;
        }
        int n = this.getCharCount(N, 0, this.intLength - 1, false);
        if (this.charsValue[this.intLength - 1] != N) {
            ++n;
        }
        return n;
    }

    public final String getLineFixedLength(int n, int n2) {
        if (n < 0 || n > this.intLength) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("width: " + n2);
        }
        char[] cArray = new char[n2 + 1];
        char[] cArray2 = this.charsValue;
        int n3 = this.intLength;
        int n4 = 0;
        IntegerStack integerStack = new IntegerStack();
        IntegerStack integerStack2 = new IntegerStack();
        boolean bl = false;
        boolean bl2 = true;
        char c = '\u0000';
        while (n <= n3) {
            if (n4 > n2 || n == n3 || c == N) {
                while (n4 > 0 && cArray[n4 - 1] <= ' ') {
                    --n4;
                }
                if (n4 > n2 && !integerStack.isEmpty()) {
                    n4 = integerStack.pop();
                    n = integerStack2.pop();
                }
                while (n < n3 && (c = cArray2[n]) != N && c <= ' ') {
                    ++n;
                }
                this.intNextLineStart = n;
                return String.valueOf(cArray, 0, n4);
            }
            c = cArray2[n];
            if (c <= ' ') {
                if (bl) {
                    integerStack.push(n4);
                    integerStack2.push(n);
                    bl = false;
                    bl2 = false;
                }
                ++n;
                if (bl2) continue;
                bl2 = true;
                if (c == N || c == R) continue;
                cArray[n4++] = 32;
                continue;
            }
            bl = true;
            ++n;
            cArray[n4++] = c;
        }
        return null;
    }

    private final String getLineFixedLength(int n, int n2, boolean bl) {
        if (n < 0 || n > this.intLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("width: " + n2);
        }
        char[] cArray = new char[n2 + 1];
        char[] cArray2 = this.charsValue;
        int n3 = this.intLength;
        int n4 = 0;
        IntegerStack integerStack = new IntegerStack();
        IntegerStack integerStack2 = new IntegerStack();
        boolean bl2 = false;
        boolean bl3 = bl;
        char c = '\u0000';
        while (n <= n3) {
            if (n4 > n2 || n == n3 || c == N) {
                if (bl) {
                    while (n4 > 0 && cArray[n4 - 1] <= ' ') {
                        --n4;
                    }
                }
                if (n4 > n2 && !integerStack.isEmpty()) {
                    n4 = integerStack.pop();
                    n = integerStack2.pop();
                }
                if (bl) {
                    while (n < n3 && (c = cArray[n]) != N || c <= ' ') {
                        ++n;
                    }
                }
                this.intNextLineStart = n;
                return String.valueOf(cArray, 0, n4);
            }
            c = cArray2[n];
            if (c <= ' ') {
                if (bl2) {
                    integerStack.push(n4);
                    integerStack2.push(n);
                    bl2 = false;
                    bl3 = false;
                }
                ++n;
                if (bl3) continue;
                bl3 = bl;
                if (c == N || c == R) continue;
                cArray[n4++] = 32;
                continue;
            }
            bl2 = true;
            ++n;
            cArray[n4++] = c;
        }
        return null;
    }

    public final Enumeration getLineFixedLengthEnumeration(int n) {
        return new LineEnumeration(this, n);
    }

    public final String getLineHardBreak(int n, boolean bl) {
        if (n < 0 || n > this.intLength) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        char[] cArray = this.charsValue;
        int n2 = this.intLength;
        int n3 = this.getIndexOf(N, n);
        int n4 = 1;
        if (n3 == -1) {
            n3 = n2;
        } else if (n3 > n && cArray[n3 - 1] == R) {
            ++n4;
            --n3;
        }
        int n5 = n3 - n;
        if (!bl) {
            this.intNextLineStart = n + n5 + n4;
            return new String(cArray, n, n5);
        }
        char[] cArray2 = new char[n5];
        int n6 = 0;
        boolean bl2 = bl;
        boolean bl3 = true;
        char c = '\u0000';
        while (n < n3) {
            if ((c = cArray[n++]) <= ' ') {
                if (bl3) {
                    bl3 = false;
                }
                if (bl2) continue;
                bl2 = bl;
                cArray2[n6++] = 32;
                continue;
            }
            bl3 = true;
            cArray2[n6++] = c;
        }
        while (n6 > 0 && cArray2[n6 - 1] <= ' ') {
            --n6;
        }
        while (n < n2 && (c = cArray[n]) != N && c <= ' ') {
            ++n;
        }
        this.intNextLineStart = n;
        return String.valueOf(cArray2, 0, n6);
    }

    public final Enumeration getLineHardBreakEnumeration() {
        return new LineEnumeration(this);
    }

    public final Enumeration getLineHardBreakEnumeration(int n) {
        LineEnumeration lineEnumeration = new LineEnumeration(this);
        LineEnumeration.access$intLineCounter(lineEnumeration, this.getLineStart(n));
        return lineEnumeration;
    }

    public final int getLineNumber(int n) {
        return this.getCharCount(N, 0, n, false) + 1;
    }

    public final String getLineSoftLength(int n, int n2, FontMetrics fontMetrics, boolean bl) {
        if (n < 0 || n > this.intLength) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("pixelWidth: " + n2);
        }
        int n3 = 0;
        double d = fontMetrics.stringWidth("iIwW");
        double d2 = d / 4.0;
        n3 = (int)((double)n2 / d2);
        char[] cArray = new char[n3 + 16];
        char[] cArray2 = this.charsValue;
        int n4 = this.intLength;
        int n5 = 0;
        IntegerStack integerStack = new IntegerStack();
        IntegerStack integerStack2 = new IntegerStack();
        boolean bl2 = false;
        boolean bl3 = bl;
        char c = '\u0000';
        boolean bl4 = false;
        while (n <= n4) {
            if (n5 > n3 | (bl4 = n == n4 | c == N)) {
                char[] cArray3;
                int n6 = fontMetrics.charsWidth(cArray, 0, n5);
                if (n6 > n2 || bl4) {
                    if (bl) {
                        while (n5 > 0 && cArray[n5 - 1] <= ' ') {
                            --n5;
                        }
                    }
                    n6 = fontMetrics.charsWidth(cArray, 0, n5);
                    while (n6 > n2 && !integerStack.isEmpty()) {
                        n5 = integerStack.pop();
                        n = integerStack2.pop();
                        n6 = fontMetrics.charsWidth(cArray, 0, n5);
                    }
                    if (cArray2[n - 1] != N) {
                        while (n < n4) {
                            c = cArray2[n];
                            if (c <= ' ') {
                                ++n;
                            }
                            if (c == N || c > ' ') break;
                            if (bl || c == R) continue;
                            if (n5 == cArray.length) {
                                cArray3 = new char[n5 * 2];
                                System.arraycopy(cArray, 0, cArray3, 0, n5);
                                cArray = cArray3;
                            }
                            cArray[n5++] = 32;
                        }
                    }
                    this.intNextLineStart = n;
                    return String.valueOf(cArray, 0, n5);
                }
                if (n5 == cArray.length) {
                    cArray3 = new char[n5 * 2];
                    System.arraycopy(cArray, 0, cArray3, 0, n5);
                    cArray = cArray3;
                }
            }
            if ((c = cArray2[n]) <= ' ') {
                if (bl2) {
                    integerStack.push(n5);
                    integerStack2.push(n);
                    bl2 = false;
                    bl3 = false;
                }
                ++n;
                if (bl3) continue;
                bl3 = bl;
                if (c == N || c == R) continue;
                cArray[n5++] = 32;
                continue;
            }
            bl2 = true;
            ++n;
            cArray[n5++] = c;
        }
        return null;
    }

    public final Enumeration getLineSoftLengthEnumeration(int n, FontMetrics fontMetrics) {
        return new LineEnumeration(this, n, fontMetrics, true);
    }

    public final Enumeration getLineSoftLengthEnumeration(int n, FontMetrics fontMetrics, boolean bl) {
        return new LineEnumeration(this, n, fontMetrics, bl);
    }

    public final int getLineStart(int n) {
        if (n < 0 || this.intLength == 0) {
            return -1;
        }
        int n2 = 0;
        while (n-- > 0) {
            int n3 = this.getIndexOf(N, n2);
            if (n3 == -1) {
                return -1;
            }
            n2 = n3 + 1;
        }
        return n2;
    }

    public final int getNextLineStart() {
        return this.intNextLineStart;
    }

    public final int getRowNumber(int n) {
        int n2 = this.getLastIndexOf(N, n);
        return n - n2;
    }

    public final String getSubstring(int n) {
        return this.getSubstring(n, this.intLength);
    }

    public final String getSubstring(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (n2 > this.intLength) {
            n2 = this.intLength;
        }
        if (n > this.intLength) {
            n = this.intLength;
        }
        return new String(this.charsValue, n, n2 - n);
    }

    public final int hashCode() {
        int n = 0;
        int n2 = 0;
        char[] cArray = this.charsValue;
        int n3 = this.intLength;
        if (n3 < 16) {
            int n4 = n3;
            while (n4 > 0) {
                n = n * 37 + cArray[n2++];
                --n4;
            }
        } else {
            int n5 = n3 / 8;
            int n6 = n3;
            while (n6 > 0) {
                n = n * 39 + cArray[n2];
                n6 -= n5;
                n2 += n5;
            }
        }
        return n;
    }

    public void init(int n) {
        if (this.charsValue == null) {
            this.charsValue = new char[n + 16];
        } else {
            this.ensureCapacity(n);
        }
    }

    public final StringBufferExtended insert(int n, char c) {
        int n2 = this.intLength + 1;
        if (n2 > this.charsValue.length) {
            this.ensureCapacity(n2);
        }
        System.arraycopy(this.charsValue, n, this.charsValue, n + 1, this.intLength - n);
        this.charsValue[n] = c;
        this.intLength = n2;
        return this;
    }

    public final StringBufferExtended insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public final StringBufferExtended insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public final StringBufferExtended insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public final StringBufferExtended insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public final StringBufferExtended insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public final StringBufferExtended insert(int n, String string) {
        int n2 = string.length();
        int n3 = this.intLength + n2;
        if (n3 > this.charsValue.length) {
            this.ensureCapacity(n3);
        }
        System.arraycopy(this.charsValue, n, this.charsValue, n + n2, this.intLength - n);
        string.getChars(0, n2, this.charsValue, n);
        this.intLength = n3;
        return this;
    }

    public final StringBufferExtended insert(int n, StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        int n3 = this.intLength + n2;
        if (n3 > this.charsValue.length) {
            this.ensureCapacity(n3);
        }
        System.arraycopy(this.charsValue, n, this.charsValue, n + n2, this.intLength - n);
        stringBuffer.getChars(0, n2, this.charsValue, n);
        this.intLength = n3;
        return this;
    }

    public final StringBufferExtended insert(int n, StringBufferExtended stringBufferExtended) {
        return this.insert(n, stringBufferExtended.charsValue, 0, stringBufferExtended.intLength);
    }

    public final StringBufferExtended insert(int n, StringBufferExtended stringBufferExtended, int n2, int n3) {
        return this.insert(n, stringBufferExtended.charsValue, n2, n3);
    }

    public final StringBufferExtended insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public final StringBufferExtended insert(int n, char[] cArray) {
        return this.insert(n, cArray, 0, cArray.length);
    }

    public final StringBufferExtended insert(int n, char[] cArray, int n2, int n3) {
        int n4 = this.intLength + n3;
        if (n4 > this.charsValue.length) {
            this.ensureCapacity(n4);
        }
        System.arraycopy(this.charsValue, n, this.charsValue, n + n3, this.intLength - n);
        System.arraycopy(cArray, n2, this.charsValue, n, n3);
        this.intLength = n4;
        return this;
    }

    public final boolean isEmpty() {
        return this.intLength == 0;
    }

    public final boolean isMatchingRegion(String string, int n, boolean bl) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        return this.isMatchingRegion(cArray, 0, n2, n, bl);
    }

    public final boolean isMatchingRegion(StringBuffer stringBuffer, int n, boolean bl) {
        int n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return this.isMatchingRegion(cArray, 0, n2, n, bl);
    }

    public final boolean isMatchingRegion(StringBufferExtended stringBufferExtended, int n, int n2, int n3, boolean bl) {
        return this.isMatchingRegion(stringBufferExtended.charsValue, n, n2, n3, bl);
    }

    public final boolean isMatchingRegion(char[] cArray, int n, int n2, int n3, boolean bl) {
        if (n < 0 || n > cArray.length || n2 < 0 || n2 + n > cArray.length || n3 > this.intLength) {
            throw new IllegalArgumentException();
        }
        if (this.intLength - n3 < n2) {
            return false;
        }
        char[] cArray2 = this.charsValue;
        int n4 = n3;
        int n5 = n;
        while (n2-- != 0) {
            char c;
            char c2;
            if ((c2 = cArray2[n4++]) == (c = cArray[n5++])) continue;
            if (bl) {
                char c3;
                char c4;
                char c5 = Character.toUpperCase(c2);
                if (c5 == (c4 = Character.toUpperCase(c))) continue;
                char c6 = Character.toLowerCase(c2);
                if (c6 != (c3 = Character.toLowerCase(c))) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Throwable {
        StringBufferExtended stringBufferExtended = new StringBufferExtended("schau mer ma: {0} {1}");
        StringBufferExtended stringBufferExtended2 = new StringBufferExtended();
        Object[] objectArray = new Object[]{"geht"};
        try {
            stringBufferExtended2 = stringBufferExtended.fillInNumberTemplate(stringBufferExtended2, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println(stringBufferExtended2);
        objectArray = new Object[]{"ignore", "ja"};
        try {
            stringBufferExtended2 = stringBufferExtended2.fillInNumberTemplate(null, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println(stringBufferExtended2);
    }

    public final StringBufferExtended overwrite(char c, int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            return this;
        }
        if (n >= this.intLength) {
            return this;
        }
        if (n2 >= this.intLength) {
            n2 = this.intLength - 1;
        }
        char[] cArray = this.charsValue;
        int n3 = n;
        while (n3 <= n2) {
            cArray[n3] = c;
            ++n3;
        }
        return this;
    }

    public final StringBufferExtended reduceSpaces() {
        int n = this.intLength;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = this.charsValue;
        boolean bl = false;
        while (n2 < n) {
            char c;
            if ((c = cArray[n2++]) > ' ') {
                cArray[n3++] = c;
                bl = true;
                continue;
            }
            if (!bl) continue;
            cArray[n3++] = 32;
            bl = false;
        }
        this.intLength = n3;
        return this;
    }

    public final StringBufferExtended reduceSpaces(boolean bl) {
        int n = this.intLength;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = this.charsValue;
        boolean bl2 = false;
        while (n2 < n) {
            char c;
            if ((c = cArray[n2++]) > ' ' || bl && (c == '\n' || c == '\r')) {
                cArray[n3++] = c;
                if (c == '\n' || c == '\r') continue;
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            cArray[n3++] = 32;
            bl2 = false;
        }
        this.intLength = n3;
        return this;
    }

    public final StringBufferExtended replace(char c, char c2) {
        if (c != c2) {
            int n = this.intLength;
            char[] cArray = this.charsValue;
            int n2 = n;
            while (n2-- > 0) {
                if (cArray[n2] != c) continue;
                cArray[n2] = c2;
            }
        }
        return this;
    }

    public final StringBufferExtended replace(String string, String string2, boolean bl) {
        int n = string.length();
        int n2 = string2.length();
        char[] cArray = new char[n];
        char[] cArray2 = new char[n2];
        string.getChars(0, n, cArray, 0);
        string2.getChars(0, n2, cArray2, 0);
        return this.replace(cArray, 0, n, cArray2, 0, n2, bl);
    }

    public final StringBufferExtended replace(StringBufferExtended stringBufferExtended, int n, int n2, StringBufferExtended stringBufferExtended2, int n3, int n4, boolean bl) {
        return this.replace(stringBufferExtended.charsValue, n, n2, stringBufferExtended2.charsValue, n3, n4, bl);
    }

    public final StringBufferExtended replace(StringBufferExtended stringBufferExtended, int n, int n2, char[] cArray, int n3, int n4, boolean bl) {
        return this.replace(stringBufferExtended.charsValue, n, n2, cArray, n3, n4, bl);
    }

    public final StringBufferExtended replace(char[] cArray, int n, int n2, StringBufferExtended stringBufferExtended, int n3, int n4, boolean bl) {
        return this.replace(cArray, n, n2, stringBufferExtended.charsValue, n3, n4, bl);
    }

    public final StringBufferExtended replace(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, boolean bl) {
        if (cArray == null || cArray2 == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n + n2 > cArray.length || n3 + n4 > cArray2.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return this;
        }
        int n5 = 0;
        while ((n5 = bl ? this.getIndexOfIgnoreCase(cArray, n, n2, n5) : this.getIndexOf(cArray, n, n2, n5)) != -1) {
            if (n2 == n4) {
                System.arraycopy(cArray2, n3, this.charsValue, n5, n4);
            } else if (n2 > n4) {
                if (n4 > 0) {
                    System.arraycopy(cArray2, n3, this.charsValue, n5, n4);
                }
                this.delete(n5 + n4, n2 - n4);
            } else {
                System.arraycopy(cArray2, n3, this.charsValue, n5, n2);
                this.insert(n5 + n2, cArray2, n3 + n2, n4 - n2);
            }
            n5 += n4;
        }
        return this;
    }

    public final StringBufferExtended replaceTabsWithSpaces(int n) {
        return this.replaceTabsWithSpaces(new int[]{n});
    }

    public final StringBufferExtended replaceTabsWithSpaces(int[] nArray) {
        int n;
        int n2;
        int n3;
        if (nArray == null) {
            throw new NullPointerException("tabStops must not be null");
        }
        int n4 = nArray.length;
        char[] cArray = null;
        if (n4 > 0) {
            n3 = 0;
            int n5 = 0;
            n2 = 0;
            while (n2 < n4) {
                n = nArray[n2];
                if (n < 0) {
                    throw new IllegalArgumentException("negative tab stop at position #" + n2 + " (" + n + ')');
                }
                n3 = Math.max(n3, n);
                if (n > 0) {
                    nArray[n5++] = n;
                }
                ++n2;
            }
            n4 = n5;
            cArray = StringBufferExtended.createFilledCharArray(' ', n3);
        }
        if (n4 == 0 || this.intLength == 0) {
            return this;
        }
        --n4;
        n3 = this.intLength;
        char[] cArray2 = (char[])this.charsValue.clone();
        this.clear();
        n2 = 0;
        n = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            char c = cArray2[n7];
            if (c == N) {
                n2 = 0;
                n6 = 0;
                n = 0;
                this.append(c);
            } else {
                if (n2 == n6) {
                    n2 += nArray[n];
                    if (n < n4) {
                        ++n;
                    }
                }
                if (c == '\t') {
                    this.append(cArray, 0, n2 - n6);
                    n6 = n2;
                } else {
                    ++n6;
                    this.append(c);
                }
            }
            ++n7;
        }
        return this;
    }

    public final StringBufferExtended reverse() {
        int n = this.intLength - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            char c = this.charsValue[n2];
            this.charsValue[n2] = this.charsValue[n - n2];
            this.charsValue[n - n2] = c;
            --n2;
        }
        return this;
    }

    public final void setCharArray(char[] cArray, int n) {
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n > cArray.length || n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.charsValue = cArray;
        this.intLength = n;
    }

    public final void setCharAt(int n, char c) {
        if (n < 0 || n >= this.intLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.charsValue[n] = c;
    }

    public final void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.charsValue.length) {
            this.ensureCapacity(n);
        }
        if (this.intLength < n) {
            while (this.intLength < n) {
                this.charsValue[this.intLength] = '\u0000';
                ++this.intLength;
            }
        } else {
            this.intLength = n;
        }
    }

    public final void setLengthIndex(int n) {
        if (n < 0 || n > this.charsValue.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.intLength = n;
    }

    public final void setNextLineStart(int n) {
        this.intNextLineStart = n;
    }

    public final boolean startsWith(String string) {
        int n = string.length();
        if (this.intLength < n) {
            return false;
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.isMatchingRegion(cArray, 0, n, 0, false);
    }

    public final boolean startsWith(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (this.intLength < n) {
            return false;
        }
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return this.isMatchingRegion(cArray, 0, n, 0, false);
    }

    public final boolean startsWith(StringBufferExtended stringBufferExtended) {
        if (this.intLength < stringBufferExtended.intLength) {
            return false;
        }
        return this.isMatchingRegion(stringBufferExtended.charsValue, 0, stringBufferExtended.intLength, 0, false);
    }

    public final boolean startsWith(StringBufferExtended stringBufferExtended, int n, int n2) {
        if (this.intLength < n2) {
            return false;
        }
        return this.isMatchingRegion(stringBufferExtended.charsValue, n, n2, 0, false);
    }

    public final boolean startsWith(char[] cArray) {
        if (this.intLength < cArray.length) {
            return false;
        }
        return this.isMatchingRegion(cArray, 0, cArray.length, 0, false);
    }

    public final boolean startsWith(char[] cArray, int n, int n2) {
        if (this.intLength < n2) {
            return false;
        }
        return this.isMatchingRegion(cArray, n, n2, 0, false);
    }

    public final StringBufferExtended stripSpaces() {
        int n = this.intLength;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = this.charsValue;
        while (n2 < n) {
            char c;
            if ((c = cArray[n2++]) <= ' ') continue;
            cArray[n3++] = c;
        }
        this.intLength = n3;
        return this;
    }

    public static void testAppend() throws Throwable {
        int n;
        long l = System.currentTimeMillis();
        StringBufferExtended stringBufferExtended = new StringBufferExtended(10000000);
        System.out.println("preparing jit");
        int n2 = 3;
        while (n2-- > 0) {
            int n3 = -100000;
            while (n3 < 100000) {
                stringBufferExtended.append(String.valueOf(n3));
                ++n3;
            }
            stringBufferExtended.clear();
            n3 = -100000;
            while (n3 < 100000) {
                stringBufferExtended.append_(n3);
                ++n3;
            }
            stringBufferExtended.clear();
            n3 = 2147383647;
            while (n3 < Integer.MAX_VALUE) {
                stringBufferExtended.append(n3);
                ++n3;
            }
            stringBufferExtended.clear();
            n3 = -2147483647;
            while (n3 < -2147383647) {
                stringBufferExtended.append(n3);
                ++n3;
            }
        }
        System.out.println("\t\tpos\t\tneg\t\t0\t\t1");
        System.out.print("internal:\t");
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        long l2 = System.currentTimeMillis();
        int n4 = 1000;
        while (n4-- > 0) {
            stringBufferExtended.clear();
            int n5 = 2147383647;
            while (n5 < Integer.MAX_VALUE) {
                stringBufferExtended.append(n5);
                ++n5;
            }
        }
        long l3 = System.currentTimeMillis();
        System.out.print(l3 - l2);
        System.out.print("\t\t");
        int n6 = stringBufferExtended.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        int n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = -2147483647;
            while (n < -2147383647) {
                stringBufferExtended.append(n);
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.print(l3 - l2);
        System.out.print("\t\t");
        int n8 = stringBufferExtended.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = -2147483647;
            while (n < -2147383647) {
                stringBufferExtended.append(0);
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.print(l3 - l2);
        System.out.print("\t\t");
        int n9 = stringBufferExtended.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = -2147483647;
            while (n < -2147383647) {
                stringBufferExtended.append(1);
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.println(l3 - l2);
        int n10 = stringBufferExtended.hashCode();
        System.out.print("test    :\t");
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = 2147383647;
            while (n < Integer.MAX_VALUE) {
                stringBufferExtended.append_(n);
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.print(l3 - l2);
        System.out.print("\t\t");
        if (n6 != stringBufferExtended.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        n6 = stringBufferExtended.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = -2147483647;
            while (n < -2147383647) {
                stringBufferExtended.append_(n);
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.print(l3 - l2);
        System.out.print("\t\t");
        if (n8 != stringBufferExtended.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        n8 = stringBufferExtended.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = -2147483647;
            while (n < -2147383647) {
                stringBufferExtended.append_(0);
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.print(l3 - l2);
        System.out.print("\t\t");
        if (n9 != stringBufferExtended.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        n9 = stringBufferExtended.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = -2147483647;
            while (n < -2147383647) {
                stringBufferExtended.append_(1);
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.println(l3 - l2);
        if (n10 != stringBufferExtended.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        n10 = stringBufferExtended.hashCode();
        System.out.print("String  :\t");
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = 2147383647;
            while (n < Integer.MAX_VALUE) {
                stringBufferExtended.append(String.valueOf(n));
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.print(l3 - l2);
        System.out.print("\t\t");
        if (n6 != stringBufferExtended.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        n6 = stringBufferExtended.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = -2147483647;
            while (n < -2147383647) {
                stringBufferExtended.append(String.valueOf(n));
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.print(l3 - l2);
        System.out.print("\t\t");
        if (n8 != stringBufferExtended.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        n8 = stringBufferExtended.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = -2147483647;
            while (n < -2147383647) {
                stringBufferExtended.append(String.valueOf(0));
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.print(l3 - l2);
        System.out.print("\t\t");
        if (n9 != stringBufferExtended.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        n9 = stringBufferExtended.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        l2 = System.currentTimeMillis();
        n7 = 1000;
        while (n7-- > 0) {
            stringBufferExtended.clear();
            n = -2147483647;
            while (n < -2147383647) {
                stringBufferExtended.append(String.valueOf(1));
                ++n;
            }
        }
        l3 = System.currentTimeMillis();
        System.out.println(l3 - l2);
        if (n10 != stringBufferExtended.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        n10 = stringBufferExtended.hashCode();
        long l4 = System.currentTimeMillis();
        System.out.println("\ntotal Test time: " + (l4 - l));
    }

    public final byte[] toByteArray() {
        return this.toByteArray(0, this.intLength);
    }

    public final byte[] toByteArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            n = this.intLength;
        }
        if (n + n2 > this.intLength) {
            n2 = this.intLength - n;
        }
        byte[] byArray = new byte[n2];
        char[] cArray = this.charsValue;
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4++] = (byte)cArray[n3++];
        }
        return byArray;
    }

    public final char[] toCharArray() {
        return this.toCharArray(0, this.intLength);
    }

    public final char[] toCharArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            n = this.intLength;
        }
        if (n + n2 > this.intLength) {
            n2 = this.intLength - n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.charsValue, n, cArray, 0, n2);
        return cArray;
    }

    public final String toString() {
        return this.toString(0, this.intLength);
    }

    public final String toString(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            n = this.intLength;
        }
        if (n + n2 > this.intLength) {
            n2 = this.intLength - n;
        }
        return new String(this.charsValue, n, n2);
    }

    public final StringBuffer toStringBuffer() {
        return this.toStringBuffer(0, this.intLength);
    }

    public final StringBuffer toStringBuffer(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            n = this.intLength;
        }
        if (n + n2 > this.intLength) {
            n2 = this.intLength - n;
        }
        return new StringBuffer(n2).append(this.charsValue, n, n2);
    }

    public final StringBufferExtended trim() {
        int n = this.intLength;
        int n2 = 0;
        char[] cArray = this.charsValue;
        while (n2 < n && cArray[n2] <= ' ') {
            ++n2;
        }
        while (n2 < n && cArray[n - 1] <= ' ') {
            --n;
        }
        this.intLength = n - n2;
        System.arraycopy(cArray, n2, cArray, 0, this.intLength);
        return this;
    }

    public final StringBufferExtended trimLeft() {
        int n = this.intLength;
        int n2 = 0;
        char[] cArray = this.charsValue;
        while (n2 < n && cArray[n2] <= ' ') {
            ++n2;
        }
        this.intLength = n - n2;
        System.arraycopy(cArray, n2, cArray, 0, this.intLength);
        return this;
    }

    public final StringBufferExtended trimRight() {
        int n = this.intLength;
        char[] cArray = this.charsValue;
        while (n > 0 && cArray[n - 1] <= ' ') {
            --n;
        }
        this.intLength = n;
        return this;
    }

    static int access$intLength(StringBufferExtended stringBufferExtended) {
        return stringBufferExtended.intLength;
    }

    static int access$intNextLineStart(StringBufferExtended stringBufferExtended) {
        return stringBufferExtended.intNextLineStart;
    }

    private class LineEnumeration
    implements Enumeration {
        /* synthetic */ StringBufferExtended this$0;
        private int intLineCounter = 0;
        private int intType = 0;
        private int intWidth = 0;
        private FontMetrics fmMetrics = null;

        LineEnumeration(StringBufferExtended stringBufferExtended) {
            this.this$0 = stringBufferExtended;
        }

        LineEnumeration(StringBufferExtended stringBufferExtended, int n) {
            this.this$0 = stringBufferExtended;
            this.intType = 1;
            this.intWidth = n;
        }

        LineEnumeration(StringBufferExtended stringBufferExtended, int n, FontMetrics fontMetrics, boolean bl) {
            this.this$0 = stringBufferExtended;
            this.intType = bl ? 2 : 3;
            this.intWidth = n;
            this.fmMetrics = fontMetrics;
        }

        public Object nextElement() {
            String string;
            switch (this.intType) {
                case 0: {
                    string = this.this$0.getLineHardBreak(this.intLineCounter, false);
                    break;
                }
                case 1: {
                    string = this.this$0.getLineFixedLength(this.intLineCounter, this.intWidth);
                    break;
                }
                case 2: {
                    string = this.this$0.getLineSoftLength(this.intLineCounter, this.intWidth, this.fmMetrics, true);
                    break;
                }
                case 3: {
                    string = this.this$0.getLineSoftLength(this.intLineCounter, this.intWidth, this.fmMetrics, false);
                    break;
                }
                default: {
                    string = "";
                }
            }
            this.intLineCounter = StringBufferExtended.access$intNextLineStart(this.this$0);
            return string;
        }

        public boolean hasMoreElements() {
            return this.intLineCounter < StringBufferExtended.access$intLength(this.this$0);
        }

        static void access$intLineCounter(LineEnumeration lineEnumeration, int n) {
            lineEnumeration.intLineCounter = n;
        }
    }
}

