/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.admin.awt;

import java.util.EmptyStackException;
import net.zerotoaster.admin.awt.StringBufferExtended;

public class IntegerStack
implements Cloneable {
    private int intLength = 0;
    private int[] intsValues = new int[16];

    public final void clear() {
        this.intLength = 0;
    }

    public Object clone() {
        try {
            IntegerStack integerStack = (IntegerStack)super.clone();
            integerStack.intsValues = (int[])this.intsValues.clone();
            return integerStack;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone failed on IntegerStack " + this);
        }
    }

    private final void enlarge() {
        int n = this.intLength + 16;
        int[] nArray = new int[n];
        System.arraycopy(this.intsValues, 0, nArray, 0, this.intLength);
        this.intsValues = nArray;
    }

    public final int getElementAt(int n) {
        if (n < 0 || n > this.intLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.intsValues[n];
    }

    public final int getSize() {
        return this.intLength;
    }

    public final boolean isEmpty() {
        return this.intLength == 0;
    }

    public final int peek() {
        int n = this.intLength;
        if (n == 0) {
            throw new EmptyStackException();
        }
        return this.intsValues[n];
    }

    public final int pop() {
        if (this.intLength == 0) {
            throw new EmptyStackException();
        }
        return this.intsValues[--this.intLength];
    }

    public final void push(int n) {
        if (this.intLength == this.intsValues.length) {
            this.enlarge();
        }
        this.intsValues[this.intLength++] = n;
    }

    public final void removeElement(int n) {
        int[] nArray = this.intsValues;
        int n2 = this.intLength;
        while (n2-- > 0) {
            if (nArray[n2] != n) continue;
            --this.intLength;
            if (n2 >= this.intLength) continue;
            System.arraycopy(nArray, n2 + 1, nArray, n2, this.intLength - n2);
        }
    }

    public final int removeElementAt(int n) {
        if (n < 0 || n >= this.intLength) {
            throw new ArrayIndexOutOfBoundsException("index=" + n + ", max=" + (this.intLength - 1));
        }
        int n2 = this.intsValues[n];
        --this.intLength;
        if (n < this.intLength) {
            System.arraycopy(this.intsValues, n + 1, this.intsValues, n, this.intLength - n);
        }
        return n2;
    }

    public String toString() {
        StringBufferExtended stringBufferExtended = new StringBufferExtended();
        stringBufferExtended.append("IntegerStack {");
        boolean bl = false;
        int n = this.intLength;
        while (n-- > 0) {
            if (!bl) {
                bl = true;
            } else {
                stringBufferExtended.append(',');
            }
            stringBufferExtended.append(this.intsValues[n]);
        }
        stringBufferExtended.append('}');
        return stringBufferExtended.toString();
    }
}

