/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.admin.awt;

import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LogContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import net.zerotoaster.admin.awt.ConfigHelp;
import net.zerotoaster.admin.awt.ConfigMenue;
import net.zerotoaster.admin.awt.MessageBox;
import net.zerotoaster.admin.awt.PrivilegeChanged;
import net.zerotoaster.admin.awt.StartSubFrameEvent;
import net.zerotoaster.admin.awt.StateChanger;
import net.zerotoaster.config.Constants;
import net.zerotoaster.event.MTAEvent;
import net.zerotoaster.event.MTAEventListener;
import net.zerotoaster.event.MTAEventQueue;
import net.zerotoaster.storage.RemoteStorageManager_Client;
import net.zerotoaster.storage.StorageException;
import net.zerotoaster.util.Helper;

public class ConfigFrame
extends Frame
implements Constants,
MTAEventListener {
    private static final String LOCAL_CONFIG_FILE = "zt_config.ini";
    private static final long serialVersionUID = 3777719903803293709L;
    protected static Properties prpConfig = null;
    protected static final Font MENUFONT = new Font("dialog", 1, 12);
    protected static LogContext logContext = null;
    protected static RemoteStorageManager_Client smManager = null;
    protected static Hashtable hshSlaves = new Hashtable();
    protected static ConfigHelp frmHelp = null;
    protected static int intRM_Privilege = -1;
    protected static String strRM_UserName = "";
    protected StateChanger stchng = null;
    private String strSavedTitle = null;

    protected void colorComponents(Component component) {
        Color color = new Color(245, 245, 245);
        SystemColor systemColor = SystemColor.control;
        if (component instanceof Container) {
            component.setBackground(systemColor);
            component.setForeground(Color.black);
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                this.colorComponents(container.getComponent(n));
                ++n;
            }
            return;
        }
        if (component instanceof TextComponent) {
            component.setBackground(color);
            component.setForeground(Color.black);
            return;
        }
        if (component instanceof List) {
            component.setBackground(color);
            component.setForeground(Color.black);
            return;
        }
        if (component instanceof Component) {
            component.setBackground(systemColor);
            component.setForeground(Color.black);
            return;
        }
    }

    protected void colorComponents_disable(Component component) {
        Color color = Color.lightGray;
        Color color2 = Color.gray;
        if (component instanceof Container) {
            component.setBackground(color);
            component.setForeground(color2);
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                this.colorComponents_disable(container.getComponent(n));
                ++n;
            }
        }
        if (component instanceof TextComponent) {
            component.setBackground(color);
            component.setForeground(color2);
            return;
        }
        if (component instanceof List) {
            component.setBackground(color);
            component.setForeground(color2);
            return;
        }
        if (component instanceof Component) {
            component.setBackground(color);
            component.setForeground(color2);
            return;
        }
    }

    private void config_load() {
        block4: {
            prpConfig = new Properties();
            File file = new File(LOCAL_CONFIG_FILE);
            FileInputStream fileInputStream = null;
            if (!file.exists()) break block4;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    prpConfig.load(fileInputStream);
                }
                catch (IOException iOException) {
                    this.handleException(iOException);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                Helper.close(fileInputStream);
                throw throwable;
            }
            Object var3_6 = null;
            Helper.close(fileInputStream);
        }
    }

    private void config_save() {
        new File(LOCAL_CONFIG_FILE);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(LOCAL_CONFIG_FILE);
                prpConfig.save(fileOutputStream, "");
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            Helper.close(fileOutputStream);
            throw throwable;
        }
        Object var2_5 = null;
        Helper.close(fileOutputStream);
    }

    public void dispose() {
        this.setVisible(false);
        if (this.stchng != null) {
            this.stchng.dispose();
            this.stchng = null;
        }
        super.dispose();
        if (this instanceof ConfigMenue) {
            Enumeration enumeration = hshSlaves.elements();
            while (enumeration.hasMoreElements()) {
                ((ConfigFrame)enumeration.nextElement()).dispose();
            }
            this.config_save();
            System.exit(0);
        }
    }

    protected void handleException(Throwable throwable) {
        if (throwable instanceof InitializationException || throwable instanceof StorageException) {
            MessageBox.OK(this, "Error !", "An error has occurred.\nSee error log");
        } else {
            logContext.write("! An internal error occured", throwable);
            MessageBox.OK(this, "Error !", String.valueOf(throwable.toString()) + "\n\nSee error log");
        }
    }

    protected void init() {
        MTAEventQueue.addListener(this);
        this.stchng = new StateChanger(this.getTitle());
        if (prpConfig == null) {
            this.config_load();
        }
    }

    public void licenceCheck() {
        try {
            String string = smManager.licenceCheck();
            if (string != null && string.length() > 0) {
                MessageBox.OK(this, "LicenceManager", string);
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public void mtaEvent(MTAEvent mTAEvent) {
        if (mTAEvent instanceof StartSubFrameEvent) {
            MTAEventQueue.consume();
            ((StartSubFrameEvent)mTAEvent).getConfigFrame().setVisible(true);
        }
        boolean cfr_ignored_0 = mTAEvent instanceof PrivilegeChanged;
    }

    public void setTitle(String string) {
        this.strSavedTitle = string;
        super.setTitle(string);
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.windowPos_save(this);
        }
        if (bl && this.isVisible()) {
            this.toFront();
            return;
        }
        if (bl) {
            this.windowPos_load(this);
        }
        super.setVisible(bl);
        if (bl) {
            try {
                URL uRL = this.getClass().getResource("/toaster.ico");
                if (uRL != null) {
                    this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected void windowPos_load(Window window) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        String string = window.getName();
        if (((Hashtable)prpConfig).containsKey(String.valueOf(string) + "-x")) {
            n4 = Integer.parseInt(prpConfig.getProperty(String.valueOf(string) + "-x"));
            n3 = Integer.parseInt(prpConfig.getProperty(String.valueOf(string) + "-y"));
            n2 = Integer.parseInt(prpConfig.getProperty(String.valueOf(string) + "-w"));
            n = Integer.parseInt(prpConfig.getProperty(String.valueOf(string) + "-h"));
            ((Component)window).setBounds(n4, n3, n2, n);
            bl = true;
        }
        if (!bl) {
            window.pack();
            n4 = this.getLocation().x;
            n3 = this.getLocation().y;
            n2 = this.getSize().width;
            n = this.getSize().height;
            int n5 = window.getSize().width;
            int n6 = window.getSize().height;
            ((Component)window).setLocation(n4 + n2 / 2 - n5 / 2, n3 + n / 2 - n6 / 2);
            window.pack();
        }
        this.colorComponents(window);
    }

    protected void windowPos_save(Window window) {
        String string = window.getName();
        Rectangle rectangle = window.getBounds();
        if (rectangle.x == 0 && rectangle.y == 0) {
            return;
        }
        ((Hashtable)prpConfig).put(String.valueOf(string) + "-x", String.valueOf(rectangle.x));
        ((Hashtable)prpConfig).put(String.valueOf(string) + "-y", String.valueOf(rectangle.y));
        ((Hashtable)prpConfig).put(String.valueOf(string) + "-w", String.valueOf(rectangle.width));
        ((Hashtable)prpConfig).put(String.valueOf(string) + "-h", String.valueOf(rectangle.height));
    }
}

