/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.admin.awt;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import java.util.Vector;
import net.zerotoaster.admin.awt.ConfigFrame;
import net.zerotoaster.admin.awt.MessageBox;
import net.zerotoaster.admin.awt.PrivilegeChanged;
import net.zerotoaster.admin.awt.StateChangeEvent;
import net.zerotoaster.admin.awt.StateChangeListener;
import net.zerotoaster.admin.awt.StructurePanel;
import net.zerotoaster.event.MTAEvent;
import net.zerotoaster.storage.FilterRecord;
import net.zerotoaster.util.Helper;

public class ConfigFilter
extends ConfigFrame
implements ActionListener,
ItemListener,
WindowListener,
StateChangeListener {
    private Menu ivjmnuFile = null;
    private MenuItem ivjmnuQuit = null;
    private Button ivjbtnCancel = null;
    private Button ivjbtnDelete = null;
    private Button ivjbtnNew = null;
    private Button ivjbtnStore = null;
    private StructurePanel ivjspnlConfig = null;
    private StructurePanel ivjspnlMemo = null;
    private StructurePanel ivjspnlName = null;
    private TextArea ivjtxtMemo = null;
    private TextField ivjtxtName = null;
    private Label ivjLabel1 = null;
    private Label ivjLabel11 = null;
    private Label ivjlblRuleType = null;
    private Button ivjbtnHelp = null;
    private Choice ivjchsFilterType = null;
    private List ivjlstFilters = null;
    private TextField ivjtxtMask = null;
    private MenuBar ivjConfigFilterMenuBar = null;
    private StructurePanel ivjspnlFilterList = null;
    private Checkbox ivjchkAVScan = null;
    private Checkbox ivjchkRBL = null;
    static Class class$java$awt$Window;

    public ConfigFilter() {
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getmnuQuit()) {
            this.connEtoC1();
        }
    }

    public void chsFilterType_ItemStateChanged() {
        int n = this.ivjchsFilterType.getSelectedIndex() + 1;
        switch (n) {
            case 1: {
                this.ivjchkAVScan.setEnabled(true);
                this.ivjchkRBL.setEnabled(true);
                break;
            }
            case 2: 
            case 3: {
                this.ivjchkAVScan.setEnabled(false);
                this.ivjchkRBL.setEnabled(false);
            }
        }
    }

    private void connEtoC1() {
        try {
            this.mnuQuit_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(WindowEvent windowEvent) {
        try {
            this.mnuQuit_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3(ItemEvent itemEvent) {
        try {
            this.lstFilters_ItemStateChanged();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC4(ItemEvent itemEvent) {
        try {
            this.chsFilterType_ItemStateChanged();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    void copyFRtoGUI(FilterRecord filterRecord) {
        ((TextComponent)this.ivjtxtName).setText(filterRecord.getName());
        ((TextComponent)this.ivjtxtMask).setText(filterRecord.getMask());
        this.ivjchsFilterType.select(filterRecord.getFilterType() - 1);
        this.chsFilterType_ItemStateChanged();
        this.ivjtxtMemo.setText(filterRecord.getMemo());
        this.ivjchkAVScan.setState(filterRecord.getAVScan());
        this.ivjchkRBL.setState(filterRecord.getRBLCheck());
        switch (filterRecord.getType()) {
            case 2: {
                this.ivjlblRuleType.setText("Filter by domain");
                break;
            }
            case 3: {
                this.ivjlblRuleType.setText("Filter by network");
                break;
            }
            case 1: {
                this.ivjlblRuleType.setText("Filter by user");
                break;
            }
            default: {
                this.ivjlblRuleType.setText("Unknown filter type");
            }
        }
    }

    boolean copyGUItoFR(FilterRecord filterRecord) {
        String string = Helper.validateFileName(this.ivjtxtName.getText());
        if (string == null) {
            MessageBox.OK(this, "Error", "Name is empty or invalid");
            this.ivjtxtName.requestFocus();
            return false;
        }
        filterRecord.setName(string);
        try {
            filterRecord.setMask(this.ivjtxtMask.getText().trim());
        }
        catch (Throwable throwable) {
            MessageBox.OK(this, "Error", throwable.getMessage());
            this.ivjtxtMask.requestFocus();
            return false;
        }
        int n = this.ivjchsFilterType.getSelectedIndex();
        if (n == -1) {
            MessageBox.OK(this, "Error", "You must select a filter type");
            this.ivjchsFilterType.requestFocus();
            return false;
        }
        filterRecord.setFilterType(n + 1);
        filterRecord.setMemo(this.ivjtxtMemo.getText().trim());
        filterRecord.setAVScan(this.ivjchkAVScan.getState());
        filterRecord.setRBLcheck(this.ivjchkRBL.getState());
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    private Button getbtnCancel() {
        if (this.ivjbtnCancel == null) {
            try {
                this.ivjbtnCancel = new Button();
                this.ivjbtnCancel.setName("btnCancel");
                this.ivjbtnCancel.setLabel("Cancel");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnCancel;
    }

    private Button getbtnDelete() {
        if (this.ivjbtnDelete == null) {
            try {
                this.ivjbtnDelete = new Button();
                this.ivjbtnDelete.setName("btnDelete");
                this.ivjbtnDelete.setLabel("Delete");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnDelete;
    }

    private Button getbtnHelp() {
        if (this.ivjbtnHelp == null) {
            try {
                this.ivjbtnHelp = new Button();
                this.ivjbtnHelp.setName("btnHelp");
                this.ivjbtnHelp.setLabel("Help");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnHelp;
    }

    private Button getbtnNew() {
        if (this.ivjbtnNew == null) {
            try {
                this.ivjbtnNew = new Button();
                this.ivjbtnNew.setName("btnNew");
                this.ivjbtnNew.setLabel("New");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnNew;
    }

    private Button getbtnStore() {
        if (this.ivjbtnStore == null) {
            try {
                this.ivjbtnStore = new Button();
                this.ivjbtnStore.setName("btnStore");
                this.ivjbtnStore.setLabel("Store");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnStore;
    }

    private static void getBuilderData() {
    }

    private Checkbox getchkAVScan() {
        if (this.ivjchkAVScan == null) {
            try {
                this.ivjchkAVScan = new Checkbox();
                this.ivjchkAVScan.setName("chkAVScan");
                this.ivjchkAVScan.setLabel("AV Scan relay mail");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjchkAVScan;
    }

    private Checkbox getchkRBL() {
        if (this.ivjchkRBL == null) {
            try {
                this.ivjchkRBL = new Checkbox();
                this.ivjchkRBL.setName("chkRBL");
                this.ivjchkRBL.setLabel("RBL check relay mail");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjchkRBL;
    }

    private Choice getchsFilterType() {
        if (this.ivjchsFilterType == null) {
            try {
                this.ivjchsFilterType = new Choice();
                this.ivjchsFilterType.setName("chsFilterType");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjchsFilterType;
    }

    private MenuBar getConfigFilterMenuBar() {
        if (this.ivjConfigFilterMenuBar == null) {
            try {
                this.ivjConfigFilterMenuBar = new MenuBar();
                this.ivjConfigFilterMenuBar.setFont(new Font("dialog", 1, 12));
                this.ivjConfigFilterMenuBar.add(this.getmnuFile());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConfigFilterMenuBar;
    }

    private Label getLabel1() {
        if (this.ivjLabel1 == null) {
            try {
                this.ivjLabel1 = new Label();
                this.ivjLabel1.setName("Label1");
                this.ivjLabel1.setText("Mask: 'user@domain.tld', 'domain.tld'");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjLabel1;
    }

    private Label getLabel11() {
        if (this.ivjLabel11 == null) {
            try {
                this.ivjLabel11 = new Label();
                this.ivjLabel11.setName("Label11");
                this.ivjLabel11.setText("or 'network, netmask'.");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjLabel11;
    }

    private Label getlblRuleType() {
        if (this.ivjlblRuleType == null) {
            try {
                this.ivjlblRuleType = new Label();
                this.ivjlblRuleType.setName("lblRuleType");
                this.ivjlblRuleType.setFont(new Font("monospaced", 0, 12));
                this.ivjlblRuleType.setText(".");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjlblRuleType;
    }

    private List getlstFilters() {
        if (this.ivjlstFilters == null) {
            try {
                this.ivjlstFilters = new List(0);
                this.ivjlstFilters.setName("lstFilters");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjlstFilters;
    }

    private Menu getmnuFile() {
        if (this.ivjmnuFile == null) {
            try {
                this.ivjmnuFile = new Menu();
                this.ivjmnuFile.setFont(new Font("dialog", 1, 12));
                this.ivjmnuFile.setLabel("File");
                this.ivjmnuFile.add(this.getmnuQuit());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjmnuFile;
    }

    private MenuItem getmnuQuit() {
        if (this.ivjmnuQuit == null) {
            try {
                this.ivjmnuQuit = new MenuItem();
                this.ivjmnuQuit.setFont(new Font("dialog", 1, 12));
                this.ivjmnuQuit.setLabel("Quit");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjmnuQuit;
    }

    private StructurePanel getspnlConfig() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        if (this.ivjspnlConfig == null) {
            try {
                this.ivjspnlConfig = new StructurePanel();
                this.ivjspnlConfig.setName("spnlConfig");
                ((Component)this.ivjspnlConfig).setFont(new Font("dialog", 0, 12));
                this.ivjspnlConfig.setLayout(new GridBagLayout());
                this.ivjspnlConfig.setBorderText("Config");
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getchsFilterType(), gridBagConstraints);
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 1;
                gridBagConstraints2.gridwidth = 1;
                gridBagConstraints2.gridheight = 1;
                gridBagConstraints2.fill = 2;
                gridBagConstraints2.anchor = 17;
                gridBagConstraints2.weightx = 0.0;
                gridBagConstraints2.weighty = 0.0;
                this.getspnlConfig().add((Component)this.gettxtMask(), gridBagConstraints2);
                gridBagConstraints3.gridx = 0;
                gridBagConstraints3.gridy = 5;
                gridBagConstraints3.gridwidth = 1;
                gridBagConstraints3.gridheight = 1;
                gridBagConstraints3.fill = 2;
                gridBagConstraints3.anchor = 17;
                gridBagConstraints3.weightx = 0.0;
                gridBagConstraints3.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getLabel1(), gridBagConstraints3);
                gridBagConstraints4.gridx = 0;
                gridBagConstraints4.gridy = 6;
                gridBagConstraints4.gridwidth = 1;
                gridBagConstraints4.gridheight = 1;
                gridBagConstraints4.fill = 2;
                gridBagConstraints4.anchor = 17;
                gridBagConstraints4.weightx = 0.0;
                gridBagConstraints4.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getLabel11(), gridBagConstraints4);
                gridBagConstraints5.gridx = 0;
                gridBagConstraints5.gridy = 4;
                gridBagConstraints5.gridwidth = 1;
                gridBagConstraints5.gridheight = 1;
                gridBagConstraints5.fill = 2;
                gridBagConstraints5.anchor = 17;
                gridBagConstraints5.weightx = 0.0;
                gridBagConstraints5.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getlblRuleType(), gridBagConstraints5);
                gridBagConstraints6.gridx = 0;
                gridBagConstraints6.gridy = 2;
                gridBagConstraints6.gridwidth = 1;
                gridBagConstraints6.gridheight = 1;
                gridBagConstraints6.fill = 2;
                gridBagConstraints6.anchor = 17;
                gridBagConstraints6.weightx = 0.0;
                gridBagConstraints6.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getchkAVScan(), gridBagConstraints6);
                gridBagConstraints7.gridx = 0;
                gridBagConstraints7.gridy = 3;
                gridBagConstraints7.gridwidth = 1;
                gridBagConstraints7.gridheight = 1;
                gridBagConstraints7.fill = 2;
                gridBagConstraints7.anchor = 17;
                gridBagConstraints7.weightx = 0.0;
                gridBagConstraints7.weighty = 0.0;
                this.getspnlConfig().add((Component)this.getchkRBL(), gridBagConstraints7);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjspnlConfig;
    }

    private StructurePanel getspnlFilterList() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        if (this.ivjspnlFilterList == null) {
            try {
                this.ivjspnlFilterList = new StructurePanel();
                this.ivjspnlFilterList.setName("spnlFilterList");
                this.ivjspnlFilterList.setLayout(new GridBagLayout());
                this.ivjspnlFilterList.setBorderText("Filters");
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 5;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.1;
                this.getspnlFilterList().add((Component)this.getlstFilters(), gridBagConstraints);
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 1;
                gridBagConstraints2.gridwidth = 1;
                gridBagConstraints2.gridheight = 1;
                gridBagConstraints2.fill = 2;
                gridBagConstraints2.anchor = 17;
                gridBagConstraints2.weightx = 0.0;
                gridBagConstraints2.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnNew(), gridBagConstraints2);
                gridBagConstraints3.gridx = 1;
                gridBagConstraints3.gridy = 1;
                gridBagConstraints3.gridwidth = 1;
                gridBagConstraints3.gridheight = 1;
                gridBagConstraints3.fill = 2;
                gridBagConstraints3.anchor = 17;
                gridBagConstraints3.weightx = 0.0;
                gridBagConstraints3.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnStore(), gridBagConstraints3);
                gridBagConstraints4.gridx = 2;
                gridBagConstraints4.gridy = 1;
                gridBagConstraints4.gridwidth = 1;
                gridBagConstraints4.gridheight = 1;
                gridBagConstraints4.fill = 2;
                gridBagConstraints4.anchor = 17;
                gridBagConstraints4.weightx = 0.0;
                gridBagConstraints4.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnCancel(), gridBagConstraints4);
                gridBagConstraints5.gridx = 3;
                gridBagConstraints5.gridy = 1;
                gridBagConstraints5.gridwidth = 1;
                gridBagConstraints5.gridheight = 1;
                gridBagConstraints5.fill = 2;
                gridBagConstraints5.anchor = 17;
                gridBagConstraints5.weightx = 0.0;
                gridBagConstraints5.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnDelete(), gridBagConstraints5);
                gridBagConstraints6.gridx = 4;
                gridBagConstraints6.gridy = 1;
                gridBagConstraints6.gridwidth = 1;
                gridBagConstraints6.gridheight = 1;
                gridBagConstraints6.fill = 2;
                gridBagConstraints6.anchor = 17;
                gridBagConstraints6.weightx = 0.0;
                gridBagConstraints6.weighty = 0.0;
                this.getspnlFilterList().add((Component)this.getbtnHelp(), gridBagConstraints6);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjspnlFilterList;
    }

    private StructurePanel getspnlMemo() {
        if (this.ivjspnlMemo == null) {
            try {
                this.ivjspnlMemo = new StructurePanel();
                this.ivjspnlMemo.setName("spnlMemo");
                ((Component)this.ivjspnlMemo).setFont(new Font("dialog", 0, 12));
                this.ivjspnlMemo.setLayout(new GridLayout());
                this.ivjspnlMemo.setBorderText("Memo");
                this.getspnlMemo().add((Component)this.gettxtMemo(), this.gettxtMemo().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjspnlMemo;
    }

    private StructurePanel getspnlName() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.ivjspnlName == null) {
            try {
                this.ivjspnlName = new StructurePanel();
                this.ivjspnlName.setName("spnlName");
                this.ivjspnlName.setLayout(new GridBagLayout());
                this.ivjspnlName.setBorderText("Name");
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                this.getspnlName().add((Component)this.gettxtName(), gridBagConstraints);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjspnlName;
    }

    private TextField gettxtMask() {
        if (this.ivjtxtMask == null) {
            try {
                this.ivjtxtMask = new TextField();
                this.ivjtxtMask.setName("txtMask");
                this.ivjtxtMask.setColumns(30);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjtxtMask;
    }

    private TextArea gettxtMemo() {
        if (this.ivjtxtMemo == null) {
            try {
                this.ivjtxtMemo = new TextArea();
                this.ivjtxtMemo.setName("txtMemo");
                this.ivjtxtMemo.setRows(10);
                this.ivjtxtMemo.setFont(new Font("dialog", 0, 12));
                this.ivjtxtMemo.setColumns(15);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjtxtMemo;
    }

    private TextField gettxtName() {
        if (this.ivjtxtName == null) {
            try {
                this.ivjtxtName = new TextField();
                this.ivjtxtName.setName("txtName");
                this.ivjtxtName.setColumns(30);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjtxtName;
    }

    public void handleException(Throwable throwable) {
        super.handleException(throwable);
    }

    protected void init() {
        ConfigFrame.logContext.write("# Relay configuration init");
        super.init();
        this.ivjchsFilterType.add("Relay configuration");
        this.ivjchsFilterType.add("Whitelist entry");
        this.ivjchsFilterType.add("Blacklist entry");
        this.ivjchsFilterType.select(0);
        this.stchng.setName("Relay Configuration");
        this.stchng.addStateChangeListener(this);
        this.stchng.registerMenuBar(this.ivjConfigFilterMenuBar);
        this.stchng.registerBtnNew(this.ivjbtnNew);
        this.stchng.registerBtnStore(this.ivjbtnStore);
        this.stchng.registerBtnCancel(this.ivjbtnCancel);
        this.stchng.registerBtnDelete(this.ivjbtnDelete);
        this.stchng.registerBtnHelp(this.ivjbtnHelp);
        this.stchng.registerKeyField(this.ivjlstFilters);
        this.stchng.registerChangeTrigger(this.ivjtxtName);
        this.stchng.registerChangeTrigger(this.ivjtxtMask);
        this.stchng.registerChangeTrigger(this.ivjchsFilterType);
        this.stchng.registerChangeTrigger(this.ivjtxtMemo);
        this.stchng.doBrowse();
        ConfigFrame.logContext.write("# Relay configuration ready");
    }

    private void initConnections() {
        this.getmnuQuit().addActionListener(this);
        this.addWindowListener(this);
        this.getlstFilters().addItemListener(this);
        this.getchsFilterType().addItemListener(this);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        this.setName("ConfigFilter");
        this.setMenuBar(this.getConfigFilterMenuBar());
        ((Component)this).setFont(new Font("dialog", 0, 12));
        this.setLayout(new GridBagLayout());
        ((Component)this).setSize(534, 355);
        this.setTitle("Filter configuration");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.getspnlName(), gridBagConstraints);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        this.add((Component)this.getspnlConfig(), gridBagConstraints2);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        this.add((Component)this.getspnlMemo(), gridBagConstraints3);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 3;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.weighty = 0.1;
        this.add((Component)this.getspnlFilterList(), gridBagConstraints4);
        this.initConnections();
        this.init();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.getlstFilters()) {
            this.connEtoC3(itemEvent);
        }
        if (itemEvent.getSource() == this.getchsFilterType()) {
            this.connEtoC4(itemEvent);
        }
    }

    public void lstFilters_ItemStateChanged() {
        String string = this.ivjlstFilters.getSelectedItem();
        if (string == null) {
            this.stchng.setRecordExists(false);
            return;
        }
        FilterRecord filterRecord = ConfigFrame.smManager.filterRead(string);
        if (filterRecord == null) {
            this.stchng.setRecordExists(false);
            MessageBox.OK(this, "", "Cannot read filter '" + string + "' !");
            return;
        }
        this.copyFRtoGUI(filterRecord);
        this.stchng.setRecordExists(true);
    }

    public static void main(String[] stringArray) {
        try {
            ConfigFilter configFilter = new ConfigFilter();
            try {
                Class<?> clazz = Class.forName("com.ibm.uvm.abt.edit.WindowCloser");
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$java$awt$Window;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$java$awt$Window = Class.forName("java.awt.Window");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class[] classArray2 = classArray;
                Object[] objectArray = new Object[]{configFilter};
                Constructor<?> constructor = clazz.getConstructor(classArray2);
                constructor.newInstance(objectArray);
            }
            catch (Throwable throwable) {}
            configFilter.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("In main() von net.zerotoaster.admin.awt.ConfigFrame trat eine Ausnahmebedingung auf");
            throwable.printStackTrace(System.out);
        }
    }

    public void mnuQuit_ActionEvents() {
        this.setVisible(false);
    }

    public void mtaEvent(MTAEvent mTAEvent) {
        if (mTAEvent instanceof PrivilegeChanged) {
            switch (ConfigFrame.intRM_Privilege) {
                case -1: 
                case 0: 
                case 1: 
                case 3: {
                    super.setVisible(false);
                    return;
                }
            }
        }
        super.mtaEvent(mTAEvent);
    }

    void refreshFilterList(String string) {
        this.ivjlstFilters.removeAll();
        if (!this.isVisible()) {
            return;
        }
        Vector vector = ConfigFrame.smManager.filterReadAll();
        int n = 0;
        while (n < vector.size()) {
            this.ivjlstFilters.addItem((String)vector.elementAt(n));
            ++n;
        }
        if (this.ivjlstFilters.getItemCount() == 0) {
            this.stchng.setRecordExists(false);
            this.copyFRtoGUI(new FilterRecord());
            return;
        }
        this.ivjlstFilters.select(0);
        if (string != null) {
            n = 0;
            while (n < this.ivjlstFilters.getItemCount()) {
                if (this.ivjlstFilters.getItem(n).equals(string)) {
                    this.ivjlstFilters.select(n);
                    break;
                }
                ++n;
            }
        }
        this.lstFilters_ItemStateChanged();
    }

    public void setVisible(boolean bl) {
        switch (ConfigFrame.intRM_Privilege) {
            case -1: 
            case 0: 
            case 1: 
            case 3: {
                super.setVisible(false);
                return;
            }
        }
        super.setVisible(bl);
        if (bl) {
            this.refreshFilterList(null);
        }
    }

    public void stateChanged(StateChangeEvent stateChangeEvent) {
        FilterRecord filterRecord = new FilterRecord();
        String string = null;
        switch (stateChangeEvent.getState()) {
            case 7: {
                ConfigFrame.frmHelp.showHelp(this);
                break;
            }
            case 3: {
                this.copyFRtoGUI(new FilterRecord());
                this.ivjtxtName.requestFocus();
                break;
            }
            case 5: {
                if (!this.copyGUItoFR(filterRecord)) {
                    stateChangeEvent.reset();
                    break;
                }
                ((Component)this).setCursor(new Cursor(3));
                ConfigFrame.smManager.filterWrite(filterRecord);
                this.copyFRtoGUI(filterRecord);
                this.refreshFilterList(filterRecord.getName());
                this.stchng.doBrowse();
                ((Component)this).setCursor(new Cursor(0));
                break;
            }
            case 6: {
                if (!MessageBox.OK_CANCEL(this, "", "Are you sure to abort this operation ?")) {
                    stateChangeEvent.reset();
                    break;
                }
                ((Component)this).setCursor(new Cursor(3));
                string = this.ivjlstFilters.getSelectedItem();
                if (string != null) {
                    filterRecord = ConfigFrame.smManager.filterRead(string);
                }
                this.copyFRtoGUI(filterRecord);
                this.stchng.doBrowse();
                ((Component)this).setCursor(new Cursor(0));
                break;
            }
            case 4: {
                string = this.ivjlstFilters.getSelectedItem();
                if (string == null) {
                    stateChangeEvent.reset();
                    break;
                }
                if (!MessageBox.OK_CANCEL(this, "Warning", "Are you sure to delete filter '" + string + "' ?")) {
                    stateChangeEvent.reset();
                    break;
                }
                ((Component)this).setCursor(new Cursor(3));
                ConfigFrame.smManager.filterDelete(string);
                this.refreshFilterList(null);
                ((Component)this).setCursor(new Cursor(0));
                this.stchng.doBrowse();
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.connEtoC2(windowEvent);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

