/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.admin.awt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Vector;
import net.zerotoaster.admin.awt.ConfigFrame;
import net.zerotoaster.admin.awt.MessageBox;
import net.zerotoaster.admin.awt.PrivilegeChanged;
import net.zerotoaster.admin.awt.SeparatorPanel;
import net.zerotoaster.admin.awt.SeparatorPanelProperties;
import net.zerotoaster.event.MTAEvent;
import net.zerotoaster.io.RemoteFile;
import net.zerotoaster.util.Helper;

public class ConfigFilemanager
extends ConfigFrame
implements ActionListener,
ItemListener,
WindowListener {
    private String strCurrentPath = "";
    private String strRemotePathSeparator = "";
    private RemoteFile[] rfCurrentList = new RemoteFile[0];
    private String strCurrentEdit = "";
    private String strCurrentLocalDirectory = "";
    private Menu ivjmnuFile = null;
    private MenuItem ivjmnuQuit = null;
    private Button ivjbtnDelete = null;
    private Button ivjbtnDownload = null;
    private Button ivjbtnEdit = null;
    private Button ivjbtnSave = null;
    private Button ivjbtnUpload = null;
    private MenuBar ivjConfigFilemanagerMenuBar = null;
    private Label ivjlblPath = null;
    private Label ivjlblStatus = null;
    private List ivjlstFiles = null;
    private Panel ivjpnlAction = null;
    private TextArea ivjtxtContent = null;
    private FlowLayout ivjpnlActionFlowLayout = null;
    private SeparatorPanel ivjSeparatorPanel1 = null;
    private SeparatorPanel ivjSeparatorPanel11 = null;
    private Button ivjbtnHelp = null;
    private SeparatorPanel ivjSeparatorPanel111 = null;
    private Button ivjbtnZeroToasterIni = null;
    private Label ivjLabel1 = null;
    static Class class$java$awt$Window;

    public ConfigFilemanager() {
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getmnuQuit()) {
            this.connEtoC1();
        }
        if (actionEvent.getSource() == this.getlstFiles()) {
            this.connEtoC3();
        }
        if (actionEvent.getSource() == this.getbtnEdit()) {
            this.connEtoC5();
        }
        if (actionEvent.getSource() == this.getbtnDownload()) {
            this.connEtoC6();
        }
        if (actionEvent.getSource() == this.getbtnUpload()) {
            this.connEtoC7();
        }
        if (actionEvent.getSource() == this.getbtnDelete()) {
            this.connEtoC8();
        }
        if (actionEvent.getSource() == this.getbtnSave()) {
            this.connEtoC9();
        }
        if (actionEvent.getSource() == this.getbtnHelp()) {
            this.connEtoC11();
        }
        if (actionEvent.getSource() == this.getbtnZeroToasterIni()) {
            this.connEtoC10();
        }
    }

    public void btnCurrentLogfile_ActionEvents() {
    }

    public void btnDelete_ActionEvents() {
        String string = this.ivjlstFiles.getSelectedItem();
        if (string == null) {
            return;
        }
        if (!MessageBox.OK_CANCEL(this, "Warning", "Are you sure to delete " + string + " ?")) {
            return;
        }
        this.remoteFileDelete(string);
    }

    public void btnDownload_ActionEvents() {
        String string = this.ivjlstFiles.getSelectedItem();
        if (string == null) {
            return;
        }
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setName("FileManager-Filedialog");
        ((Dialog)fileDialog).setTitle("Store File ...");
        fileDialog.setMode(0);
        fileDialog.setFile(string);
        fileDialog.setDirectory(this.strCurrentLocalDirectory);
        fileDialog.setResizable(true);
        fileDialog.addNotify();
        this.windowPos_load(fileDialog);
        ((Component)fileDialog).setVisible(true);
        this.windowPos_save(fileDialog);
        if (fileDialog.getFile() == null) {
            return;
        }
        this.strCurrentLocalDirectory = fileDialog.getDirectory();
        String string2 = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        this.remoteFileLoad(string, string2);
    }

    public void btnEdit_ActionEvents() {
        String string = this.ivjlstFiles.getSelectedItem();
        if (string == null) {
            return;
        }
        this.strCurrentEdit = "";
        this.remoteFileLoad(string, null);
    }

    public void btnHelp_ActionEvents() {
        ConfigFrame.frmHelp.showHelp(this);
    }

    public void btnSave_ActionEvents() {
        String string = this.ivjlstFiles.getSelectedItem();
        if (string == null) {
            return;
        }
        String string2 = this.ivjtxtContent.getText().trim();
        if (string2.length() == 0 && !MessageBox.OK_CANCEL(this, "Warning", "Text is empty. Save anyway ?")) {
            return;
        }
        this.remoteFileSave(null, string);
    }

    public void btnUpload_ActionEvents() {
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setName("FileManager-Filedialog");
        ((Dialog)fileDialog).setTitle("Upload File ...");
        fileDialog.setMode(1);
        fileDialog.setFile("*.*");
        fileDialog.setDirectory(this.strCurrentLocalDirectory);
        fileDialog.setResizable(true);
        fileDialog.setModal(true);
        this.windowPos_load(fileDialog);
        ((Component)fileDialog).setVisible(true);
        this.windowPos_save(fileDialog);
        if (fileDialog.getFile() == null) {
            return;
        }
        this.strCurrentLocalDirectory = fileDialog.getDirectory();
        String string = fileDialog.getFile();
        String string2 = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        if (!new File(string2).exists()) {
            MessageBox.OK(this, "Error", "File " + string2 + " doesn't exist");
            return;
        }
        this.remoteFileSave(string2, string);
    }

    public void btnZeroToasterIni_ActionEvents() {
        this.strCurrentPath = "";
        this.refreshFileManager();
        this.ivjlstFiles.select(-1);
        String[] stringArray = this.ivjlstFiles.getItems();
        int n = -1;
        String string = "zerotoaster.ini";
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            MessageBox.OK(this, "Error", "Cannot find " + string);
            return;
        }
        this.ivjlstFiles.select(n);
        this.lstFiles_ItemStateChanged();
        this.btnEdit_ActionEvents();
    }

    private void connEtoC1() {
        try {
            this.mnuQuit_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC10() {
        try {
            this.btnZeroToasterIni_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC11() {
        try {
            this.btnHelp_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(WindowEvent windowEvent) {
        try {
            this.mnuQuit_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3() {
        try {
            this.lstFiles_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC4(ItemEvent itemEvent) {
        try {
            this.lstFiles_ItemStateChanged();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC5() {
        try {
            this.btnEdit_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC6() {
        try {
            this.btnDownload_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC7() {
        try {
            this.btnUpload_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC8() {
        try {
            this.btnDelete_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC9() {
        try {
            this.btnSave_ActionEvents();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public void dispose() {
        super.dispose();
    }

    private Button getbtnDelete() {
        if (this.ivjbtnDelete == null) {
            try {
                this.ivjbtnDelete = new Button();
                this.ivjbtnDelete.setName("btnDelete");
                this.ivjbtnDelete.setLabel("Delete");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnDelete;
    }

    private Button getbtnDownload() {
        if (this.ivjbtnDownload == null) {
            try {
                this.ivjbtnDownload = new Button();
                this.ivjbtnDownload.setName("btnDownload");
                this.ivjbtnDownload.setLabel("Download");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnDownload;
    }

    private Button getbtnEdit() {
        if (this.ivjbtnEdit == null) {
            try {
                this.ivjbtnEdit = new Button();
                this.ivjbtnEdit.setName("btnEdit");
                this.ivjbtnEdit.setActionCommand("Edit");
                this.ivjbtnEdit.setLabel("Edit");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnEdit;
    }

    private Button getbtnHelp() {
        if (this.ivjbtnHelp == null) {
            try {
                this.ivjbtnHelp = new Button();
                this.ivjbtnHelp.setName("btnHelp");
                this.ivjbtnHelp.setLabel("Help");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnHelp;
    }

    private Button getbtnSave() {
        if (this.ivjbtnSave == null) {
            try {
                this.ivjbtnSave = new Button();
                this.ivjbtnSave.setName("btnSave");
                this.ivjbtnSave.setActionCommand("Save");
                this.ivjbtnSave.setLabel("Save");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnSave;
    }

    private Button getbtnUpload() {
        if (this.ivjbtnUpload == null) {
            try {
                this.ivjbtnUpload = new Button();
                this.ivjbtnUpload.setName("btnUpload");
                this.ivjbtnUpload.setLabel("Upload");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnUpload;
    }

    private Button getbtnZeroToasterIni() {
        if (this.ivjbtnZeroToasterIni == null) {
            try {
                this.ivjbtnZeroToasterIni = new Button();
                this.ivjbtnZeroToasterIni.setName("btnZeroToasterIni");
                this.ivjbtnZeroToasterIni.setLabel("ED zerotoaster.ini");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjbtnZeroToasterIni;
    }

    private static void getBuilderData() {
    }

    private MenuBar getConfigFilemanagerMenuBar() {
        if (this.ivjConfigFilemanagerMenuBar == null) {
            try {
                this.ivjConfigFilemanagerMenuBar = new MenuBar();
                this.ivjConfigFilemanagerMenuBar.setFont(new Font("dialog", 1, 12));
                this.ivjConfigFilemanagerMenuBar.add(this.getmnuFile());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConfigFilemanagerMenuBar;
    }

    private Label getLabel1() {
        if (this.ivjLabel1 == null) {
            try {
                this.ivjLabel1 = new Label();
                this.ivjLabel1.setName("Label1");
                this.ivjLabel1.setText(" Shortcuts");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjLabel1;
    }

    private Label getlblPath() {
        if (this.ivjlblPath == null) {
            try {
                this.ivjlblPath = new Label();
                this.ivjlblPath.setName("lblPath");
                this.ivjlblPath.setFont(new Font("dialog", 1, 12));
                this.ivjlblPath.setText(".");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjlblPath;
    }

    private Label getlblStatus() {
        if (this.ivjlblStatus == null) {
            try {
                this.ivjlblStatus = new Label();
                this.ivjlblStatus.setName("lblStatus");
                this.ivjlblStatus.setFont(new Font("dialog", 1, 12));
                this.ivjlblStatus.setText(".");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjlblStatus;
    }

    private List getlstFiles() {
        if (this.ivjlstFiles == null) {
            try {
                this.ivjlstFiles = new List(15);
                this.ivjlstFiles.setName("lstFiles");
                this.ivjlstFiles.setFont(new Font("dialog", 1, 12));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjlstFiles;
    }

    private Menu getmnuFile() {
        if (this.ivjmnuFile == null) {
            try {
                this.ivjmnuFile = new Menu();
                this.ivjmnuFile.setFont(new Font("dialog", 1, 12));
                this.ivjmnuFile.setLabel("File");
                this.ivjmnuFile.add(this.getmnuQuit());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjmnuFile;
    }

    private MenuItem getmnuQuit() {
        if (this.ivjmnuQuit == null) {
            try {
                this.ivjmnuQuit = new MenuItem();
                this.ivjmnuQuit.setFont(new Font("dialog", 1, 12));
                this.ivjmnuQuit.setLabel("Quit");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjmnuQuit;
    }

    private Panel getpnlAction() {
        if (this.ivjpnlAction == null) {
            try {
                this.ivjpnlAction = new Panel();
                this.ivjpnlAction.setName("pnlAction");
                this.ivjpnlAction.setLayout(this.getpnlActionFlowLayout());
                this.getpnlAction().add((Component)this.getbtnEdit(), this.getbtnEdit().getName());
                this.getpnlAction().add((Component)this.getbtnSave(), this.getbtnSave().getName());
                this.getpnlAction().add((Component)this.getSeparatorPanel1(), this.getSeparatorPanel1().getName());
                this.getpnlAction().add((Component)this.getbtnDownload(), this.getbtnDownload().getName());
                this.getpnlAction().add((Component)this.getbtnUpload(), this.getbtnUpload().getName());
                this.getpnlAction().add((Component)this.getSeparatorPanel11(), this.getSeparatorPanel11().getName());
                this.getpnlAction().add((Component)this.getbtnDelete(), this.getbtnDelete().getName());
                this.getpnlAction().add((Component)this.getSeparatorPanel111(), this.getSeparatorPanel111().getName());
                this.ivjpnlAction.add(this.getbtnHelp());
                this.ivjpnlAction.add(this.getLabel1());
                this.getpnlAction().add((Component)this.getbtnZeroToasterIni(), this.getbtnZeroToasterIni().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjpnlAction;
    }

    private FlowLayout getpnlActionFlowLayout() {
        FlowLayout flowLayout = null;
        try {
            flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            flowLayout.setVgap(0);
            flowLayout.setHgap(0);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return flowLayout;
    }

    private SeparatorPanel getSeparatorPanel1() {
        if (this.ivjSeparatorPanel1 == null) {
            try {
                this.ivjSeparatorPanel1 = new SeparatorPanel();
                this.ivjSeparatorPanel1.setName("SeparatorPanel1");
                this.ivjSeparatorPanel1.setProperties(new SeparatorPanelProperties("20\u00ad5\u00ad1\u00ad0"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSeparatorPanel1;
    }

    private SeparatorPanel getSeparatorPanel11() {
        if (this.ivjSeparatorPanel11 == null) {
            try {
                this.ivjSeparatorPanel11 = new SeparatorPanel();
                this.ivjSeparatorPanel11.setName("SeparatorPanel11");
                this.ivjSeparatorPanel11.setProperties(new SeparatorPanelProperties("20\u00ad5\u00ad1\u00ad0"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSeparatorPanel11;
    }

    private SeparatorPanel getSeparatorPanel111() {
        if (this.ivjSeparatorPanel111 == null) {
            try {
                this.ivjSeparatorPanel111 = new SeparatorPanel();
                this.ivjSeparatorPanel111.setName("SeparatorPanel111");
                this.ivjSeparatorPanel111.setProperties(new SeparatorPanelProperties("20\u00ad5\u00ad1\u00ad0"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSeparatorPanel111;
    }

    private TextArea gettxtContent() {
        if (this.ivjtxtContent == null) {
            try {
                this.ivjtxtContent = new TextArea();
                this.ivjtxtContent.setName("txtContent");
                this.ivjtxtContent.setFont(new Font("monospaced", 0, 14));
                this.ivjtxtContent.setColumns(0);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjtxtContent;
    }

    public void handleException(Throwable throwable) {
        super.handleException(throwable);
    }

    protected void init() {
        ConfigFrame.logContext.write("# File manager init");
        super.init();
        ConfigFrame.logContext.write("# File manager ready");
    }

    private void initConnections() {
        this.getmnuQuit().addActionListener(this);
        this.addWindowListener(this);
        this.getlstFiles().addActionListener(this);
        this.getlstFiles().addItemListener(this);
        this.getbtnEdit().addActionListener(this);
        this.getbtnDownload().addActionListener(this);
        this.getbtnUpload().addActionListener(this);
        this.getbtnDelete().addActionListener(this);
        this.getbtnSave().addActionListener(this);
        this.getbtnHelp().addActionListener(this);
        this.getbtnZeroToasterIni().addActionListener(this);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        this.setName("ConfigFilemanager");
        this.setMenuBar(this.getConfigFilemanagerMenuBar());
        this.setLayout(new GridBagLayout());
        ((Component)this).setSize(1010, 341);
        this.setTitle("File manager");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.getlstFiles(), gridBagConstraints);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.25;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(5, 3, 5, 5);
        this.add((Component)this.gettxtContent(), gridBagConstraints2);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.getlblPath(), gridBagConstraints3);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridwidth = 3;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.getlblStatus(), gridBagConstraints4);
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.gridwidth = 3;
        gridBagConstraints5.gridheight = 1;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.getpnlAction(), gridBagConstraints5);
        this.initConnections();
        this.init();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.getlstFiles()) {
            this.connEtoC4(itemEvent);
        }
    }

    public void lstFiles_ActionEvents() {
        RemoteFile remoteFile;
        String string = this.ivjlstFiles.getSelectedItem();
        if (string == null) {
            return;
        }
        if (string.endsWith(this.strRemotePathSeparator)) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.strCurrentPath.length() > 0) {
            string = String.valueOf(this.strCurrentPath) + this.strRemotePathSeparator + string;
        }
        if ((remoteFile = ConfigFrame.smManager.fileGet(string)).isDirectory()) {
            if (string.endsWith("\\..")) {
                int n = (string = string.substring(0, string.length() - 3)).lastIndexOf(this.strRemotePathSeparator);
                string = n == -1 ? "" : string.substring(0, n);
            }
            this.strCurrentPath = string;
            this.refreshFileManager();
        }
    }

    public void lstFiles_ItemStateChanged() {
        String string = this.ivjlstFiles.getSelectedItem();
        if (string == null) {
            return;
        }
        this.ivjtxtContent.setText("");
        String string2 = string;
        if (string2.endsWith(this.strRemotePathSeparator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.ivjlblStatus.setText("");
        boolean bl = false;
        int n = 0;
        while (n < this.rfCurrentList.length) {
            RemoteFile remoteFile = this.rfCurrentList[n];
            if (remoteFile.getName().equals(string2)) {
                String string3 = "";
                if (remoteFile.isDirectory()) {
                    string3 = String.valueOf(string3) + "Directory: " + remoteFile.getName();
                } else {
                    string3 = String.valueOf(string3) + "File: " + remoteFile.getName();
                    string3 = String.valueOf(string3) + ", Size= " + Helper.formatMemoryString(remoteFile.length());
                    string3 = String.valueOf(string3) + ", Date= " + new Date(remoteFile.lastModified());
                    bl = true;
                }
                this.ivjlblStatus.setText(string3);
                break;
            }
            ++n;
        }
        this.ivjbtnDelete.setEnabled(bl);
        this.ivjbtnDownload.setEnabled(bl);
        this.ivjbtnEdit.setEnabled(bl);
        this.ivjbtnSave.setEnabled(bl);
    }

    public static void main(String[] stringArray) {
        try {
            ConfigFilemanager configFilemanager = new ConfigFilemanager();
            try {
                Class<?> clazz = Class.forName("com.ibm.uvm.abt.edit.WindowCloser");
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$java$awt$Window;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$java$awt$Window = Class.forName("java.awt.Window");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class[] classArray2 = classArray;
                Object[] objectArray = new Object[]{configFilemanager};
                Constructor<?> constructor = clazz.getConstructor(classArray2);
                constructor.newInstance(objectArray);
            }
            catch (Throwable throwable) {}
            configFilemanager.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("In main() von net.zerotoaster.admin.awt.ConfigFrame trat eine Ausnahmebedingung auf");
            throwable.printStackTrace(System.out);
        }
    }

    public void mnuQuit_ActionEvents() {
        this.setVisible(false);
    }

    public void mtaEvent(MTAEvent mTAEvent) {
        if (mTAEvent instanceof PrivilegeChanged) {
            switch (ConfigFrame.intRM_Privilege) {
                case -1: 
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    super.setVisible(false);
                    break;
                }
            }
        }
        super.mtaEvent(mTAEvent);
    }

    void refreshFileManager() {
        ((Component)this).setCursor(new Cursor(3));
        this.ivjlstFiles.removeAll();
        this.ivjlblStatus.setText("Reading directory");
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string = this.strCurrentPath;
        if (string.length() == 0) {
            string = ".";
        }
        this.rfCurrentList = ConfigFrame.smManager.fileList(string);
        if (this.strRemotePathSeparator.length() == 0 && this.rfCurrentList.length > 0) {
            this.strRemotePathSeparator = RemoteFile.separatorChar + "";
        }
        int n = 0;
        while (n < this.rfCurrentList.length) {
            if (this.rfCurrentList[n].isDirectory()) {
                vector.addElement(String.valueOf(this.rfCurrentList[n].getName()) + RemoteFile.separatorChar);
            } else {
                vector2.addElement(this.rfCurrentList[n].getName());
            }
            ++n;
        }
        Helper.sortVector(vector);
        Helper.sortVector(vector2);
        if (this.strCurrentPath.length() > 0) {
            this.ivjlstFiles.add("..");
        }
        n = 0;
        while (n < vector.size()) {
            this.ivjlstFiles.add((String)vector.elementAt(n));
            ++n;
        }
        n = 0;
        while (n < vector2.size()) {
            this.ivjlstFiles.add((String)vector2.elementAt(n));
            ++n;
        }
        this.ivjlstFiles.select(0);
        this.lstFiles_ItemStateChanged();
        this.ivjlblPath.setText("Current directory: {ROOT}/" + this.strCurrentPath);
        ((Component)this).setCursor(new Cursor(0));
    }

    void remoteFileDelete(String string) {
        try {
            if (this.strCurrentPath.length() > 0) {
                string = String.valueOf(this.strCurrentPath) + this.strRemotePathSeparator + string;
            }
            ConfigFrame.smManager.fileDelete(string);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        this.refreshFileManager();
    }

    void remoteFileLoad(String string, String string2) {
        this.ivjlblStatus.setText("Initiating transfer for " + string + ". Please be patient");
        try {
            OutputStream outputStream = null;
            outputStream = string2 != null ? new FileOutputStream(string2) : new ByteArrayOutputStream();
            if (this.strCurrentPath.length() > 0) {
                string = String.valueOf(this.strCurrentPath) + this.strRemotePathSeparator + string;
            }
            ConfigFrame.smManager.fileLoad(string, new TransferOutputStream(this, outputStream));
            outputStream.flush();
            outputStream.close();
            if (string2 == null) {
                this.ivjlblStatus.setText("Moving logfile to screen");
                String string3 = ((ByteArrayOutputStream)outputStream).toString();
                this.ivjtxtContent.setText(string3);
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        this.ivjlblStatus.setText("Transfer finished");
    }

    void remoteFileSave(String string, String string2) {
        this.ivjlblStatus.setText("Initiating transfer for " + string2 + ". Please be patient");
        try {
            InputStream inputStream = null;
            inputStream = string != null ? new FileInputStream(string) : new ByteArrayInputStream(this.ivjtxtContent.getText().getBytes());
            if (this.strCurrentPath.length() > 0) {
                string2 = String.valueOf(this.strCurrentPath) + this.strRemotePathSeparator + string2;
            }
            ConfigFrame.smManager.fileSave(string2, new TransferInputStream(this, inputStream));
            inputStream.close();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        this.ivjlblStatus.setText("Transfer finished");
        this.refreshFileManager();
    }

    public void setVisible(boolean bl) {
        switch (ConfigFrame.intRM_Privilege) {
            case -1: 
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                super.setVisible(false);
                return;
            }
        }
        super.setVisible(bl);
        if (bl) {
            this.refreshFileManager();
        } else {
            this.ivjtxtContent.setText("");
            this.ivjlstFiles.removeAll();
            this.ivjlblPath.setText("");
            this.ivjlblStatus.setText("");
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.connEtoC2(windowEvent);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    static Label access$ivjlblStatus(ConfigFilemanager configFilemanager) {
        return configFilemanager.ivjlblStatus;
    }

    public class TransferOutputStream
    extends OutputStream {
        /* synthetic */ ConfigFilemanager this$0;
        private OutputStream out;
        private long lngBytes = 0L;
        private long lngOldBytes = 0L;
        private long lngStartTime = System.currentTimeMillis();

        public TransferOutputStream(ConfigFilemanager configFilemanager, OutputStream outputStream) {
            this.this$0 = configFilemanager;
            this.out = outputStream;
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.lngBytes;
            this.progress();
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
            this.lngBytes += (long)byArray.length;
            this.progress();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.lngBytes += (long)n2;
            this.progress();
        }

        private void progress() {
            if (this.lngBytes - this.lngOldBytes > 4096L) {
                this.lngOldBytes = this.lngBytes;
                long l = (System.currentTimeMillis() - this.lngStartTime) / 1000L;
                if (l > 0L) {
                    long l2 = this.lngBytes / 1024L;
                    long l3 = l2 / l;
                    ConfigFilemanager.access$ivjlblStatus(this.this$0).setText(l2 + " kBytes, " + l3 + " kBytes/s");
                }
            }
        }
    }

    public class TransferInputStream
    extends InputStream {
        /* synthetic */ ConfigFilemanager this$0;
        private InputStream in;
        private long lngBytes = 0L;
        private long lngOldBytes = 0L;
        private long lngStartTime = System.currentTimeMillis();

        public TransferInputStream(ConfigFilemanager configFilemanager, InputStream inputStream) {
            this.this$0 = configFilemanager;
            this.in = inputStream;
        }

        public int read() throws IOException {
            int n = this.in.read();
            if (n != -1) {
                ++this.lngBytes;
                this.progress();
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            int n = this.in.read(byArray);
            this.lngBytes += (long)n;
            this.progress();
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            this.lngBytes += (long)n3;
            this.progress();
            return n3;
        }

        private void progress() {
            if (this.lngBytes - this.lngOldBytes > 4096L) {
                this.lngOldBytes = this.lngBytes;
                long l = (System.currentTimeMillis() - this.lngStartTime) / 1000L;
                if (l > 0L) {
                    long l2 = this.lngBytes / 1024L;
                    long l3 = l2 / l;
                    ConfigFilemanager.access$ivjlblStatus(this.this$0).setText(l2 + " kBytes, " + l3 + " kBytes/s");
                }
            }
        }
    }
}

