/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import de.zwanzigeins.util.VectorInt;
import java.io.Serializable;

public class VectorString
implements Cloneable,
Serializable {
    protected String[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767609914048989439L;

    public VectorString() {
        this(10);
    }

    public VectorString(int n) {
        this(n, 0);
    }

    public VectorString(int n, int n2) {
        this.elementData = new String[n];
        this.capacityIncrement = n2;
    }

    public void addElement(String string) {
        int n = this.elementCount + 1;
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
        this.elementData[this.elementCount++] = string;
    }

    public Object clone() {
        try {
            VectorInt vectorInt = (VectorInt)super.clone();
            vectorInt.elementData = new int[this.elementCount];
            System.arraycopy(this.elementData, 0, vectorInt.elementData, 0, this.elementCount);
            return vectorInt;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void copyInto(String[] stringArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            stringArray[n] = this.elementData[n];
        }
    }

    public String elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    private void ensureCapacityHelper(int n) {
        int n2;
        int n3 = this.elementData.length;
        String[] stringArray = this.elementData;
        int n4 = n2 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
        if (n2 < n) {
            n2 = n;
        }
        this.elementData = new String[n2];
        System.arraycopy(stringArray, 0, this.elementData, 0, this.elementCount);
    }

    public int indexOf(String string) {
        int n = 0;
        while (n < this.elementCount) {
            if (string.equals(this.elementData[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void insertElementAt(String string, int n) {
        int n2 = this.elementCount + 1;
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = string;
        ++this.elementCount;
    }

    public int lastIndexOf(String string) {
        int n = this.elementCount - 1;
        while (n >= 0) {
            if (string.equals(this.elementData[n])) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public void removeAllElements() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
    }

    public void setElementAt(String string, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = string;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.size()) {
            stringBuffer.append(this.elementData[n]);
            if (n < this.size()) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            String[] stringArray = this.elementData;
            this.elementData = new String[this.elementCount];
            System.arraycopy(stringArray, 0, this.elementData, 0, this.elementCount);
        }
    }
}

