/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.io.Serializable;

public class VectorObject
implements Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767609110148989439L;

    public VectorObject() {
        this(10);
    }

    public VectorObject(int n) {
        this(n, 0);
    }

    public VectorObject(int n, int n2) {
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public void addElement(Object object) {
        int n = this.elementCount + 1;
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
        this.elementData[this.elementCount++] = object;
    }

    public Object clone() {
        try {
            VectorObject vectorObject = (VectorObject)super.clone();
            vectorObject.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, vectorObject.elementData, 0, this.elementCount);
            return vectorObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void copyInto(Object[] objectArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            objectArray[n] = this.elementData[n];
        }
    }

    public Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    private void ensureCapacityHelper(int n) {
        int n2;
        int n3 = this.elementData.length;
        Object[] objectArray = this.elementData;
        int n4 = n2 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
        if (n2 < n) {
            n2 = n;
        }
        this.elementData = new Object[n2];
        System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
    }

    public int indexOf(Object object) {
        int n = 0;
        while (n < this.elementCount) {
            if (object.equals(this.elementData[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void insertElementAt(Object object, int n) {
        int n2 = this.elementCount + 1;
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public int lastIndexOf(Object object) {
        int n = this.elementCount - 1;
        while (n >= 0) {
            if (object.equals(this.elementData[n])) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public void removeAllElements() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
    }

    public void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = object;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.size()) {
            stringBuffer.append(this.elementData[n]);
            if (n < this.size()) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }
}

