/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.io.Serializable;

public class VectorInt
implements Cloneable,
Serializable {
    protected int[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767609914048989439L;

    public VectorInt() {
        this(10);
    }

    public VectorInt(int n) {
        this(n, 0);
    }

    public VectorInt(int n, int n2) {
        this.elementData = new int[n];
        this.capacityIncrement = n2;
    }

    public void addElement(int n) {
        int n2 = this.elementCount + 1;
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
        this.elementData[this.elementCount++] = n;
    }

    public Object clone() {
        try {
            VectorInt vectorInt = (VectorInt)super.clone();
            vectorInt.elementData = new int[this.elementCount];
            System.arraycopy(this.elementData, 0, vectorInt.elementData, 0, this.elementCount);
            return vectorInt;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void copyInto(int[] nArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            nArray[n] = this.elementData[n];
        }
    }

    public int elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    private void ensureCapacityHelper(int n) {
        int n2;
        int n3 = this.elementData.length;
        int[] nArray = this.elementData;
        int n4 = n2 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
        if (n2 < n) {
            n2 = n;
        }
        this.elementData = new int[n2];
        System.arraycopy(nArray, 0, this.elementData, 0, this.elementCount);
    }

    public int indexOf(int n) {
        int n2 = 0;
        while (n2 < this.elementCount) {
            if (n == this.elementData[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void insertElementAt(int n, int n2) {
        int n3 = this.elementCount + 1;
        if (n2 >= n3) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.elementCount);
        }
        if (n3 > this.elementData.length) {
            this.ensureCapacityHelper(n3);
        }
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = n;
        ++this.elementCount;
    }

    public int lastIndexOf(int n) {
        int n2 = this.elementCount - 1;
        while (n2 >= 0) {
            if (n == this.elementData[n2]) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public void removeAllElements() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n] = 0;
            ++n;
        }
        this.elementCount = 0;
    }

    public void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
    }

    public void setElementAt(int n, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        this.elementData[n2] = n;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.size()) {
            stringBuffer.append(this.elementData[n]);
            if (n < this.size()) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            int[] nArray = this.elementData;
            this.elementData = new int[this.elementCount];
            System.arraycopy(nArray, 0, this.elementData, 0, this.elementCount);
        }
    }
}

