/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class TimeFactory {
    private static TimeFactory tfImpl;
    private static long lngLastTime;
    private static int intTimeIndex;
    private static final DateFormat dfUID;
    private static final Date dateUID;

    static {
        lngLastTime = 0L;
        intTimeIndex = 0;
        dfUID = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        dateUID = new Date();
    }

    protected TimeFactory() {
    }

    public static synchronized String createUID() {
        StringBuffer stringBuffer = new StringBuffer(20);
        long l = TimeFactory.getTime();
        intTimeIndex = l == lngLastTime ? ++intTimeIndex : 0;
        dateUID.setTime(l);
        stringBuffer.append(dfUID.format(dateUID));
        stringBuffer.append(String.valueOf(1000 + intTimeIndex).substring(1));
        lngLastTime = l;
        return stringBuffer.toString();
    }

    public static long getTime() {
        if (tfImpl == null) {
            return System.currentTimeMillis();
        }
        return tfImpl.getTimeImpl();
    }

    protected abstract long getTimeImpl();

    public static void setTimeFactoryImpl(TimeFactory timeFactory) {
        tfImpl = timeFactory;
    }
}

