/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import de.zwanzigeins.util.HelperFilter;
import de.zwanzigeins.util.HelperIO;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.VectorInt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class IniManager {
    private static final String SECTIONMARKER_LEFT = "[";
    private static final String SECTIONMARKER_RIGHT = "]";
    private static final String COMMENTCHARS = "#;!";
    private static final String SEPARATOR = "=";
    static final int TYPE_EMTPY = 0;
    static final int TYPE_COMMENT = 1;
    static final int TYPE_SECTION = 2;
    static final int TYPE_DATA = 3;
    static final int TYPE_UNKNOWN = 4;
    static final int TYPE_PLACEHOLDER = 5;
    private static final String PLACEHOLDER_CHAR = "$";
    private Hashtable hshPlaceholders = new Hashtable();
    private IniManager iniMaster = null;
    private String strIniFile = null;
    private boolean blnEmbeddedMode = false;
    private Vector vecData = new Vector();
    private boolean blnHasLoaded = false;
    private long lngCheckSum1 = 0L;
    private long lngCheckSum2 = 0L;
    private long lngCheckSum3 = 0L;

    private IniManager() {
        this(null, false);
    }

    public IniManager(String string) {
        this(string, false);
    }

    public IniManager(String string, boolean bl) {
        this.strIniFile = string;
        this.blnEmbeddedMode = bl;
        this.load();
    }

    public void dropKeys(String string, String string2) {
        this.setPropertiesString(string, string2, new String[0]);
    }

    public void dropSection(String string) {
        boolean bl = false;
        if (string.length() == 0) {
            bl = true;
        }
        int n = 0;
        while (n < this.vecData.size()) {
            Entry entry = (Entry)this.vecData.elementAt(n);
            if (entry.intType == 2) {
                if (bl) break;
                bl = entry.strKey.equalsIgnoreCase(string);
            }
            if (bl) {
                this.vecData.removeElementAt(n);
                --n;
            }
            ++n;
        }
    }

    public String getFileName() {
        return this.strIniFile;
    }

    public Enumeration getKeys(String string, boolean bl) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        boolean bl2 = false;
        if (string.length() == 0) {
            bl2 = true;
        }
        int n = 0;
        while (n < this.vecData.size()) {
            object = (Entry)this.vecData.elementAt(n);
            if (((Entry)object).intType == 2) {
                if (bl2) break;
                bl2 = ((Entry)object).strKey.equalsIgnoreCase(string);
            } else if (((Entry)object).intType == 3 && bl2 && vector.indexOf(((Entry)object).strKey) == -1) {
                vector.addElement(((Entry)object).strKey);
            }
            ++n;
        }
        if (this.iniMaster != null) {
            Enumeration enumeration = this.iniMaster.getKeys(string, bl);
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (vector.indexOf(object) != -1) continue;
                vector.addElement(object);
            }
        }
        return vector.elements();
    }

    public IniManager getMaster() {
        return this.iniMaster;
    }

    public String[] getPropertiesString(String string, String string2) {
        return this.getPropertiesString(string, string2, new String[0]);
    }

    public String[] getPropertiesString(String string, String string2, String[] stringArray) {
        VectorInt vectorInt = this.match(string, string2);
        String[] stringArray2 = new String[vectorInt.size()];
        int n = 0;
        while (n < vectorInt.size()) {
            String string3;
            String string4;
            Entry entry = (Entry)this.vecData.elementAt(vectorInt.elementAt(n));
            String string5 = entry.strData;
            int n2 = string5.indexOf(PLACEHOLDER_CHAR);
            int n3 = string5.indexOf(PLACEHOLDER_CHAR, n2 + 1);
            if (n2 != -1 && n3 != -1 && (string4 = (String)this.hshPlaceholders.get(string3 = string5.substring(n2, n3 + 1).toLowerCase())) != null) {
                string5 = String.valueOf(string5.substring(0, n2)) + string4 + string5.substring(n3 + 1);
            }
            stringArray2[n] = string5;
            ++n;
        }
        if (stringArray2.length == 0 && this.iniMaster != null) {
            stringArray2 = this.iniMaster.getPropertiesString(string, string2, new String[0]);
        }
        if (stringArray2.length == 0) {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    public boolean getPropertyBoolean(String string, String string2) {
        return this.getPropertyBoolean(string, string2, false);
    }

    public boolean getPropertyBoolean(String string, String string2, boolean bl) {
        return this.getPropertyString(string, string2, bl ? "1" : "0").equals("1");
    }

    public double getPropertyDouble(String string, String string2) {
        return this.getPropertyDouble(string, string2, 0.0);
    }

    public double getPropertyDouble(String string, String string2, double d) {
        try {
            return Double.valueOf(this.getPropertyString(string, string2, String.valueOf(d)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Cannot parse value '[" + string + "] " + string2 + "'");
        }
    }

    public double[] getPropertyDoubleAsArray(String string, String string2) {
        return this.getPropertyDoubleAsArray(string, string2, new double[0]);
    }

    public double[] getPropertyDoubleAsArray(String string, String string2, double[] dArray) {
        String[] stringArray = new String[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            stringArray[n] = String.valueOf(dArray[n]);
            ++n;
        }
        String[] stringArray2 = this.getPropertyStringAsArray(string, string2, stringArray);
        double[] dArray2 = new double[stringArray2.length];
        int n2 = 0;
        while (n2 < dArray2.length) {
            dArray2[n2] = Double.valueOf(stringArray2[n2]);
            ++n2;
        }
        return dArray2;
    }

    public int getPropertyInt(String string, String string2) {
        return this.getPropertyInt(string, string2, 0);
    }

    public int getPropertyInt(String string, String string2, int n) {
        return (int)this.getPropertyLong(string, string2, n);
    }

    public int[] getPropertyIntAsArray(String string, String string2) {
        return this.getPropertyIntAsArray(string, string2, new int[0]);
    }

    public int[] getPropertyIntAsArray(String string, String string2, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = String.valueOf(nArray[n]);
            ++n;
        }
        String[] stringArray2 = this.getPropertyStringAsArray(string, string2, stringArray);
        int[] nArray2 = new int[stringArray2.length];
        int n2 = 0;
        while (n2 < nArray2.length) {
            nArray2[n2] = Integer.valueOf(stringArray2[n2]);
            ++n2;
        }
        return nArray2;
    }

    public long getPropertyLong(String string, String string2) {
        return this.getPropertyLong(string, string2, 0L);
    }

    public long getPropertyLong(String string, String string2, long l) {
        try {
            return Long.parseLong(this.getPropertyString(string, string2, String.valueOf(l)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Cannot parse value '[" + string + "] " + string2 + "'");
        }
    }

    public long[] getPropertyLongAsArray(String string, String string2) {
        return this.getPropertyLongAsArray(string, string2, new long[0]);
    }

    public long[] getPropertyLongAsArray(String string, String string2, long[] lArray) {
        String[] stringArray = new String[lArray.length];
        int n = 0;
        while (n < lArray.length) {
            stringArray[n] = String.valueOf(lArray[n]);
            ++n;
        }
        String[] stringArray2 = this.getPropertyStringAsArray(string, string2, stringArray);
        long[] lArray2 = new long[stringArray2.length];
        int n2 = 0;
        while (n2 < lArray2.length) {
            lArray2[n2] = Long.valueOf(stringArray2[n2]);
            ++n2;
        }
        return lArray2;
    }

    public String getPropertyString(String string, String string2) {
        return this.getPropertyString(string, string2, "");
    }

    public String getPropertyString(String string, String string2, String string3) {
        String[] stringArray = this.getPropertiesString(string, string2, new String[]{string3});
        return stringArray == null ? "" : stringArray[0];
    }

    public String[] getPropertyStringAsArray(String string, String string2) {
        return this.getPropertyStringAsArray(string, string2, new String[]{""});
    }

    public String[] getPropertyStringAsArray(String string, String string2, String[] stringArray) {
        String string3 = this.getPropertyString(string, string2);
        if (string3 == null || string3.length() == 0) {
            if (stringArray != null && stringArray.length > 0) {
                String string4 = "";
                int n = 0;
                while (n < stringArray.length) {
                    string4 = String.valueOf(string4) + stringArray[n] + ",";
                    ++n;
                }
                string4 = string4.substring(0, string4.length() - 1);
                this.setPropertyString(string, string2, string4);
            }
            return stringArray;
        }
        return IniManager.toArray(string3);
    }

    public Enumeration getSections(boolean bl) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.vecData.size()) {
            object = (Entry)this.vecData.elementAt(n);
            if (((Entry)object).intType == 2 && vector.indexOf(((Entry)object).strKey) == -1) {
                vector.addElement(((Entry)object).strKey);
            }
            ++n;
        }
        if (bl && this.iniMaster != null) {
            Enumeration enumeration = this.iniMaster.getSections(bl);
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (vector.indexOf(object) != -1) continue;
                vector.addElement(object);
            }
        }
        return vector.elements();
    }

    public boolean hasLoaded() {
        return this.blnHasLoaded;
    }

    public boolean isModified() {
        if (!this.hasLoaded()) {
            return false;
        }
        if (this.blnEmbeddedMode) {
            return false;
        }
        long l = 0L;
        long l2 = 0L;
        File file = new File(this.strIniFile);
        if (!file.exists()) {
            return false;
        }
        this.lngCheckSum3 = file.lastModified();
        if (this.lngCheckSum3 == file.lastModified()) {
            return false;
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).length() == 0 || COMMENTCHARS.indexOf(string.charAt(0)) != -1) continue;
                    l = l + (long)string.hashCode() & 0x7FFFL;
                    l2 ^= (long)string.hashCode();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            HelperIO.close(bufferedReader);
            throw throwable;
        }
        Object var7_9 = null;
        HelperIO.close(bufferedReader);
        return l != this.lngCheckSum1 || l2 != this.lngCheckSum2;
    }

    private void load() {
        Object object;
        this.vecData.removeAllElements();
        this.hshPlaceholders.clear();
        this.blnHasLoaded = false;
        this.lngCheckSum1 = 0L;
        this.lngCheckSum2 = 0L;
        this.lngCheckSum3 = 0L;
        InputStream inputStream = null;
        if (!this.blnEmbeddedMode) {
            object = new File(this.strIniFile);
            if (!((File)object).exists()) {
                return;
            }
            this.lngCheckSum3 = ((File)object).lastModified();
            try {
                inputStream = new FileInputStream((File)object);
            }
            catch (IOException iOException) {
                inputStream = null;
            }
        } else {
            inputStream = this.getClass().getResourceAsStream(HelperPath.buildRessourcePath(this.strIniFile));
        }
        if (inputStream == null) {
            return;
        }
        object = null;
        try {
            try {
                object = new BufferedReader(new InputStreamReader(inputStream));
                String string = null;
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    string = string.trim();
                    Entry entry = new Entry(this);
                    if (string.length() == 0) {
                        entry.intType = 0;
                        this.vecData.addElement(entry);
                        continue;
                    }
                    if (COMMENTCHARS.indexOf(string.charAt(0)) != -1) {
                        entry.intType = 1;
                        entry.strKey = string;
                        this.vecData.addElement(entry);
                        continue;
                    }
                    this.lngCheckSum1 = this.lngCheckSum1 + (long)string.hashCode() & 0x7FFFL;
                    this.lngCheckSum2 ^= (long)string.hashCode();
                    if (string.startsWith(SECTIONMARKER_LEFT) && string.endsWith(SECTIONMARKER_RIGHT)) {
                        entry.intType = 2;
                        entry.strKey = string.substring(1, string.length() - 1);
                        this.vecData.addElement(entry);
                        continue;
                    }
                    if (string.indexOf(SEPARATOR) != -1) {
                        String string2 = string.substring(0, string.indexOf(SEPARATOR)).trim();
                        String string3 = string.substring(string.indexOf(SEPARATOR) + 1).trim();
                        string3 = HelperFilter.replaceMore(string3, "\\n", "\n");
                        string3 = HelperFilter.replaceMore(string3, "\\r", "\r");
                        string3 = HelperFilter.replaceMore(string3, "\\t", "\t");
                        if (string2.startsWith(PLACEHOLDER_CHAR) && string2.endsWith(PLACEHOLDER_CHAR)) {
                            entry.intType = 5;
                            this.hshPlaceholders.put(string2.toLowerCase(), string3);
                        } else {
                            entry.intType = 3;
                        }
                        entry.strKey = string2;
                        entry.strData = string3;
                        this.vecData.addElement(entry);
                        continue;
                    }
                    entry.intType = 4;
                    entry.strKey = string;
                    this.vecData.addElement(entry);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            HelperIO.close(object);
            throw throwable;
        }
        Object var3_10 = null;
        HelperIO.close(object);
        this.blnHasLoaded = this.vecData.size() > 0;
    }

    public static void main(String[] stringArray) {
        File file = new File("");
        System.out.println(file.getAbsolutePath());
        IniManager iniManager = new IniManager("../P_Zerotoaster_Httpd/zerotoaster.ini");
        String[] stringArray2 = iniManager.getPropertiesString("servlets", "servlet_config");
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
        System.out.println(iniManager.getPropertiesString("", "key1"));
        System.out.println(iniManager.getPropertyString("", "key2"));
        System.out.println(iniManager.getPropertyString("", "key3"));
        System.out.println(iniManager.getPropertyString("", "key4"));
    }

    private VectorInt match(String string, String string2) {
        VectorInt vectorInt = new VectorInt();
        boolean bl = false;
        if (string.length() == 0) {
            bl = true;
        }
        int n = 0;
        while (n < this.vecData.size()) {
            Entry entry = (Entry)this.vecData.elementAt(n);
            if (entry.intType == 2) {
                bl = entry.strKey.equalsIgnoreCase(string);
            } else if (entry.intType == 3 && bl && entry.strKey.equalsIgnoreCase(string2)) {
                vectorInt.addElement(n);
            }
            ++n;
        }
        return vectorInt;
    }

    public void save() {
        if (this.blnEmbeddedMode) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new FileWriter(new File(this.strIniFile)));
                int n = 0;
                while (n < this.vecData.size()) {
                    Entry entry = (Entry)this.vecData.elementAt(n);
                    printWriter.println(entry.toString());
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            HelperIO.close(printWriter);
            throw throwable;
        }
        Object var2_7 = null;
        HelperIO.close(printWriter);
    }

    public boolean sectionExists(String string, boolean bl) {
        if (string.length() == 0) {
            return true;
        }
        int n = 0;
        while (n < this.vecData.size()) {
            Entry entry = (Entry)this.vecData.elementAt(n);
            if (entry.intType == 2 && entry.strKey.equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return bl && this.iniMaster != null && this.iniMaster.sectionExists(string, bl);
    }

    public void setMaster(IniManager iniManager) {
        this.iniMaster = iniManager;
    }

    public void setPropertiesString(String string, String string2, String[] stringArray) {
        Entry entry;
        VectorInt vectorInt = this.match(string, string2);
        if (vectorInt.size() != 0) {
            int n = 0;
            while (n < vectorInt.size()) {
                this.vecData.removeElementAt(vectorInt.elementAt(n) - n);
                ++n;
            }
            n = vectorInt.elementAt(0);
            int n2 = 0;
            while (n2 < stringArray.length) {
                Entry entry2 = new Entry(this);
                entry2.intType = 3;
                entry2.strKey = string2;
                entry2.strData = stringArray[n2];
                this.vecData.insertElementAt(entry2, n + n2);
                ++n2;
            }
            return;
        }
        int n = -1;
        int n3 = 0;
        while (n3 < this.vecData.size()) {
            entry = (Entry)this.vecData.elementAt(n3);
            if (entry.intType == 2 && entry.strKey.equalsIgnoreCase(string)) {
                n = n3 + 1;
                break;
            }
            ++n3;
        }
        if (n == -1) {
            if (string.length() != 0) {
                Entry entry3 = new Entry(this);
                entry3.intType = 2;
                entry3.strKey = string;
                this.vecData.addElement(entry3);
            }
            n = this.vecData.size();
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            entry = new Entry(this);
            entry.intType = 3;
            entry.strKey = string2;
            entry.strData = stringArray[n4];
            this.vecData.insertElementAt(entry, n + n4);
            ++n4;
        }
    }

    public void setPropertyBoolean(String string, String string2, boolean bl) {
        this.setPropertyString(string, string2, bl ? "1" : "0");
    }

    public void setPropertyDouble(String string, String string2, double d) {
        this.setPropertyString(string, string2, String.valueOf(d));
    }

    public void setPropertyInt(String string, String string2, int n) {
        this.setPropertyString(string, string2, String.valueOf(n));
    }

    public void setPropertyLong(String string, String string2, long l) {
        this.setPropertyString(string, string2, String.valueOf(l));
    }

    public void setPropertyString(String string, String string2, String string3) {
        this.setPropertiesString(string, string2, new String[]{string3});
    }

    public static final String[] toArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    public String toString() {
        return this.getFileName();
    }

    class Entry
    implements Serializable {
        /* synthetic */ IniManager this$0;
        int intType = -1;
        String strKey = null;
        String strData = null;

        public String toString() {
            switch (this.intType) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.strKey;
                }
                case 2: {
                    return IniManager.SECTIONMARKER_LEFT + this.strKey + IniManager.SECTIONMARKER_RIGHT;
                }
                case 3: {
                    return " " + this.strKey + IniManager.SEPARATOR + this.strData;
                }
                case 5: {
                    return String.valueOf(this.strKey) + IniManager.SEPARATOR + this.strData;
                }
                case 4: {
                    return this.strKey;
                }
            }
            return "????";
        }

        Entry(IniManager iniManager) {
            this.this$0 = iniManager;
        }
    }
}

