/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public class HelperIO {
    private static final Object objLock = new Object();
    private static Hashtable hshLockedFiles = new Hashtable();

    private HelperIO() {
    }

    public static final boolean close(Object object) {
        if (object == null) {
            return true;
        }
        try {
            if (object instanceof RandomAccessFile) {
                ((RandomAccessFile)object).close();
                return true;
            }
            if (object instanceof InputStream) {
                ((InputStream)object).close();
                return true;
            }
            if (object instanceof OutputStream) {
                ((OutputStream)object).close();
                return true;
            }
            if (object instanceof Writer) {
                ((Writer)object).close();
                return true;
            }
            if (object instanceof Reader) {
                ((Reader)object).close();
                return true;
            }
            if (object instanceof ServerSocket) {
                ((ServerSocket)object).close();
                return true;
            }
            if (object instanceof Socket) {
                ((Socket)object).close();
                return true;
            }
            if (object instanceof Connection) {
                ((Connection)object).close();
                return true;
            }
            if (object instanceof Statement) {
                ((Statement)object).close();
                return true;
            }
            if (object instanceof PreparedStatement) {
                ((PreparedStatement)object).close();
                return true;
            }
            if (object instanceof ResultSet) {
                ((ResultSet)object).close();
                return true;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public static final boolean commit(Connection connection) {
        if (connection == null) {
            return true;
        }
        try {
            connection.commit();
            return true;
        }
        catch (Throwable throwable) {
            HelperIO.writeLog(throwable);
            return false;
        }
    }

    public static final boolean fileLock(String string) {
        Hashtable hashtable = hshLockedFiles;
        synchronized (hashtable) {
            if (hshLockedFiles.containsKey(string)) {
                return false;
            }
            hshLockedFiles.put(string, "0");
            return true;
        }
    }

    public static final Enumeration filesLocked() {
        return hshLockedFiles.keys();
    }

    public static final boolean fileUnlock(String string) {
        Hashtable hashtable = hshLockedFiles;
        synchronized (hashtable) {
            return hshLockedFiles.remove(string) != null;
        }
    }

    public static final void flush(Object object) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof OutputStream) {
                ((OutputStream)object).flush();
                return;
            }
            if (object instanceof Writer) {
                ((Writer)object).flush();
                return;
            }
            HelperIO.writeLog("Unknown flush object: " + object);
        }
        catch (Throwable throwable) {}
    }

    public static final boolean rollback(Connection connection) {
        if (connection == null) {
            return true;
        }
        try {
            connection.rollback();
            return true;
        }
        catch (Throwable throwable) {
            HelperIO.writeLog(throwable);
            return false;
        }
    }

    public static final void writeLog(String string) {
        Object object = objLock;
        synchronized (object) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter("err.dmp"));
                printWriter.println(string);
                printWriter.flush();
                printWriter.close();
            }
            catch (Throwable throwable) {
                System.out.println("close: " + throwable);
            }
        }
    }

    public static final void writeLog(Throwable throwable) {
        Object object = objLock;
        synchronized (object) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter("err.dmp"));
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                printWriter.close();
            }
            catch (Throwable throwable2) {
                System.out.println("close: " + throwable2);
            }
        }
    }
}

