/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.lang.reflect.Constructor;

public abstract class Encoding {
    private static final String BASECLASS = "de.zwanzigeins.util.";
    protected byte[] bytBuffer = null;
    protected int intBufferSize = 0;
    protected int intBufferIndex = 0;
    protected int intBufferEnd = 0;
    protected boolean blnFinish = false;
    protected boolean blnDecodeMode = false;
    protected boolean blnIsBinary = false;

    protected Encoding() {
        this(8192);
    }

    protected Encoding(int n) {
        this.intBufferSize = n;
    }

    private String codeString(String string, boolean bl) {
        if (bl) {
            this.startDecode(true);
        } else {
            this.startEncode(true);
        }
        byte[] byArray = new byte[1024];
        this.setInput(string.getBytes(), 0, string.length());
        this.finish();
        int n = this.convert(byArray, 0, byArray.length);
        return new String(byArray, 0, n);
    }

    public abstract int convert(byte[] var1, int var2, int var3);

    public static Encoding createEncodingInstance(String string) {
        return Encoding.createEncodingInstance(string, 0);
    }

    public static Encoding createEncodingInstance(String string, int n) {
        if ((string = string.toLowerCase()).indexOf(45) > -1) {
            string = string.replace('-', '_');
        }
        try {
            Class<?> clazz = Class.forName(BASECLASS + string);
            if (n < 1024) {
                return (Encoding)Class.forName(BASECLASS + string).newInstance();
            }
            Class[] classArray = new Class[]{Integer.TYPE};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return (Encoding)constructor.newInstance(new Integer(n));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String decodeString(String string) {
        return this.codeString(string, true);
    }

    public void dispose() {
        this.bytBuffer = null;
        this.intBufferSize = 0;
        this.intBufferIndex = 0;
        this.intBufferEnd = 0;
        this.blnFinish = false;
        this.blnDecodeMode = false;
        this.blnIsBinary = false;
    }

    public String encodeString(String string) {
        return this.codeString(string, false);
    }

    public final void finish() {
        this.blnFinish = true;
    }

    protected final void init() {
        if (this.bytBuffer == null) {
            this.bytBuffer = new byte[this.intBufferSize];
        }
        this.intBufferIndex = 0;
        this.intBufferEnd = 0;
        this.blnIsBinary = false;
        this.blnFinish = false;
    }

    public final boolean isBinary() {
        return this.blnIsBinary;
    }

    public final boolean needInput() {
        return this.intBufferIndex == this.intBufferEnd;
    }

    public final void setBinary(boolean bl) {
        this.blnIsBinary = bl;
    }

    public final void setInput(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("off+len > buffer length, data not set (" + n + '+' + n2 + '>' + byArray.length + ')');
        }
        if (this.intBufferIndex > 0 && this.intBufferIndex < this.intBufferEnd) {
            System.arraycopy(this.bytBuffer, this.intBufferIndex, this.bytBuffer, 0, this.intBufferEnd - this.intBufferIndex);
        }
        this.intBufferEnd -= this.intBufferIndex;
        this.intBufferIndex = 0;
        if (this.intBufferSize - this.intBufferEnd < n2) {
            this.intBufferSize = this.intBufferEnd + n2;
            byte[] byArray2 = new byte[this.intBufferSize];
            System.arraycopy(this.bytBuffer, 0, byArray2, 0, this.intBufferEnd);
            this.bytBuffer = byArray2;
        }
        System.arraycopy(byArray, n, this.bytBuffer, this.intBufferEnd, n2);
        this.intBufferEnd += n2;
    }

    public final void startDecode() {
        this.startDecode(false);
    }

    public void startDecode(boolean bl) {
        this.init();
        this.blnDecodeMode = true;
        this.blnIsBinary = bl;
    }

    public final void startEncode() {
        this.startEncode(false);
    }

    public void startEncode(boolean bl) {
        this.init();
        this.blnDecodeMode = false;
        this.blnIsBinary = bl;
    }
}

