/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

public class ByteTokenizer {
    private byte bytDelimiter = 0;
    private byte[] bytBuffer = null;
    private int intIdx = -1;

    public ByteTokenizer(byte[] byArray, byte by) {
        this.bytBuffer = byArray;
        this.bytDelimiter = by;
        this.intIdx = 0;
    }

    public ByteTokenizer(byte[] byArray, char c) {
        this(byArray, (byte)c);
    }

    public boolean hasMoreTokens() {
        return this.nextDelimiterPosition() != -1;
    }

    public int nextDelimiterPosition() {
        if (this.intIdx >= this.bytBuffer.length) {
            return -1;
        }
        int n = -1;
        int n2 = this.intIdx;
        while (n2 < this.bytBuffer.length) {
            if (this.bytBuffer[n2] == this.bytDelimiter) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public String nextToken() {
        int n = this.nextDelimiterPosition();
        if (n == -1) {
            return null;
        }
        int n2 = n - this.intIdx - 1;
        if (n2 == -1) {
            this.intIdx = n + 1;
            return "";
        }
        String string = new String(this.bytBuffer, this.intIdx, n2 + 1);
        this.intIdx = n + 1;
        return string;
    }
}

