/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.awt.FontMetrics;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public final class ByteString
implements Serializable,
Cloneable {
    private static final int CASEDIFF = 32;
    private static final int LOWER_BIT = 32;
    private static final int UPPER_BIT = -33;
    private static final byte[] NULL = "null".getBytes();
    private static final byte[] TRUE = "true".getBytes();
    private static final byte[] FALSE = "false".getBytes();
    private static final byte[] DIGITS = "0123456789ABCDEF".getBytes();
    public static final int[] CHAR_VALUES = new int[23];
    private static final byte[] UNITS;
    private static final byte[] TENTH_UNITS;
    private static final byte[] INTEGER_MIN;
    private static final byte[] LONG_MIN;
    private static final byte MINUS = 45;
    private byte[] bytValue = null;
    private int intLength = 0;
    private int intNextLineStart = 0;
    private byte[] bytLineBreak = new byte[]{13, 10};

    static {
        int n = 23;
        while (n-- > 0) {
            int n2 = n + 48;
            n2 = n2 > 64 ? (n2 -= 65) : (n2 > 57 ? -1 : n);
            ByteString.CHAR_VALUES[n] = n2;
        }
        UNITS = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".getBytes();
        TENTH_UNITS = "0000000000111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999".getBytes();
        INTEGER_MIN = "-2147483648".getBytes();
        LONG_MIN = "-9223372036854775808".getBytes();
    }

    public ByteString() {
        this(16);
    }

    public ByteString(int n) {
        this.bytValue = new byte[n];
    }

    public ByteString(ByteString byteString) {
        this(byteString.bytValue, 0, byteString.intLength);
    }

    public ByteString(ByteString byteString, int n, int n2) {
        this(byteString.bytValue, n, n2);
    }

    public ByteString(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public ByteString(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteString(byte[] byArray, int n, int n2) {
        this(byArray.length + 16);
        this.append(byArray, n, n2);
    }

    public ByteString(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public ByteString(char[] cArray, int n, int n2) {
        this(cArray.length + 16);
        this.append(cArray, n, n2);
    }

    public final ByteString append(byte by) {
        int n = this.intLength + 1;
        if (n > this.bytValue.length) {
            this.ensureCapacity(n);
        }
        this.bytValue[this.intLength++] = by;
        return this;
    }

    public final ByteString append(char c) {
        int n = this.intLength + 1;
        if (n > this.bytValue.length) {
            this.ensureCapacity(n);
        }
        this.bytValue[this.intLength++] = (byte)c;
        return this;
    }

    public final ByteString append(double d) {
        return this.append(String.valueOf(d));
    }

    public final ByteString append(float f) {
        return this.append(String.valueOf(f));
    }

    public final ByteString append(int n) {
        if (n == Integer.MIN_VALUE) {
            return this.append(INTEGER_MIN, 0, INTEGER_MIN.length);
        }
        byte[] byArray = new byte[12];
        boolean bl = n < 0;
        int n2 = 12;
        if (bl) {
            n = -n;
            this.append((byte)45);
        }
        if (n < 10) {
            this.append((byte)(n + 48));
            return this;
        }
        byte[] byArray2 = UNITS;
        byte[] byArray3 = TENTH_UNITS;
        do {
            int n3 = n % 100;
            byArray[--n2] = byArray2[n3];
            byArray[--n2] = byArray3[n3];
        } while ((n /= 100) != 0);
        if (byArray[n2] == 48) {
            ++n2;
        }
        this.append(byArray, n2, 12 - n2);
        return this;
    }

    public final ByteString append(long l) {
        if (l == Long.MIN_VALUE) {
            return this.append(LONG_MIN, 0, LONG_MIN.length);
        }
        byte[] byArray = new byte[20];
        boolean bl = l < 0L;
        int n = 20;
        if (bl) {
            l = -l;
            this.append((byte)45);
        }
        if (l < 10L) {
            return this.append((byte)(l + 48L));
        }
        byte[] byArray2 = UNITS;
        byte[] byArray3 = TENTH_UNITS;
        do {
            int n2 = (int)(l % 100L);
            byArray[--n] = byArray2[n2];
            byArray[--n] = byArray3[n2];
        } while ((l /= 100L) != 0L);
        if (byArray[n] == 48) {
            ++n;
        }
        return this.append(byArray, n, 20 - n);
    }

    public final ByteString append(ByteString byteString) {
        if (byteString == null) {
            return this.append(NULL, 0, 4);
        }
        int n = byteString.intLength;
        int n2 = this.intLength + n;
        if (n2 > this.bytValue.length) {
            this.ensureCapacity(n2);
        }
        System.arraycopy(byteString.bytValue, 0, this.bytValue, this.intLength, n);
        this.intLength = n2;
        return this;
    }

    public final ByteString append(Object object) {
        return this.append(String.valueOf(object));
    }

    public final ByteString append(String string) {
        if (string == null) {
            return this.append(NULL, 0, 4);
        }
        int n = string.length();
        int n2 = this.intLength + n;
        if (n2 > this.bytValue.length) {
            this.ensureCapacity(n2);
        }
        byte[] byArray = ByteString.getASCII(string);
        System.arraycopy(byArray, 0, this.bytValue, this.intLength, n);
        this.intLength = n2;
        return this;
    }

    public final ByteString append(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            return this.append(NULL, 0, 4);
        }
        return this.append(string.getBytes(string2));
    }

    public final ByteString append(boolean bl) {
        if (bl) {
            return this.append(TRUE, 0, 4);
        }
        return this.append(FALSE, 0, 5);
    }

    public final ByteString append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public final ByteString append(byte[] byArray, int n, int n2) {
        int n3 = this.intLength + n2;
        if (n3 > this.bytValue.length) {
            this.ensureCapacity(n3);
        }
        System.arraycopy(byArray, n, this.bytValue, this.intLength, n2);
        this.intLength = n3;
        return this;
    }

    public final ByteString append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public final ByteString append(char[] cArray, int n, int n2) {
        int n3 = this.intLength + n2;
        if (n3 > this.bytValue.length) {
            this.ensureCapacity(n3);
        }
        System.arraycopy(ByteString.getASCII(cArray), n, this.bytValue, this.intLength, n2);
        this.intLength = n3;
        return this;
    }

    public ByteString appendLineBreak() {
        this.append(this.bytLineBreak, 0, this.bytLineBreak.length);
        return this;
    }

    public final void clear() {
        this.intLength = 0;
    }

    public final Object clone() {
        try {
            ByteString byteString = (ByteString)super.clone();
            byteString.bytValue = (byte[])this.bytValue.clone();
            return byteString;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone failed on StringBufferExtended");
        }
    }

    public final int compareTo(ByteString byteString) {
        return this.compareTo(byteString.bytValue, 0, byteString.intLength, false);
    }

    public final int compareTo(byte[] byArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n2 + n > byArray.length) {
            throw new IllegalArgumentException();
        }
        int n3 = Math.min(this.intLength, n2);
        byte[] byArray2 = this.bytValue;
        int n4 = 0;
        int n5 = n;
        while (n3-- != 0) {
            int n6;
            int n7;
            int n8;
            if ((n8 = byArray2[n4++] & 0xFF) == (n7 = byArray[n5++] & 0xFF) || bl && (n6 = n8 & 0xFFFFFFDF) > 64 && n6 < 91 && n6 == (n7 & 0xFFFFFFDF)) continue;
            return n8 - n7;
        }
        return this.intLength - n2;
    }

    public final int compareToIgnoreCase(ByteString byteString) {
        return this.compareTo(byteString.bytValue, 0, byteString.intLength, true);
    }

    public final ByteString convertToLowerCase() {
        int n = this.intLength;
        byte[] byArray = this.bytValue;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 > 64 && n3 < 91) {
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] | 0x20);
            }
            ++n2;
        }
        return this;
    }

    public final ByteString convertToUpperCase() {
        int n = this.intLength;
        byte[] byArray = this.bytValue;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 > 96 && n3 < 123) {
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] & 0x20);
            }
            ++n2;
        }
        return this;
    }

    public final ByteString decLength() {
        if (--this.intLength < 0) {
            this.intLength = 0;
        }
        return this;
    }

    public final ByteString delete(int n) {
        return this.delete(n, Integer.MAX_VALUE);
    }

    public final ByteString delete(int n, int n2) {
        if (n < 0 || n >= this.intLength) {
            throw new StringIndexOutOfBoundsException("offset out of bounds: " + n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("len must be >= 0: " + n2);
        }
        if (n2 == 0) {
            return this;
        }
        int n3 = n + n2;
        if (n3 >= this.intLength || n3 < 0) {
            this.setLength(n);
            return this;
        }
        System.arraycopy(this.bytValue, n + n2, this.bytValue, n, this.intLength - (n + n2));
        this.intLength -= n2;
        return this;
    }

    private int digit(byte n) {
        int n2 = n;
        if (n2 > 97) {
            n2 -= 32;
        }
        if ((n2 -= 48) > 23 || n2 < 0) {
            throw new NumberFormatException("b=" + n);
        }
        n2 = CHAR_VALUES[n2];
        if (n < 0) {
            throw new NumberFormatException("b=" + n);
        }
        return n2;
    }

    public void dispose() {
        this.bytValue = null;
        this.intLength = 0;
        this.intNextLineStart = 0;
    }

    public final boolean endsWith(ByteString byteString) {
        int n = byteString.intLength;
        if (this.intLength < n) {
            return false;
        }
        return this.isMatchingRegion(byteString.bytValue, 0, n, this.intLength - n, false);
    }

    public final boolean endsWith(String string) {
        int n = string.length();
        if (this.intLength < n) {
            return false;
        }
        return this.isMatchingRegion(ByteString.getASCII(string), 0, n, this.intLength - n, false);
    }

    public final void ensureCapacity(int n) {
        if (n > this.bytValue.length) {
            int n2 = (this.bytValue.length + 1) * 2;
            if (n > n2) {
                n2 = n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.bytValue, 0, byArray, 0, this.intLength);
            this.bytValue = byArray;
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            ByteString byteString = (ByteString)object;
            int n = this.intLength;
            if (n == byteString.intLength) {
                int n2 = 0;
                int n3 = n - 1;
                n = (n + 1) / 2;
                byte[] byArray = this.bytValue;
                byte[] byArray2 = byteString.bytValue;
                while (n-- > 0) {
                    if (byArray[n2] == byArray2[n2++] && byArray[n3] == byArray2[n3--]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final ByteString erase(int n, int n2) {
        return this.overwrite(' ', n, n2);
    }

    public static final byte[] getASCII(String string) {
        char[] cArray = string.toCharArray();
        return ByteString.getASCII(cArray, 0, cArray.length);
    }

    public static final byte[] getASCII(char[] cArray) {
        return ByteString.getASCII(cArray, 0, cArray.length);
    }

    public static final byte[] getASCII(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = n2;
        while (n3-- > 0) {
            byArray[n3] = (byte)cArray[n3 + n];
        }
        return byArray;
    }

    public final byte getByteAt(int n) {
        if (n >= this.intLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.bytValue[n];
    }

    public final void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < n2) {
            System.arraycopy(this.bytValue, n, byArray, n3, n2 - n);
        }
    }

    public final int getCapacity() {
        return this.bytValue.length;
    }

    public static final char[] getCharArray(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = n2;
        while (n3-- > 0) {
            cArray[n3] = (char)(byArray[n3 + n] & 0xFF);
        }
        return cArray;
    }

    public final char getCharAt(int n) {
        if (n >= this.intLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return (char)(this.bytValue[n] & 0xFF);
    }

    public final int getCharCount(byte by, int n, int n2) {
        if (this.intLength == 0) {
            return 0;
        }
        byte[] byArray = this.bytValue;
        int n3 = 0;
        int n4 = this.intLength;
        while (n4-- > 0) {
            if (byArray[n4] != by) continue;
            ++n3;
        }
        return n3;
    }

    public final int getIndexOf(byte by) {
        return this.getIndexOf(by, 0);
    }

    public final int getIndexOf(byte by, int n) {
        int n2 = this.intLength;
        byte[] byArray = this.bytValue;
        if (n < 0) {
            n = 0;
        } else if (n >= this.intLength) {
            return -1;
        }
        int n3 = n;
        while (n3 < n2) {
            if (byArray[n3] == by) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public final int getIndexOf(ByteString byteString) {
        return this.getIndexOf(byteString, 0);
    }

    public final int getIndexOf(ByteString byteString, int n) {
        return this.getIndexOf(byteString.bytValue, 0, byteString.intLength, n);
    }

    public final int getIndexOf(String string) {
        return this.getIndexOf(string, 0);
    }

    public final int getIndexOf(String string, int n) {
        return this.getIndexOf(ByteString.getASCII(string), 0, string.length(), n);
    }

    private final int getIndexOf(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = this.bytValue;
        int n4 = this.intLength;
        int n5 = n4 - n2;
        if (n3 >= n4) {
            return -1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 == 0) {
            return n3;
        }
        byte by = byArray[n];
        block0: while (true) {
            if (n3 <= n5 && byArray2[n3] != by) {
                ++n3;
                continue;
            }
            if (n3 > n5) {
                return -1;
            }
            int n6 = n3 + 1;
            int n7 = n6 + n2 - 1;
            int n8 = n + 1;
            while (n6 < n7) {
                if (byArray2[n6++] == byArray[n8++]) continue;
                ++n3;
                continue block0;
            }
            break;
        }
        return n3;
    }

    public final int getIndexOfIgnoreCase(ByteString byteString) {
        return this.getIndexOfIgnoreCase(byteString.bytValue, 0, byteString.intLength, 0);
    }

    public final int getIndexOfIgnoreCase(ByteString byteString, int n) {
        return this.getIndexOfIgnoreCase(byteString.bytValue, 0, byteString.intLength, n);
    }

    public final int getIndexOfIgnoreCase(String string) {
        return this.getIndexOfIgnoreCase(string, 0);
    }

    public final int getIndexOfIgnoreCase(String string, int n) {
        int n2 = string.length();
        return this.getIndexOfIgnoreCase(ByteString.getASCII(string), 0, n2, n);
    }

    private final int getIndexOfIgnoreCase(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = this.bytValue;
        int n4 = this.intLength;
        int n5 = n4 - n2;
        if (n3 >= n4) {
            return -1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 == 0) {
            return n3;
        }
        byte by = byArray[n];
        byte by2 = (byte)(by & 0xFFFFFFDF);
        byte by3 = (byte)(by | 0x20);
        block0: while (true) {
            int n6;
            if (n3 <= n5) {
                n6 = byArray2[n3];
                if (n6 != by && (n6 & 0xFFFFFFDF) != by2 && (n6 | 0x20) != by3) {
                    ++n3;
                    continue;
                }
            }
            if (n3 > n5) {
                return -1;
            }
            n6 = n3 + 1;
            int n7 = n6 + n2 - 1;
            int n8 = n + 1;
            while (n6 < n7) {
                byte by4;
                byte by5 = byArray2[n6++];
                byte by6 = (byte)(by5 & 0xFFFFFFDF);
                byte by7 = (byte)(by5 | 0x20);
                if ((by4 = byArray[n8++]) == by5 || by6 == (by4 & 0xFFFFFFDF) || by7 == (by4 | 0x20)) continue;
                ++n3;
                continue block0;
            }
            break;
        }
        return n3;
    }

    public final byte[] getInternalByteArray() {
        return this.bytValue;
    }

    public final int getLastIndexOf(byte by) {
        return this.getLastIndexOf(by, this.intLength - 1);
    }

    public final int getLastIndexOf(byte by, int n) {
        byte[] byArray = this.bytValue;
        int n2 = n >= this.intLength ? this.intLength - 1 : n;
        while (n2 >= 0) {
            if (byArray[n2] == by) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public final int getLastIndexOf(ByteString byteString) {
        return this.getLastIndexOf(byteString, 0);
    }

    public final int getLastIndexOf(ByteString byteString, int n) {
        return this.getLastIndexOf(byteString.bytValue, 0, byteString.intLength, n);
    }

    public final int getLastIndexOf(String string) {
        string.length();
        return this.getLastIndexOf(string, this.intLength - 1);
    }

    public final int getLastIndexOf(String string, int n) {
        int n2 = string.length();
        return this.getLastIndexOf(ByteString.getASCII(string), 0, n2, n);
    }

    private final int getLastIndexOf(byte[] byArray, int n, int n2, int n3) {
        int n4;
        if (n3 < 0) {
            return -1;
        }
        int n5 = this.intLength - n2;
        if (n3 > n5) {
            n3 = n5;
        }
        if (n2 == 0) {
            return n3;
        }
        byte[] byArray2 = this.bytValue;
        int n6 = n + n2 - 1;
        byte by = byArray[n6];
        int n7 = n2 - 1;
        int n8 = n7 + n3;
        block0: while (true) {
            if (n8 >= n7 && byArray2[n8] != by) {
                --n8;
                continue;
            }
            if (n8 < n7) {
                return -1;
            }
            int n9 = n8 - 1;
            n4 = n9 - (n2 - 1);
            int n10 = n6 - 1;
            while (n9 > n4) {
                if (byArray2[n9--] == byArray[n10--]) continue;
                --n8;
                continue block0;
            }
            break;
        }
        return n4 + 1;
    }

    public final int getLastIndexOfIgnoreCase(ByteString byteString) {
        return this.getLastIndexOfIgnoreCase(byteString, 0);
    }

    public final int getLastIndexOfIgnoreCase(ByteString byteString, int n) {
        return this.getLastIndexOfIgnoreCase(byteString.bytValue, 0, byteString.intLength, n);
    }

    public final int getLastIndexOfIgnoreCase(String string) {
        string.length();
        return this.getLastIndexOfIgnoreCase(string, this.intLength - 1);
    }

    public final int getLastIndexOfIgnoreCase(String string, int n) {
        int n2 = string.length();
        return this.getLastIndexOfIgnoreCase(ByteString.getASCII(string), 0, n2, n);
    }

    private final int getLastIndexOfIgnoreCase(byte[] byArray, int n, int n2, int n3) {
        int n4;
        if (n3 < 0) {
            return -1;
        }
        int n5 = this.intLength - n2;
        if (n3 > n5) {
            n3 = n5;
        }
        if (n2 == 0) {
            return n3;
        }
        byte[] byArray2 = this.bytValue;
        int n6 = n + n2 - 1;
        byte by = byArray[n6];
        byte by2 = (byte)(by & 0xFFFFFFDF);
        byte by3 = (byte)(by | 0x20);
        int n7 = n2 - 1;
        int n8 = n7 + n3;
        block0: while (true) {
            int n9;
            if (n8 >= n7) {
                n9 = byArray2[n8];
                if (n9 != by && (n9 & 0xFFFFFFDF) != by2 && (n9 | 0x20) != by3) {
                    --n8;
                    continue;
                }
            }
            if (n8 < n7) {
                return -1;
            }
            n9 = n8 - 1;
            n4 = n9 - (n2 - 1);
            int n10 = n6 - 1;
            while (n9 > n4) {
                byte by4;
                byte by5 = byArray2[n9--];
                byte by6 = (byte)(by5 & 0xFFFFFFDF);
                byte by7 = (byte)(by5 | 0x20);
                if ((by4 = byArray[n10--]) == by5 || (by4 & 0xFFFFFFDF) == by6 || (by4 | 0x20) == by7) continue;
                --n8;
                continue block0;
            }
            break;
        }
        return n4 + 1;
    }

    public final int getLength() {
        return this.intLength;
    }

    public String getLineBreak() {
        return new String(this.bytLineBreak);
    }

    public final int getLineCount() {
        if (this.intLength == 0) {
            return 0;
        }
        byte by = this.bytLineBreak[0];
        int n = this.getCharCount(by, 0, this.intLength - 1);
        int n2 = this.bytLineBreak.length;
        if (this.bytValue[this.intLength - n2] != by) {
            ++n;
        }
        return n;
    }

    public final ByteString getLineHardBreak(int n) {
        if (n < 0 || n > this.intLength) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        byte[] byArray = this.bytValue;
        int n2 = this.intLength;
        int n3 = this.getIndexOf(this.bytLineBreak[0], n);
        if (n3 == -1) {
            n3 = n2;
        }
        int n4 = n3 - n;
        this.intNextLineStart = n + n4 + this.bytLineBreak.length;
        return new ByteString(byArray, n, n4);
    }

    public final Enumeration getLineHardBreakEnumeration() {
        return new LineEnumeration(this);
    }

    public final int getNextLineStart() {
        return this.intNextLineStart;
    }

    public static final String getString(byte[] byArray) {
        return ByteString.getString(byArray, 0, byArray.length);
    }

    public static final String getString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = n2;
        while (n3-- > 0) {
            cArray[n3] = (char)(byArray[n3 + n] & 0xFF);
        }
        return new String(cArray);
    }

    public final ByteString getSubstring(int n) {
        return this.getSubstring(n, this.intLength);
    }

    public final ByteString getSubstring(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (n2 > this.intLength) {
            n2 = this.intLength;
        }
        if (n > this.intLength) {
            n = this.intLength;
        }
        return new ByteString(this.bytValue, n, n2 - n);
    }

    public final int hashCode() {
        int n = 0;
        int n2 = 0;
        byte[] byArray = this.bytValue;
        int n3 = this.intLength;
        if (n3 < 16) {
            int n4 = n3;
            while (n4 > 0) {
                n = n * 37 + byArray[n2++];
                --n4;
            }
        } else {
            int n5 = n3 / 8;
            int n6 = n3;
            while (n6 > 0) {
                n = n * 39 + byArray[n2];
                n6 -= n5;
                n2 += n5;
            }
        }
        return n;
    }

    public void init(int n) {
        if (this.bytValue == null) {
            this.bytValue = new byte[n + 16];
        } else {
            this.ensureCapacity(n);
        }
    }

    public final ByteString insert(int n, byte by) {
        int n2 = this.intLength + 1;
        if (n2 > this.bytValue.length) {
            this.ensureCapacity(n2);
        }
        System.arraycopy(this.bytValue, n, this.bytValue, n + 1, this.intLength - n);
        this.bytValue[n] = by;
        this.intLength = n2;
        return this;
    }

    public final ByteString insert(int n, char c) {
        int n2 = this.intLength + 1;
        if (n2 > this.bytValue.length) {
            this.ensureCapacity(n2);
        }
        System.arraycopy(this.bytValue, n, this.bytValue, n + 1, this.intLength - n);
        this.bytValue[n] = (byte)c;
        this.intLength = n2;
        return this;
    }

    public final ByteString insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public final ByteString insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public final ByteString insert(int n, int n2) {
        if (n2 == Integer.MIN_VALUE) {
            return this.insert(n, INTEGER_MIN, 0, INTEGER_MIN.length);
        }
        byte[] byArray = new byte[12];
        boolean bl = n2 < 0;
        int n3 = 12;
        if (bl) {
            n2 = -n2;
        }
        if (n2 < 10 && !bl) {
            return this.insert(n, (byte)(n2 + 48));
        }
        do {
            int n4 = n2 % 100;
            byArray[--n3] = UNITS[n4];
            byArray[--n3] = TENTH_UNITS[n4];
        } while ((n2 /= 100) != 0);
        if (byArray[n3] == 48) {
            ++n3;
        }
        if (bl) {
            byArray[--n3] = 45;
        }
        return this.insert(n, byArray, n3, 12 - n3);
    }

    public final ByteString insert(int n, long l) {
        if (l == Long.MIN_VALUE) {
            return this.insert(n, LONG_MIN, 0, LONG_MIN.length);
        }
        byte[] byArray = new byte[20];
        boolean bl = l < 0L;
        int n2 = 20;
        if (bl) {
            l = -l;
        }
        if (l < 10L && !bl) {
            return this.insert(n, (byte)(l + 48L));
        }
        do {
            int n3 = (int)(l % 100L);
            byArray[--n2] = UNITS[n3];
            byArray[--n2] = TENTH_UNITS[n3];
        } while ((l /= 100L) != 0L);
        if (byArray[n2] == 48) {
            ++n2;
        }
        if (bl) {
            byArray[--n2] = 45;
        }
        return this.insert(n, byArray, n2, 20 - n2);
    }

    public final ByteString insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public final ByteString insert(int n, String string) {
        int n2 = string.length();
        int n3 = this.intLength + n2;
        if (n3 > this.bytValue.length) {
            this.ensureCapacity(n3);
        }
        System.arraycopy(this.bytValue, n, this.bytValue, n + n2, this.intLength - n);
        System.arraycopy(ByteString.getASCII(string), 0, this.bytValue, n, n2);
        this.intLength = n3;
        return this;
    }

    public final ByteString insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public final ByteString insert(int n, byte[] byArray, int n2, int n3) {
        int n4 = this.intLength + n3;
        if (n4 > this.bytValue.length) {
            this.ensureCapacity(n4);
        }
        System.arraycopy(this.bytValue, n, this.bytValue, n + n3, this.intLength - n);
        System.arraycopy(byArray, n2, this.bytValue, n, n3);
        this.intLength = n4;
        return this;
    }

    public final ByteString insert(int n, char[] cArray) {
        return this.insert(n, cArray, 0, cArray.length);
    }

    public final ByteString insert(int n, char[] cArray, int n2, int n3) {
        return this.insert(n, ByteString.getASCII(cArray), n2, n3);
    }

    public final boolean isEmpty() {
        return this.intLength == 0;
    }

    public final boolean isMatchingRegion(ByteString byteString, int n, boolean bl) {
        return this.isMatchingRegion(byteString.bytValue, 0, byteString.intLength, n, bl);
    }

    public final boolean isMatchingRegion(String string, int n, boolean bl) {
        return this.isMatchingRegion(ByteString.getASCII(string), 0, string.length(), n, bl);
    }

    private final boolean isMatchingRegion(byte[] byArray, int n, int n2, int n3, boolean bl) {
        if (n < 0 || n > byArray.length || n2 < 0 || n2 + n > byArray.length || n3 > this.intLength) {
            throw new IllegalArgumentException();
        }
        if (this.intLength - n3 < n2) {
            return false;
        }
        byte[] byArray2 = this.bytValue;
        int n4 = n3;
        int n5 = n;
        while (n2-- != 0) {
            byte by;
            byte by2;
            if ((by2 = byArray2[n4++]) == (by = byArray[n5++]) || bl && (by2 & 0xFFFFFFDF) == (by & 0xFFFFFFDF)) continue;
            return false;
        }
        return true;
    }

    public final ByteString overwrite(byte by, int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            return this;
        }
        if (n >= this.intLength) {
            return this;
        }
        if (n2 >= this.intLength) {
            n2 = this.intLength - 1;
        }
        byte[] byArray = this.bytValue;
        int n3 = n;
        while (n3 <= n2) {
            byArray[n3] = by;
            ++n3;
        }
        return this;
    }

    public final ByteString overwrite(char c, int n, int n2) {
        return this.overwrite((byte)c, n, n2);
    }

    public long parseLong(int n, int n2) throws NumberFormatException {
        return this.parseLong(n, n2, 10);
    }

    private long parseLong(int n, int n2, int n3) throws NumberFormatException {
        if (n2 <= n) {
            return 0L;
        }
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = n;
        int n5 = n2 - n;
        byte[] byArray = this.bytValue;
        if (n5 > 0) {
            int n6;
            long l2;
            if (byArray[n4] == 45) {
                bl = true;
                l2 = Long.MIN_VALUE;
                ++n4;
            } else {
                l2 = -9223372036854775807L;
            }
            if (n3 == 16 && n5 == 16 && this.digit(byArray[n4]) > 7) {
                bl = true;
                bl2 = true;
                l2 = Long.MIN_VALUE;
            } else {
                l2 = -9223372036854775807L;
            }
            long l3 = l2 / (long)n3;
            if (n4 < n2) {
                n6 = this.digit(byArray[n4++]);
                if (bl2) {
                    n6 ^= 0xF;
                }
                if (n6 < 0) {
                    throw new NumberFormatException(new String(byArray, n, n2));
                }
                l = -n6;
            }
            while (n4 < n2) {
                n6 = this.digit(byArray[n4++]);
                if (bl2) {
                    n6 ^= 0xF;
                }
                if (n6 < 0) {
                    return 0L;
                }
                if (l < l3) {
                    return 0L;
                }
                if ((l *= (long)n3) < l2 + (long)n6) {
                    return 0L;
                }
                l -= (long)n6;
            }
        } else {
            return 0L;
        }
        if (bl2) {
            --l;
        }
        if (bl) {
            if (n4 > 1) {
                return l;
            }
            return 0L;
        }
        return -l;
    }

    public final ByteString reduceSpaces() {
        int n = this.intLength;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = this.bytValue;
        boolean bl = false;
        while (n2 < n) {
            int n4;
            if ((n4 = byArray[n2++] & 0xFF) > 32) {
                byArray[n3++] = (byte)n4;
                bl = true;
                continue;
            }
            if (!bl) continue;
            byArray[n3++] = 32;
            bl = false;
        }
        this.intLength = n3;
        return this;
    }

    public final ByteString reduceSpaces(boolean bl) {
        int n = this.intLength;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = this.bytValue;
        boolean bl2 = false;
        while (n2 < n) {
            int n4;
            if ((n4 = byArray[n2++] & 0xFF) > 32 || bl && (n4 == 13 || n4 == 10)) {
                byArray[n3++] = (byte)n4;
                if (n4 == 13 || n4 == 10) continue;
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            byArray[n3++] = 32;
            bl2 = false;
        }
        this.intLength = n3;
        return this;
    }

    public final ByteString replace(byte by, byte by2) {
        if (by != by2) {
            int n = this.intLength;
            byte[] byArray = this.bytValue;
            int n2 = n;
            while (n2-- > 0) {
                if (byArray[n2] != by) continue;
                byArray[n2] = by2;
            }
        }
        return this;
    }

    public final ByteString replace(ByteString byteString, ByteString byteString2, boolean bl) {
        return this.replace(byteString.bytValue, 0, byteString.intLength, byteString2.bytValue, 0, byteString2.intLength, bl);
    }

    public final ByteString replace(String string, String string2, boolean bl) {
        int n = string.length();
        int n2 = string2.length();
        return this.replace(ByteString.getASCII(string), 0, n, ByteString.getASCII(string2), 0, n2, bl);
    }

    private final ByteString replace(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, boolean bl) {
        if (byArray == null || byArray2 == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n + n2 > byArray.length || n3 + n4 > byArray2.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return this;
        }
        int n5 = 0;
        while ((n5 = bl ? this.getIndexOfIgnoreCase(byArray, n, n2, n5) : this.getIndexOf(byArray, n, n2, n5)) != -1) {
            if (n2 == n4) {
                System.arraycopy(byArray2, n3, this.bytValue, n5, n4);
            } else if (n2 > n4) {
                if (n4 > 0) {
                    System.arraycopy(byArray2, n3, this.bytValue, n5, n4);
                }
                this.delete(n5 + n4, n2 - n4);
            } else {
                System.arraycopy(byArray2, n3, this.bytValue, n5, n2);
                this.insert(n5 + n2, byArray2, n3 + n2, n4 - n2);
            }
            n5 += n4;
        }
        return this;
    }

    public final ByteString reverse() {
        int n = this.intLength - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            byte by = this.bytValue[n2];
            this.bytValue[n2] = this.bytValue[n - n2];
            this.bytValue[n - n2] = by;
            --n2;
        }
        return this;
    }

    public final void setByteArray(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n > byArray.length || n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.bytValue = byArray;
        this.intLength = n;
    }

    public final void setCharAt(int n, byte by) {
        if (n < 0 || n >= this.intLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.bytValue[n] = by;
    }

    public final void setCharAt(int n, char c) {
        this.setCharAt(n, (byte)c);
    }

    public final void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.bytValue.length) {
            this.ensureCapacity(n);
        }
        if (this.intLength < n) {
            while (this.intLength < n) {
                this.bytValue[this.intLength] = 0;
                ++this.intLength;
            }
        } else {
            this.intLength = n;
        }
    }

    public final void setLengthIndex(int n) {
        if (n < 0 || n > this.bytValue.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.intLength = n;
    }

    public void setLineBreak(String string) {
        this.bytLineBreak = string.getBytes();
    }

    public final void setNextLineStart(int n) {
        this.intNextLineStart = n;
    }

    public final boolean startsWith(String string) {
        int n = string.length();
        if (this.intLength < n) {
            return false;
        }
        return this.isMatchingRegion(ByteString.getASCII(string), 0, n, 0, false);
    }

    public final ByteString stripSpaces() {
        int n = this.intLength;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = this.bytValue;
        while (n2 < n) {
            byte by;
            if (((by = byArray[n2++]) & 0xFF) <= 32) continue;
            byArray[n3++] = by;
        }
        this.intLength = n3;
        return this;
    }

    public final byte[] toByteArray() {
        return this.toByteArray(0, this.intLength);
    }

    public final byte[] toByteArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            n = this.intLength;
        }
        if (n + n2 > this.intLength) {
            n2 = this.intLength - n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.bytValue, n, byArray, 0, n2);
        return byArray;
    }

    public final char[] toCharArray() {
        return this.toCharArray(0, this.intLength);
    }

    public final char[] toCharArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            n = this.intLength;
        }
        if (n + n2 > this.intLength) {
            n2 = this.intLength - n;
        }
        return ByteString.getCharArray(this.bytValue, n, n2);
    }

    public String toString() {
        return ByteString.getString(this.bytValue, 0, this.intLength);
    }

    public final ByteString trim() {
        int n = this.intLength;
        int n2 = 0;
        byte[] byArray = this.bytValue;
        while (n2 < n && (byArray[n2] & 0xFF) <= 32) {
            ++n2;
        }
        while (n2 < n && (byArray[n - 1] & 0xFF) <= 32) {
            --n;
        }
        this.intLength = n - n2;
        System.arraycopy(byArray, n2, byArray, 0, this.intLength);
        return this;
    }

    public final ByteString trimLeft() {
        int n = this.intLength;
        int n2 = 0;
        byte[] byArray = this.bytValue;
        while (n2 < n && (byArray[n2] & 0xFF) <= 32) {
            ++n2;
        }
        this.intLength = n - n2;
        System.arraycopy(byArray, n2, byArray, 0, this.intLength);
        return this;
    }

    public final ByteString trimRight() {
        int n = this.intLength;
        byte[] byArray = this.bytValue;
        while (n > 0 && (byArray[n - 1] & 0xFF) < 33) {
            --n;
        }
        this.intLength = n;
        return this;
    }

    static int access$intNextLineStart(ByteString byteString) {
        return byteString.intNextLineStart;
    }

    static int access$intLength(ByteString byteString) {
        return byteString.intLength;
    }

    private class LineEnumeration
    implements Enumeration {
        /* synthetic */ ByteString this$0;
        private int intLineCounter = 0;
        private int intType = 0;
        private int intWidth = 0;
        private FontMetrics fmMetrics = null;

        LineEnumeration(ByteString byteString) {
            this.this$0 = byteString;
        }

        LineEnumeration(ByteString byteString, int n) {
            this.this$0 = byteString;
            this.intType = 1;
            this.intWidth = n;
        }

        LineEnumeration(ByteString byteString, int n, FontMetrics fontMetrics, boolean bl) {
            this.this$0 = byteString;
            this.intType = bl ? 2 : 3;
            this.intWidth = n;
            this.fmMetrics = fontMetrics;
        }

        public Object nextElement() {
            ByteString byteString;
            switch (this.intType) {
                case 0: {
                    byteString = this.this$0.getLineHardBreak(this.intLineCounter);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    byteString = new ByteString();
                }
            }
            this.intLineCounter = ByteString.access$intNextLineStart(this.this$0);
            return byteString;
        }

        public boolean hasMoreElements() {
            return this.intLineCounter < ByteString.access$intLength(this.this$0);
        }
    }
}

